/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.payment;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.dto.pay.PaymentMqNotifyReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.PayRecordEo;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BOrderStatemachineHandle;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="PAYMENT_NOTIFY_TOPIC", tag="PAYMENT_NOTIFY_TAG")
public class PayNotifyProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(PayNotifyProcessor.class);
    @Resource
    private IDgF2BOrderStatemachineHandle dgF2BOrderStatemachineHandle;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    public MessageResponse process(String messageVo) {
        log.info("PayNotifyProcessor:{}", (Object)JSON.toJSONString((Object)messageVo));
        try {
            PaymentMqNotifyReqDto reqDto = (PaymentMqNotifyReqDto)JSON.parseObject((String)messageVo, PaymentMqNotifyReqDto.class);
            PayRecordEo payRecordEo = this.payRecordDomain.selectByTradeNo(reqDto.getTradeId());
            if (payRecordEo == null) {
                return MessageResponse.SUCCESS;
            }
            DgPerformOrderInfoEo dgPerformOrderInfoEo = this.dgPerformOrderInfoDomain.queryByOrderNo(payRecordEo.getOrderNo());
            if (dgPerformOrderInfoEo == null) {
                return MessageResponse.SUCCESS;
            }
            reqDto.setOrderId(dgPerformOrderInfoEo.getId());
            log.info("reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
            this.dgF2BOrderStatemachineHandle.paymentCallback(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), reqDto);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u6d88\u606f\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

