/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.payment;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderRefundStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDomain;
import com.yunxi.dg.base.center.trade.dto.pay.RefundMqNotifyReqDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundDetailEo;
import com.yunxi.dg.base.center.trade.eo.DgRefundEo;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(topic="PAYMENT_NOTIFY_TOPIC", tag="REFUND_NOTIFY_TAG")
public class RefundNotifyProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(RefundNotifyProcessor.class);
    @Resource
    private IDgRefundDomain dgRefundDomain;
    @Resource
    private IDgRefundDetailDomain dgRefundDetailDomain;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;

    @Transactional(rollbackFor={Exception.class})
    public MessageResponse process(String messageVo) {
        block9: {
            log.info("RefundNotifyProcessor:{}", (Object)JSON.toJSONString((Object)messageVo));
            try {
                RefundMqNotifyReqDto reqDto = (RefundMqNotifyReqDto)JSON.parseObject((String)messageVo, RefundMqNotifyReqDto.class);
                List refundDetailEoList = this.dgRefundDetailDomain.queryEosByRefundNo(reqDto.getStoreRefundId());
                if (CollectionUtils.isEmpty((Collection)refundDetailEoList)) {
                    log.info("\u672a\u6839\u636e\u9000\u6b3e\u6d41\u6c34\u53f7\u627e\u5230\u9000\u6b3e\u5355\u636e\u4fe1\u606f");
                    return MessageResponse.SUCCESS;
                }
                if (Objects.equals(reqDto.getStatus(), "F")) {
                    DgRefundEo updateRefundEo = new DgRefundEo();
                    updateRefundEo.setId(((DgRefundDetailEo)refundDetailEoList.get(0)).getRefundId());
                    updateRefundEo.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUND_FAIL.getCode());
                    this.dgRefundDomain.updateSelective((BaseEo)updateRefundEo);
                    if (((DgRefundDetailEo)refundDetailEoList.get(0)).getAfterSaleOrderId() != null) {
                        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(((DgRefundDetailEo)refundDetailEoList.get(0)).getAfterSaleOrderId());
                        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
                        dgAfterSaleOrderEo.setId(afterSaleOrderEo.getId());
                        dgAfterSaleOrderEo.setRefundStatus(DgAfterSaleOrderRefundStatusEnum.REFUND_FAIL.getCode());
                        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
                    }
                    for (DgRefundDetailEo dgRefundDetailEo : refundDetailEoList) {
                        DgRefundDetailEo updateRefundDetailEo = new DgRefundDetailEo();
                        updateRefundDetailEo.setId(dgRefundDetailEo.getId());
                        updateRefundDetailEo.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUND_FAIL.getCode());
                        updateRefundDetailEo.setRefundTime(reqDto.getFinishTime());
                        this.dgRefundDetailDomain.updateSelective((BaseEo)updateRefundDetailEo);
                    }
                    break block9;
                }
                if (Objects.equals(reqDto.getStatus(), "S")) {
                    DgRefundEo updateRefundEo = new DgRefundEo();
                    updateRefundEo.setId(((DgRefundDetailEo)refundDetailEoList.get(0)).getRefundId());
                    updateRefundEo.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
                    this.dgRefundDomain.updateSelective((BaseEo)updateRefundEo);
                    if (((DgRefundDetailEo)refundDetailEoList.get(0)).getAfterSaleOrderId() != null) {
                        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(((DgRefundDetailEo)refundDetailEoList.get(0)).getAfterSaleOrderId());
                        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
                        dgAfterSaleOrderEo.setId(afterSaleOrderEo.getId());
                        dgAfterSaleOrderEo.setRefundStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
                        this.dgAfterSaleOrderDomain.updateSelective((BaseEo)dgAfterSaleOrderEo);
                    }
                    for (DgRefundDetailEo dgRefundDetailEo : refundDetailEoList) {
                        DgRefundDetailEo updateRefundDetailEo = new DgRefundDetailEo();
                        updateRefundDetailEo.setId(dgRefundDetailEo.getId());
                        updateRefundDetailEo.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
                        updateRefundDetailEo.setRefundTime(reqDto.getFinishTime());
                        this.dgRefundDetailDomain.updateSelective((BaseEo)updateRefundDetailEo);
                    }
                    break block9;
                }
                log.info("\u9000\u6b3e\u72b6\u6001\u975e\u7ec8\u6001,\u4e0d\u5904\u7406\u540e\u7eed\u6d41\u7a0b");
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                log.error("\u9000\u6b3e\u6d88\u606f\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
            }
        }
        return MessageResponse.SUCCESS;
    }
}

