/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.afterorder;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgF2BAfterStatus;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderReturnBizTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderOptService;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgF2BAfterOrderStatemachineHandle;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="TRADE_DELAY_TOPIC", tag="F2B_CHANNEL_TRANSFER_SALE_RETURN")
public class ChannelTransferSaleReturnProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChannelTransferSaleReturnProcessor.class);
    @Resource
    private IDgF2BAfterOrderStatemachineHandle dgF2BAfterOrderStatemachineHandle;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderOptService dgAfterSaleOrderOptService;

    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        try {
            DgAfterSaleOrderDto orderDto = (DgAfterSaleOrderDto)JSON.parseObject((String)message.getData().toString(), DgAfterSaleOrderDto.class);
            LOGGER.info("\u63a5\u6536\u6e20\u9053\u9000\u8d27\u5355\u63a8\u9001MQ\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderDto));
            DgAfterSaleOrderEo channelAfterOrder = (DgAfterSaleOrderEo)this.dgAfterSaleOrderDomain.selectByPrimaryKey(orderDto.getId());
            AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)channelAfterOrder), (String)("\u627e\u4e0d\u5230\u6e20\u9053\u9000\u8d27\u5355\u4fe1\u606f\uff1a" + orderDto.getId()));
            LOGGER.info("\u9000\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)channelAfterOrder));
            switch (AfterSaleOrderReturnBizTypeEnum.forCode((Integer)channelAfterOrder.getReturnBizType())) {
                case SPECIAL_RETURN: 
                case DEALER_SECOND_RETURN: {
                    if (channelAfterOrder.getStatus().equals(DgF2BAfterStatus.WAIT_IN_STORAGE.getCode())) {
                        RestResponseHelper.extractData((RestResponse)this.dgF2BAfterOrderStatemachineHandle.channelTransferSaleReturn(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderDto));
                    }
                    break;
                }
                case DIRECT_SALE_FIRST_RETURN: 
                case DIRECT_SALE_SECOND_RETURN: 
                case DIRECT_SALE_UNDELIVERED_RETURN: 
                case ADJUSTMENT_RETURN_ORDER: {
                    if (channelAfterOrder.getStatus().equals(DgF2BAfterStatus.COMPLETE.getCode())) {
                        RestResponseHelper.extractData((RestResponse)this.dgF2BAfterOrderStatemachineHandle.channelTransferSaleReturn(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderDto));
                    }
                    break;
                }
                case UNDELIVERED_RETURN: {
                    LOGGER.info("\u7ecf\u9500\u5546\u672a\u53d1\u8d27\u9000\u8d27");
                    if (channelAfterOrder.getStatus().equals(DgF2BAfterStatus.WAIT_IN_STORAGE.getCode())) {
                        LOGGER.info("\u5355\u636e\u5f85\u9000\u8d27\uff0c\u8f6c\u5355\u62c6\u5355");
                        RestResponseHelper.extractData((RestResponse)this.dgF2BAfterOrderStatemachineHandle.channelTransferSaleReturn(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderDto));
                        break;
                    }
                    if (channelAfterOrder.getStatus().equals(DgF2BAfterStatus.COMPLETE.getCode())) {
                        LOGGER.info("\u5355\u636e\u5b8c\u6210\uff0c\u66f4\u65b0\u7ed3\u7b97\u91d1\u989d");
                        RestResponseHelper.extractData((RestResponse)this.dgF2BAfterOrderStatemachineHandle.channelTransferSaleReturn(DgPerformOrderBizModelEnum.F2B_ORDER.getCode(), orderDto));
                        this.dgAfterSaleOrderOptService.channelCompleteUpdateSaleReturn(orderDto);
                    }
                    break;
                }
                default: {
                    LOGGER.info("\u672a\u5904\u7406\u5355\u636e\uff01\uff01");
                    break;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u63a5\u6536\u6e20\u9053\u9000\u8d27\u5355\u63a8\u9001MQ\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

