/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.afterorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BAfterSaleStatemachineHandle;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="CREATE_PLATFORM_SETTLEMENT_AFTER_ORDER")
public class E3CreatePlatformSettlementAfterOrderProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(E3CreatePlatformSettlementAfterOrderProcessor.class);
    @Resource
    private IDgB2BAfterSaleStatemachineHandle dgB2BAfterSaleStatemachineHandle;
    private static final String B2B_AFTER_BIZ_MODEL = "SALE_REFUND";

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("[\u63a5\u6536\u521b\u5efa\u5e73\u53f0\u7ed3\u7b97\u9000\u5355\u6d88\u606f]: {}", (Object)JSON.toJSONString((Object)message.getData()));
        try {
            List reqDtos = JSON.parseArray((String)message.getData().toString(), DgBizAfterSaleOrderReqDto.class);
            if (CollectionUtils.isNotEmpty((Collection)reqDtos)) {
                for (DgBizAfterSaleOrderReqDto reqDto : reqDtos) {
                    this.dgB2BAfterSaleStatemachineHandle.createPlatformSettlementeAfterOrderByImport(B2B_AFTER_BIZ_MODEL, reqDto);
                }
            }
        }
        catch (Exception e) {
            throw new BizException("\u521b\u5efa\u5e73\u53f0\u7ed3\u7b97\u9000\u5355\u5931\u8d25" + e.getMessage());
        }
        return MessageResponse.SUCCESS;
    }
}

