/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.config;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.yunxi.dg.base.center.shop.dto.entity.ShopUpdateMessageDto;
import com.yunxi.dg.base.center.shop.dto.response.DgShopRespDto;
import com.yunxi.dg.base.center.trade.constants.config.AutoAuditTypeEnum;
import com.yunxi.dg.base.center.trade.constants.config.AutoCancelTypeEnum;
import com.yunxi.dg.base.center.trade.constants.config.InventoryPreemptionEnum;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationReqDto;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="SHOP_UPDATE_CHANNEL_TAG", msgType="publish")
public class ShopAuditPassAddConfigProcessor
implements IMessageProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(ShopAuditPassAddConfigProcessor.class);
    @Resource
    private IDgOrderConfigurationService dgOrderConfigurationService;

    public MessageResponse process(String message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("\u4ea4\u6613\u4e2d\u5fc3\u63a5\u6536\u5e97\u94fa\u5ba1\u6838\u901a\u8fc7\u6d88\u606f\uff1a{}", (Object)message);
        if (StringUtils.isBlank((CharSequence)message)) {
            return MessageResponse.SUCCESS;
        }
        ShopUpdateMessageDto shopBaseDto = (ShopUpdateMessageDto)JacksonUtil.readValue((String)message, ShopUpdateMessageDto.class);
        try {
            this.saveShopConfigInfo(shopBaseDto.getNewShop());
        }
        catch (Exception e) {
            logger.error("[\u521d\u59cb\u5316\u65b0\u589e\u5e97\u94fa\u8ba2\u5355\u914d\u7f6e\u5931\u8d25]:{}", (Object)e.getMessage());
            e.printStackTrace();
            return MessageResponse.SUCCESS;
        }
        return MessageResponse.SUCCESS;
    }

    private void saveShopConfigInfo(DgShopRespDto shopBaseDto) {
        DgOrderConfigurationReqDto addDto = new DgOrderConfigurationReqDto();
        addDto.setOrganizationId(shopBaseDto.getSaleOrganizationId());
        addDto.setOrganizationName(shopBaseDto.getSaleOrganizationName());
        addDto.setOrganizationCode(shopBaseDto.getSaleOrganizationCode());
        addDto.setShopId(shopBaseDto.getId());
        addDto.setShopCode(shopBaseDto.getStoreCode());
        addDto.setShopName(shopBaseDto.getStoreName());
        addDto.setInventoryPreemption(InventoryPreemptionEnum.SUBMIT.getType());
        addDto.setAutoCancelNum(Integer.valueOf(1));
        addDto.setAutoCancelType(AutoCancelTypeEnum.DAY.getType());
        addDto.setBusinessAudit(AutoAuditTypeEnum.AUTO_AUDIT.getType());
        addDto.setFinancialAudit(AutoAuditTypeEnum.MANUAL_AUDIT.getType());
        addDto.setReturnAudit(AutoAuditTypeEnum.MANUAL_AUDIT.getType());
        addDto.setComputeKneadPrice(YesNoEnum.YES.getValue());
        addDto.setKneadPriceReturn(YesNoEnum.YES.getValue());
        ArrayList priorityDtoList = Lists.newArrayList();
        addDto.setPriorityDtoList(Collections.emptyList());
        this.dgOrderConfigurationService.addConfigInfo(addDto);
    }
}

