/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.service.oms.common.Impl.OrderCommonHandleServiceImpl;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BSaleStatemachineHandle;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="CREATE_PLATFORM_SETTLEMENT_ORDER")
public class E3CreatePlatformSettlementOrderProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(E3CreatePlatformSettlementOrderProcessor.class);
    @Resource
    private IDgB2BSaleStatemachineHandle dgB2BSaleStatemachineHandle;
    @Resource
    private OrderCommonHandleServiceImpl orderCommonHandleService;
    private static final String B2B_AFTER_BIZ_MODEL = "INSIDE_SALES_ORDER";

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("[\u63a5\u6536\u521b\u5efa\u5e73\u53f0\u7ed3\u7b97\u8ba2\u5355\u6d88\u606f]: {}", (Object)JSON.toJSONString((Object)message.getData()));
        try {
            List reqDtos = JSON.parseArray((String)message.getData().toString(), DgBizPerformOrderReqDto.class);
            if (CollectionUtils.isNotEmpty((Collection)reqDtos)) {
                for (DgBizPerformOrderReqDto reqDto : reqDtos) {
                    this.dgB2BSaleStatemachineHandle.createSaleOrder(B2B_AFTER_BIZ_MODEL, reqDto);
                }
            }
        }
        catch (Exception e) {
            throw new BizException("\u521b\u5efa\u5e73\u53f0\u7ed3\u7b97\u8ba2\u5355\u5931\u8d25" + e.getMessage());
        }
        return MessageResponse.SUCCESS;
    }
}

