/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.inventory.service.holdMerge.MergeOrderNoticeVo;
import com.yunxi.dg.base.center.trade.action.oms.B2B.IB2BOrderMergeAction;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.constant.DgB2BOrderStatus;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BSaleStatemachineHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="NOTICE_MERGE_TAG", msgType="publish")
public class MergeOrderNoticeProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(MergeOrderNoticeProcessor.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(MergeOrderNoticeProcessor.class);
    private static final String MERGE_TYPE = "merge";
    private static final String SPLIT_TYPE = "split";
    private static final String MERGE_FAIL_TYPE = "mergeFail";
    @Resource
    private IB2BOrderMergeAction b2BOrderMergeAction;
    @Resource
    private IDgB2BSaleStatemachineHandle dgB2BSaleStatemachineHandle;
    @Resource
    private IDgOmsOrderInfoQueryDomain dgOmsOrderInfoQueryDomain;

    public MessageResponse process(MessageVo messageVo) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        LOGGER.info("\u4f9b\u5e94\u94fe-\u5408\u5355\u901a\u77e5\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        if (Objects.isNull(messageVo.getData())) {
            log.error("[\u5408\u5355\u901a\u77e5\u6d88\u606f]\u6d88\u606f\u4f53\u6570\u636e\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        MergeOrderNoticeVo vo = (MergeOrderNoticeVo)JSON.parseObject((String)messageVo.getData().toString(), MergeOrderNoticeVo.class);
        if (StringUtils.isBlank((CharSequence)vo.getOptType())) {
            LOGGER.error("\u5408\u5355\u901a\u77e5\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        if (CollectionUtil.isEmpty((Collection)vo.getRelevanceOrderNos())) {
            LOGGER.error("\u5408\u5355\u901a\u77e5\u5355\u53f7\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        if (Objects.equals(MERGE_TYPE, vo.getOptType())) {
            this.b2BOrderMergeAction.mergeOrder(vo.getRelevanceOrderNos(), vo.getMergeOrderNo());
        } else if (Objects.equals(SPLIT_TYPE, vo.getOptType())) {
            this.b2BOrderMergeAction.cancelMerge(vo.getMergeOrderNo());
            if (CollectionUtil.isNotEmpty((Collection)vo.getRelevanceOrderNos())) {
                List orderRespDtoList = this.dgOmsOrderInfoQueryDomain.queryInfoListByOrderNos(vo.getRelevanceOrderNos());
                for (DgPerformOrderRespDto dto : orderRespDtoList) {
                    try {
                        if (!Objects.equals(DgB2BOrderStatus.WAIT_DELIVERY.getCode(), dto.getOrderStatus())) continue;
                        this.dgB2BSaleStatemachineHandle.cancelAppoint(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), dto.getId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.error("\u53d6\u6d88\u5408\u5355\uff0c\u5b50\u5355\u53d1\u8d77\u53d6\u6d88\u540c\u6b65\u8ba2\u5355\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                    }
                }
            }
        } else if (Objects.equals(MERGE_FAIL_TYPE, vo.getOptType())) {
            List orderRespDtoList = this.dgOmsOrderInfoQueryDomain.queryInfoListByOrderNos(vo.getRelevanceOrderNos());
            for (DgPerformOrderRespDto dto : orderRespDtoList) {
                try {
                    if (!Objects.equals(DgB2BOrderStatus.WAIT_DELIVERY.getCode(), dto.getOrderStatus())) continue;
                    this.dgB2BSaleStatemachineHandle.cancelAppoint(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), dto.getId());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5408\u5355\u5f02\u5e38\u53d1\u8d77\u53d6\u6d88\u540c\u6b65\u8ba2\u5355\u5931\u8d25\uff1a{}", (Object)e.getMessage());
                }
            }
        } else {
            LOGGER.error("\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38\uff1a{}", (Object)vo.getOptType());
        }
        return MessageResponse.SUCCESS;
    }
}

