/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="PUBLISH_TOPIC", tag="NOTICE_LOGISTICS_NO_TAG")
public class NoticeLogisticsNoProcessor
implements IMessageProcessor<String> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    public MessageResponse process(String message) {
        this.logger.info("\u63a5\u6536\u5230\u66f4\u65b0\u7269\u6d41\u5355\u53f7\u6d88\u606f\uff1a{}", (Object)message);
        if (StringUtils.isEmpty((CharSequence)message)) {
            this.logger.info("\u63a5\u6536\u5230\u66f4\u65b0\u7269\u6d41\u5355\u53f7\u6d88\u606f\u6d88\u606f\u4f53\u4e3a\u7a7a,\u6d88\u606f\u5ffd\u7565\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        try {
            DgPerformOrderInfoEo info = this.dgPerformOrderInfoDomain.queryByOrderNo(message);
            if (info == null) {
                this.logger.info("\u67e5\u8be2\u65e0\u6570\u636e,\u6d88\u606f\u5ffd\u7565\u5904\u7406");
                return MessageResponse.SUCCESS;
            }
            DgPerformOrderInfoEo update = new DgPerformOrderInfoEo();
            update.setTenantId(Long.valueOf(2L));
            this.dgPerformOrderInfoDomain.updateSaleOrderById(info.getId(), update);
        }
        catch (Exception e) {
            this.logger.error("\u66f4\u65b0\u7269\u6d41\u5355\u53f7\u6d88\u606f\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
        }
        return MessageResponse.SUCCESS;
    }
}

