/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yunxi.dg.base.center.report.dto.entity.BizTagDto;
import com.yunxi.dg.base.center.report.dto.tag.ReBizTagPageReqDto;
import com.yunxi.dg.base.center.report.proxy.tag.IReBizTagApiProxy;
import com.yunxi.dg.base.center.trade.constants.strategy.DgStrategyConfItemTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyConfItemSuitDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgStrategyRuleSuitDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyConfItemSuitPageReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyRuleSuitPageReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyRuleReqDto;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleEo;
import com.yunxi.dg.base.center.trade.eo.DgStrategyRuleSuitEo;
import com.yunxi.dg.base.center.trade.eo.StrategyConfItemSuitEo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="REPORT_PUBLISH_TOPIC", tag="ORDER_LABEL_CHANGE_TAG", msgType="publish")
public class OrderTagLabelProcessor
implements IMessageProcessor<MessageVo> {
    private static Logger logger = LoggerFactory.getLogger(OrderTagLabelProcessor.class);
    @Resource
    private IReBizTagApiProxy reBizTagApiProxy;
    @Resource
    private IDgStrategyRuleDomain dgStrategyRuleDomain;
    @Resource
    private IDgStrategyConfItemSuitDomain dgStrategyConfItemSuitDomain;
    @Resource
    private IDgStrategyRuleSuitDomain dgStrategyRuleSuitDomain;
    private final ObjectMapper om = new ObjectMapper();

    public MessageResponse process(MessageVo message) {
        this.printProcessorInfo();
        try {
            String json = this.om.writeValueAsString((Object)message);
            logger.info("\u76d1\u542c\u5668\u63a5\u6536\u5230\u6d88\u606f\uff1a{}", (Object)json);
            String string = message.getData().toString();
            List data = JSONObject.parseArray((String)string, String.class);
            ReBizTagPageReqDto reBizTagPageReqDto = new ReBizTagPageReqDto();
            reBizTagPageReqDto.setTagCodes(data);
            List bizTagDtos = (List)RestResponseHelper.extractData((RestResponse)this.reBizTagApiProxy.findAll(reBizTagPageReqDto));
            logger.info("\u5339\u914d\u5f53\u524d\u66f4\u65b0\u7684\u6807\u7b7e\uff1a{}", (Object)JSON.toJSONString((Object)bizTagDtos));
            Map bizTagDtoMap = bizTagDtos.stream().collect(Collectors.toMap(BizTagDto::getTagCode, Function.identity()));
            Set<String> tagCodes = bizTagDtoMap.keySet();
            ArrayList<String> queryTagCodes = new ArrayList<String>(tagCodes);
            List collectNew = bizTagDtos.stream().map(BizTagDto::getTagCode).distinct().collect(Collectors.toList());
            HashSet largerSet = new HashSet(data);
            HashSet smallerSet = new HashSet(collectNew);
            largerSet.removeAll(smallerSet);
            ArrayList missElement = new ArrayList(largerSet);
            DgStrategyRuleReqDto dgStrategyRuleReqDto = new DgStrategyRuleReqDto();
            dgStrategyRuleReqDto.setLabelCodes(queryTagCodes);
            List dgStrategyRuleEos = this.dgStrategyRuleDomain.findAll(dgStrategyRuleReqDto);
            Map<String, List<DgStrategyRuleEo>> collectDeleted = dgStrategyRuleEos.stream().collect(Collectors.groupingBy(DgStrategyRuleEo::getLabelCode));
            if (CollectionUtils.isNotEmpty((Collection)dgStrategyRuleEos)) {
                for (DgStrategyRuleEo dgClueSuitAttributeEo : dgStrategyRuleEos) {
                    DgStrategyRuleEo dgStrategyRuleEoUpdate = new DgStrategyRuleEo();
                    dgStrategyRuleEoUpdate.setId(dgClueSuitAttributeEo.getId());
                    String labelCode = dgClueSuitAttributeEo.getLabelCode();
                    BizTagDto bizTagDto = (BizTagDto)bizTagDtoMap.get(labelCode);
                    dgStrategyRuleEoUpdate.setLabelName(bizTagDto.getTagName());
                    this.dgStrategyRuleDomain.updateSelective((BaseEo)dgStrategyRuleEoUpdate);
                }
            }
            DgStrategyConfItemSuitPageReqDto dgStrategyConfItemSuitPageReqDto = new DgStrategyConfItemSuitPageReqDto();
            dgStrategyConfItemSuitPageReqDto.setSuitType(DgStrategyConfItemTypeEnum.SPECIAL_LABEL.getCode());
            dgStrategyConfItemSuitPageReqDto.setSuitValues(queryTagCodes);
            List queryStrategyConfItemSuitEos = this.dgStrategyConfItemSuitDomain.findAll(dgStrategyConfItemSuitPageReqDto);
            Map<String, List<StrategyConfItemSuitEo>> collectDeleted1 = queryStrategyConfItemSuitEos.stream().collect(Collectors.groupingBy(StrategyConfItemSuitEo::getSuitValue));
            if (CollectionUtils.isNotEmpty((Collection)queryStrategyConfItemSuitEos)) {
                for (StrategyConfItemSuitEo queryStrategyConfItemSuitEo : queryStrategyConfItemSuitEos) {
                    StrategyConfItemSuitEo strategyConfItemSuitEoUpdate = new StrategyConfItemSuitEo();
                    strategyConfItemSuitEoUpdate.setId(queryStrategyConfItemSuitEo.getId());
                    String suitValue = strategyConfItemSuitEoUpdate.getSuitValue();
                    BizTagDto bizTagDto = (BizTagDto)bizTagDtoMap.get(suitValue);
                    strategyConfItemSuitEoUpdate.setDr(bizTagDto.getTagStatus() == 1 ? 0 : 1);
                    this.dgStrategyConfItemSuitDomain.updateSelective((BaseEo)strategyConfItemSuitEoUpdate);
                }
            }
            DgStrategyRuleSuitPageReqDto dgStrategyRuleSuitPageReqDto = new DgStrategyRuleSuitPageReqDto();
            dgStrategyRuleSuitPageReqDto.setSuitKeys(queryTagCodes);
            List queryList = this.dgStrategyRuleSuitDomain.findAll(dgStrategyRuleSuitPageReqDto);
            Map<String, List<DgStrategyRuleSuitEo>> collectDeleted2 = queryList.stream().collect(Collectors.groupingBy(DgStrategyRuleSuitEo::getSuitKey));
            if (CollectionUtils.isNotEmpty((Collection)queryList)) {
                for (DgStrategyRuleSuitEo dgStrategyRuleSuitEo : queryList) {
                    DgStrategyRuleSuitEo dgStrategyRuleSuitEoUpdate = new DgStrategyRuleSuitEo();
                    dgStrategyRuleSuitEoUpdate.setId(dgStrategyRuleSuitEo.getId());
                    String suitValue = dgStrategyRuleSuitEo.getSuitKey();
                    BizTagDto bizTagDto = (BizTagDto)bizTagDtoMap.get(suitValue);
                    dgStrategyRuleSuitEoUpdate.setDr(bizTagDto.getTagStatus() == 1 ? 0 : 1);
                    this.dgStrategyRuleSuitDomain.updateSelective((BaseEo)dgStrategyRuleSuitEoUpdate);
                }
            }
            if (CollectionUtils.isNotEmpty(missElement)) {
                for (String s : missElement) {
                    List<DgStrategyRuleSuitEo> dgStrategyRuleSuitEos;
                    List<StrategyConfItemSuitEo> strategyConfItemSuitEos;
                    List<DgStrategyRuleEo> dgStrategyRuleEos1 = collectDeleted.get(s);
                    if (CollectionUtils.isNotEmpty(dgStrategyRuleEos1)) {
                        List collect = dgStrategyRuleEos1.stream().map(BaseEo::getId).collect(Collectors.toList());
                        this.dgStrategyRuleDomain.logicDeleteByIds(collect);
                    }
                    if (CollectionUtils.isNotEmpty(strategyConfItemSuitEos = collectDeleted1.get(s))) {
                        List collect = strategyConfItemSuitEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                        this.dgStrategyConfItemSuitDomain.logicDeleteByIds(collect);
                    }
                    if (!CollectionUtils.isNotEmpty(dgStrategyRuleSuitEos = collectDeleted2.get(s))) continue;
                    List collect = dgStrategyRuleSuitEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                    this.dgStrategyConfItemSuitDomain.logicDeleteByIds(collect);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u76d1\u542c\u5668\u63a5\u6536\u5230\u6d88\u606f,\u6d88\u8d39\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
        return MessageResponse.SUCCESS;
    }

    protected void printProcessorInfo() {
        MQDesc mqDesc = this.getClass().getAnnotation(MQDesc.class);
        if (mqDesc == null) {
            logger.info("ProcessorInfo: \u672a\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f");
            return;
        }
        String info = String.format("topic=%s, tag=%s, consumer=%s, msgType=%s", mqDesc.topic(), mqDesc.tag(), mqDesc.consumer(), mqDesc.msgType());
        logger.info("ProcessorInfo: {}", (Object)info);
    }
}

