/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.dto.finance.PushStatusToTradeDto;
import com.yunxi.dg.base.center.trade.service.entity.IPerformOrderSysFinanceService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="PUSH_STATUS_TO_TRADE", msgType="single")
public class PerformOrderSysFinanceProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformOrderSysFinanceProcessor.class);
    @Resource
    private IPerformOrderSysFinanceService iPerformOrderSysFinanceService;

    public MessageResponse process(MessageVo message) {
        try {
            LOGGER.info("\u63a8\u9001\u8bb0\u8d26\u72b6\u6001\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
            PushStatusToTradeDto pushStatusToTradeDto = (PushStatusToTradeDto)JSON.parseObject((String)message.getData().toString(), PushStatusToTradeDto.class);
            String orderType = pushStatusToTradeDto.getOrderType();
            if (orderType.equals("SALE_LIST")) {
                this.iPerformOrderSysFinanceService.assembleSaleOrderAction(pushStatusToTradeDto);
            } else {
                this.iPerformOrderSysFinanceService.assembleAfterSaleOrderAction(pushStatusToTradeDto);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u63a8\u9001\u8bb0\u8d26\u72b6\u6001\u6d88\u606f\uff1a{}", (Object)e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

