/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2CSaleStatemachineHandle;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="PLATFORM_ORDER_MODIFY_ADDRES_TAG")
public class PlatformOrderModifyAddresProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(PlatformOrderModifyAddresProcessor.class);
    @Resource
    private IDgB2CSaleStatemachineHandle dgB2CSaleStatemachineHandle;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;

    public MessageResponse process(String message) {
        log.info("\u63a5\u6536\u5230\u5e73\u53f0\u8ba2\u5355\u66f4\u65b0\u6536\u8d27\u5730\u5740\u4fe1\u606f\u548c\uff1a{}", (Object)message);
        JSONObject msgObj = JSON.parseObject((String)message);
        String platformOrderNo = msgObj.getString("platformOrderNo");
        DgPerformOrderAddrReqDto reqDto = (DgPerformOrderAddrReqDto)msgObj.getObject("reqDto", DgPerformOrderAddrReqDto.class);
        List dgPerformOrderInfoEos = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        for (DgPerformOrderInfoEo dgPerformOrderInfoEo : dgPerformOrderInfoEos) {
            try {
                this.dgB2CSaleStatemachineHandle.modifyAddress(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), dgPerformOrderInfoEo.getId(), reqDto);
            }
            catch (Exception e) {
                log.error("\u8ba2\u5355:{},\u66f4\u65b0\u5730\u5740\u5f02\u5e38,\u5f02\u5e38\u539f\u56e0:{}", (Object)dgPerformOrderInfoEo.getSaleOrderNo(), (Object)e.getMessage());
            }
        }
        return MessageResponse.SUCCESS;
    }
}

