/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.ext.api.dto.request.OrderAuditReqDto;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderDetailDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderExtDto;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgF2BOrderStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.CustomOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrItemDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrItemExtDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.custom.DgCustomPackageOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.custom.DgCustomPackageOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrItemEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="TRANSFER_GOODS_ORDER_COMPLETE_TAG", msgType="publish")
public class TransferGoodsOrderCompleteProcessor
implements IMessageProcessor<TransferGoodsOrderExtDto> {
    private static final Logger log = LoggerFactory.getLogger(TransferGoodsOrderCompleteProcessor.class);
    private static final String STOCK_UP = "STOCK_UP";
    private static final String PICK_UP = "PICK_UP";
    @Resource
    private IDgPerformOrderAddrItemDomain dgPerformOrderAddrItemDomain;
    @Resource
    private ILockService lockService;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private IDgF2BOrderStatemachineApi dgF2BOrderStatemachineApi;
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageResponse process(TransferGoodsOrderExtDto orderExtDto) {
        Mutex mutex;
        block43: {
            MessageResponse orderAddrReqDtoMap2;
            block42: {
                MessageResponse messageResponse;
                block41: {
                    TransferOrderRespDto trfOrderDto;
                    block40: {
                        TransferOrderKeyDto transferOrderKeyDto;
                        block39: {
                            log.info("\u4f9b\u5e94\u94fe-\u6e20\u9053\u8c03\u8d27\u5355\u5b8c\u6210\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)orderExtDto));
                            mutex = null;
                            try {
                                List orderLobelCodes;
                                String extension;
                                if (!Objects.equals(orderExtDto.getOrderStatus(), "COMPLETED") && !Objects.equals(orderExtDto.getOrderStatus(), "FINISHED")) {
                                    log.info("\u8c03\u8d27\u5355\u72b6\u6001\u5f02\u5e38,\u4e0d\u5904\u7406");
                                    MessageResponse messageResponse2 = MessageResponse.SUCCESS;
                                    return messageResponse2;
                                }
                                String businessType = orderExtDto.getPreBusinessType();
                                String saleOrderNo = null;
                                if (StringUtils.isBlank((CharSequence)businessType) && StringUtils.isNotBlank((CharSequence)(extension = orderExtDto.getExtension()))) {
                                    JSONObject jsonObject = JSON.parseObject((String)extension);
                                    if (extension != null) {
                                        businessType = jsonObject.get((Object)"businessType") + "";
                                    }
                                }
                                if (Objects.equals(PICK_UP, businessType)) {
                                    businessType = orderExtDto.getPreBusinessType();
                                    transferOrderKeyDto = new TransferOrderKeyDto();
                                    transferOrderKeyDto.setTransferOrderNo(orderExtDto.getPreOrderNo());
                                    log.info("\u67e5\u8be2\u63d0\u8d27\u6539\u8c03\u62e8\u5355\u5165\u53c2\uff1a{}", JSON.toJSON((Object)transferOrderKeyDto));
                                    trfOrderDto = (TransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.detail(transferOrderKeyDto));
                                    AssertUtils.notNull((Object)trfOrderDto, (String)"\u63d0\u8d27\u6539\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
                                    saleOrderNo = trfOrderDto.getPreOrderNo();
                                } else {
                                    saleOrderNo = Objects.equals(STOCK_UP, businessType) ? orderExtDto.getPreOrderNo() : orderExtDto.getPreOrderNo();
                                }
                                mutex = this.lockService.lock("tr_dg_perform_order_info", saleOrderNo, 5, 5, TimeUnit.SECONDS);
                                if (mutex == null) {
                                    log.info("\u83b7\u53d6\u5206\u9875\u5f0f\u9501\u5931\u8d25\uff1a{}", (Object)saleOrderNo);
                                    transferOrderKeyDto = MessageResponse.SUCCESS;
                                    if (mutex == null) return transferOrderKeyDto;
                                    break block39;
                                }
                                DgPerformOrderRespDto orderRespDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(saleOrderNo);
                                if (orderRespDto == null) {
                                    log.warn("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
                                    trfOrderDto = MessageResponse.SUCCESS;
                                    if (mutex == null) return trfOrderDto;
                                    break block40;
                                }
                                DgPerformOrderSnapshotDto snapshotEo = orderRespDto.getPerformOrderSnapshotDto();
                                List itemExtDtoList = this.dgPerformOrderAddrItemDomain.queryItemAddrInfo(orderRespDto.getId());
                                Map<String, BigDecimal> tgodMap = orderExtDto.getOrderDetail().stream().collect(Collectors.toMap(TransferGoodsOrderDetailDto::getSkuCode, TransferGoodsOrderDetailDto::getCompleteQuantity));
                                Boolean autoAuditFlag = Boolean.TRUE;
                                List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(orderRespDto.getId());
                                Map orderLineMap = orderLineDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
                                if (CustomOrderTypeEnum.STOCK_REFORM_ORDER.getType().equals(orderRespDto.getOrderType())) {
                                    orderLobelCodes = this.dgOrderLabelRecordDomain.queryExistLabelCode(orderRespDto.getId(), (List)Lists.newArrayList((Object[])new DgOrderLabelEnum[]{DgOrderLabelEnum.DELIVERY_TRANSFER_ORDER, DgOrderLabelEnum.CREATE_DELIVERY_TRANSFER_FALI, DgOrderLabelEnum.PRODUCTION_TRANSFER_ORDER, DgOrderLabelEnum.CREATE_PRODUCTION_TRANSFER_FALI}));
                                    if (Objects.equals(PICK_UP, businessType) && !orderLobelCodes.contains(DgOrderLabelEnum.DELIVERY_TRANSFER_ORDER.getCode()) || Objects.equals(STOCK_UP, businessType) && !orderLobelCodes.contains(DgOrderLabelEnum.PRODUCTION_TRANSFER_ORDER.getCode())) {
                                        log.info("\u501f\u8d27\u5355\u5df2\u56de\u8c03");
                                        messageResponse = MessageResponse.SUCCESS;
                                        if (mutex == null) return messageResponse;
                                        break block41;
                                    }
                                    HashMap orderAddrReqDtoMap2 = Maps.newHashMap();
                                    for (DgPerformOrderAddrItemExtDto row : itemExtDtoList) {
                                        DgCustomPackageOrderAddrReqDto orderAddrReqDto;
                                        DgPerformOrderAddrItemEo updateEo;
                                        BigDecimal allotNum;
                                        BigDecimal balance;
                                        if (Objects.equals(STOCK_UP, businessType)) {
                                            if (row.getProductionReformNum() != null && BigDecimal.ZERO.compareTo(row.getProductionReformNum()) < 0) {
                                                balance = tgodMap.getOrDefault(row.getOriginalSkuCode(), BigDecimal.ZERO);
                                                allotNum = row.getProductionReformNum().min(balance);
                                                updateEo = new DgPerformOrderAddrItemEo();
                                                updateEo.setProductionReformNum(allotNum);
                                                updateEo.setId(row.getId());
                                                updateEo.setStockoutNum(row.getStockoutNum().subtract(allotNum));
                                                if (orderLobelCodes.size() == 1) {
                                                    updateEo.setItemNum(row.getPlaceItemNum().subtract(row.getStockoutNum()));
                                                    row.setProductionReformNum(allotNum);
                                                    row.setStockoutNum(row.getStockoutNum().subtract(allotNum));
                                                    row.setItemNum(row.getPlaceItemNum().subtract(row.getStockoutNum()));
                                                    orderAddrReqDto = orderAddrReqDtoMap2.getOrDefault(row.getOrderAddrId(), this.buildOrderAddrReqDto(row));
                                                    orderAddrReqDto.getItemList().add(this.buildOrderAddrItemReqDto(orderRespDto, row, (DgPerformOrderLineDto)orderLineMap.get(row.getOrderItemId())));
                                                    orderAddrReqDtoMap2.put(row.getOrderAddrId(), orderAddrReqDto);
                                                }
                                                if (BigDecimal.ZERO.compareTo(updateEo.getStockoutNum()) < 0) {
                                                    autoAuditFlag = Boolean.FALSE;
                                                }
                                                this.dgPerformOrderAddrItemDomain.updateSelective((BaseEo)updateEo);
                                                balance = balance.subtract(allotNum);
                                                tgodMap.put(row.getOriginalSkuCode(), balance);
                                            }
                                            this.dgOrderLabelRecordDomain.removeOrderLabelRecordById(orderRespDto.getId(), DgOrderLabelEnum.PRODUCTION_TRANSFER_ORDER);
                                            continue;
                                        }
                                        if (row.getDeliveryReformNum() != null && BigDecimal.ZERO.compareTo(row.getDeliveryReformNum()) < 0) {
                                            balance = tgodMap.getOrDefault(row.getOriginalSkuCode(), BigDecimal.ZERO);
                                            allotNum = row.getDeliveryReformNum().min(balance);
                                            updateEo = new DgPerformOrderAddrItemEo();
                                            updateEo.setDeliveryReformNum(allotNum);
                                            updateEo.setId(row.getId());
                                            updateEo.setStockoutNum(row.getStockoutNum().subtract(allotNum));
                                            if (orderLobelCodes.size() == 1) {
                                                updateEo.setItemNum(row.getPlaceItemNum().subtract(row.getStockoutNum()));
                                                row.setDeliveryReformNum(allotNum);
                                                row.setStockoutNum(row.getStockoutNum().subtract(allotNum));
                                                row.setItemNum(row.getPlaceItemNum().subtract(row.getStockoutNum()));
                                                orderAddrReqDto = orderAddrReqDtoMap2.getOrDefault(row.getOrderAddrId(), this.buildOrderAddrReqDto(row));
                                                orderAddrReqDto.getItemList().add(this.buildOrderAddrItemReqDto(orderRespDto, row, (DgPerformOrderLineDto)orderLineMap.get(row.getOrderItemId())));
                                                orderAddrReqDtoMap2.put(row.getOrderAddrId(), orderAddrReqDto);
                                            }
                                            if (BigDecimal.ZERO.compareTo(updateEo.getStockoutNum()) < 0) {
                                                autoAuditFlag = Boolean.FALSE;
                                            }
                                            this.dgPerformOrderAddrItemDomain.updateSelective((BaseEo)updateEo);
                                            balance = balance.subtract(allotNum);
                                            tgodMap.put(row.getOriginalSkuCode(), balance);
                                        }
                                        this.dgOrderLabelRecordDomain.removeOrderLabelRecordById(orderRespDto.getId(), DgOrderLabelEnum.DELIVERY_TRANSFER_ORDER);
                                    }
                                    if (CollectionUtils.isNotEmpty(orderAddrReqDtoMap2.values())) {
                                        this.calcOrder(orderRespDto, Lists.newArrayList(orderAddrReqDtoMap2.values()));
                                    }
                                } else {
                                    orderLobelCodes = this.dgOrderLabelRecordDomain.queryExistLabelCode(orderRespDto.getId(), (List)Lists.newArrayList((Object[])new DgOrderLabelEnum[]{DgOrderLabelEnum.WAIT_BORROW_GOODS}));
                                    if (CollectionUtils.isEmpty((Collection)orderLobelCodes)) {
                                        log.info("\u8ba2\u5355\u5df2\u89e3\u6302\uff0c\u4e0d\u518d\u91cd\u590d\u5904\u7406\uff1a{}", (Object)orderRespDto.getSaleOrderNo());
                                        orderAddrReqDtoMap2 = MessageResponse.SUCCESS;
                                        if (mutex == null) return orderAddrReqDtoMap2;
                                        break block42;
                                    }
                                    HashMap addrReqDtoMap = Maps.newHashMap();
                                    for (DgPerformOrderAddrItemExtDto row : itemExtDtoList) {
                                        DgCustomPackageOrderAddrReqDto addrReqDto;
                                        DgPerformOrderAddrItemEo itemEo = new DgPerformOrderAddrItemEo();
                                        itemEo.setId(row.getId());
                                        BigDecimal balance = tgodMap.get(row.getSkuCode());
                                        if (balance != null && BigDecimal.ZERO.compareTo(balance) < 0) {
                                            BigDecimal app = balance.subtract(Optional.ofNullable(row.getStockoutNum()).orElse(BigDecimal.ZERO));
                                            if (BigDecimal.ZERO.compareTo(app) <= 0) {
                                                itemEo.setStockoutNum(BigDecimal.ZERO);
                                                balance = app;
                                            } else {
                                                itemEo.setStockoutNum(app.negate());
                                                itemEo.setItemNum(row.getPlaceItemNum().subtract(itemEo.getStockoutNum()));
                                                row.setItemNum(itemEo.getItemNum());
                                                balance = BigDecimal.ZERO;
                                            }
                                            tgodMap.put(row.getSkuCode(), balance);
                                            this.dgPerformOrderAddrItemDomain.updateSelective((BaseEo)itemEo);
                                        }
                                        if (!addrReqDtoMap.containsKey(row.getOrderAddrId())) {
                                            addrReqDto = new DgCustomPackageOrderAddrReqDto();
                                            addrReqDto.setAddrLineNo(row.getOrderAddrId());
                                            addrReqDto.setAddressId(row.getAddressId());
                                            addrReqDto.setCity(row.getCity());
                                            addrReqDto.setCityCode(row.getCityCode());
                                            addrReqDto.setCounty(row.getCounty());
                                            addrReqDto.setCountyCode(row.getCountyCode());
                                            addrReqDto.setId(row.getOrderAddrId());
                                            addrReqDto.setProvince(row.getProvince());
                                            addrReqDto.setProvinceCode(row.getProvinceCode());
                                            addrReqDto.setPurchaseOrderNo(row.getPurchaseOrderNo());
                                            addrReqDto.setReceiveAddress(row.getReceiveAddress());
                                            addrReqDto.setReceiveName(row.getReceiveName());
                                            addrReqDto.setReceivePhone(row.getReceivePhone());
                                            addrReqDto.setItemList((List)Lists.newArrayList());
                                            addrReqDtoMap.put(row.getOrderAddrId(), addrReqDto);
                                        }
                                        addrReqDto = (DgCustomPackageOrderAddrReqDto)addrReqDtoMap.get(row.getOrderAddrId());
                                        addrReqDto.getItemList().add(this.buildOrderAddrItemReqDto(orderRespDto, row, (DgPerformOrderLineDto)orderLineMap.get(row.getOrderItemId())));
                                    }
                                    if (CollectionUtils.isNotEmpty(addrReqDtoMap.values())) {
                                        this.calcOrder(orderRespDto, Lists.newArrayList(addrReqDtoMap.values()));
                                    }
                                    if (!Objects.equals(orderExtDto.getOrderStatus(), "COMPLETED")) {
                                        autoAuditFlag = Boolean.FALSE;
                                    }
                                }
                                if (autoAuditFlag.booleanValue()) {
                                    OrderAuditReqDto orderAuditReqDto = new OrderAuditReqDto();
                                    orderAuditReqDto.setAuditResult(Integer.valueOf(1));
                                    orderAuditReqDto.setAuditDesc("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
                                    orderAuditReqDto.setAuditor("system");
                                    orderAuditReqDto.setAuditType("1");
                                    orderAuditReqDto.setOrderId(orderRespDto.getId());
                                    HashMap<String, String> stringStringHashMap = new HashMap<String, String>();
                                    stringStringHashMap.put("auditStatus", "pass");
                                    orderAuditReqDto.setExtFields(stringStringHashMap);
                                    orderAuditReqDto.setTradeNo(orderRespDto.getSaleOrderNo());
                                    this.dgF2BOrderStatemachineApi.auditOrder(orderAuditReqDto);
                                }
                                if (mutex == null) return MessageResponse.SUCCESS;
                                break block43;
                            }
                            catch (Exception e) {
                                log.error("\u6e20\u9053\u8c03\u8d27\u7ed3\u679c\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)e);
                                return MessageResponse.SUCCESS;
                            }
                        }
                        this.lockService.unlock(mutex);
                        return transferOrderKeyDto;
                    }
                    this.lockService.unlock(mutex);
                    return trfOrderDto;
                }
                this.lockService.unlock(mutex);
                return messageResponse;
            }
            this.lockService.unlock(mutex);
            return orderAddrReqDtoMap2;
        }
        this.lockService.unlock(mutex);
        return MessageResponse.SUCCESS;
        finally {
            if (mutex != null) {
                this.lockService.unlock(mutex);
            }
        }
    }

    private void calcOrder(DgPerformOrderRespDto orderRespDto, List<DgCustomPackageOrderAddrReqDto> reqDtos) {
        DgPerformOrderSnapshotDto snapshotDto = orderRespDto.getPerformOrderSnapshotDto();
        DgCustomPackageOrderReqDto reqDto = new DgCustomPackageOrderReqDto();
        reqDto.setId(orderRespDto.getId());
        reqDto.setCustomerId(snapshotDto.getCustomerId());
        reqDto.setDeliveryDate(orderRespDto.getDeliveryDate());
        reqDto.setMatchActivity(Boolean.FALSE);
        reqDto.setOrderSource(orderRespDto.getOrderSource());
        reqDto.setOrderType(orderRespDto.getOrderType());
        reqDto.setPlanShipmentEnterpriseCode(orderRespDto.getPlanShipmentEnterpriseCode());
        reqDto.setPlanShipmentEnterpriseName(orderRespDto.getPlanShipmentEnterpriseName());
        reqDto.setShopId(snapshotDto.getShopId());
        reqDto.setOrderAddrReqDtos(reqDtos);
        reqDto.setCustomerDiscountId(orderRespDto.getCustomerDiscountId());
        reqDto.setHandmadeDiscount(orderRespDto.getHandmadeDiscount());
        reqDto.setCustomerBatch(orderRespDto.getPerformOrderExtensionDto().getCustomerBatch());
        reqDto.setDirectOrder(orderRespDto.getDirectOrder());
        reqDto.setPackageRemark(orderRespDto.getPackageRemark());
        reqDto.setPlanShipmentEnterpriseId(orderRespDto.getPlanShipmentEnterpriseId());
        reqDto.setPlanShipmentEnterpriseCode(orderRespDto.getPlanShipmentEnterpriseCode());
        reqDto.setPlanShipmentEnterpriseName(orderRespDto.getPlanShipmentEnterpriseName());
        reqDto.setRemark(orderRespDto.getRemark());
        reqDto.setSellerRemark(orderRespDto.getSellerRemark());
        reqDto.setSaleOrderNo(orderRespDto.getSaleOrderNo());
        reqDto.setChannelWarehouseId(orderRespDto.getPerformOrderSnapshotDto().getChannelWarehouseId());
        reqDto.setChannelWarehouseCode(orderRespDto.getPerformOrderSnapshotDto().getChannelWarehouseCode());
        reqDto.setChannelWarehouseName(orderRespDto.getPerformOrderSnapshotDto().getChannelWarehouseName());
        reqDto.setProductionLotNumber(orderRespDto.getPerformOrderExtensionDto().getProductionLotNumber());
        this.dgF2BOrderStatemachineApi.customPackageRecalculateOrder(reqDto);
    }

    private OrderPreviewItemReqDto buildOrderAddrItemReqDto(DgPerformOrderRespDto orderRespDto, DgPerformOrderAddrItemExtDto orderAddrItemExtDto, DgPerformOrderLineDto orderLineDto) {
        OrderPreviewItemReqDto itemReqDto = new OrderPreviewItemReqDto();
        BeanUtil.copyProperties((Object)orderLineDto, (Object)itemReqDto, (String[])new String[0]);
        itemReqDto.setItemLineNo(orderAddrItemExtDto.getOrderItemId());
        itemReqDto.setItemId(orderAddrItemExtDto.getItemId());
        itemReqDto.setSkuId(orderAddrItemExtDto.getSkuId());
        itemReqDto.setShopId(orderRespDto.getPerformOrderSnapshotDto().getShopId());
        itemReqDto.setItemNum(orderAddrItemExtDto.getItemNum());
        itemReqDto.setPlaceItemNum(orderAddrItemExtDto.getPlaceItemNum());
        itemReqDto.setHandmadeDiscount(orderLineDto.getHandmadeDiscount());
        itemReqDto.setHandmadeDiscountAmount(orderLineDto.getHandmadeDiscountAmount());
        itemReqDto.setOrderItemUnit(orderLineDto.getOrderItemUnit());
        itemReqDto.setOrderItemUnitName(orderLineDto.getOrderItemUnitName());
        itemReqDto.setIsRebate(orderLineDto.getIsRebate());
        itemReqDto.setStocksCode(orderAddrItemExtDto.getStocksCode());
        itemReqDto.setRemark(orderLineDto.getRemark());
        return itemReqDto;
    }

    private DgCustomPackageOrderAddrReqDto buildOrderAddrReqDto(DgPerformOrderAddrItemExtDto row) {
        DgCustomPackageOrderAddrReqDto addrReqDto = new DgCustomPackageOrderAddrReqDto();
        addrReqDto.setAddrLineNo(row.getOrderAddrId());
        addrReqDto.setAddressId(row.getAddressId());
        addrReqDto.setCity(row.getCity());
        addrReqDto.setCityCode(row.getCityCode());
        addrReqDto.setCounty(row.getCounty());
        addrReqDto.setCountyCode(row.getCountyCode());
        addrReqDto.setId(row.getOrderAddrId());
        addrReqDto.setProvince(row.getProvince());
        addrReqDto.setProvinceCode(row.getProvinceCode());
        addrReqDto.setPurchaseOrderNo(row.getPurchaseOrderNo());
        addrReqDto.setReceiveAddress(row.getReceiveAddress());
        addrReqDto.setReceiveName(row.getReceiveName());
        addrReqDto.setReceivePhone(row.getReceivePhone());
        addrReqDto.setItemList((List)Lists.newArrayList());
        return addrReqDto;
    }
}

