/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order.advance;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderItemLineEo;
import com.yunxi.dg.base.center.trade.mqc.order.advance.msg.DeliveryCompleteMessageDto;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_STATUS_CREATE_TAG", msgType="single", topic="PUBLISH_TOPIC")
public class AdvanceOrderDeliveryPlanProcessor
implements IMessageProcessor<String> {
    @Resource
    private IDgAdvanceOrderItemLineDomain dgAdvanceOrderItemLineDomain;

    public MessageResponse process(String message) {
        try {
            LOG.info("[\u9884\u8ba2\u5355\u6d88\u8d39\u843d\u8d27\u8ba1\u5212]\u5f00\u59cb\u6d88\u8d39\uff0c\u6d88\u606f\u4f53\uff1a{}", (Object)JSON.toJSONString((Object)message));
            List messageDtoList = JSON.parseArray((String)message, DeliveryCompleteMessageDto.class);
            List orderNoLIst = messageDtoList.stream().map(DeliveryCompleteMessageDto::getPrecedingOrderNumber).collect(Collectors.toList());
            List skuCodeList = messageDtoList.stream().map(DeliveryCompleteMessageDto::getSkuCode).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(orderNoLIst) || CollectionUtils.isEmpty(skuCodeList)) {
                LOG.error("[\u9884\u8ba2\u5355\u6d88\u8d39\u843d\u8d27\u8ba1\u5212]\u6d88\u8d39\u5931\u8d25\uff1a\u9884\u8ba2\u5355\u53f7\u6216sku\u7f16\u7801\u4e3a\u7a7a");
                return MessageResponse.SUCCESS;
            }
            Map strStatusMap = messageDtoList.stream().collect(Collectors.toMap(o -> o.getPrecedingOrderNumber() + o.getSkuCode(), Function.identity(), (k1, k2) -> k1));
            List lineEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAdvanceOrderItemLineDomain.filter().in((Object)"order_no", orderNoLIst)).eq((Object)"status", (Object)0)).in((Object)"sku_code", skuCodeList)).list();
            if (CollectionUtils.isEmpty((Collection)lineEoList)) {
                LOG.info("[\u9884\u8ba2\u5355\u6d88\u8d39\u843d\u8d27\u8ba1\u5212]\u6d88\u8d39\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9884\u8ba2\u5355\u6216sku\u7f16\u7801");
                return MessageResponse.SUCCESS;
            }
            for (DgAdvanceOrderItemLineEo itemLineEo : lineEoList) {
                String key = itemLineEo.getOrderNo() + itemLineEo.getSkuCode();
                DeliveryCompleteMessageDto messageDto = (DeliveryCompleteMessageDto)strStatusMap.get(key);
                if (Objects.isNull(messageDto)) {
                    LOG.info("[\u9884\u8ba2\u5355\u6d88\u8d39\u843d\u8d27\u8ba1\u5212]\u6d88\u8d39\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9884\u8ba2\u5355\u6216sku\u7f16\u7801{}", (Object)key);
                    continue;
                }
                Integer status = messageDto.getStatus();
                itemLineEo.setDeliveryPlanNo(messageDto.getDocumentNo());
                if (Objects.equals(status, 0)) {
                    itemLineEo.setDeliveryPlan(Integer.valueOf(1));
                    continue;
                }
                if (!Objects.equals(status, 1)) continue;
                itemLineEo.setDeliveryPlan(Integer.valueOf(0));
                itemLineEo.setDeliveryPlanNo("");
            }
            this.dgAdvanceOrderItemLineDomain.updateAdditivePriceBatch(lineEoList);
        }
        catch (Exception e) {
            LOG.error("[\u9884\u8ba2\u5355\u6d88\u8d39\u843d\u8d27\u8ba1\u5212]\u6d88\u8d39\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return MessageResponse.SUCCESS;
        }
        LOG.info("[\u9884\u8ba2\u5355\u6d88\u8d39\u843d\u8d27\u8ba1\u5212]\u6d88\u8d39\u6210\u529f");
        return MessageResponse.SUCCESS;
    }
}

