/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order.advance;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAdvanceOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.eo.DgAdvanceOrderItemLineEo;
import com.yunxi.dg.base.center.trade.mqc.order.advance.msg.PurchaseOrderMsgDto;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="PUSH_PURCHASE_ORDER", msgType="single", topic="PUBLISH_TOPIC")
public class AdvanceOrderEntryProcessor
implements IMessageProcessor<String> {
    @Resource
    private IDgAdvanceOrderItemLineDomain dgAdvanceOrderItemLineDomain;

    public MessageResponse process(String message) {
        try {
            LOG.info("[\u9884\u8ba2\u5355\u6d88\u8d39\u5165\u5e93]\u5f00\u59cb\u6d88\u8d39\uff0c\u6d88\u606f\u4f53\uff1a{}", (Object)message);
            PurchaseOrderMsgDto purchaseOrderMsgDto = (PurchaseOrderMsgDto)JSON.parseObject((String)message, PurchaseOrderMsgDto.class);
            if (StringUtils.isBlank((CharSequence)purchaseOrderMsgDto.getPreOrderNo()) || CollectionUtils.isEmpty(purchaseOrderMsgDto.getLines()) || Objects.isNull(purchaseOrderMsgDto.getCompleteDate())) {
                LOG.error("[\u9884\u8ba2\u5355\u6d88\u8d39\u5165\u5e93]\u6d88\u8d39\u5931\u8d25\uff1a\u9884\u8ba2\u5355\u53f7\u3001sku\u7f16\u7801\u6216\u5165\u5e93\u65f6\u95f4\u4e3a\u7a7a");
                return MessageResponse.ERROR;
            }
            List skuCodeList = purchaseOrderMsgDto.getLines().stream().map(PurchaseOrderMsgDto.Line::getSkuCode).collect(Collectors.toList());
            List lineEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgAdvanceOrderItemLineDomain.filter().in((Object)"order_no", new Object[]{purchaseOrderMsgDto.getPreOrderNo()})).eq((Object)"status", (Object)0)).in((Object)"sku_code", skuCodeList)).list();
            if (CollectionUtils.isEmpty((Collection)lineEoList)) {
                LOG.info("[\u9884\u8ba2\u5355\u6d88\u8d39\u5165\u5e93]\u6d88\u8d39\u5931\u8d25\uff1a\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9884\u8ba2\u5355\u6216sku\u7f16\u7801");
                return MessageResponse.ERROR;
            }
            for (DgAdvanceOrderItemLineEo itemLineEo : lineEoList) {
                itemLineEo.setEntryStatus(Integer.valueOf(1));
                itemLineEo.setEntryTime(purchaseOrderMsgDto.getCompleteDate());
            }
            this.dgAdvanceOrderItemLineDomain.updateAdditivePriceBatch(lineEoList);
        }
        catch (Exception e) {
            LOG.error("[\u9884\u8ba2\u5355\u6d88\u8d39\u5165\u5e93]\u6d88\u8d39\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return MessageResponse.ERROR;
        }
        LOG.info("[\u9884\u8ba2\u5355\u6d88\u8d39\u5165\u5e93]\u6d88\u8d39\u6210\u529f");
        return MessageResponse.SUCCESS;
    }
}

