/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order.platform;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2CSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsActivityService;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderStatus;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="CIS_SALE_ORDER_STATUS_CHANGE_TAG", msgType="publish")
public class PlatformOrderCompleteProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger log = LoggerFactory.getLogger(PlatformOrderCompleteProcessor.class);
    @Resource
    private IDgOmsActivityService dgOmsActivityService;
    @Resource
    private IDgB2CSaleStatemachineApi dgB2CSaleStatemachineApi;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain dgOmsOrderInfoQueryDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain dgPerformOrderSplitReleationDomain;

    public MessageResponse process(MessageVo messageVo) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        log.info("\u63a5\u6536\u5230\u5e73\u53f0\u8ba2\u5355\u5b8c\u6210mq\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        DgPerformOrderRespDto performOrderRespDto = (DgPerformOrderRespDto)JSON.parseObject((String)((String)messageVo.getData()), DgPerformOrderRespDto.class);
        List giftItemDtos = Lists.newArrayList();
        JSONObject object = JSON.parseObject((String)((String)messageVo.getData()));
        List orderRespDtoList = this.dgOmsOrderInfoQueryDomain.queryDtoByPlatformOrderNo(performOrderRespDto.getPlatformOrderNo());
        orderRespDtoList = orderRespDtoList.stream().filter(orderDto -> !Objects.equals(orderDto.getOrderType(), DgSaleOrderTypeEnum.REPLENISH_ORDER.getType())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(orderRespDtoList)) {
            return MessageResponse.SUCCESS;
        }
        Long mainOrderId = null;
        if (orderRespDtoList.size() == 1) {
            mainOrderId = ((DgPerformOrderRespDto)orderRespDtoList.get(0)).getId();
        } else {
            List dgPerformOrderSplitReleationEos = this.dgPerformOrderSplitReleationDomain.queryByOrderId(((DgPerformOrderRespDto)orderRespDtoList.get(0)).getId());
            mainOrderId = ((DgPerformOrderSplitReleationEo)dgPerformOrderSplitReleationEos.get(0)).getMainOrderId();
        }
        if (mainOrderId == null) {
            return MessageResponse.SUCCESS;
        }
        DgPerformOrderRespDto orderRespDto = this.dgOmsOrderInfoQueryDomain.queryDtoById(mainOrderId);
        if (Objects.equals(object.get((Object)"afterStatus"), DgB2COrderStatus.DELIVERED.getCode())) {
            giftItemDtos = this.dgOmsActivityService.joinActivityByOrderNo(orderRespDto, Integer.valueOf(3));
        } else if (Objects.equals(object.get((Object)"afterStatus"), DgB2COrderStatus.COMPLETE.getCode())) {
            giftItemDtos = this.dgOmsActivityService.joinActivityByOrderNo(orderRespDto, Integer.valueOf(2));
        }
        log.info("\u8865\u53d1\u5355\u5339\u914d\u5230\u8d60\u54c1\u4fe1\u606f\uff1a{}", JSON.toJSON((Object)giftItemDtos));
        if (CollectionUtils.isNotEmpty((Collection)giftItemDtos)) {
            DgPerformOrderAddrDto dgPerformOrderAddrDto = this.dgPerformOrderAddrDomain.queryAddressByOrderId(orderRespDto.getId());
            DgBizPerformOrderReqDto dgBizPerformOrderReqDto = new DgBizPerformOrderReqDto();
            dgBizPerformOrderReqDto.setOrderType(DgSaleOrderTypeEnum.REPLENISH_ORDER.getType());
            dgBizPerformOrderReqDto.setBizType(orderRespDto.getBizType());
            dgBizPerformOrderReqDto.setPlatformOrderNo(orderRespDto.getPlatformOrderNo());
            dgBizPerformOrderReqDto.setPlatformOrderId(orderRespDto.getPlatformOrderId());
            dgBizPerformOrderReqDto.setDeliveryModelCode(orderRespDto.getDeliveryModelCode());
            dgBizPerformOrderReqDto.setHandmadeDiscount(orderRespDto.getHandmadeDiscount());
            dgBizPerformOrderReqDto.setManualCreate(orderRespDto.getManualCreate());
            dgBizPerformOrderReqDto.setOrderSource(orderRespDto.getOrderSource());
            dgBizPerformOrderReqDto.setOrderSourceModel(orderRespDto.getOrderSourceModel());
            dgBizPerformOrderReqDto.setPerformOrderSnapshotDto((DgPerformOrderSnapshotDto)BeanUtil.copyProperties((Object)orderRespDto.getPerformOrderSnapshotDto(), DgPerformOrderSnapshotDto.class, (String[])new String[0]));
            dgBizPerformOrderReqDto.setOrderAddrReqDto((DgPerformOrderAddrReqDto)BeanUtil.copyProperties((Object)dgPerformOrderAddrDto, DgPerformOrderAddrReqDto.class, (String[])new String[0]));
            dgBizPerformOrderReqDto.setGiftList(giftItemDtos);
            dgBizPerformOrderReqDto.setItemList((List)Lists.newArrayList());
            dgBizPerformOrderReqDto.setJoinGiftActivity(Boolean.FALSE);
            log.info("\u521b\u5efa\u8865\u53d1\u5355\uff1a{}", JSON.toJSON((Object)dgBizPerformOrderReqDto));
            RestResponseHelper.extractData((RestResponse)this.dgB2CSaleStatemachineApi.createSaleOrder(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), dgBizPerformOrderReqDto));
        }
        return MessageResponse.SUCCESS;
    }
}

