/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.tc.order;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleRefundApi;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SapOrderLineUpdateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleRefundQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.service.tc.ISaleRefundService;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sale/order/refund"})
public class SaleRefundRest
implements ISaleRefundApi,
ISaleRefundQueryApi {
    @Resource
    private ISaleRefundService saleRefundService;

    public RestResponse<Long> addSaleRefund(@RequestBody BizSaleRefundReqDto addReqDto) {
        Long refundId = this.saleRefundService.addSaleRefund(addReqDto);
        addReqDto.setId(refundId);
        this.saleRefundService.confirmOrder(addReqDto);
        return new RestResponse((Object)refundId);
    }

    public RestResponse<Void> modifySaleRefund(@RequestBody SaleRefundReqDto modifyReqDto) {
        this.saleRefundService.modifySaleRefund(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeSaleRefund(@PathVariable(value="ids") String ids, @RequestParam(value="instanceId") Long instanceId) {
        this.saleRefundService.removeSaleRefund(ids, instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<BizSaleRefundRespDto> queryByRefundNo(String refundNo) {
        return new RestResponse((Object)this.saleRefundService.queryDetail(null, refundNo));
    }

    public RestResponse<BizSaleRefundRespDto> queryById(@RequestParam(value="id") Long id) {
        return new RestResponse((Object)this.saleRefundService.queryDetail(id, null));
    }

    public RestResponse<PageInfo<SaleRefundRespDto>> queryByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return new RestResponse((Object)this.saleRefundService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<List<SaleRefundRespDto>> queryDetailByPlatformRefundNo(@RequestParam(value="platformRefundNo") String platformRefundNo) {
        return new RestResponse((Object)this.saleRefundService.queryDetailByPlatformRefundNo(platformRefundNo));
    }

    public RestResponse<Void> sapOrderLineUpdate(@RequestBody SapOrderLineUpdateReqDto reqDto) {
        this.saleRefundService.sapOrderLineUpdate(reqDto);
        return RestResponse.VOID;
    }
}

