/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.tc.order;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.component.track.commons.aspect.annotation.TrackLogNode;
import com.dtyunxi.cube.component.track.commons.constant.TrackLogBizDefine;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.ISaleOrderApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.CisSaleOrderBizModelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyLogicalWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SapOrderLineUpdateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderStatusLogRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.query.ISaleOrderQueryApi;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.action.tc.IDgTcPerformOrderAction;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.handle.tc.IDgTcSaleStatemachineHandle;
import com.yunxi.dg.base.center.trade.service.tc.IAutoReceivedOrderService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/sale/order"})
@TrackLogNode(nodeBizDefine=TrackLogBizDefine.BIZ_OPERATION_LOG, nodeBizCode="saleOrder")
public class TcSaleOrderApiRest
implements ISaleOrderApi,
ISaleOrderQueryApi {
    private Logger logger = LoggerFactory.getLogger(TcSaleOrderApiRest.class);
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private IAutoReceivedOrderService autoReceivedOrderService;
    @Resource
    private IDgTcPerformOrderAction dgTcPerformOrderAction;
    @Resource
    private IDgTcSaleStatemachineHandle dgTcSaleStatemachineHandle;

    public RestResponse<String> addSaleOrder(@RequestBody BizSaleOrderReqDto addReqDto) {
        this.logger.info("addSaleOrder \u521b\u5efa\u53d1\u8d27\u5355,\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)addReqDto));
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = new DgBizPerformOrderReqDto();
        CubeBeanUtils.copyProperties((Object)dgBizPerformOrderReqDto, (Object)addReqDto, (String[])new String[0]);
        dgBizPerformOrderReqDto.setCostCenterCode(addReqDto.getCostCenter());
        DgPerformOrderSnapshotDto performOrderSnapshotDto = new DgPerformOrderSnapshotDto();
        CubeBeanUtils.copyProperties((Object)performOrderSnapshotDto, (Object)addReqDto, (String[])new String[0]);
        dgBizPerformOrderReqDto.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)addReqDto.getItemList(), DgPerformOrderItemReqDto.class);
        dgBizPerformOrderReqDto.setItemList((List)itemList);
        ArrayList giftList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)giftList, (Collection)addReqDto.getGiftList(), DgPerformOrderItemReqDto.class);
        dgBizPerformOrderReqDto.setGiftList((List)giftList);
        DgPerformOrderAddrReqDto orderAddrReqDto = new DgPerformOrderAddrReqDto();
        CubeBeanUtils.copyProperties((Object)orderAddrReqDto, (Object)addReqDto.getOrderAddrReqDto(), (String[])new String[0]);
        dgBizPerformOrderReqDto.setOrderAddrReqDto(orderAddrReqDto);
        return this.dgTcSaleStatemachineHandle.createSaleOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), dgBizPerformOrderReqDto);
    }

    public RestResponse<Void> modifySaleOrder(@RequestBody SaleOrderReqDto modifyReqDto) {
        this.saleOrderService.modifySaleOrder(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeSaleOrder(@PathVariable(value="ids") String ids, @RequestParam(value="instanceId") Long instanceId) {
        this.saleOrderService.removeSaleOrder(ids, instanceId);
        return RestResponse.VOID;
    }

    public RestResponse<Void> changeDeliveredForOrder(OutDeliveryResultReqDto reqDto) {
        DgSaleOrderEo dgSaleOrderEo = this.saleOrderService.queryEoByOrderNo(reqDto.getOrderNo());
        this.dgTcSaleStatemachineHandle.changeDeliveredForOrder(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), dgSaleOrderEo.getId(), reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> changeOrderRemark(SaleOrderReqDto reqDto) {
        this.dgTcSaleStatemachineHandle.changeOrderRemark(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), reqDto.getId(), reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> autoReceived() {
        this.autoReceivedOrderService.handleAutoReceiveTask();
        return RestResponse.VOID;
    }

    public RestResponse<Void> changeLogicalWarehouse(ModifyLogicalWarehouseReqDto reqDto) {
        for (Long orderId : reqDto.getOrderIdList()) {
            this.dgTcSaleStatemachineHandle.changeLogicalWarehouse(CisSaleOrderBizModelEnum.PCP_SALE_ORDER.getCode(), orderId, reqDto);
        }
        return RestResponse.VOID;
    }

    public RestResponse<BizSaleOrderRespDto> queryByOrderNo(@PathVariable(value="orderNo") String orderNo) {
        return new RestResponse((Object)this.saleOrderService.queryByOrderNo(orderNo));
    }

    public RestResponse<List<SaleOrderRespDto>> queryByOrderIds(@RequestBody List<Long> orderIds) {
        return new RestResponse((Object)this.saleOrderService.queryByOrderIds(orderIds));
    }

    public RestResponse<PageInfo<SaleOrderRespDto>> queryByPage(@RequestParam(value="filter") String filter, @RequestParam(name="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(name="pageSize", required=false, defaultValue="10") Integer pageSize) {
        return new RestResponse((Object)this.saleOrderService.queryByPage(filter, pageNum, pageSize));
    }

    public RestResponse<List<OrderStatusLogRespDto>> queryOrderStatus(Long orderId) {
        return new RestResponse((Object)this.saleOrderService.queryOrderStatus(orderId));
    }

    public RestResponse<List<OrderStatusLogRespDto>> queryOrderStatus(Long orderId, String type) {
        return new RestResponse((Object)this.saleOrderService.queryOrderStatus(orderId, type));
    }

    public RestResponse<List<SaleOrderRespDto>> queryByPlatFormOrderNo(String platFormOrderNo, String platFormOrderSelectTypeCode) {
        return new RestResponse((Object)this.saleOrderService.queryByPlatFormOrderNo(platFormOrderNo, platFormOrderSelectTypeCode));
    }

    public RestResponse<BizSaleOrderRespDto> queryMainSaleOrderByPlatFormOrderNo(@RequestBody SaleOrderQueryReqDto reqDto) {
        return new RestResponse((Object)this.saleOrderService.queryMainSaleOrderByPlatFormOrderNo(reqDto));
    }

    public RestResponse<Void> updateEasVerifyStatus(@RequestParam(value="saleOrderNo") String saleOrderNo) {
        this.saleOrderService.updateEasVerifyStatus(saleOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateEasOutOrderNo(@RequestBody List<String> saleOrders, @RequestParam(value="easOutOrderNo") String easOutOrderNo) {
        this.saleOrderService.updateEasOutOrderNo(saleOrders, easOutOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<List<SaleOrderRespDto>> queryByParamList(@RequestBody SaleOrderQueryReqDto queryReqDto) {
        return new RestResponse((Object)this.saleOrderService.queryByParamList(queryReqDto));
    }

    public RestResponse<String> getSaleOrderNo() {
        return new RestResponse((Object)this.saleOrderService.getSaleOrderNo());
    }

    public RestResponse<BizSaleOrderRespDto> queryNewestOrderByCustomerId(@PathVariable(value="customerId") Long customerId) {
        return new RestResponse((Object)this.saleOrderService.queryNewestOrderByCustomerId(customerId));
    }

    public RestResponse<Void> sendEasSaleOrderRest(@RequestParam(value="saleOrderNo") String saleOrderNo) {
        this.saleOrderService.sendEasSaleOrderRest(saleOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> easCancelOrderLock(@RequestParam(value="platformOrderNo") String platformOrderNo) {
        this.saleOrderService.easCancelOrderLock(platformOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> easDeleteOrderLock(@RequestParam(value="platformOrderNo") String platformOrderNo) {
        this.saleOrderService.easDeleteOrderLock(platformOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> cspCancelOrderLock(@RequestParam(value="platformOrderNo") String platformOrderNo) {
        this.saleOrderService.cspCancelOrderLock(platformOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> cspObsoleteByPlatformOrderNo(@RequestParam(value="platformOrderNo") String platformOrderNo) {
        this.saleOrderService.cspObsoleteByPlatformOrderNo(platformOrderNo);
        return RestResponse.VOID;
    }

    public RestResponse<Void> sapOrderLineUpdate(@RequestBody SapOrderLineUpdateReqDto reqDto) {
        this.saleOrderService.sapOrderLineUpdate(reqDto);
        return RestResponse.VOID;
    }

    public void updatePssStatus(@RequestParam(value="saleOrderNoList") List<String> saleOrderNoList, @RequestParam(value="pssStatus") Integer pssStatus) {
        this.saleOrderService.updatePssStatus(saleOrderNoList, pssStatus);
    }

    public RestResponse<Boolean> verifySaleOrderEntireSign(@RequestParam(name="orderId", required=false) Long orderId, @RequestParam(name="saleOrderNo", required=false) String saleOrderNo) {
        return new RestResponse((Object)this.saleOrderService.verifySaleOrderEntireSign(orderId, saleOrderNo));
    }
}

