/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.rest.statemachine;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OmsSaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderUpdateDto;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgOmsOrderOptAction;
import com.yunxi.dg.base.center.trade.api.statemachine.IPlatformOrderOmsStatemachineApi;
import com.yunxi.dg.base.center.trade.api.statemachine.ISaleOrderOmsStatemachineApi;
import com.yunxi.dg.base.center.trade.api.statemachine.ISaleOrderSellerRemarkOmsStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.BizPlatformOrderConfirmGoodsResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.BizPlatformOrderSyncStatusResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.BizPlatformOrderUpdateResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.BizSaleOrderBaseUpdateDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderRemarkReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSyncPlatformDeliveryReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.ModifyPlatformOrderStatusReqDto;
import com.yunxi.dg.base.center.trade.enums.PerformOrderGeneralConfigDataEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.rest.statemachine.DgB2CSaleStatemachineApiRest;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/statemachine/platform", "/v1/statemachine/saleOrder", "/v1/sale/order"})
public class PlatformOrderOmsStatemachineApiRest
implements IPlatformOrderOmsStatemachineApi,
ISaleOrderOmsStatemachineApi,
ISaleOrderSellerRemarkOmsStatemachineApi {
    private static final Logger log = LoggerFactory.getLogger(PlatformOrderOmsStatemachineApiRest.class);
    @Resource
    private DgB2COrderStatemachineExecutor dgB2COrderStatemachineExecutor;
    @Resource
    private IDgOmsOrderOptAction dgOmsOrderOptAction;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private DgB2CSaleStatemachineApiRest dgB2CSaleStatemachineApiRest;

    public RestResponse<BizPlatformOrderUpdateResultRespDto> updateSaleOrderInfo(String bizModel, String platformOrderNo, BizSaleOrderUpdateDto reqDto) {
        return null;
    }

    public RestResponse<BizPlatformOrderUpdateResultRespDto> updateSaleOrderInfo(String bizModel, String platformOrderNo, BizSaleOrderBaseUpdateDto reqDto) {
        return null;
    }

    public RestResponse<BizPlatformOrderConfirmGoodsResultRespDto> confirmReceiveGoodsPlatformOrderNo(String bizModel, String platformOrderNo, String desc) {
        AssertUtils.notBlank((String)platformOrderNo, (String)"\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-trade", PerformOrderGeneralConfigDataEnum.ORDER_FINISH_CONDITION.getCode()));
        int status = dictDto == null ? 2 : Integer.parseInt(dictDto.getValue());
        log.info("\u8bfb\u53d6\u5b8c\u6210\u72b6\u6001\u66f4\u65b0\u8282\u70b9\u914d\u7f6e\uff1a{}", (Object)status);
        List orderInfoEoList = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        AssertUtils.notEmpty((Collection)orderInfoEoList, (String)"\u8be5\u5e73\u53f0\u5355\u53f7\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355");
        BizPlatformOrderConfirmGoodsResultRespDto bizPlatformOrderConfirmGoodsResultRespDto = new BizPlatformOrderConfirmGoodsResultRespDto();
        bizPlatformOrderConfirmGoodsResultRespDto.setPlatformOrderNo(platformOrderNo);
        bizPlatformOrderConfirmGoodsResultRespDto.setSaleOrderConfirmGoodsResultRespDtos(new ArrayList());
        for (DgPerformOrderInfoEo dto : orderInfoEoList) {
            AssertUtils.notNull((Object)dto, (String)"\u9519\u8bef\u6620\u5c04\u5173\u7cfb");
            BizPlatformOrderConfirmGoodsResultRespDto.BizSaleOrderConfirmGoodsResultRespDto bizSaleOrderConfirmGoodsResultRespDto = new BizPlatformOrderConfirmGoodsResultRespDto.BizSaleOrderConfirmGoodsResultRespDto();
            bizSaleOrderConfirmGoodsResultRespDto.setSaleOrderId(dto.getId());
            bizSaleOrderConfirmGoodsResultRespDto.setSaleOrderNo(dto.getSaleOrderNo());
            bizPlatformOrderConfirmGoodsResultRespDto.getSaleOrderConfirmGoodsResultRespDtos().add(bizSaleOrderConfirmGoodsResultRespDto);
            try {
                if (status == 2) {
                    this.dgB2COrderStatemachineExecutor.executeStatemachine(bizModel, dto.getId(), (Object)desc, (Object)DgB2COrderMachineEvents.CONFIRM_RECEIVE_GOODS).getFirstActionResultSubRestResponse(Void.class);
                }
                bizSaleOrderConfirmGoodsResultRespDto.setUpdateResultFlag(Boolean.valueOf(true));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                bizSaleOrderConfirmGoodsResultRespDto.setUpdateResultFlag(Boolean.valueOf(false));
                bizSaleOrderConfirmGoodsResultRespDto.setUpdateInfoErrorMsg(e.getMessage());
            }
        }
        return new RestResponse((Object)bizPlatformOrderConfirmGoodsResultRespDto);
    }

    public RestResponse<BizPlatformOrderSyncStatusResultRespDto> syncPlatformOrderStatus(String bizModel, String platformOrderNo, ModifyPlatformOrderStatusReqDto reqDto) {
        log.info("\u540c\u6b65\u5e73\u53f0\u8ba2\u5355\u72b6\u6001\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.notBlank((String)reqDto.getPlatformOrderNo(), (String)"\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)reqDto.getPlatformOrderStatus(), (String)"\u5e73\u53f0\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)reqDto.getPlatformOrderStatusName(), (String)"\u5e73\u53f0\u72b6\u6001\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        List orderInfoEoList = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        AssertUtils.notEmpty((Collection)orderInfoEoList, (String)"\u8be5\u5e73\u53f0\u5355\u53f7\u67e5\u8be2\u4e0d\u5230\u8ba2\u5355");
        for (DgPerformOrderInfoEo dgPerformOrderInfoEo : orderInfoEoList) {
            this.dgOmsOrderOptAction.modifyPlatformOrderStatus(dgPerformOrderInfoEo.getId(), reqDto.getPlatformOrderStatus(), reqDto.getPlatformOrderStatusName());
        }
        orderInfoEoList = orderInfoEoList.stream().filter(dto -> !OmsSaleOrderStatus.CANCEL.getCode().equals(dto.getOmsSaleOrderStatus()) && !OmsSaleOrderStatus.SPLIT.getCode().equals(dto.getOmsSaleOrderStatus())).collect(Collectors.toList());
        BizPlatformOrderSyncStatusResultRespDto syncStatusResultRespDto = new BizPlatformOrderSyncStatusResultRespDto();
        syncStatusResultRespDto.setPlatformOrderNo(platformOrderNo);
        syncStatusResultRespDto.setSaleOrderSyncStatusResultRespDtoList(new ArrayList());
        for (DgPerformOrderInfoEo dto2 : orderInfoEoList) {
            AssertUtils.notNull((Object)dto2, (String)"\u9519\u8bef\u6620\u5c04\u5173\u7cfb");
            BizPlatformOrderSyncStatusResultRespDto.BizSaleOrderSyncStatusResultRespDto saleOrderSyncStatusResultRespDto = new BizPlatformOrderSyncStatusResultRespDto.BizSaleOrderSyncStatusResultRespDto();
            saleOrderSyncStatusResultRespDto.setSaleOrderId(dto2.getId());
            saleOrderSyncStatusResultRespDto.setSaleOrderNo(dto2.getSaleOrderNo());
            syncStatusResultRespDto.getSaleOrderSyncStatusResultRespDtoList().add(saleOrderSyncStatusResultRespDto);
            try {
                DgOmsSaleOrderStatus omsSaleOrderStatus = DgOmsSaleOrderStatus.forCode((String)reqDto.getCovertOrderStatus());
                if (!DgOmsSaleOrderStatus.COMPLETE.equals((Object)omsSaleOrderStatus) && !DgOmsSaleOrderStatus.CANCEL.equals((Object)omsSaleOrderStatus)) {
                    DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
                    dgPerformOrderInfoEo.setId(dto2.getId());
                    dgPerformOrderInfoEo.setCovertOrderStatus(reqDto.getCovertOrderStatus());
                    dgPerformOrderInfoEo.setPlatformOrderStatus(reqDto.getPlatformOrderStatus());
                    dgPerformOrderInfoEo.setPlatformOrderStatusName(reqDto.getPlatformOrderStatusName());
                    this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
                    saleOrderSyncStatusResultRespDto.setSyncResultFlag(Boolean.valueOf(true));
                    continue;
                }
                List dgOrderLabelRecordDtos = this.dgOrderLabelRecordDomain.queryByOrderIdsAndLabelCodes(Arrays.asList(dto2.getId()), DgOrderLabelEnum.VIRTUAL_ORDER.getCode());
                if (CollectionUtils.isNotEmpty((Collection)dgOrderLabelRecordDtos)) {
                    log.info("\u8be5\u8ba2\u5355\u662f\u865a\u62df\u8ba2\u5355");
                }
                saleOrderSyncStatusResultRespDto.setSyncResultFlag(Boolean.valueOf(true));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                saleOrderSyncStatusResultRespDto.setSyncResultFlag(Boolean.valueOf(false));
                saleOrderSyncStatusResultRespDto.setSyncErrorMsg(e.getMessage());
            }
        }
        return new RestResponse((Object)syncStatusResultRespDto);
    }

    private DgB2COrderMachineEvents chooseSyncEvent(ModifyPlatformOrderStatusReqDto reqDto) {
        DgB2COrderMachineEvents chooseResult;
        DgOmsSaleOrderStatus omsSaleOrderStatus = DgOmsSaleOrderStatus.forCode((String)reqDto.getCovertOrderStatus());
        switch (omsSaleOrderStatus) {
            case COMPLETE: {
                chooseResult = DgB2COrderMachineEvents.CONFIRM_RECEIVE_GOODS;
                break;
            }
            case CANCEL: {
                chooseResult = DgB2COrderMachineEvents.SYNC_PLATFORM_STATUS_CANCEL;
                break;
            }
            default: {
                throw new BizException("-1", "\u65e0\u6cd5\u8bc6\u522b\u5e76\u8f6c\u6362\u8be5\u8f6c\u5355\u72b6\u6001\u5bf9\u5e94\u64cd\u4f5c" + reqDto.getCovertOrderStatus());
            }
        }
        return chooseResult;
    }

    public RestResponse<Void> modifyOrderSellerRemark(DgModifyOrderRemarkReqDto reqDto) {
        this.dgPerformOrderInfoDomain.modifyOrderSellerRemark(reqDto);
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> removeExceptionOrderByPlatformOrderNos(List<String> platformOrderNoList) {
        if (CollectionUtils.isEmpty(platformOrderNoList)) {
            return RestResponse.VOID;
        }
        this.dgPerformOrderInfoDomain.logicDeleteRelationInfoByOrderIds(platformOrderNoList);
        return RestResponse.VOID;
    }

    public RestResponse<Void> syncPlatformDelivery(String bizModel, Long saleOrderId, DgSyncPlatformDeliveryReqDto syncPlatformDeliveryReqDto) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(bizModel, saleOrderId, (Object)syncPlatformDeliveryReqDto, (Object)DgB2COrderMachineEvents.SYNC_PLATFORM_DELIVERY_STATUS).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    public RestResponse<Void> cancelOrder(String bizModel, Long saleOrderId, String cancelReason) {
        return Optional.ofNullable(this.dgB2COrderStatemachineExecutor.executeStatemachine(bizModel, saleOrderId, (Object)cancelReason, (Object)DgB2COrderMachineEvents.CANCEL_ORDER).getFirstActionResultSubRestResponse(Void.class)).orElseGet(RestResponse::new);
    }

    public RestResponse<Boolean> statusLock(String bizModel, Long saleOrderId, String desc) {
        log.info("{} - \u914d\u8d27\u5355 {} \u6302\u8d77\uff0c\u539f\u56e0\uff1a{}", new Object[]{bizModel, saleOrderId, desc});
        return this.dgB2CSaleStatemachineApiRest.statusLock(bizModel, saleOrderId, "");
    }

    public RestResponse<Void> statusLockByPlatformOrderNo(String bizModel, String platformOrderNo, String desc) {
        List list = this.dgPerformOrderInfoDomain.queryEoByPlatformOrderNo(platformOrderNo);
        for (DgPerformOrderInfoEo eo : list) {
            Long id = eo.getId();
            try {
                RestResponse<Boolean> resp = this.statusLock(bizModel, id, desc);
                log.info("\u5e73\u53f0\u8ba2\u5355\uff1a{} \u5bf9\u5e94\u914d\u8d27\u5355id:{} \u6302\u8d77,\u54cd\u5e94\uff1a{}", new Object[]{platformOrderNo, id, JSON.toJSONString(resp)});
            }
            catch (Exception e) {
                log.error("\u5e73\u53f0\u8ba2\u5355\uff1a{} \u5bf9\u5e94\u914d\u8d27\u5355id:{} \u6302\u8d77\u5931\u8d25", new Object[]{platformOrderNo, id, e});
            }
        }
        return new RestResponse();
    }
}

