/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.source.dto.enmu;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum SourceStatusEnum {
    WAIT_SOURCE("WAIT_SOURCE", "\u5f85\u5bfb\u6e90"),
    SOURCING("SOURCING", "\u5bfb\u6e90\u4e2d"),
    SOURCE_FAIL("SOURCE_FAIL", "\u5bfb\u6e90\u5931\u8d25"),
    SOURCE_SUCCESS("SOURCE_SUCCESS", "\u5bfb\u6e90\u6210\u529f"),
    CANCEL("CANCEL", "\u5df2\u53d6\u6d88"),
    ABOLISH("ABOLISH", "\u5df2\u4f5c\u5e9f");

    public final String code;
    public final String desc;
    public static final Map<String, SourceStatusEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private SourceStatusEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SourceStatusEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(SourceStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(SourceStatusEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
    }
}

