/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.after_sale;

import cn.hutool.core.collection.CollectionUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.AbstractSingleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.proxy.other.IInventoryAdjustmentOrderApiProxy;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgCisAfterSaleBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgNoSourceReturnRecordDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyReturnNoSourceMatchRuleRespDto;
import com.yunxi.dg.base.center.trade.eo.DgNoSourceReturnRecordEo;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.entity.IDgNoSourceReturnRecordService;
import com.yunxi.dg.base.center.trade.service.entity.impl.DgNoSourceReturnRecordServiceImpl;
import com.yunxi.dg.base.center.trade.service.orderStrategy.IDgStrategyReturnNoSourceMatchRuleService;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.constant.DgB2CAfterSaleMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.aftersale.execute.DgB2CAfterSaleStatemachineExecutor;
import com.yunxi.dg.base.center.trade.vo.NoSourceReturnRecordMatchSuccessDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Scope(value="prototype")
@Component(value="noSourceReturnRecordMatchJob")
public class AfterNoSourceReturnScheduler
extends AbstractSingleScheduleEvent {
    private static final Logger log = LoggerFactory.getLogger(AfterNoSourceReturnScheduler.class);
    private final int PAGE_SIZE = 1000;
    @Resource
    private IDgNoSourceReturnRecordDomain noSourceReturnRecordDomain;
    @Resource
    private IDgNoSourceReturnRecordService noSourceReturnRecordService;
    @Resource
    private IDgStrategyReturnNoSourceMatchRuleService strategyReturnNoSourceMatchRuleService;
    @Resource
    private DgB2CAfterSaleStatemachineExecutor dgB2CAfterSaleStatemachineExecutor;
    @Resource
    private IDgAfterSaleOrderService afterSaleOrderService;
    @Resource
    private IInventoryAdjustmentOrderApiProxy inventoryAdjustmentOrderApiProxy;
    @Resource
    private IDgAfterSaleOrderItemService afterSaleOrderItemService;

    public void before(TaskMsg taskMsg) {
        log.info("\u9000\u8d27\u65e0\u5934\u4ef6\u5339\u914d\u4efb\u52a1\u5f00\u59cb");
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean execute(TaskMsg taskMsg) {
        int count;
        String reqId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
        ServiceContext.getContext().setAttachment("yes.req.userCode", "system");
        DgNoSourceReturnRecordEo noSourceReturnRecordEo = new DgNoSourceReturnRecordEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"match_status", (Object)DgNoSourceReturnRecordServiceImpl.FAILED_MATCH_STATUS));
        noSourceReturnRecordEo.setSqlFilters(sqlFilterList);
        noSourceReturnRecordEo.setGenerateClutteredOrderInStatus(Integer.valueOf(0));
        noSourceReturnRecordEo.setOrderBy("id");
        log.info("\u5f53\u524d\u5f85\u5339\u914d\u3001\u5339\u914d\u5931\u8d25\u8bb0\u5f55\u6761\u6570\uff1a{}", (Object)count);
        if (count <= 0) {
            return true;
        }
        int pageNum = 1;
        DgStrategyReturnNoSourceMatchRuleRespDto noSourceMatchRule = this.strategyReturnNoSourceMatchRuleService.get();
        ArrayList successList = new ArrayList();
        ArrayList failList = new ArrayList();
        for (count = this.noSourceReturnRecordDomain.count((BaseEo)noSourceReturnRecordEo); count > 0; count -= 1000) {
            PageInfo pageInfo = this.noSourceReturnRecordDomain.selectPage((BaseEo)noSourceReturnRecordEo, Integer.valueOf(pageNum), Integer.valueOf(1000));
            List list = pageInfo.getList();
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                this.noSourceReturnRecordService.match(list, successList, noSourceMatchRule, failList);
            }
            ++pageNum;
        }
        List matchSuccessDtos = this.noSourceReturnRecordService.matchResultAndHandlerV2(successList, failList);
        List afterOrderIds = matchSuccessDtos.stream().map(NoSourceReturnRecordMatchSuccessDto::getAfterOrderId).distinct().collect(Collectors.toList());
        Map<Long, List<NoSourceReturnRecordMatchSuccessDto>> afterOrderIdMap = matchSuccessDtos.stream().collect(Collectors.groupingBy(NoSourceReturnRecordMatchSuccessDto::getAfterOrderId));
        log.info("\u9000\u8d27\u65e0\u5934\u4ef6\u5339\u914d\u4efb\u52a1,\u5339\u914d\u6210\u529f\u7684\u552e\u540e\u5355ids\u6761\u6570:{}", (Object)afterOrderIds.size());
        Map<Long, List<NoSourceReturnRecordMatchSuccessDto>> group = matchSuccessDtos.stream().collect(Collectors.groupingBy(NoSourceReturnRecordMatchSuccessDto::getAfterOrderId));
        if (CollectionUtil.isNotEmpty(afterOrderIds)) {
            List afterSaleOrderRespDtos = this.afterSaleOrderService.queryByIds(afterOrderIds);
            afterSaleOrderRespDtos.forEach(afterSaleOrderRespDto -> {
                block8: {
                    log.info("\u5339\u914d\u6210\u529f\u7684\u552e\u540e\u5355\u53f7\uff1a{}\uff0c \u552e\u540e\u7c7b\u578b\uff1a{}", (Object)afterSaleOrderRespDto.getAfterSaleOrderNo(), (Object)afterSaleOrderRespDto.getAfterSaleOrderType());
                    DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
                    bizAfterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
                    bizAfterSaleOrderReqDto.setNoSendWms(true);
                    bizAfterSaleOrderReqDto.setAutoComplete(true);
                    DgCisAfterSaleBizModelEnum cisAfterSaleOrderBizModelEnum = (DgCisAfterSaleBizModelEnum)DgCisAfterSaleBizModelEnum.CODE_LOOKUP.get(afterSaleOrderRespDto.getAfterSaleOrderType());
                    try {
                        switch (cisAfterSaleOrderBizModelEnum) {
                            case THTK: {
                                this.dgB2CAfterSaleStatemachineExecutor.executeStatemachine(afterSaleOrderRespDto.getAfterSaleOrderType(), afterSaleOrderRespDto.getId(), (Object)bizAfterSaleOrderReqDto, (Object)DgB2CAfterSaleMachineEvents.THTK_CONFIRM_NO_SOURCE).getActionResultSubRestResponse(Void.class);
                                break;
                            }
                            case HH: {
                                this.dgB2CAfterSaleStatemachineExecutor.executeStatemachine(afterSaleOrderRespDto.getAfterSaleOrderType(), afterSaleOrderRespDto.getId(), (Object)bizAfterSaleOrderReqDto, (Object)DgB2CAfterSaleMachineEvents.HH_BUYER_SENT_NO_SOURCE).getActionResultSubRestResponse(Void.class);
                                break;
                            }
                        }
                        List adjustmentReqs = ((List)group.getOrDefault(afterSaleOrderRespDto.getId(), new ArrayList(0))).stream().map(NoSourceReturnRecordMatchSuccessDto::getAdjustmentOrderDtoList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
                        if (!adjustmentReqs.isEmpty()) {
                            RestResponse resp = this.inventoryAdjustmentOrderApiProxy.insertBatchV3(adjustmentReqs);
                            List list = (List)RestResponseHelper.extractData((RestResponse)resp);
                            for (int i = 0; i < adjustmentReqs.size(); ++i) {
                                AdjustmentOrderDto dto = (AdjustmentOrderDto)adjustmentReqs.get(i);
                                AdjustmentOrderDto rs = (AdjustmentOrderDto)list.get(i);
                                log.info("\u6dfb\u52a0\u5e93\u5b58\u8c03\u6574\u5355\u6210\u529f\uff1aafterSaleOrderItemId={}, noSourceReturnRecordIds={}, adjustmentOrderId={}, adjustmentOrderNo={}", new Object[]{dto.getAfterSaleOrderItemId(), dto.getNoSourceReturnRecordIds(), rs.getId(), rs.getAdjustmentNo()});
                                this.noSourceReturnRecordService.updateAdjustmentNo(dto.getNoSourceReturnRecordIds(), rs.getAdjustmentNo());
                                this.afterSaleOrderItemService.updateAdjustmentNo(dto.getAfterSaleOrderItemId(), rs.getAdjustmentNo());
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error("\u5339\u914d\u6210\u529f\u7684\u552e\u540e\u5355\u53f7\uff1a{}\uff0c\u5904\u7406\u8ba2\u5355\u6d41\u7a0b\u9519\u8bef\uff1a{}", new Object[]{afterSaleOrderRespDto.getAfterSaleOrderNo(), e.getMessage(), e});
                        List matchSuccessDtos1 = (List)afterOrderIdMap.get(afterSaleOrderRespDto.getId());
                        if (!CollectionUtil.isNotEmpty((Collection)matchSuccessDtos1)) break block8;
                        this.noSourceReturnRecordService.updateMatchFailByIds(matchSuccessDtos1);
                    }
                }
            });
        }
        return true;
    }

    public void after(TaskMsg taskMsg) {
        log.info("\u9000\u8d27\u65e0\u5934\u4ef6\u5339\u914d\u4efb\u52a1\u7ed3\u675f");
    }
}

