/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.proxy.impl;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsDocumentTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IChannelInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.enums.PreemptOperateTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.share.api.dto.request.CsInventoryOperateReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.baseorder.BaseOrderAddressAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.baseorder.OrderUpdateShipmentInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateCargoReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOrderShipmentCheckReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.LogicPreemptInventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IReceiveDeliveryNoticeOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.inventory.ILogicInventoryExposedApiProxy;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgInventoryApiServcieImpl
implements IDgInventoryApiServcie {
    private static final Logger log = LoggerFactory.getLogger(DgInventoryApiServcieImpl.class);
    @Value(value="${oms.lockShareFlag:false}")
    private Boolean lockShareFlag = false;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrExtDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderApiProxy receiveDeliveryNoticeOrderApi;
    @Resource
    private ILogicInventoryExposedApiProxy logicInventoryExposedApi;
    @Resource
    private IChannelInventoryExposedApi channelInventoryExposedApi;

    @Override
    public void resetChannelPreemptForSplit(DgPerformOrderRespDto parentSaleOrder, List<DgPerformOrderRespDto> childOrderList, Map<Long, List<DgPerformOrderItemDto>> orderItemsMap) {
        if (this.lockShareFlag.booleanValue()) {
            AssertUtils.notNull((Object)parentSaleOrder, (String)"%s\u539f\u8ba2\u5355\u4e3a\u7a7a", (Object[])new Object[]{parentSaleOrder.getSaleOrderNo()});
            AssertUtils.notEmpty(childOrderList, (String)"\u5b50\u8ba2\u5355\u5217\u8868\u4e3a\u7a7a");
            ArrayList inventoryOperateReqDtoList = Lists.newArrayList();
            try {
                childOrderList.forEach(saleOrderRespDto -> {
                    CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
                    inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
                    inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
                    inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
                    inventoryOperateReqDto.setBusinessType(saleOrderRespDto.getBizType());
                    inventoryOperateReqDto.setChannelCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
                    inventoryOperateReqDto.setOperateType(PreemptOperateTypeEnum.UPDATE_PREEMPT.getCode());
                    inventoryOperateReqDto.setReleaseSourceNo(parentSaleOrder.getSaleOrderNo());
                    List saleOrderItemRespDtoList = (List)orderItemsMap.get(saleOrderRespDto.getId());
                    if (CollectionUtils.isNotEmpty((Collection)saleOrderItemRespDtoList)) {
                        List operateCargoReqDtoList = saleOrderItemRespDtoList.stream().map(saleOrderItemEo -> {
                            CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
                            inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
                            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
                            inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getBatchNo());
                            return inventoryOperateCargoReqDto;
                        }).collect(Collectors.toList());
                        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
                    }
                    inventoryOperateReqDtoList.add(inventoryOperateReqDto);
                });
                log.info("[\u91cd\u65b0\u9884\u5360\u6e20\u9053\u5e93\u5b58]\u62c6\u5355\u540e\u91cd\u65b0\u9884\u5360\u6e20\u9053\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDtoList));
                this.channelInventoryExposedApi.batchInventoryByPreemption((List)inventoryOperateReqDtoList);
            }
            catch (Exception e) {
                log.error("[\u6279\u91cf\u5e93\u5b58\u9884\u5360]\u5f02\u5e38\uff1a", (Throwable)e);
                throw DgPcpTradeExceptionCode.PREEMPT_CHANNEL_EXCEPTION.builderException();
            }
        }
    }

    @Override
    public void deducateAllInventory(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderItemRespDto> saleOrderItemRespDtos) {
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        AssertUtils.notEmpty(saleOrderItemRespDtos, (String)"\u8ba2\u5355\u5546\u54c1\u4fe1\u606f\u4e3a\u7a7a");
        LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto = new LogicPreemptInventoryOperateReqDto();
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setYfRepairOrderNo(saleOrderRespDto.getPlatformParentOrderNo());
        logicPreemptInventoryOperateReqDto.setOaidOrderSourceCode(saleOrderRespDto.getPlatformOrderNo());
        List operateCargoReqDtoList = saleOrderItemRespDtos.stream().map(saleOrderItemEo -> {
            InventoryOperateCargoReqDto inventoryOperateCargoReqDto = new InventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
            inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
            inventoryOperateCargoReqDto.setCargoName(saleOrderItemEo.getItemName());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setBasicDataBusinessType(saleOrderRespDto.getBizType());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        this.popOrderAddress(logicPreemptInventoryOperateReqDto, saleOrderRespDto.getId(), saleOrderRespDto.getOaid());
        logicPreemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
        log.info("[\u4e09\u65b9\u5c65\u7ea6\u5355\u76f4\u63a5\u6263\u51cf\u5e93\u5b58]\u8bf7\u6c42\u6263\u51cf\u5e93\u5b58\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApi.deductionInventoryOrder(logicPreemptInventoryOperateReqDto);
        log.info("[\u4e09\u65b9\u5c65\u7ea6\u5355\u76f4\u63a5\u6263\u51cf\u5e93\u5b58]\u8bf7\u6c42\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        Boolean result = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        if (!result.booleanValue()) {
            throw DgPcpTradeExceptionCode.DEDUCTION_INVENTORY_EXCEPTION.builderException();
        }
    }

    @Override
    public InventoryOperateRespDto preemptLogicInventoryBackResult(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList) {
        LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto = new LogicPreemptInventoryOperateReqDto();
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        inventoryOperateReqDto.setShipmentEnterpriseCode(saleOrderRespDto.getShipmentEnterpriseCode());
        inventoryOperateReqDto.setShipmentEnterpriseName(saleOrderRespDto.getShipmentEnterpriseName());
        inventoryOperateReqDto.setYfRepairOrderNo(saleOrderRespDto.getPlatformParentOrderNo());
        logicPreemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
        logicPreemptInventoryOperateReqDto.setSourcePlatformCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        logicPreemptInventoryOperateReqDto.setOaidOrderSourceCode(saleOrderRespDto.getPlatformOrderNo());
        logicPreemptInventoryOperateReqDto.setPayTime(saleOrderRespDto.getPerformOrderPaymentDto().getPayTime());
        logicPreemptInventoryOperateReqDto.setTradeOrderCreateTime(saleOrderRespDto.getSaleCreateTime());
        logicPreemptInventoryOperateReqDto.setExchangeOrderNo(saleOrderRespDto.getExchangeOrderNo());
        logicPreemptInventoryOperateReqDto.setExchangePlatformAfterSaleOrderNo(saleOrderRespDto.getExchangePlatformAfterSaleOrderNo());
        logicPreemptInventoryOperateReqDto.setTradeOrderType(saleOrderRespDto.getOrderType());
        this.popLogicPreemptInventoryOperateReqDto(saleOrderRespDto, logicPreemptInventoryOperateReqDto);
        List operateCargoReqDtoList = saleOrderItemRespDtoList.stream().map(saleOrderItemEo -> {
            InventoryOperateCargoReqDto inventoryOperateCargoReqDto = new InventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderRespDto.getDeliveryLogicalWarehouseCode());
            this.popInventoryOperateCargoReqDto((DgPerformOrderItemRespDto)saleOrderItemEo, inventoryOperateCargoReqDto);
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setBasicDataBusinessType(saleOrderRespDto.getBizType());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        this.popOrderAddress(logicPreemptInventoryOperateReqDto, saleOrderRespDto.getId(), saleOrderRespDto.getOaid());
        log.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        RestResponse inventoryOperateRespDtoRestResponse = this.logicInventoryExposedApi.preemptInventoryBackResult(logicPreemptInventoryOperateReqDto);
        log.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateRespDtoRestResponse));
        return (InventoryOperateRespDto)RestResponseHelper.extractData((RestResponse)inventoryOperateRespDtoRestResponse);
    }

    @Override
    public Boolean updateOrderShipmentInfo(DgPerformOrderRespDto respDto, DgArrangeShipmentEnterpriseReqDto reqDto) {
        OrderUpdateShipmentInfoReqDto updateShipmentInfo = new OrderUpdateShipmentInfoReqDto();
        updateShipmentInfo.setOrderNo(respDto.getSaleOrderNo());
        updateShipmentInfo.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        updateShipmentInfo.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        log.info("[\u6307\u5b9a\u7269\u6d41]\u9500\u552e\u8ba2\u5355\u5f85\u914d\u8d27\uff0c\u66f4\u65b0\u8ba2\u5355\u7269\u6d41\u4fe1\u606f\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)updateShipmentInfo));
        return (Boolean)RestResponseHelper.extractData((RestResponse)this.receiveDeliveryNoticeOrderApi.updateOrderShipmentInfo(updateShipmentInfo));
    }

    @Override
    public List<InventoryOperateRespDto> resetLogicalPreemptForSplit(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderRespDto> childSaleOrderList, Map<Long, List<DgPerformOrderItemRespDto>> orderItemsMap) {
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setReleaseStrategyList((List)Lists.newArrayList((Object[])new String[]{CsInventoryStrategyEnum.LOGIC.getCode()}));
        inventoryOperateReqDto.setCancelOrderStrategyList((List)Lists.newArrayList((Object[])new String[]{CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode()}));
        log.info("[\u62c6\u5355\u91cd\u5360\u5e93\u5b58]\u91ca\u653e\u5e93\u5b58\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        Boolean releaseInventoryResult = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.releaseInventoryByStrategy(inventoryOperateReqDto));
        log.info("[\u62c6\u5355\u91cd\u5360\u5e93\u5b58]\u91ca\u653e\u5e93\u5b58\u7684\u53c2\u6570\uff1a{}", (Object)releaseInventoryResult);
        ArrayList preemptResultList = Lists.newArrayList();
        if (releaseInventoryResult.booleanValue()) {
            for (DgPerformOrderRespDto orderRespDto : childSaleOrderList) {
                List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = orderItemsMap.get(orderRespDto.getId());
                InventoryOperateRespDto inventoryOperateRespDto = this.preemptLogicInventoryBackResult(orderRespDto, saleOrderItemRespDtoList);
                preemptResultList.add(inventoryOperateRespDto);
            }
        }
        return preemptResultList;
    }

    @Override
    public Boolean releaseLogicalAndPhysics(DgPerformOrderRespDto saleOrderRespDto) {
        log.info("[\u64a4\u9500\u5ba1\u6838]\u91ca\u653e\u6e20\u9053\u4ed3\u6210\u529f\uff1a{}", (Object)saleOrderRespDto.getSaleOrderNo());
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setReleaseStrategyList((List)Lists.newArrayList((Object[])new String[]{CsInventoryStrategyEnum.LOGIC.getCode(), CsInventoryStrategyEnum.PHYSICS.getCode()}));
        inventoryOperateReqDto.setCancelOrderStrategyList((List)Lists.newArrayList((Object[])new String[]{CsDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode(), CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode()}));
        log.info("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u903b\u8f91\u4ed3\u548c\u7269\u7406\u4ed3\u9884\u5360\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApi.releaseInventoryByStrategy(inventoryOperateReqDto);
        return (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    @Override
    public Boolean releasePhysics(DgPerformOrderRespDto saleOrderRespDto) {
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setReleaseStrategyList((List)Lists.newArrayList((Object[])new String[]{CsInventoryStrategyEnum.PHYSICS.getCode()}));
        inventoryOperateReqDto.setCancelOrderStrategyList((List)Lists.newArrayList((Object[])new String[]{CsDocumentTypeEnum.OUT_NOTICE_ORDER.getCode()}));
        log.info("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u51fa\u5e93\u901a\u77e5\u5355\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApi.releaseInventoryByStrategy(inventoryOperateReqDto);
        return (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    @Override
    public Boolean preemptChannelInventoryForOrderItemChange(List<DgPerformOrderItemRespDto> orderItemEos, DgPerformOrderRespDto saleOrderRespDto) {
        return this.preemptChannelInventory(orderItemEos, saleOrderRespDto, PreemptOperateTypeEnum.UPDATE_PREEMPT.getCode(), saleOrderRespDto.getSaleOrderNo());
    }

    private Boolean preemptChannelInventory(List<DgPerformOrderItemRespDto> orderItemEos, DgPerformOrderRespDto saleOrderRespDto, String operateType, String releaseSourceNo) {
        if (this.lockShareFlag.booleanValue()) {
            AssertUtils.notEmpty(orderItemEos, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                PreemptDto preemptDto = new PreemptDto();
                preemptDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
                preemptDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
                List operationDetailDtoList = orderItemEos.stream().map(saleOrderItemEo -> {
                    OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
                    inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
                    inventoryOperateCargoReqDto.setNum(saleOrderItemEo.getItemNum());
                    inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getChannelWarehouseCode());
                    return inventoryOperateCargoReqDto;
                }).collect(Collectors.toList());
                preemptDto.setDetails(operationDetailDtoList);
                preemptDto.setExternalOrderNo(saleOrderRespDto.getPlatformOrderNo());
                log.info("[\u9884\u5360\u6e20\u9053\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptDto));
                RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApi.preempt(preemptDto));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("[\u9884\u5360\u6e20\u9053\u4ed3]\u5f02\u5e38\uff1a", (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean releaseAndpreemptInventory(DgPerformOrderRespDto saleOrderRespDto, List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList) {
        InventoryOperateReqDto inventoryOperateReqDto = new InventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        inventoryOperateReqDto.setYfRepairOrderNo(saleOrderRespDto.getPlatformParentOrderNo());
        List operateCargoReqDtoList = saleOrderItemRespDtoList.stream().map(saleOrderItemEo -> {
            InventoryOperateCargoReqDto inventoryOperateCargoReqDto = new InventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderRespDto.getDeliveryLogicalWarehouseCode());
            inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
            inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getBatchNo());
            inventoryOperateCargoReqDto.setCargoName(saleOrderItemEo.getItemName());
            this.popInventoryOperateCargoReqDto((DgPerformOrderItemRespDto)saleOrderItemEo, inventoryOperateCargoReqDto);
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setShipmentEnterpriseCode(saleOrderRespDto.getShipmentEnterpriseCode());
        inventoryOperateReqDto.setShipmentEnterpriseName(saleOrderRespDto.getShipmentEnterpriseName());
        inventoryOperateReqDto.setBasicDataBusinessType(saleOrderRespDto.getBizType());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto = new LogicPreemptInventoryOperateReqDto();
        logicPreemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
        logicPreemptInventoryOperateReqDto.setSourcePlatformCode(saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
        logicPreemptInventoryOperateReqDto.setOaidOrderSourceCode(saleOrderRespDto.getPlatformOrderNo());
        logicPreemptInventoryOperateReqDto.setPayTime(saleOrderRespDto.getPerformOrderPaymentDto().getPayTime());
        logicPreemptInventoryOperateReqDto.setExchangeOrderNo(saleOrderRespDto.getExchangeOrderNo());
        this.popLogicPreemptInventoryOperateReqDto(saleOrderRespDto, logicPreemptInventoryOperateReqDto);
        this.popOrderAddress(logicPreemptInventoryOperateReqDto, saleOrderRespDto.getId(), saleOrderRespDto.getOaid());
        log.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicPreemptInventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApi.releaseAndPreemptInventory(logicPreemptInventoryOperateReqDto);
        log.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u7ed3\u679c\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)restResponse));
        return (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    @Override
    public Boolean orderShipmentCheck(DgPerformOrderRespDto respDto) {
        InventoryOrderShipmentCheckReqDto shipmentCheckReqDto = new InventoryOrderShipmentCheckReqDto();
        shipmentCheckReqDto.setSourceNo(respDto.getSaleOrderNo());
        shipmentCheckReqDto.setShipmentEnterpriseCode(respDto.getShipmentEnterpriseCode());
        shipmentCheckReqDto.setShipmentEnterpriseName(respDto.getShipmentEnterpriseName());
        log.info("[\u6821\u9a8c\u7269\u6d41]\u9500\u552e\u8ba2\u5355\u5f85\u914d\u8d27\uff0c\u6821\u9a8c\u7269\u6d41\u516c\u53f8\u4e00\u81f4\u6027\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)shipmentCheckReqDto));
        return (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.orderShipmentCheck(shipmentCheckReqDto));
    }

    @Override
    public Boolean releaseChannelInventory(DgPerformOrderRespDto saleOrderRespDto) {
        if (this.lockShareFlag.booleanValue()) {
            try {
                ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
                releasePreemptParam.setSourceNo(saleOrderRespDto.getSaleOrderNo());
                releasePreemptParam.setSourceType(CsInventorySourceTypeEnum.PCP_OUT_SALE_RELEASE.getCode());
                RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApi.releasePreempt(releasePreemptParam));
                return Boolean.TRUE;
            }
            catch (Exception e) {
                log.error("[\u5e93\u5b58\u91ca\u653e]\u5f02\u5e38\uff1a", (Throwable)e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    @Override
    public Boolean preemptChannelInventoryForBSAudit(List<DgPerformOrderItemRespDto> orderItems, DgPerformOrderRespDto saleOrderRespDto) {
        if (StringUtils.equals((String)DgOrderSourceModelEnum.B2B.getCode(), (String)saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode())) {
            return this.preemptChannelInventory(orderItems, saleOrderRespDto, PreemptOperateTypeEnum.UPDATE_PREEMPT.getCode(), saleOrderRespDto.getPlatformOrderNo());
        }
        return this.preemptChannelInventory(orderItems, saleOrderRespDto, PreemptOperateTypeEnum.NORMAL.getCode(), saleOrderRespDto.getSaleOrderNo());
    }

    private void popOrderAddress(LogicPreemptInventoryOperateReqDto logicPreemptInventoryOperateReqDto, Long saleOrderId, String oaid) {
        DgPerformOrderAddrDto saleOrderAddrRespDto = this.performOrderAddrExtDomain.queryAddressByOrderId(saleOrderId);
        BaseOrderAddressAddReqDto orderAddressAddReqDto = new BaseOrderAddressAddReqDto();
        orderAddressAddReqDto.setProvince(saleOrderAddrRespDto.getProvince());
        orderAddressAddReqDto.setEncryptProvince(saleOrderAddrRespDto.getEncryptProvince());
        orderAddressAddReqDto.setProvinceCode(saleOrderAddrRespDto.getProvinceCode());
        orderAddressAddReqDto.setEncryptProvinceCode(saleOrderAddrRespDto.getEncryptProvinceCode());
        orderAddressAddReqDto.setCity(saleOrderAddrRespDto.getCity());
        orderAddressAddReqDto.setEncryptCity(saleOrderAddrRespDto.getEncryptCity());
        orderAddressAddReqDto.setCityCode(saleOrderAddrRespDto.getCityCode());
        orderAddressAddReqDto.setEncryptCityCode(saleOrderAddrRespDto.getEncryptCityCode());
        orderAddressAddReqDto.setDistrict(saleOrderAddrRespDto.getCounty());
        orderAddressAddReqDto.setEncryptDistrict(saleOrderAddrRespDto.getEncryptCounty());
        orderAddressAddReqDto.setDistrictCode(saleOrderAddrRespDto.getCountyCode());
        orderAddressAddReqDto.setEncryptDistrictCode(saleOrderAddrRespDto.getEncryptCountyCode());
        orderAddressAddReqDto.setDetailAddress(saleOrderAddrRespDto.getReceiveAddress());
        orderAddressAddReqDto.setEncryptDetailAddress(saleOrderAddrRespDto.getEncryptReceiveAddress());
        orderAddressAddReqDto.setContacts(saleOrderAddrRespDto.getReceiveName());
        orderAddressAddReqDto.setEncryptContacts(saleOrderAddrRespDto.getEncryptReceiveName());
        orderAddressAddReqDto.setPhone(saleOrderAddrRespDto.getReceivePhone());
        orderAddressAddReqDto.setEncryptPhone(saleOrderAddrRespDto.getEncryptReceivePhone());
        orderAddressAddReqDto.setOaid(oaid);
        logicPreemptInventoryOperateReqDto.setReceivePersonAddressInfo(orderAddressAddReqDto);
    }

    private void popInventoryOperateCargoReqDto(DgPerformOrderItemRespDto saleOrderItemEo, InventoryOperateCargoReqDto inventoryOperateCargoReqDto) {
        inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
        inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
        inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getDeliveryItemBatchNo());
        inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
        inventoryOperateCargoReqDto.setRetailPrice(saleOrderItemEo.getSalePrice());
        inventoryOperateCargoReqDto.setActualPrice(saleOrderItemEo.getPrice());
        inventoryOperateCargoReqDto.setDiscountAmount(saleOrderItemEo.getDiscountAmount().divide(saleOrderItemEo.getItemNum(), 6, 4));
        inventoryOperateCargoReqDto.setTotalRetailAmount(saleOrderItemEo.getSalePrice().multiply(saleOrderItemEo.getItemNum()));
        inventoryOperateCargoReqDto.setTotalActualAmount(saleOrderItemEo.getRealPayAmount());
        inventoryOperateCargoReqDto.setTotalDiscountAmount(saleOrderItemEo.getDiscountAmount());
        inventoryOperateCargoReqDto.setTotalRefundAmount(saleOrderItemEo.getRefundedPayAmount());
    }

    private void popLogicPreemptInventoryOperateReqDto(DgPerformOrderRespDto saleOrderEo, LogicPreemptInventoryOperateReqDto preemptInventoryOperateReqDto) {
        preemptInventoryOperateReqDto.setSourcePlatformCode(saleOrderEo.getPerformOrderSnapshotDto().getChannelCode());
        preemptInventoryOperateReqDto.setOaidOrderSourceCode(saleOrderEo.getPlatformOrderNo());
        preemptInventoryOperateReqDto.setPayTime(saleOrderEo.getPerformOrderPaymentDto().getPayTime());
        preemptInventoryOperateReqDto.setTradeOrderCreateTime(saleOrderEo.getSaleCreateTime());
        preemptInventoryOperateReqDto.setGotAmount(saleOrderEo.getRealPayAmount());
        preemptInventoryOperateReqDto.setArAmount(saleOrderEo.getPayAmount());
        preemptInventoryOperateReqDto.setFreight(saleOrderEo.getFreightCost());
        preemptInventoryOperateReqDto.setDiscountAmount(saleOrderEo.getDiscountAmount());
        preemptInventoryOperateReqDto.setItemAmount(saleOrderEo.getGoodsTotalAmount());
        preemptInventoryOperateReqDto.setTotalAmount(saleOrderEo.getMerchantReceivableAmount());
        preemptInventoryOperateReqDto.setShopId(saleOrderEo.getPerformOrderSnapshotDto().getShopId());
        preemptInventoryOperateReqDto.setShopCode(saleOrderEo.getPerformOrderSnapshotDto().getShopCode());
        preemptInventoryOperateReqDto.setShopName(saleOrderEo.getPerformOrderSnapshotDto().getShopName());
    }

    @Override
    public Boolean preemptChannelInventory(List<DgPerformOrderItemRespDto> orderItems, DgPerformOrderRespDto saleOrderRespDto) {
        return this.preemptChannelInventory(orderItems, saleOrderRespDto, PreemptOperateTypeEnum.ADD_PREEMPT.getCode(), saleOrderRespDto.getSaleOrderNo());
    }
}

