/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.mark.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgOrderLabelItemEo;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderLabelItemService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgOrderLabelItemServiceImpl
implements IDgOrderLabelItemService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;

    @Override
    public void addOrderLabelItems(List<DgOrderLabelItemReqDto> addReqDtos) {
        if (CollectionUtils.isNotEmpty(addReqDtos)) {
            ArrayList orderLabelItemEos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)orderLabelItemEos, addReqDtos, DgOrderLabelItemEo.class);
            this.orderLabelItemDomain.insertBatch((List)orderLabelItemEos);
        }
    }

    @Override
    public Long addOrderLabelItem(DgOrderLabelItemReqDto addReqDto) {
        DgOrderLabelItemEo orderLabelItemEo = new DgOrderLabelItemEo();
        CubeBeanUtils.copyProperties((Object)orderLabelItemEo, (Object)addReqDto, (String[])new String[0]);
        this.orderLabelItemDomain.insert((BaseEo)orderLabelItemEo);
        return orderLabelItemEo.getId();
    }

    @Override
    public Long addOrderLabelItem(Long orderId, Long orderItemId, DgOrderLabelEnum addReqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderItemId, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u5546\u54c1\u884cID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto, (String)"[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelItemEo record = new DgOrderLabelItemEo();
        record.setOrderId(orderId);
        record.setOrderItemId(orderItemId);
        record.setLabelCode(addReqDto.getCode());
        record.setDisplay(addReqDto.getDisplay());
        DgOrderLabelItemEo eo = (DgOrderLabelItemEo)this.orderLabelItemDomain.selectOne((BaseEo)record);
        if (Objects.nonNull(eo)) {
            this.logger.warn(String.format("[\u65b0\u589e\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u5df2\u5b58\u5728%s\u6807\u8bc6", orderId, orderItemId, addReqDto.getCode()));
            return null;
        }
        DgOrderLabelItemEo orderLabelItemEo = new DgOrderLabelItemEo();
        orderLabelItemEo.setLabelCode(addReqDto.getCode());
        orderLabelItemEo.setOrderId(orderId);
        orderLabelItemEo.setOrderItemId(orderItemId);
        orderLabelItemEo.setDisplay(addReqDto.getDisplay());
        this.orderLabelItemDomain.insert((BaseEo)orderLabelItemEo);
        return orderLabelItemEo.getId();
    }

    @Override
    public void modifyOrderLabelItem(DgOrderLabelItemReqDto modifyReqDto) {
        DgOrderLabelItemEo orderLabelItemEo = new DgOrderLabelItemEo();
        CubeBeanUtils.copyProperties((Object)orderLabelItemEo, (Object)modifyReqDto, (String[])new String[0]);
        this.orderLabelItemDomain.updateSelective((BaseEo)orderLabelItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderLabelItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderLabelItemDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeOrderLabelItemById(Long id) {
        this.orderLabelItemDomain.logicDeleteById(id);
    }

    @Override
    public void removeOrderLabelItemById(Long orderId, Long orderItemId, DgOrderLabelEnum reqDto) {
        AssertUtils.notNull((Object)orderId, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u8ba2\u5355ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderItemId, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u5546\u54c1\u884cID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"[\u5220\u9664\u8ba2\u5355\u5546\u54c1\u6807\u8bc6]\u6807\u8bc6\u679a\u4e3e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgOrderLabelItemEo record = new DgOrderLabelItemEo();
        record.setOrderId(orderId);
        record.setOrderItemId(orderItemId);
        record.setLabelCode(reqDto.getCode());
        record.setDisplay(reqDto.getDisplay());
        DgOrderLabelItemEo orderLabelItemEo = (DgOrderLabelItemEo)this.orderLabelItemDomain.selectOne((BaseEo)record);
        if (Objects.isNull(orderLabelItemEo)) {
            this.logger.warn(String.format("[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]%s,%s,\u672a\u627e\u5230\u8be5%s\u6807\u8bc6", orderId, orderItemId, reqDto.getCode()));
            return;
        }
        this.orderLabelItemDomain.logicDeleteById(orderLabelItemEo.getId());
    }

    @Override
    public DgOrderLabelItemRespDto queryById(Long id) {
        DgOrderLabelItemEo orderLabelItemEo = (DgOrderLabelItemEo)this.orderLabelItemDomain.selectByPrimaryKey(id);
        DgOrderLabelItemRespDto orderLabelItemRespDto = new DgOrderLabelItemRespDto();
        DtoHelper.eo2Dto((BaseEo)orderLabelItemEo, (BaseVo)orderLabelItemRespDto);
        return orderLabelItemRespDto;
    }

    @Override
    public PageInfo<DgOrderLabelItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgOrderLabelItemReqDto dgOrderLabelItemReqDto = (DgOrderLabelItemReqDto)JSON.parseObject((String)filter, DgOrderLabelItemReqDto.class);
        DgOrderLabelItemEo orderLabelItemEo = new DgOrderLabelItemEo();
        CubeBeanUtils.copyProperties((Object)orderLabelItemEo, (Object)dgOrderLabelItemReqDto, (String[])new String[0]);
        PageInfo eoPageInfo = this.orderLabelItemDomain.selectPage((BaseEo)orderLabelItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgOrderLabelItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgOrderLabelItemRespDto> queryByParam(DgOrderLabelItemReqDto dgOrderLabelItemReqDto) {
        List saleOrderEos;
        AssertUtils.notNull((Object)dgOrderLabelItemReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(dgOrderLabelItemReqDto.getLabelCode())) {
            queryWrapper.eq(DgOrderLabelItemEo::getLabelCode, (Object)dgOrderLabelItemReqDto.getLabelCode());
        }
        if (Objects.nonNull(dgOrderLabelItemReqDto.getOrderId())) {
            queryWrapper.eq(DgOrderLabelItemEo::getOrderId, (Object)dgOrderLabelItemReqDto.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)dgOrderLabelItemReqDto.getOrderIds())) {
            queryWrapper.in(DgOrderLabelItemEo::getOrderId, (Collection)dgOrderLabelItemReqDto.getOrderIds());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.orderLabelItemDomain.getMapper().selectList((Wrapper)queryWrapper)))) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, DgOrderLabelItemRespDto.class);
        return resultList;
    }

    @Override
    public DgOrderLabelItemRespDto queryByItem(DgOrderLabelItemReqDto DgOrderLabelItemReqDto2) {
        DgOrderLabelItemEo orderLabelItemEo;
        AssertUtils.notNull((Object)DgOrderLabelItemReqDto2, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        if (Objects.nonNull(DgOrderLabelItemReqDto2.getLabelCode())) {
            queryWrapper.eq(DgOrderLabelItemEo::getLabelCode, (Object)DgOrderLabelItemReqDto2.getLabelCode());
        }
        if (Objects.nonNull(DgOrderLabelItemReqDto2.getOrderId())) {
            queryWrapper.eq(DgOrderLabelItemEo::getOrderId, (Object)DgOrderLabelItemReqDto2.getOrderId());
        }
        if (CollectionUtils.isNotEmpty((Collection)DgOrderLabelItemReqDto2.getOrderIds())) {
            queryWrapper.in(DgOrderLabelItemEo::getOrderId, (Collection)DgOrderLabelItemReqDto2.getOrderIds());
        }
        if (Objects.isNull(orderLabelItemEo = (DgOrderLabelItemEo)this.orderLabelItemDomain.getMapper().selectOne((Wrapper)queryWrapper))) {
            return null;
        }
        DgOrderLabelItemRespDto orderLabelItemRespDto = new DgOrderLabelItemRespDto();
        DtoHelper.eo2Dto((BaseEo)orderLabelItemEo, (BaseVo)orderLabelItemRespDto);
        return orderLabelItemRespDto;
    }

    @Override
    public List<DgOrderLabelItemRespDto> queryByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgOrderLabelItemEo::getOrderId, (Object)orderId);
        List saleOrderEos = this.orderLabelItemDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, DgOrderLabelItemRespDto.class);
        return resultList;
    }

    @Override
    public List<DgOrderLabelItemRespDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgOrderLabelItemEo::getOrderId, orderIds);
        List saleOrderEos = this.orderLabelItemDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, DgOrderLabelItemRespDto.class);
        return resultList;
    }

    @Override
    public List<String> queryExistLabelCode(Long orderId, List<DgOrderLabelEnum> orderLabelEnumList) {
        AssertUtils.notNull((Object)orderId, (String)"\u9500\u552e\u8ba2\u5355ID\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull(orderLabelEnumList, (String)"\u6807\u8bc6\u7f16\u7801\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgOrderLabelItemReqDto DgOrderLabelItemReqDto2 = new DgOrderLabelItemReqDto();
        DgOrderLabelItemReqDto2.setOrderId(orderId);
        DgOrderLabelItemReqDto2.setLabelCodes(orderLabelEnumList.stream().map(DgOrderLabelEnum::getCode).collect(Collectors.toList()));
        List<DgOrderLabelItemRespDto> orderLabelItemRespDtos = this.queryByParam(DgOrderLabelItemReqDto2);
        if (CollectionUtils.isEmpty(orderLabelItemRespDtos)) {
            return null;
        }
        return orderLabelItemRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
    }
}

