/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleRefundTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyStatusReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ModifyWarehouseCodeReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemSapAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderSapAuditReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleRefundReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleRefundRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsInventoryOrderSalesRefundDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsInventoryOrderSalesRefundReqDto;
import com.yunxi.dg.base.center.inventory.dto.report.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.inventory.dto.report.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.proxy.inventory.IDgLogicWarehouseApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.inventory.ILogicInventoryExposedApiProxy;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleRefundAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleRefundDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleRefundItemDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleRefundAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleRefundEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleRefundItemEo;
import com.yunxi.dg.base.center.trade.service.tc.ICspService;
import com.yunxi.dg.base.center.trade.service.tc.IExternalNoticeService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleRefundItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleRefundOptService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleRefundService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ISaleRefundOptServiceImpl
implements ISaleRefundOptService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ISaleRefundOptServiceImpl.class);
    private final String SEND_BACK = "SEND_BACK";
    private final String SEND_CANCEL = "SEND_CANCEL";
    @Resource
    private IDgSaleRefundDomain dgSaleRefundDomain;
    @Resource
    private ISaleRefundService saleRefundService;
    @Resource
    private ISaleRefundItemService saleRefundItemService;
    @Resource
    private IDgSaleRefundItemDomain dgSaleRefundItemDomain;
    @Resource
    private ILogicInventoryExposedApiProxy logicInventoryExposedApiProxy;
    @Resource
    private IDgLogicWarehouseApiProxy dgLogicWarehouseApiProxy;
    @Resource
    private IDgSaleRefundAddrDomain dgSaleRefundAddrDomain;
    @Resource
    private ICspService cspService;
    @Resource
    private IExternalNoticeService externalNoticeService;

    @Override
    @DgRedisLock(lockName="saleRefund", key="#refundId")
    @Transactional(rollbackFor={Exception.class})
    public void confirmOrder(Long refundId) {
        AssertUtils.notNull((Object)refundId, (String)"refundId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryRefundWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryRefundWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)refundId);
        DgSaleRefundEo saleRefundEo = (DgSaleRefundEo)this.dgSaleRefundDomain.getMapper().selectOne((Wrapper)queryRefundWrapper);
        AssertUtils.notNull((Object)saleRefundEo, (String)"id=%s\u7684\u9000\u8d27\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{refundId});
        this.checkSaleRefunOrderStatus((SaleOrderStatus)SaleRefundStatusEnum.forCode((String)saleRefundEo.getRefundStatus()), new SaleOrderStatus[]{SaleRefundStatusEnum.WAIT_CHECK});
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundItemEo::getOrderId, (Object)saleRefundEo.getId());
        List saleRefundItemEos = this.dgSaleRefundItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleRefundItemEos, (String)"%s \u9500\u552e\u9000\u5355\u7684\u5546\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[]{saleRefundEo.getSaleRefundNo()});
        LambdaQueryWrapper saleRefundAddrQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)saleRefundAddrQuery.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundAddrEo::getOrderId, (Object)saleRefundEo.getId());
        DgSaleRefundAddrEo saleRefundAddrEo = (DgSaleRefundAddrEo)this.dgSaleRefundAddrDomain.getMapper().selectOne((Wrapper)saleRefundAddrQuery);
        DgSaleRefundEo updateStatusEo = new DgSaleRefundEo();
        updateStatusEo.setRefundStatus(SaleRefundStatusEnum.HAD_CHECK.getCode());
        this.optimisticSaleRefundStatus(updateStatusEo, refundId, SaleRefundStatusEnum.WAIT_CHECK);
        this.applyRefundForInventory(saleRefundEo, saleRefundItemEos, saleRefundAddrEo);
    }

    private void applyRefundForInventory(DgSaleRefundEo saleRefundEo, List<DgSaleRefundItemEo> saleRefundItemEos, DgSaleRefundAddrEo saleRefundAddrEo) {
        CsInventoryOrderSalesRefundReqDto inventoryOrderSalesRefundReqDto = new CsInventoryOrderSalesRefundReqDto();
        inventoryOrderSalesRefundReqDto.setTotalInventory(saleRefundEo.getGoodsTotalNum());
        inventoryOrderSalesRefundReqDto.setSourceNo(saleRefundEo.getSaleRefundNo());
        inventoryOrderSalesRefundReqDto.setRemark(saleRefundEo.getRemark());
        ArrayList operateCargoReqDtoList = Lists.newArrayList();
        saleRefundItemEos.forEach(saleRefundItemEo -> {
            CsInventoryOrderSalesRefundDetailReqDto inventoryOrderSalesRefundDetailReqDto = new CsInventoryOrderSalesRefundDetailReqDto();
            inventoryOrderSalesRefundDetailReqDto.setId(saleRefundItemEo.getId());
            inventoryOrderSalesRefundDetailReqDto.setLongCode(saleRefundItemEo.getSkuCode());
            inventoryOrderSalesRefundDetailReqDto.setBatch(saleRefundItemEo.getBatchNo());
            inventoryOrderSalesRefundDetailReqDto.setWarehouseCode(saleRefundItemEo.getRefundWarehouseCode());
            inventoryOrderSalesRefundDetailReqDto.setChangeInventory(saleRefundItemEo.getItemNum());
            inventoryOrderSalesRefundDetailReqDto.setProduceTime(saleRefundItemEo.getProduceTime());
            inventoryOrderSalesRefundDetailReqDto.setExpireTime(saleRefundItemEo.getExpireTime());
            operateCargoReqDtoList.add(inventoryOrderSalesRefundDetailReqDto);
        });
        inventoryOrderSalesRefundReqDto.setOperateCargoReqDtoList((List)operateCargoReqDtoList);
        ContactDto contactDto = new ContactDto();
        contactDto.setPhone(saleRefundAddrEo.getReceivePhone());
        contactDto.setContacts(saleRefundAddrEo.getReceiveName());
        contactDto.setReciveName(saleRefundAddrEo.getReceiveName());
        contactDto.setRecivePhone(saleRefundAddrEo.getReceivePhone());
        contactDto.setDetailAddress(saleRefundAddrEo.getReceiveAddress());
        inventoryOrderSalesRefundReqDto.setContactDto(contactDto);
        LOGGER.info("[\u9500\u552e\u9000\u786e\u8ba4]\u8bf7\u6c42\u5e93\u5b58\u4e2d\u5fc3\u9500\u552e\u9000\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOrderSalesRefundReqDto));
        RestResponse restResponse = this.logicInventoryExposedApiProxy.orderSalesRefundConfirm(inventoryOrderSalesRefundReqDto);
        RestResponseHelper.checkOrThrow((RestResponse)restResponse);
    }

    @Override
    @DgRedisLock(lockName="saleRefund", key="#refundId")
    public void cancel(Long refundId) {
        AssertUtils.notNull((Object)refundId, (String)"refundId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryRefundWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryRefundWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)refundId);
        DgSaleRefundEo saleRefundEo = (DgSaleRefundEo)this.dgSaleRefundDomain.getMapper().selectOne((Wrapper)queryRefundWrapper);
        AssertUtils.notNull((Object)saleRefundEo, (String)"id=%s\u7684\u9000\u8d27\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{refundId});
        if (SaleRefundStatusEnum.INVALID.getCode().equals(saleRefundEo.getRefundStatus())) {
            return;
        }
        this.checkSaleRefunOrderStatus((SaleOrderStatus)SaleRefundStatusEnum.forCode((String)saleRefundEo.getRefundStatus()), new SaleOrderStatus[]{SaleRefundStatusEnum.WAIT_CHECK});
        RestResponse restResponse = this.logicInventoryExposedApiProxy.orderSalesCheckCancel(saleRefundEo.getSaleRefundNo());
        Boolean canCancel = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        if (!canCancel.booleanValue()) {
            throw PcpTradeExceptionCode.CANNOT_CANCEL_EXCEPTION.builderException();
        }
        DgSaleRefundEo updateStatusEo = new DgSaleRefundEo();
        updateStatusEo.setRefundStatus(SaleRefundStatusEnum.CANCEL.getCode());
        this.optimisticSaleRefundStatus(updateStatusEo, refundId, SaleRefundStatusEnum.WAIT_CHECK);
    }

    @Override
    @DgRedisLock(lockName="saleRefund", key="#refundId")
    public void doClose(Long refundId) {
        AssertUtils.notNull((Object)refundId, (String)"refundId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)refundId);
        DgSaleRefundEo saleRefundEo = (DgSaleRefundEo)this.dgSaleRefundDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtils.notNull((Object)saleRefundEo, (String)"\u5f53\u524d\u9500\u552e\u9000\u5355\u4e0d\u5b58\u5728");
        this.checkSaleRefunOrderStatus((SaleOrderStatus)SaleRefundStatusEnum.forCode((String)saleRefundEo.getRefundStatus()), new SaleOrderStatus[]{SaleRefundStatusEnum.HAD_CHECK, SaleRefundStatusEnum.PART_OUTBOUND});
        RestResponse restResponse = this.logicInventoryExposedApiProxy.orderSalesClose(saleRefundEo.getSaleRefundNo());
        Boolean closeSuccess = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        if (closeSuccess.booleanValue()) {
            DgSaleRefundEo updateStatusEo = new DgSaleRefundEo();
            updateStatusEo.setRefundStatus(SaleRefundStatusEnum.CLOSE.getCode());
            this.optimisticSaleRefundStatus(updateStatusEo, refundId, SaleRefundStatusEnum.HAD_CHECK, SaleRefundStatusEnum.PART_OUTBOUND);
        }
    }

    @Override
    @DgRedisLock(lockName="saleRefund", key="#reqDto.getSaleRefundOrderId()")
    public void modifyWarehouseCode(ModifyWarehouseCodeReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getSaleRefundOrderId(), (String)"saleRefundOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)reqDto.getSaleRefundOrderId());
        DgSaleRefundEo saleRefundEo = (DgSaleRefundEo)this.dgSaleRefundDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtils.notNull((Object)saleRefundEo, (String)"id=%s\u7684\u9500\u552e\u9000\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{reqDto.getSaleRefundOrderId()});
        this.checkEnableModifyWarehouse(saleRefundEo);
        this.modifyWarehouseForRefundItem(reqDto);
    }

    @Override
    public void modifyStatus(ModifyStatusReqDto reqDto) {
        AssertUtils.notBlank((String)reqDto.getSaleRefundNo(), (String)"saleRefundNo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundEo::getSaleRefundNo, (Object)reqDto.getSaleRefundNo());
        DgSaleRefundEo saleRefundEo = (DgSaleRefundEo)this.dgSaleRefundDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtils.notNull((Object)saleRefundEo, (String)"%s\u9500\u552e\u9000\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{reqDto.getSaleRefundNo()});
        String orderStatus = null;
        if ("SEND_BACK".equals(reqDto.getTypeFlag())) {
            this.checkSaleRefunOrderStatus((SaleOrderStatus)SaleRefundStatusEnum.forCode((String)saleRefundEo.getRefundStatus()), new SaleOrderStatus[]{SaleRefundStatusEnum.HAD_CHECK, SaleRefundStatusEnum.PART_OUTBOUND});
            BigDecimal goodsTotalNum = saleRefundEo.getGoodsTotalNum();
            LOGGER.info("[\u4fee\u6539\u9500\u552e\u9000\u72b6\u6001]\u9500\u552e\u9000\u5546\u54c1\u603b\u6570\u91cf\u4e3a\uff1a{}\uff0c\u5df2\u5165\u5e93\u7684\u603b\u6570\u91cf\u4e3a\uff1a{}", (Object)goodsTotalNum, (Object)reqDto.getInBoundCount());
            orderStatus = SaleRefundStatusEnum.PART_OUTBOUND.getCode();
            if (goodsTotalNum.compareTo(reqDto.getInBoundCount()) == 0) {
                orderStatus = SaleRefundStatusEnum.COMPLETE.getCode();
            }
        } else {
            SaleRefundStatusEnum saleRefundStatusEnum = SaleRefundStatusEnum.enumOf((String)reqDto.getStatus());
            orderStatus = saleRefundStatusEnum.getCode();
        }
        DgSaleRefundEo updateStatusEo = new DgSaleRefundEo();
        updateStatusEo.setRefundStatus(orderStatus);
        this.optimisticSaleRefundStatus(updateStatusEo, saleRefundEo.getId(), SaleRefundStatusEnum.HAD_CHECK, SaleRefundStatusEnum.PART_OUTBOUND);
        if (Objects.equals(orderStatus, SaleRefundStatusEnum.COMPLETE.getCode())) {
            SaleRefundReqDto saleRefundReqDto = new SaleRefundReqDto();
            DtoHelper.eo2Dto((BaseEo)saleRefundEo, (BaseVo)saleRefundReqDto);
            saleRefundReqDto.setRefundStatus(SaleRefundStatusEnum.COMPLETE.getCode());
            this.externalNoticeService.sendSaleRefundOrderCompleteBroadcast(saleRefundReqDto);
        }
    }

    @Override
    public void invalid(Long saleRefundId) {
        AssertUtils.notNull((Object)saleRefundId, (String)"refundId\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryRefundWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryRefundWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)saleRefundId);
        DgSaleRefundEo saleRefundEo = (DgSaleRefundEo)this.dgSaleRefundDomain.getMapper().selectOne((Wrapper)queryRefundWrapper);
        AssertUtils.notNull((Object)saleRefundEo, (String)"id=%s\u7684\u9000\u8d27\u5355\u4e0d\u5b58\u5728", (Object[])new Object[]{saleRefundId});
        this.checkSaleRefunOrderStatus((SaleOrderStatus)SaleRefundStatusEnum.forCode((String)saleRefundEo.getRefundStatus()), new SaleOrderStatus[]{SaleRefundStatusEnum.COMPLETE});
        DgSaleRefundEo updateStatusEo = new DgSaleRefundEo();
        updateStatusEo.setRefundStatus(SaleRefundStatusEnum.INVALID.getCode());
        this.optimisticSaleRefundStatus(updateStatusEo, saleRefundId, SaleRefundStatusEnum.COMPLETE);
    }

    @Override
    public void batchConfirmOrder(List<Long> refundIdList) {
        if (refundIdList.size() == 1) {
            this.confirmOrder(refundIdList.get(0));
            return;
        }
        LOGGER.info("[\u6279\u91cf\u64cd\u4f5c\u624b\u5de5\u786e\u8ba4]\u6279\u91cf\u64cd\u4f5c\u9500\u552e\u9000\u5355id={}", (Object)JSON.toJSONString(refundIdList));
        ArrayList saleRefundIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long saleRefundId : refundIdList) {
            try {
                this.confirmOrder(saleRefundId);
            }
            catch (Exception e) {
                saleRefundIdOfexceptionList.add(saleRefundId);
                errMessageMap.put(saleRefundId, e.getMessage());
                LOGGER.error("[\u6279\u91cf\u64cd\u4f5c\u9500\u552e\u9000\u5355\u786e\u8ba4]\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saleRefundIdOfexceptionList)) {
            String message = "\u6279\u91cf\u64cd\u4f5c\u5931\u8d25:\n %s ";
            this.throwExceptoinMessage(saleRefundIdOfexceptionList, message, errMessageMap);
        }
    }

    @Override
    public void batchCancel(List<Long> refundIdList) {
        if (refundIdList.size() == 1) {
            this.cancel(refundIdList.get(0));
            return;
        }
        LOGGER.info("[\u6279\u91cf\u53d6\u6d88\u9500\u552e\u9000\u5355]\u6279\u91cf\u64cd\u4f5c\u9500\u552e\u9000\u5355\u53d6\u6d88 id={}", (Object)JSON.toJSONString(refundIdList));
        ArrayList saleRefundIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long saleRefundId : refundIdList) {
            try {
                this.cancel(saleRefundId);
            }
            catch (Exception e) {
                saleRefundIdOfexceptionList.add(saleRefundId);
                errMessageMap.put(saleRefundId, e.getMessage());
                LOGGER.error("[\u6279\u91cf\u53d6\u6d88\u9500\u552e\u9000\u5355]\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saleRefundIdOfexceptionList)) {
            String message = "\u6279\u91cf\u64cd\u4f5c\u5931\u8d25:\n %s ";
            this.throwExceptoinMessage(saleRefundIdOfexceptionList, message, errMessageMap);
        }
    }

    @Override
    public void batchInvalid(List<Long> refundIdList) {
        AssertUtils.notEmpty(refundIdList, (String)"");
        ArrayList saleRefundIdOfexceptionList = Lists.newArrayList();
        HashMap<Long, String> errMessageMap = new HashMap<Long, String>();
        for (Long saleRefundId : refundIdList) {
            try {
                this.invalid(saleRefundId);
            }
            catch (Exception e) {
                saleRefundIdOfexceptionList.add(saleRefundId);
                errMessageMap.put(saleRefundId, e.getMessage());
                LOGGER.error("[\u4f5c\u5e9f\u9500\u552e\u9000\u5355]\u5f02\u5e38\uff1a{}", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saleRefundIdOfexceptionList)) {
            String message = "\u64cd\u4f5c\u5931\u8d25:\n %s ";
            this.throwExceptoinMessage(saleRefundIdOfexceptionList, message, errMessageMap);
        }
    }

    @Override
    public void saleRefundSapAudit(SaleOrderSapAuditReqDto reqDto) {
        List<SaleRefundRespDto> respList = this.saleRefundService.queryDetailByPlatformRefundNo(reqDto.getCustomerOrderNumber());
        if (CollectionUtils.isNotEmpty(respList)) {
            SaleRefundRespDto respDto = respList.get(0);
            SaleRefundReqDto modifyReqDto = new SaleRefundReqDto();
            modifyReqDto.setId(respDto.getId());
            modifyReqDto.setSapOrderNo(reqDto.getSapOrderNo());
            modifyReqDto.setSapAuditFlag(Integer.valueOf(1));
            this.saleRefundService.modifySaleRefund(modifyReqDto);
            PageInfo<SaleRefundItemRespDto> pageInfo = this.saleRefundItemService.queryByPage(respDto.getId(), 1, 5000);
            List itemList = pageInfo.getList();
            if (CollectionUtils.isNotEmpty((Collection)itemList)) {
                for (SaleRefundItemRespDto item : itemList) {
                    Optional<SaleOrderItemSapAuditReqDto> filterSapItem = reqDto.getItemList().stream().filter(i -> i.getCustomerOrderItemNumber().equals(item.getOrderLine())).findFirst();
                    if (!filterSapItem.isPresent()) continue;
                    SaleOrderItemSapAuditReqDto sapItem = filterSapItem.get();
                    SaleRefundItemReqDto itemReqDto = new SaleRefundItemReqDto();
                    itemReqDto.setId(item.getId());
                    HashMap<String, String> extInfo = new HashMap<String, String>();
                    extInfo.put("sourceBillEntryId", sapItem.getSapOrderItemId());
                    itemReqDto.setExtension(JSON.toJSONString(extInfo));
                    this.saleRefundItemService.modifySaleRefundItem(itemReqDto);
                }
            }
            this.externalNoticeService.sendSaleRefundOrderSapAuditBroadcast(respDto.getSaleRefundNo());
        }
    }

    private void modifyWarehouseForRefundItem(ModifyWarehouseCodeReqDto reqDto) {
        AssertUtils.notEmpty((Collection)reqDto.getGoodsList(), (String)"goodsList\u4e0d\u80fd\u4e3a\u7a7a");
        Long refundOrderId = reqDto.getSaleRefundOrderId();
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleRefundItemEo::getOrderId, (Object)refundOrderId);
        List saleRefundItemEos = this.dgSaleRefundItemDomain.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty((Collection)saleRefundItemEos, (String)"\u8be5\u9000\u8d27\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        AssertUtils.notNull((Object)((SaleRefundItemReqDto)reqDto.getGoodsList().get(0)).getId(), (String)"\u9000\u8d27\u5355\u5546\u54c1id\u4e0d\u80fd\u4e3a\u7a7a");
        Map refundItemReqDtoMap = reqDto.getGoodsList().stream().collect(Collectors.toMap(SaleRefundItemReqDto::getId, Function.identity()));
        List deliveryLogicalWarehouseCodeList = reqDto.getGoodsList().stream().map(SaleRefundItemReqDto::getRefundWarehouseCode).collect(Collectors.toList());
        DgLogicWarehousePageReqDto logicWarehouseParamQueryDto = new DgLogicWarehousePageReqDto();
        logicWarehouseParamQueryDto.setWarehouseCodes(deliveryLogicalWarehouseCodeList);
        RestResponse listRestResponse = this.dgLogicWarehouseApiProxy.queryList(logicWarehouseParamQueryDto);
        List logicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
        LOGGER.info("[\u4fee\u6539\u4ed3\u5e93]\u67e5\u8be2\u5230\u903b\u8f91\u4ed3\u4fe1\u606f\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicWarehousePageRespDtos));
        Map warehousePageRespDtoMap = logicWarehousePageRespDtos.stream().collect(Collectors.toMap(DgLogicWarehouseDto::getWarehouseCode, Function.identity(), (v1, v2) -> v2));
        saleRefundItemEos.forEach(saleRefundItemEo -> {
            SaleRefundItemReqDto saleRefundItemReqDto = (SaleRefundItemReqDto)refundItemReqDtoMap.get(saleRefundItemEo.getId());
            if (saleRefundItemReqDto != null) {
                if (saleRefundItemEo.getItemNum().compareTo(saleRefundItemReqDto.getItemNum()) > 0) {
                    LOGGER.info("[\u4fee\u6539\u4ed3\u5e93]refundItemId={}\u53ea\u4fee\u6539\u4e86\u90e8\u5206\u5546\u54c1({})\u7684\u4ed3\u5e93\u4fe1\u606f\uff0c\u9700\u8981\u8fdb\u884c\u5546\u54c1\u62c6\u5206", (Object)saleRefundItemEo.getId(), (Object)saleRefundItemReqDto.getItemNum());
                    this.splitRefundItemAndModifyWarehouse((DgSaleRefundItemEo)saleRefundItemEo, saleRefundItemReqDto, warehousePageRespDtoMap);
                } else if (saleRefundItemEo.getItemNum().compareTo(saleRefundItemReqDto.getItemNum()) == 0) {
                    DgLogicWarehouseDto logicWarehousePageRespDto;
                    AssertUtils.notNull((Object)saleRefundItemReqDto.getBatchNo(), (String)"batchNo\u4e0d\u80fd\u4e3a\u7a7a");
                    AssertUtils.notNull((Object)saleRefundItemReqDto.getRefundWarehouseCode(), (String)"refundWarehouseCode\u4e0d\u80fd\u4e3a\u7a7a");
                    LOGGER.info("[\u4fee\u6539\u4ed3\u5e93]refundItemId={}\u53ea\u4fee\u6539\u4e86\u5168\u90e8\u4fee\u6539\u4e3awarehouseCode={}, batchNo={}", new Object[]{saleRefundItemEo.getId(), saleRefundItemReqDto.getRefundWarehouseCode(), saleRefundItemReqDto.getBatchNo()});
                    DgSaleRefundItemEo updateEo = new DgSaleRefundItemEo();
                    updateEo.setId(saleRefundItemEo.getId());
                    updateEo.setBatchNo(saleRefundItemReqDto.getBatchNo());
                    if (Objects.nonNull(saleRefundItemReqDto.getExpireTime())) {
                        updateEo.setExpireTime(saleRefundItemReqDto.getExpireTime());
                    }
                    if (Objects.nonNull(saleRefundItemReqDto.getProduceTime())) {
                        updateEo.setProduceTime(saleRefundItemReqDto.getProduceTime());
                    }
                    if ((logicWarehousePageRespDto = (DgLogicWarehouseDto)warehousePageRespDtoMap.get(saleRefundItemReqDto.getRefundWarehouseCode())) != null) {
                        updateEo.setRefundWarehouseCode(logicWarehousePageRespDto.getWarehouseCode());
                        updateEo.setRefundWarehouseId(logicWarehousePageRespDto.getId());
                        updateEo.setRefundWarehouseName(logicWarehousePageRespDto.getWarehouseName());
                    }
                    this.dgSaleRefundItemDomain.updateSelective((BaseEo)updateEo);
                }
            }
        });
    }

    private void splitRefundItemAndModifyWarehouse(DgSaleRefundItemEo saleRefundItemEo, SaleRefundItemReqDto saleRefundItemReqDto, Map<String, DgLogicWarehouseDto> warehousePageRespDtoMap) {
        DgSaleRefundItemEo splitSaleRefundItemEo = new DgSaleRefundItemEo();
        CubeBeanUtils.copyProperties((Object)splitSaleRefundItemEo, (Object)saleRefundItemEo, (String[])new String[]{"id", "create_time", "update_time"});
        DgLogicWarehouseDto warehousePageRespDto = warehousePageRespDtoMap.get(saleRefundItemReqDto.getRefundWarehouseCode());
        if (warehousePageRespDto != null) {
            splitSaleRefundItemEo.setRefundWarehouseCode(saleRefundItemReqDto.getRefundWarehouseCode());
            splitSaleRefundItemEo.setRefundWarehouseId(warehousePageRespDto.getId());
            splitSaleRefundItemEo.setRefundWarehouseName(warehousePageRespDto.getWarehouseName());
        }
        splitSaleRefundItemEo.setItemNum(saleRefundItemReqDto.getItemNum());
        splitSaleRefundItemEo.setBatchNo(saleRefundItemReqDto.getBatchNo());
        if (Objects.nonNull(saleRefundItemReqDto.getExpireTime())) {
            splitSaleRefundItemEo.setExpireTime(saleRefundItemReqDto.getExpireTime());
        }
        if (Objects.nonNull(saleRefundItemReqDto.getProduceTime())) {
            splitSaleRefundItemEo.setProduceTime(saleRefundItemReqDto.getProduceTime());
        }
        this.dgSaleRefundItemDomain.insert((BaseEo)splitSaleRefundItemEo);
        BigDecimal remainNum = saleRefundItemEo.getItemNum().subtract(saleRefundItemReqDto.getItemNum());
        DgSaleRefundItemEo updateEo = new DgSaleRefundItemEo();
        updateEo.setId(saleRefundItemEo.getId());
        updateEo.setItemNum(remainNum);
        this.dgSaleRefundItemDomain.updateSelective((BaseEo)updateEo);
    }

    private void checkEnableModifyWarehouse(DgSaleRefundEo saleRefundEo) {
        String refundType = saleRefundEo.getRefundType();
        if (!SaleRefundTypeEnum.SPECIAL.getCode().equals(refundType)) {
            throw PcpTradeExceptionCode.CHECK_MODIFY_WAREHOUSE.builderException();
        }
        this.checkSaleRefunOrderStatus((SaleOrderStatus)SaleRefundStatusEnum.forCode((String)saleRefundEo.getRefundStatus()), new SaleOrderStatus[]{SaleRefundStatusEnum.WAIT_CHECK});
    }

    private void checkSaleRefunOrderStatus(SaleOrderStatus nowStatus, SaleOrderStatus ... allowStatus) {
        SaleOrderStatus status;
        if (allowStatus == null) {
            throw PcpTradeExceptionCode.CHECK_REFUND_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.getDesc()});
        }
        boolean inAllow = false;
        SaleOrderStatus[] saleOrderStatusArray = allowStatus;
        int n = saleOrderStatusArray.length;
        for (int i = 0; i < n && !(inAllow = (status = saleOrderStatusArray[i]) == nowStatus); ++i) {
        }
        if (!inAllow) {
            throw PcpTradeExceptionCode.CHECK_REFUND_STATUS_NOT_ALLOW.buildBizException(new Object[]{nowStatus.getDesc()});
        }
    }

    private void optimisticSaleRefundStatus(DgSaleRefundEo updateStatusEo, Long refundId, SaleRefundStatusEnum ... beforeStatus) {
        DgSaleRefundEo queryEo = new DgSaleRefundEo();
        queryEo.setId(refundId);
        UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
        updateWrapper.in((Object)"refund_status", (Collection)Stream.of(beforeStatus).map(String::valueOf).collect(Collectors.toList()));
        this.saleRefundService.optimisticModifySaleRefund(updateStatusEo, (UpdateWrapper<DgSaleRefundEo>)updateWrapper, 1, true);
    }

    private void throwExceptoinMessage(List<Long> orderIdOfexceptionList, String message, Map<Long, String> errMessageMap) {
        List<SaleRefundRespDto> saleRefundRespDtos = this.saleRefundService.queryByRefundIds(orderIdOfexceptionList);
        StringBuilder messageBuilder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(saleRefundRespDtos)) {
            for (SaleRefundRespDto saleRefundRespDto : saleRefundRespDtos) {
                messageBuilder.append(saleRefundRespDto.getSaleRefundNo()).append(errMessageMap.get(saleRefundRespDto.getId())).append("; \n");
            }
        }
        throw new BizException(PcpTradeExceptionCode.BATCH_OPT_EXCEPTION.getCode(), String.format(message, messageBuilder.toString()));
    }
}

