/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.impl;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.inventory.api.bd.ICsInOutOrderExtApi;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.inventory.pcp.ICsPcpInventoryExposedApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateCargoReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsInventoryOperateReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.order.CsInOutOrderTriggerReqDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.inventory.CsAddInventoryOrderRespDto;
import com.yunxi.dg.base.center.inventory.api.baseorder.IInOutNoticeOrderApi;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedApi;
import com.yunxi.dg.base.center.inventory.dto.baseorder.GenerateInNoticeOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderGenerateDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderGenerateReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOrderSalesRefundDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOrderSalesRefundReqDto;
import com.yunxi.dg.base.center.trade.action.IDgAfterSaleOrderAction;
import com.yunxi.dg.base.center.trade.action.IDgPerformOrderOptAction;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundInterceptStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderLevelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderBatchReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderGoodsItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderGoodsItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemExtensionEo;
import com.yunxi.dg.base.center.trade.service.IDgAfterSaleOrderGoodsItemService;
import com.yunxi.dg.base.center.trade.service.IDgAfterSaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.IDgAfterSaleOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.IDgSaleOrderAndItemAmountChangeService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAfterSaleOrderActionImpl
implements IDgAfterSaleOrderAction {
    private static final Logger log = LoggerFactory.getLogger(DgAfterSaleOrderActionImpl.class);
    private static final String log_prefix = "afterSaleOrderAction";
    private static final Integer BATCH_INSERT_THRESHOLD = 2000;
    @Resource
    private Validator validator;
    @Resource
    private IDgAfterSaleOrderService dgAfterSaleOrderService;
    @Resource
    private IDgAfterSaleOrderItemService dgAfterSaleOrderItemService;
    @Resource
    private IDgAfterSaleOrderGoodsItemService dgAfterSaleOrderGoodsItemService;
    @Resource
    private IDgPerformOrderService dgPerformOrderService;
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgSaleOrderAndItemAmountChangeService saleOrderAndItemAmountChangeService;
    @Resource
    private IDgPerformOrderOptAction performOrderOptAction;
    @Resource
    private ILogicInventoryExposedApi logicInventoryExposedApi;
    @Resource
    private ICsInOutOrderExtApi csInOutOrderExtApi;
    @Resource
    private IInOutNoticeOrderApi inOutNoticeOrderApi;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private ICsPcpInventoryExposedApi inventoryExposedApi;
    @Resource
    private IDgAfterSaleOrderTagRecordService afterSaleOrderTagRecordService;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateNumAndAmountConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        if (dto.getItemNum() != null && dto.getItemNum() > 0) {
            updateEo.setRefundedItemNum(BigDecimal.valueOf(dto.getItemNum().intValue()));
        }
        if (dto.getRefundAmount() != null && dto.getRefundAmount().compareTo(BigDecimal.ZERO) > 0) {
            updateEo.setRefundedPayAmount(dto.getRefundAmount());
            updateEo.setSurplusCanRefundPayAmount(dto.getRefundAmount());
        }
        this.saleOrderAndItemAmountChangeService.changeSaleOrderItem(dto.getSaleOrderId(), dto.getSaleOrderItemId(), updateEo, null);
    };
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateNumConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        if (dto.getItemNum() != null && dto.getItemNum() > 0) {
            updateEo.setRefundedItemNum(BigDecimal.valueOf(dto.getItemNum().intValue()));
        }
        updateEo.setRefundedPayAmount(BigDecimal.ZERO);
        updateEo.setSurplusCanRefundPayAmount(BigDecimal.ZERO);
        this.saleOrderAndItemAmountChangeService.changeSaleOrderItem(dto.getSaleOrderId(), dto.getSaleOrderItemId(), updateEo, null);
    };
    private final Consumer<DgAfterSaleOrderItemRespDto> calculateAmountConsumer = dto -> {
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        updateEo.setRefundedItemNum(BigDecimal.ZERO);
        if (dto.getRefundAmount() != null && dto.getRefundAmount().compareTo(BigDecimal.ZERO) > 0) {
            updateEo.setRefundedPayAmount(dto.getRefundAmount());
            updateEo.setSurplusCanRefundPayAmount(dto.getRefundAmount());
        }
        this.saleOrderAndItemAmountChangeService.changeSaleOrderItem(dto.getSaleOrderId(), dto.getSaleOrderItemId(), updateEo, null);
    };

    @Override
    @Transactional
    public RestResponse<Long> create(DgAfterSaleOrderDto addDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        log.info("{}_create addDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)addDto));
        log.info("{}_create itemReqDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemReqDtoList));
        log.info("{}_create goodsItemReqDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(goodsItemReqDtoList));
        if ((addDto.getRelateToPlatformOrder() == null || Objects.equals(addDto.getRelateToPlatformOrder(), 0)) && (AfterSaleOrderTypeEnum.THTK.getCode().equals(addDto.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.HH.getCode().equals(addDto.getAfterSaleOrderType()))) {
            this.performOrderItemDomain.reducePerformOrderReturnItemNum(addDto.getSaleOrderId(), itemReqDtoList);
        }
        long id = this.dgAfterSaleOrderService.addAfterSaleOrder(addDto);
        this.batchInsertAfterSaleOrderItem(id, itemReqDtoList, goodsItemReqDtoList);
        return new RestResponse((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> update(DgAfterSaleOrderRespDto afterSaleOrderRespDto, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        log.info("{}_update afterSaleOrderReqDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        log.info("{}_update itemReqDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemReqDtoList));
        log.info("{}_update goodsItemReqDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(goodsItemReqDtoList));
        if (afterSaleOrderRespDto.getId() == null || StringUtils.isEmpty((CharSequence)afterSaleOrderRespDto.getAfterSaleOrderNo())) {
            log.warn("\u552e\u540e\u5355\u7f3a\u5c11\u552f\u4e00\u7ea6\u675f: {}", (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
            throw new BizException("\u7f3a\u5c11\u552f\u4e00\u7ea6\u675f");
        }
        log.info("{}_update afterSaleOrderRespDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderReqDto, (Object)afterSaleOrderRespDto, (String[])new String[0]);
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        this.dgAfterSaleOrderItemService.removeByAfterSaleOrder(afterSaleOrderRespDto.getId());
        this.dgAfterSaleOrderGoodsItemService.removeByAfterSaleOrder(afterSaleOrderRespDto.getId());
        this.batchInsertAfterSaleOrderItem(afterSaleOrderReqDto.getId(), itemReqDtoList, goodsItemReqDtoList);
        return RestResponse.VOID;
    }

    public void batchInsertAfterSaleOrderItem(Long afterSaleId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList, List<DgAfterSaleOrderGoodsItemReqDto> goodsItemReqDtoList) {
        if (CollectionUtils.isNotEmpty(itemReqDtoList)) {
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            for (DgAfterSaleOrderItemModifyReqDto dgAfterSaleOrderItemModifyReqDto : itemReqDtoList) {
                dgAfterSaleOrderItemModifyReqDto.setAfterSaleOrderId(afterSaleId);
                dgAfterSaleOrderItemModifyReqDto.setId(null);
                Long itemId = this.dgAfterSaleOrderItemService.addAfterSaleOrderItem((DgAfterSaleOrderItemReqDto)dgAfterSaleOrderItemModifyReqDto);
                idMap.put(dgAfterSaleOrderItemModifyReqDto.getSaleOrderItemId(), itemId);
            }
            if (CollectionUtils.isNotEmpty(goodsItemReqDtoList)) {
                ArrayList batchInsertDtoList = Lists.newArrayList();
                for (DgAfterSaleOrderGoodsItemReqDto goodsItemReqDto : goodsItemReqDtoList) {
                    goodsItemReqDto.setAfterSaleOrderId(afterSaleId);
                    goodsItemReqDto.setId(Long.valueOf(IdGenrator.getDistributedId()));
                    goodsItemReqDto.setAfterSaleOrderItemId((Long)idMap.get(goodsItemReqDto.getLinkSaleOrderItemId()));
                    batchInsertDtoList.add(goodsItemReqDto);
                    if (batchInsertDtoList.size() < BATCH_INSERT_THRESHOLD) continue;
                    ArrayList<DgAfterSaleOrderGoodsItemEo> dgAfterSaleOrderGoodsItemEoList = new ArrayList<DgAfterSaleOrderGoodsItemEo>();
                    DtoHelper.dtoList2EoList((Collection)batchInsertDtoList, dgAfterSaleOrderGoodsItemEoList, DgAfterSaleOrderGoodsItemEo.class);
                    this.dgAfterSaleOrderGoodsItemService.batchAddAfterSaleOrderGoodsItem(dgAfterSaleOrderGoodsItemEoList);
                    batchInsertDtoList = Lists.newArrayList();
                }
                if (CollectionUtils.isNotEmpty((Collection)batchInsertDtoList)) {
                    ArrayList<DgAfterSaleOrderGoodsItemEo> arrayList = new ArrayList<DgAfterSaleOrderGoodsItemEo>();
                    DtoHelper.dtoList2EoList((Collection)batchInsertDtoList, arrayList, DgAfterSaleOrderGoodsItemEo.class);
                    this.dgAfterSaleOrderGoodsItemService.batchAddAfterSaleOrderGoodsItem(arrayList);
                }
            }
        }
    }

    @Override
    @Transactional
    public RestResponse<Void> audit(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<String> send2wmsByChild(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_send2wmsByChild afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        InventoryOrderSalesRefundReqDto reqDto = new InventoryOrderSalesRefundReqDto();
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        reqDto.setTotalInventory(new BigDecimal(itemRespDtoList.stream().map(DgAfterSaleOrderItemDto::getItemNum).reduce(Integer::sum).orElseThrow(() -> new BizException("\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"))));
        reqDto.setSourceNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        List operateCargoReqDtoList = itemRespDtoList.stream().map(itemDto -> {
            InventoryOrderSalesRefundDetailReqDto operateCargoReqDto = new InventoryOrderSalesRefundDetailReqDto();
            operateCargoReqDto.setLongCode(itemDto.getSkuCode());
            operateCargoReqDto.setBatch(itemDto.getBatchNo());
            operateCargoReqDto.setWarehouseCode(itemDto.getRefundWarehouseCode());
            operateCargoReqDto.setChangeInventory(new BigDecimal(itemDto.getItemNum()));
            operateCargoReqDto.setPreOrderItemId(itemDto.getId());
            return operateCargoReqDto;
        }).collect(Collectors.toList());
        reqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        ContactDto contactDto = new ContactDto();
        contactDto.setPhone(afterSaleOrderRespDto.getReturnRecipientPhone());
        contactDto.setContacts(afterSaleOrderRespDto.getReturnRecipient());
        contactDto.setReciveName(afterSaleOrderRespDto.getReturnRecipient());
        contactDto.setRecivePhone(afterSaleOrderRespDto.getReturnRecipientPhone());
        contactDto.setDetailAddress(afterSaleOrderRespDto.getReturnAddress());
        reqDto.setContactDto(contactDto);
        log.info("[\u9500\u552e\u9000\u786e\u8ba4]\u8bf7\u6c42\u5e93\u5b58\u4e2d\u5fc3\u9500\u552e\u9000\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        RestResponseHelper.checkOrThrow((RestResponse)this.logicInventoryExposedApi.orderSalesRefundConfirm(reqDto));
        return RestResponse.SUCCEED;
    }

    @Override
    public RestResponse<String> send2wms(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_send2wms afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        return this.send2wms(afterSaleOrderRespDto, null);
    }

    @Override
    public RestResponse<Boolean> send2wmsVirtualWarehouse(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgShippingInfoReqDto shippingInfo) {
        log.info("{}_send2wmsVirtualWarehouse afterSaleOrderNo: {}, shippingInfo: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), JacksonUtil.toJson((Object)shippingInfo)});
        log.info("{}_send2wmsVirtualWarehouse respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        if (shippingInfo != null) {
            afterSaleOrderRespDto.setReturnShippingSn(shippingInfo.getShippingOrderNo());
            afterSaleOrderRespDto.setShippingCode(shippingInfo.getShippingCompanyCode());
            afterSaleOrderRespDto.setShippingName(shippingInfo.getShippingCompanyName());
        }
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        log.info("{}_send2wmsVirtualWarehouse itemRespDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemRespDtoList));
        InOutOrderGenerateReqDto reqDto = this.convert(afterSaleOrderRespDto, itemRespDtoList);
        log.info("{}_send2wmsVirtualWarehouse reqDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)reqDto));
        GenerateInNoticeOrderRespDto response = (GenerateInNoticeOrderRespDto)RestResponseHelper.extractData((RestResponse)this.inOutNoticeOrderApi.generateInNoticeOrderReturnDto(reqDto));
        log.info("{}_send2wmsVirtualWarehouse response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)response));
        if (Objects.nonNull(response)) {
            DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
            modifyReqDto.setInputWarehouseOrderNo(response.getInNoticeOrderNo());
            modifyReqDto.setId(afterSaleOrderRespDto.getId());
            modifyReqDto.setReturnShippingSn(afterSaleOrderRespDto.getReturnShippingSn());
            modifyReqDto.setShippingCode(afterSaleOrderRespDto.getShippingCode());
            modifyReqDto.setShippingName(afterSaleOrderRespDto.getShippingName());
            this.dgAfterSaleOrderService.modifyAfterSaleOrder(modifyReqDto);
            return new RestResponse((Object)response.getSinceTheClosedLoop());
        }
        log.warn("\u4e0b\u53d1\u5230WMS\u5931\u6557: {}", (Object)JacksonUtil.toJson((Object)response));
        throw new BizException("\u4e0b\u53d1\u5230WMS\u5931\u6557: {}", JacksonUtil.toJson((Object)response));
    }

    @Override
    public RestResponse<String> send2wms(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgShippingInfoReqDto shippingInfo) {
        log.info("{}_send2wms afterSaleOrderNo: {}, shippingInfo: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), JacksonUtil.toJson((Object)shippingInfo)});
        log.info("{}_send2wms respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        if (shippingInfo != null) {
            afterSaleOrderRespDto.setReturnShippingSn(shippingInfo.getShippingOrderNo());
            afterSaleOrderRespDto.setShippingCode(shippingInfo.getShippingCompanyCode());
            afterSaleOrderRespDto.setShippingName(shippingInfo.getShippingCompanyName());
        }
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        log.info("{}_send2wms itemRespDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemRespDtoList));
        InOutOrderGenerateReqDto reqDto = this.convert(afterSaleOrderRespDto, itemRespDtoList);
        log.info("{}_send2wms reqDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)reqDto));
        RestResponse response = this.inOutNoticeOrderApi.generateInNoticeOrder(reqDto);
        log.info("{}_send2wms response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)response));
        if ("0".equals(response.getResultCode())) {
            DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
            modifyReqDto.setInputWarehouseOrderNo((String)response.getData());
            modifyReqDto.setId(afterSaleOrderRespDto.getId());
            modifyReqDto.setReturnShippingSn(afterSaleOrderRespDto.getReturnShippingSn());
            modifyReqDto.setShippingCode(afterSaleOrderRespDto.getShippingCode());
            modifyReqDto.setShippingName(afterSaleOrderRespDto.getShippingName());
            this.dgAfterSaleOrderService.modifyAfterSaleOrder(modifyReqDto);
            return RestResponse.SUCCEED;
        }
        log.warn("\u4e0b\u53d1\u5230WMS\u5931\u6557: {}", (Object)JacksonUtil.toJson((Object)response));
        throw new BizException(response.getResultMsg());
    }

    @Override
    public RestResponse<Void> send2wmsOutReturn(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgShippingInfoReqDto shippingInfo) {
        log.info("{}_send2wmsOutReturn afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        log.info("{}_send2wmsOutReturn respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        if (shippingInfo != null) {
            afterSaleOrderRespDto.setReturnShippingSn(shippingInfo.getShippingOrderNo());
            afterSaleOrderRespDto.setShippingCode(shippingInfo.getShippingCompanyCode());
            afterSaleOrderRespDto.setShippingName(shippingInfo.getShippingCompanyName());
        }
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        log.info("{}_send2wmsOutReturn itemRespDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemRespDtoList));
        List detailReqDtoList = itemRespDtoList.stream().map(itemRespDto -> {
            CsInventoryOperateCargoReqDto detailReqDto = new CsInventoryOperateCargoReqDto();
            detailReqDto.setWarehouseCode(afterSaleOrderRespDto.getReturnWarehouseCode());
            detailReqDto.setLongCode(itemRespDto.getSkuCode());
            detailReqDto.setChangeInventory(itemRespDto.getItemNum() == null ? BigDecimal.ZERO : BigDecimal.valueOf(itemRespDto.getItemNum().intValue()));
            return detailReqDto;
        }).collect(Collectors.toList());
        CsInventoryOperateReqDto reqDto = new CsInventoryOperateReqDto();
        reqDto.setOperateCargoReqDtoList(detailReqDtoList);
        reqDto.setShipmentEnterpriseCode(afterSaleOrderRespDto.getShippingCode());
        reqDto.setShipmentEnterpriseName(afterSaleOrderRespDto.getShippingName());
        reqDto.setSourceNo(afterSaleOrderRespDto.getAfterSaleOrderNo());
        reqDto.setBasicDataBusinessType(afterSaleOrderRespDto.getBizType());
        reqDto.setPlatformOrderNo(afterSaleOrderRespDto.getPlatformRefundOrderSn());
        log.info("{}_send2wmsOutReturn reqDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)reqDto));
        RestResponse response = this.inventoryExposedApi.addInventoryOrder(reqDto);
        log.info("{}_send2wmsOutReturn response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)response));
        if (!"0".equals(response.getResultCode())) {
            log.warn("\u4e0b\u53d1\u5230WMS\u5931\u6557(\u5165\u5e93\u7ed3\u679c\u5355): {}", (Object)JacksonUtil.toJson((Object)response));
            throw new BizException(response.getResultMsg());
        }
        DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
        modifyReqDto.setInputWarehouseResultOrderNo(((CsAddInventoryOrderRespDto)response.getData()).getInResultResultOrderNo());
        modifyReqDto.setId(afterSaleOrderRespDto.getId());
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(modifyReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> cancelFromWms(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_cancelFromWms afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        log.info("{}_cancelFromWms respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        if (!StringUtils.equalsIgnoreCase((CharSequence)afterSaleOrderRespDto.getStatus(), (CharSequence)DgAfterSaleOrderStatusEnum.WAIT_CHECK_GOODS.getCode())) {
            log.warn("\u53ea\u6709\u5f85\u9a8c\u8d27\u72b6\u6001\u7684\u552e\u540e\u5355\u53ef\u4ee5\u4eceWMS\u64a4\u56de: {}", (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
            throw new BizException("\u53ea\u6709\u5f85\u9a8c\u8d27\u72b6\u6001\u7684\u552e\u540e\u5355\u53ef\u4ee5\u4eceWMS\u64a4\u56de");
        }
        RestResponse<Boolean> response = this.cancelFromWmsApi(afterSaleOrderRespDto);
        log.info("{}_cancelFromWms response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(response));
        if ("0".equals(response.getResultCode()) && ((Boolean)response.getData()).booleanValue()) {
            return RestResponse.VOID;
        }
        log.warn("WMS\u64a4\u56de\u5931\u6557: {}", (Object)JacksonUtil.toJson(response));
        throw new BizException(response.getResultMsg());
    }

    @Override
    public RestResponse<String> confirm(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        log.info("{}_confirm afterSaleOrderNo: {}", (Object)log_prefix, (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
        log.info("{}_confirm respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        List<DgAfterSaleOrderItemRespDto> itemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(afterSaleOrderRespDto.getAfterSaleOrderNo(), "0");
        log.info("{}_confirm itemRespDtoList: {}", (Object)log_prefix, (Object)JacksonUtil.toJson(itemRespDtoList));
        InOutOrderGenerateReqDto reqDto = this.convert(afterSaleOrderRespDto, itemRespDtoList);
        log.info("{}_confirm reqDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)reqDto));
        RestResponse response = this.inOutNoticeOrderApi.generateInNoticeOrder(reqDto);
        log.info("{}_confirm response: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)response));
        if ("0".equals(response.getResultCode())) {
            DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
            modifyReqDto.setInputWarehouseResultOrderNo((String)response.getData());
            modifyReqDto.setId(afterSaleOrderRespDto.getId());
            modifyReqDto.setLastChanged(new Date());
            this.dgAfterSaleOrderService.modifyAfterSaleOrder(modifyReqDto);
            return RestResponse.SUCCEED;
        }
        log.warn("\u9a8c\u8d27\u5931\u8d25: {}", (Object)JacksonUtil.toJson((Object)response));
        throw new BizException(response.getResultMsg());
    }

    @Override
    public RestResponse<Void> cancel(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderRefundStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderRefundStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}_updateAfterSaleOrderRefundStatus afterSaleOrderNo: {}, afterSaleOrderRefundStatus: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), afterSaleOrderRefundStatus});
        log.info("{}_updateAfterSaleOrderRefundStatus respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setRefundStatus(afterSaleOrderRefundStatus);
        afterSaleOrderReqDto.setLastChanged(afterSaleOrderRespDto.getLastChanged());
        if (StringUtils.equalsIgnoreCase((CharSequence)afterSaleOrderRefundStatus, (CharSequence)DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode()) && StringUtils.isEmpty((CharSequence)afterSaleOrderReqDto.getRefundStatus())) {
            afterSaleOrderReqDto.setLastChanged(new Date());
        }
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderAbolishFlag(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderAbolishFlag) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}_updateAfterSaleOrderAbolishFlag afterSaleOrderNo: {}, afterSaleOrderAbolishFlag: {}", new Object[]{log_prefix, afterSaleOrderRespDto.getAfterSaleOrderNo(), afterSaleOrderAbolishFlag});
        log.info("{}_updateAfterSaleOrderAbolishFlag respDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setAbolishFlag(afterSaleOrderAbolishFlag);
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderDeliveryStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String afterSaleOrderDeliveryStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderDeliveryStatus afterSaleOrderRespDto: {}, afterSaleOrderDeliveryStatus: {}", new Object[]{log_prefix, JacksonUtil.toJson((Object)afterSaleOrderRespDto), afterSaleOrderDeliveryStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setDeliveryStatus(afterSaleOrderDeliveryStatus);
        afterSaleOrderReqDto.setLastChanged(new Date());
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderLastPlatformSyncStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, String lastPlatformSyncStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderLastPlatformSyncStatus afterSaleOrderRespDto: {}, lastPlatformSyncStatus: {}", new Object[]{log_prefix, JacksonUtil.toJson((Object)afterSaleOrderRespDto), lastPlatformSyncStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setLastPlatformRefundSyncStatus(lastPlatformSyncStatus);
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderInWarehouseDate(Long afterSaleId) {
        AssertUtils.notNull((Object)afterSaleId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderInWarehouseDate afterSaleId: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleId));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleId);
        afterSaleOrderReqDto.setInWarehouseDate(new Date());
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderCompleteDate(Long afterSaleId) {
        AssertUtils.notNull((Object)afterSaleId, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderCompleteDate afterSaleId: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleId));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleId);
        afterSaleOrderReqDto.setCompleteDate(new Date());
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderCancelStatus(DgAfterSaleOrderRespDto afterSaleOrderRespDto, Integer cancelStatus) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderCancelStatus afterSaleOrderRespDto: {}, cancelStatus: {}", new Object[]{log_prefix, JacksonUtil.toJson((Object)afterSaleOrderRespDto), cancelStatus});
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setCancelStatus(cancelStatus);
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateAfterSaleOrderExchangeShippingInfo(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("{}updateAfterSaleOrderCancelStatus afterSaleOrderRespDto: {}", (Object)log_prefix, (Object)JacksonUtil.toJson((Object)afterSaleOrderRespDto));
        DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
        afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
        afterSaleOrderReqDto.setExchangeExpressCode(afterSaleOrderRespDto.getExchangeExpressCode());
        afterSaleOrderReqDto.setExchangeExpressCompanyCode(afterSaleOrderRespDto.getExchangeExpressCompanyCode());
        afterSaleOrderReqDto.setExchangeExpressCompanyName(afterSaleOrderRespDto.getExchangeExpressCompanyName());
        afterSaleOrderReqDto.setExchangeSaleOrderId(afterSaleOrderRespDto.getExchangeSaleOrderId());
        afterSaleOrderReqDto.setExchangeSaleOrderNo(afterSaleOrderRespDto.getExchangeSaleOrderNo());
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(afterSaleOrderReqDto);
        return RestResponse.VOID;
    }

    private InOutOrderGenerateReqDto convert(DgAfterSaleOrderRespDto respDto, List<DgAfterSaleOrderItemRespDto> itemRespDtoList) {
        List detailReqDtoList = itemRespDtoList.stream().map(itemRespDto -> {
            InOutOrderGenerateDetailReqDto detailReqDto = new InOutOrderGenerateDetailReqDto();
            detailReqDto.setItemPrice(itemRespDto.getItemPrice());
            detailReqDto.setSkuCode(itemRespDto.getSkuCode());
            detailReqDto.setQuantity(itemRespDto.getItemNum() == null ? BigDecimal.ZERO : BigDecimal.valueOf(itemRespDto.getItemNum().intValue()));
            detailReqDto.setSkuName(itemRespDto.getSkuName());
            detailReqDto.setTradeOrderItemId(itemRespDto.getId());
            detailReqDto.setTotalRefundAmount(itemRespDto.getRefundAmount());
            return detailReqDto;
        }).collect(Collectors.toList());
        InOutOrderGenerateReqDto reqDto = new InOutOrderGenerateReqDto();
        reqDto.setDetailReqDtoList(detailReqDtoList);
        reqDto.setLogicWarehouseCode(respDto.getReturnWarehouseCode());
        reqDto.setOrderNo(respDto.getAfterSaleOrderNo());
        reqDto.setPlatformOrderNo(respDto.getPlatformRefundOrderSn());
        reqDto.setShippingCode(respDto.getReturnShippingSn());
        reqDto.setShipmentEnterpriseCode(respDto.getShippingCode());
        reqDto.setShipmentEnterpriseName(respDto.getShippingName());
        reqDto.setBasicDataBusinessType(respDto.getBizType());
        reqDto.setShopCode(respDto.getShopCode());
        reqDto.setShopName(respDto.getShopName());
        return reqDto;
    }

    private RestResponse<Boolean> cancelFromWmsApi(DgAfterSaleOrderRespDto respDto) {
        CsInOutOrderTriggerReqDto triggerReqDto = new CsInOutOrderTriggerReqDto();
        triggerReqDto.setOrderNo(respDto.getAfterSaleOrderNo());
        triggerReqDto.setDocumentNo(respDto.getInputWarehouseOrderNo());
        triggerReqDto.setTriggerType("cancel");
        triggerReqDto.setDocumentType("in");
        return this.csInOutOrderExtApi.triggerInOutOrder(triggerReqDto);
    }

    @Override
    public RestResponse<Void> updateSaleOrderItemStatusByAfterSaleOrderItem(Long afterSaleId, String refundStatus, List<String> statusSet) {
        AssertUtils.notNull((Object)afterSaleId, (String)"afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderService.queryById(afterSaleId);
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        DgSaleOrderItemRefundStatusEnum saleOrderItemRefundStatusEnum = DgSaleOrderItemRefundStatusEnum.forCode((String)refundStatus);
        List<DgAfterSaleOrderItemRespDto> orderItemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSaleOrderId(afterSaleOrderRespDto.getId());
        AssertUtils.notEmpty(orderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5546\u54c1\u4fe1\u606f");
        DgPerformOrderRespDto saleOrderRespDto = this.dgPerformOrderService.querySaleOrderById(afterSaleOrderRespDto.getSaleOrderId());
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        DgBizPerformOrderItemReqDto bizSaleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
        bizSaleOrderItemReqDto.setRefundStatus(saleOrderItemRefundStatusEnum.getCode());
        bizSaleOrderItemReqDto.setQueryUpdateRefundStatusList(statusSet);
        bizSaleOrderItemReqDto.setQueryUpdateStatusList(Collections.singletonList(DgSaleOrderItemStatusEnum.NORMAL.getCode()));
        bizSaleOrderItemReqDto.setUpdateOrderItemList(new ArrayList());
        orderItemRespDtoList.stream().filter(dto -> dto.getAfterSaleOrderItemType().equals(0)).forEach(dto -> {
            DgBizPerformOrderItemReqDto saleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
            saleOrderItemReqDto.setId(dto.getSaleOrderItemId());
            saleOrderItemReqDto.setItemNum(new BigDecimal(dto.getItemNum()));
            bizSaleOrderItemReqDto.getUpdateOrderItemList().add(saleOrderItemReqDto);
        });
        return this.performOrderOptAction.changeSaleOrderItemRefundStatus(saleOrderRespDto, bizSaleOrderItemReqDto);
    }

    @Override
    public RestResponse<Void> updateRefundInterceptStatus2SuccessByOrderItem(Long saleOrder, String refundInterceptStatus) {
        DgPerformOrderRespDto saleOrderRespDto = this.dgPerformOrderService.querySaleOrderById(saleOrder);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(saleOrder);
        AssertUtils.notNull((Object)saleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        DgBizPerformOrderItemReqDto bizSaleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
        bizSaleOrderItemReqDto.setUpdateOrderItemList(new ArrayList());
        DgSaleOrderItemRefundInterceptStatusEnum saleOrderItemRefundInterceptStatusEnum = DgSaleOrderItemRefundInterceptStatusEnum.forCode((String)refundInterceptStatus);
        saleOrderItemRespDtoList.forEach(dto -> {
            DgBizPerformOrderItemReqDto saleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
            saleOrderItemReqDto.setId(dto.getId());
            saleOrderItemReqDto.setItemNum(dto.getItemNum());
            saleOrderItemReqDto.setRefundInterceptStatus(saleOrderItemRefundInterceptStatusEnum.getCode());
            boolean refunded = dto.getRefundStatus().equals(DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode());
            if (refunded && DgSaleOrderItemRefundInterceptStatusEnum.SUCCESS.equals((Object)saleOrderItemRefundInterceptStatusEnum)) {
                saleOrderItemReqDto.setStatus(DgSaleOrderItemStatusEnum.CANCEL.getCode());
                saleOrderItemReqDto.setQueryUpdateStatusList(Arrays.asList(DgSaleOrderItemStatusEnum.NORMAL.getCode()));
                bizSaleOrderItemReqDto.getUpdateOrderItemList().add(saleOrderItemReqDto);
            }
        });
        if (bizSaleOrderItemReqDto.getUpdateOrderItemList().isEmpty()) {
            log.info("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5546\u54c1\u884c\u4fe1\u606f");
            return RestResponse.VOID;
        }
        return this.performOrderOptAction.changeSaleOrderItemRefundInterceptStatus(saleOrderRespDto, bizSaleOrderItemReqDto);
    }

    @Override
    public RestResponse<Void> subSaleOrderItemNumAndAmount(Long afterSaleId, int calcType) {
        Consumer<DgAfterSaleOrderItemRespDto> consumer;
        AssertUtils.notNull((Object)afterSaleId, (String)"afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderService.queryById(afterSaleId);
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSaleOrderId(afterSaleOrderRespDto.getId());
        AssertUtils.notEmpty(afterSaleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5546\u54c1\u4fe1\u606f");
        switch (calcType) {
            case 1: {
                consumer = this.calculateNumConsumer;
                break;
            }
            case 2: {
                consumer = this.calculateAmountConsumer;
                break;
            }
            default: {
                consumer = this.calculateNumAndAmountConsumer;
            }
        }
        afterSaleOrderItemRespDtoList.stream().filter(dto -> dto.getAfterSaleOrderItemType().equals(0)).forEach(consumer);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> subSaleOrderItemInvoiceNumAndAmount(Long afterSaleId, int calcType, DgAfterSaleOrderStatusEnum afterSaleOrderStatus) {
        AssertUtils.notNull((Object)afterSaleId, (String)"afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgAfterSaleOrderService.queryById(afterSaleId);
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto = new DgBizAfterSaleOrderReqDto();
        bizAfterSaleOrderReqDto.setSaleOrderNo(afterSaleOrderRespDto.getSaleOrderNo());
        bizAfterSaleOrderReqDto.setStatus(afterSaleOrderStatus.getCode());
        List<DgAfterSaleOrderRespDto> afterSaleOrderRespDtoList = this.dgAfterSaleOrderService.queryByBizAfterSaleOrderReqDto(bizAfterSaleOrderReqDto);
        AssertUtils.notEmpty(afterSaleOrderRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        List idList = afterSaleOrderRespDtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
        DgBizAfterSaleOrderItemReqDto bizAfterSaleOrderItemReqDto = new DgBizAfterSaleOrderItemReqDto();
        bizAfterSaleOrderItemReqDto.setAfterSaleOrderIds(idList);
        bizAfterSaleOrderItemReqDto.setAfterSaleOrderItemType(Integer.valueOf(0));
        List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList = this.dgAfterSaleOrderItemService.queryByAfterSale(bizAfterSaleOrderItemReqDto);
        AssertUtils.notEmpty(afterSaleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5546\u54c1\u4fe1\u606f");
        Map<Long, List<DgAfterSaleOrderItemRespDto>> afterSaleOrderItemMaps = afterSaleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgAfterSaleOrderItemDto::getSaleOrderItemId));
        log.info("\u5546\u54c1\u884c\u5f00\u7968\u8ba1\u7b97\u76f8\u5173\u552e\u540e\u5355:{}", (Object)JSON.toJSONString(afterSaleOrderItemMaps));
        afterSaleOrderItemMaps.entrySet().stream().forEach(e -> {
            DgPerformOrderItemExtensionEo updateEo = new DgPerformOrderItemExtensionEo();
            if (calcType == 1) {
                Integer itemNum = ((List)e.getValue()).stream().map(DgAfterSaleOrderItemDto::getItemNum).reduce(Integer::sum).orElse(0);
                if (itemNum != null && itemNum > 0) {
                    updateEo.setInvoiceRefundedItemNum(new BigDecimal(itemNum));
                }
                updateEo.setInvoiceRefundedPayAmount(BigDecimal.ZERO);
            } else if (calcType == 2) {
                BigDecimal refundAmount = ((List)e.getValue()).stream().map(DgAfterSaleOrderItemDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (refundAmount != null && refundAmount.compareTo(BigDecimal.ZERO) > 0) {
                    updateEo.setInvoiceRefundedPayAmount(refundAmount);
                }
                updateEo.setInvoiceRefundedItemNum(BigDecimal.ZERO);
            } else if (calcType == 3) {
                BigDecimal refundAmount;
                updateEo.setInvoiceRefundedPayAmount(BigDecimal.ZERO);
                updateEo.setInvoiceRefundedItemNum(BigDecimal.ZERO);
                Integer itemNum = ((List)e.getValue()).stream().map(DgAfterSaleOrderItemDto::getItemNum).reduce(Integer::sum).orElse(0);
                if (itemNum != null && itemNum > 0) {
                    updateEo.setInvoiceRefundedItemNum(new BigDecimal(itemNum));
                }
                if ((refundAmount = ((List)e.getValue()).stream().map(DgAfterSaleOrderItemDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add)) != null && refundAmount.compareTo(BigDecimal.ZERO) > 0) {
                    updateEo.setInvoiceRefundedPayAmount(refundAmount);
                }
            }
            log.info("\u5546\u54c1\u884c\u5f00\u7968\u76f8\u5173\u91d1\u989d\u6216\u6570\u91cf-orderId:{},orderItemId:{},updateEo:{}", new Object[]{((DgAfterSaleOrderItemRespDto)((List)e.getValue()).get(0)).getSaleOrderId(), e.getKey(), JSON.toJSONString((Object)updateEo)});
            this.saleOrderAndItemAmountChangeService.changeSaleOrderItemInvoice(((DgAfterSaleOrderItemRespDto)((List)e.getValue()).get(0)).getSaleOrderId(), (Long)e.getKey(), updateEo);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualAddTag(DgAfterSaleOrderRespDto respDto, List<DgAfterSaleOrderTagRecordReqDto> tagList) {
        tagList.forEach(tag -> this.manualAddTag(respDto, (DgAfterSaleOrderTagRecordReqDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualAddTag(DgAfterSaleOrderRespDto respDto, DgAfterSaleOrderTagRecordReqDto request) {
        request.setOrderId(respDto.getId());
        List<DgAfterSaleOrderTagRecordRespDto> tagRespDtos = this.afterSaleOrderTagRecordService.queryByParam(request);
        if (CollectionUtils.isNotEmpty(tagRespDtos)) {
            log.info("\u8ba2\u5355:{}\u5df2\u5b58\u5728\u6807\u8bc6:{}", (Object)respDto.getId(), (Object)request.getTagCode());
            return RestResponse.VOID;
        }
        this.afterSaleOrderTagRecordService.addAfterSaleOrderTagRecord(request);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveTag(DgAfterSaleOrderRespDto respDto, List<DgAfterSaleOrderTagRecordReqDto> tagList) {
        tagList.forEach(tag -> this.manualRemoveTag(respDto, (DgAfterSaleOrderTagRecordReqDto)tag));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualRemoveTag(DgAfterSaleOrderRespDto respDto, DgAfterSaleOrderTagRecordReqDto request) {
        DgAfterSaleOrderTagRecordReqDto orderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(respDto.getId());
        orderTagRecordReqDto.setTagCode(request.getTagCode());
        List<DgAfterSaleOrderTagRecordRespDto> tagRespDtos = this.afterSaleOrderTagRecordService.queryByParam(orderTagRecordReqDto);
        if (CollectionUtils.isEmpty(tagRespDtos)) {
            log.info("\u8ba2\u5355:{}\u4e0d\u5b58\u5728\u6807\u8bc6:{}", (Object)respDto.getId(), (Object)request.getTagCode());
            return RestResponse.VOID;
        }
        tagRespDtos.forEach(tag -> this.afterSaleOrderTagRecordService.removeAfterSaleOrderTagRecord(tag.getId()));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualBatchAddTag(String bizModel, DgAfterSaleOrderBatchReqDto batchReqDto) {
        List addrReqDtos = batchReqDto.getTagCodes().stream().map(code -> {
            DgAfterSaleOrderTagRecordReqDto afterSaleOrderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
            afterSaleOrderTagRecordReqDto.setTagCode(code);
            return afterSaleOrderTagRecordReqDto;
        }).collect(Collectors.toList());
        batchReqDto.getAfterSaleOrderIds().forEach(id -> {
            addrReqDtos.forEach(dto -> dto.setOrderId(Long.valueOf(id)));
            DgAfterSaleOrderRespDto respDto = new DgAfterSaleOrderRespDto();
            respDto.setId(id);
            this.manualAddTag(respDto, addrReqDtos);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> manualBatchRemoveTag(String bizModel, DgAfterSaleOrderBatchReqDto batchReqDto) {
        List removeReqDtos = batchReqDto.getTagCodes().stream().map(code -> {
            DgAfterSaleOrderTagRecordReqDto afterSaleOrderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
            afterSaleOrderTagRecordReqDto.setTagCode(code);
            return afterSaleOrderTagRecordReqDto;
        }).collect(Collectors.toList());
        batchReqDto.getAfterSaleOrderIds().forEach(id -> {
            removeReqDtos.forEach(dto -> dto.setOrderId(Long.valueOf(id)));
            DgAfterSaleOrderRespDto respDto = new DgAfterSaleOrderRespDto();
            respDto.setId(id);
            this.manualRemoveTag(respDto, removeReqDtos);
        });
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> convertToJTK(DgAfterSaleOrderRespDto respDto) {
        DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto = this.afterSaleOrderDomain.queryById(respDto.getId());
        AssertUtils.notNull((Object)dgAfterSaleOrderRespDto, (String)"\u552e\u540e\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        dgAfterSaleOrderRespDto.setStatus(DgAfterSaleOrderStatusEnum.ABOLISH.getCode());
        this.updateAfterSaleOrderLastPlatformSyncStatus(dgAfterSaleOrderRespDto, dgAfterSaleOrderRespDto.getLastPlatformRefundSyncStatus());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyShipping(Long afterSaleId, DgBizAfterSaleOrderReqDto request) {
        log.info("\u66f4\u65b0\u552e\u540e\u5355\u9000\u8d27\u7269\u6d41-afterSaleId:{},request{}", (Object)afterSaleId, (Object)JSON.toJSONString((Object)request));
        DgAfterSaleOrderReqDto modifyReqDto = new DgAfterSaleOrderReqDto();
        modifyReqDto.setId(afterSaleId);
        modifyReqDto.setShippingCode(request.getShippingCode());
        modifyReqDto.setReturnShippingSn(request.getReturnShippingSn());
        modifyReqDto.setShippingName(request.getShippingName());
        this.dgAfterSaleOrderService.modifyAfterSaleOrder(modifyReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateRefundInterceptStatusByAfterSaleOrderItem(Long afterSaleId, String refundInterceptStatus) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)afterSaleId, (String)"afterSaleId\u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.afterSaleOrderDomain.queryById(afterSaleId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u4fe1\u606f");
        List orderItemRespDtoList = this.afterSaleOrderItemDomain.queryByAfterSaleOrderId(afterSaleOrderRespDto.getId());
        com.yunxi.dg.base.commons.utils.AssertUtils.notEmpty((Collection)orderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u552e\u540e\u5546\u54c1\u4fe1\u606f");
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(afterSaleOrderRespDto.getSaleOrderId());
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(afterSaleOrderRespDto.getSaleOrderId());
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        Map saleOrderItemRespDtoMap = saleOrderItemRespDtoList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        DgBizPerformOrderItemReqDto bizSaleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
        bizSaleOrderItemReqDto.setUpdateOrderItemList(new ArrayList());
        DgSaleOrderItemRefundInterceptStatusEnum dgSaleOrderItemRefundInterceptStatusEnum = DgSaleOrderItemRefundInterceptStatusEnum.forCode((String)refundInterceptStatus);
        boolean isCancel = this.isJTKCancel(afterSaleOrderRespDto, dgSaleOrderItemRefundInterceptStatusEnum);
        log.info("{}\u662f\u5426\u9700\u8981\u53d6\u6d88\u5546\u54c1\u884c:{},saleOrderItemRefundInterceptStatusEnum={}", new Object[]{afterSaleOrderRespDto.getSaleOrderId(), isCancel, dgSaleOrderItemRefundInterceptStatusEnum});
        orderItemRespDtoList.stream().filter(dto -> dto.getAfterSaleOrderItemType().equals(0)).forEach(dto -> {
            DgBizPerformOrderItemReqDto saleOrderItemReqDto = new DgBizPerformOrderItemReqDto();
            saleOrderItemReqDto.setId(dto.getSaleOrderItemId());
            saleOrderItemReqDto.setItemNum(new BigDecimal(dto.getItemNum()));
            saleOrderItemReqDto.setRefundInterceptStatus(dgSaleOrderItemRefundInterceptStatusEnum.getCode());
            DgPerformOrderItemRespDto saleOrderItemRespDto = (DgPerformOrderItemRespDto)saleOrderItemRespDtoMap.get(dto.getSaleOrderItemId());
            boolean refunded = saleOrderItemRespDto.getRefundStatus().equals(DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode());
            if (refunded && isCancel) {
                saleOrderItemReqDto.setStatus(DgSaleOrderItemStatusEnum.CANCEL.getCode());
                saleOrderItemReqDto.setQueryUpdateStatusList(Arrays.asList(DgSaleOrderItemStatusEnum.NORMAL.getCode()));
            }
            if (DgSaleOrderItemStatusEnum.NORMAL.getCode().equals(saleOrderItemRespDto.getStatus())) {
                bizSaleOrderItemReqDto.getUpdateOrderItemList().add(saleOrderItemReqDto);
            }
        });
        if (bizSaleOrderItemReqDto.getUpdateOrderItemList().isEmpty()) {
            log.info("\u6ca1\u6709\u9700\u8981\u66f4\u65b0\u7684\u5546\u54c1\u884c\u4fe1\u606f");
            return RestResponse.VOID;
        }
        return this.performOrderOptAction.changeSaleOrderItemRefundInterceptStatus(saleOrderRespDto, bizSaleOrderItemReqDto);
    }

    @Override
    public RestResponse<Void> reCalculateSaleOrderNumAndAmount(Long saleOrderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(saleOrderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(saleOrderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notEmpty((Collection)saleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        DgPerformOrderReqDto saleOrderReqDto = new DgPerformOrderReqDto();
        saleOrderReqDto.setGoodsTotalNum(BigDecimal.ZERO);
        saleOrderReqDto.setMerchantReceivableAmount(BigDecimal.ZERO);
        saleOrderReqDto.setGoodsTotalAmount(BigDecimal.ZERO);
        saleOrderReqDto.setDiscountAmount(BigDecimal.ZERO);
        saleOrderReqDto.setPayAmount(BigDecimal.ZERO);
        saleOrderReqDto.setRealPayAmount(BigDecimal.ZERO);
        saleOrderItemRespDtoList.stream().filter(dto -> DgSaleOrderItemStatusEnum.NORMAL.getCode().equals(dto.getStatus())).forEach(dto -> {
            saleOrderReqDto.setGoodsTotalNum(saleOrderReqDto.getGoodsTotalNum().add(dto.getItemNum()));
            saleOrderReqDto.setDiscountAmount(saleOrderReqDto.getDiscountAmount().add(dto.getDiscountAmount()));
            saleOrderReqDto.setGoodsTotalAmount(saleOrderReqDto.getGoodsTotalAmount().add(dto.getSalePrice().multiply(dto.getItemNum())));
            saleOrderReqDto.setPayAmount(saleOrderReqDto.getPayAmount().add(dto.getPayAmount()));
            saleOrderReqDto.setRealPayAmount(saleOrderReqDto.getRealPayAmount().add(dto.getRealPayAmount()));
        });
        saleOrderReqDto.setMerchantReceivableAmount(saleOrderReqDto.getGoodsTotalAmount().add(saleOrderRespDto.getFreightCost()).subtract(saleOrderReqDto.getDiscountAmount()));
        if (!DgSaleOrderLevelEnum.CHILD.getType().equals(saleOrderRespDto.getOrderLevel())) {
            saleOrderReqDto.setMerchantOriginReceivableAmount(saleOrderReqDto.getMerchantReceivableAmount());
        }
        saleOrderReqDto.setId(saleOrderRespDto.getId());
        this.performOrderDomain.update(saleOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> relateSaleOrderItemInventory(Long saleOrderId) {
        Boolean relateResult;
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(saleOrderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(saleOrderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.notEmpty((Collection)saleOrderItemRespDtoList, (String)"\u83b7\u53d6\u4e0d\u5230\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        List<DgPerformOrderItemRespDto> relateSaleOrderItemInventoryList = saleOrderItemRespDtoList.stream().filter(dto -> DgSaleOrderItemStatusEnum.NORMAL.getCode().equals(dto.getStatus())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(relateSaleOrderItemInventoryList) && !(relateResult = this.inventoryApiServcie.preemptChannelInventoryForOrderItemChange(relateSaleOrderItemInventoryList, saleOrderRespDto)).booleanValue()) {
            throw new BizException("-1", "\u5e93\u5b58\u91ca\u653e/\u91cd\u65b0\u9884\u5360\u5931\u8d25");
        }
        return RestResponse.VOID;
    }

    private boolean isJTKCancel(DgAfterSaleOrderRespDto afterSaleOrderRespDto, DgSaleOrderItemRefundInterceptStatusEnum saleOrderItemRefundInterceptStatusEnum) {
        return AfterSaleOrderTypeEnum.JTK.getCode().equals(afterSaleOrderRespDto.getAfterSaleOrderType()) && DgSaleOrderItemRefundInterceptStatusEnum.SUCCESS.getCode().equals(saleOrderItemRefundInterceptStatusEnum.getCode());
    }
}

