/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.threads;

import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.threads.ObtainTaskPageFunction;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTaskHandleHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiTaskHandleHelper.class);

    public static <T> void handleTask(String moduleName, Integer pageSize, ObtainTaskPageFunction<T> obtainTaskPageFunction, Consumer<List<T>> taskFunc) {
        Integer pageNo = 1;
        PageInfo<T> pageInfo = obtainTaskPageFunction.getTasks(pageNo, pageSize);
        if (pageInfo.getTotal() == 0L) {
            LOGGER.info("[{}]\u6ca1\u6709\u67e5\u5230\u5c06\u8981\u6267\u884c\u4efb\u52a1", (Object)moduleName);
            return;
        }
        LOGGER.info("[{}]\u9700\u8981\u6267\u884c\u4efb\u52a1\u6709{}\u6761", (Object)moduleName, (Object)pageInfo.getTotal());
        if (pageInfo.getTotal() > (long)pageSize.intValue() && pageInfo.getTotal() > (long)pageSize.intValue() * 3L) {
            LOGGER.info("[{}]\u5f00\u542f\u591a\u7ebf\u7a0b\u6267\u884c\u4efb\u52a1", (Object)moduleName);
            MultiTaskHandleHelper.doMutiTask(pageInfo, obtainTaskPageFunction, taskFunc);
        } else {
            LOGGER.info("[{}]\u5355\u7ebf\u7a0b\u5faa\u73af\u6267\u884c({})\u4efb\u52a1", (Object)moduleName, (Object)pageInfo.getTotal());
            taskFunc.accept(pageInfo.getList());
        }
    }

    private static <T> void doMutiTask(PageInfo<T> pageInfo, ObtainTaskPageFunction<T> obtainTaskPageFunction, Consumer<List<T>> taskFunc) {
        taskFunc.accept(pageInfo.getList());
        for (int i = 1; i < pageInfo.getPages(); ++i) {
            int nextPage = i + 1;
            CompletableFuture.runAsync(() -> {
                PageInfo tasksPage = obtainTaskPageFunction.getTasks(nextPage, pageInfo.getPageSize());
                taskFunc.accept(tasksPage.getList());
            });
        }
    }
}

