/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.impl;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderItemDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderDas;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemExtensionEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.IDgSaleOrderAndItemAmountChangeService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderAndItemAmountChangeServiceImpl
implements IDgSaleOrderAndItemAmountChangeService {
    @Resource
    private IDgSaleOrderDas saleOrderDas;
    @Resource
    private IDgPerformOrderInfoDas performOrderInfoDas;
    @Resource
    private IDgPerformOrderItemDas performOrderItemDas;

    @Override
    public int changeSaleOrderItem(Long orderId, Long orderItemId, DgPerformOrderItemEo performOrderItemEo, DgPerformOrderItemEo queryEo) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderItemId, (String)"orderItemId\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkUpdateSaleOrderItemInfo(performOrderItemEo);
        int updateCount = this.performOrderItemDas.changeSaleOrderItem(orderItemId, performOrderItemEo);
        if (updateCount != 1) {
            throw new BizException("-1", orderId + "\u66f4\u65b0\u5546\u54c1\u884c\u4fe1\u606f\u5931\u8d25");
        }
        return updateCount;
    }

    private void checkUpdateSaleOrderItemInfo(DgPerformOrderItemEo performOrderItemEo) {
        if (Objects.isNull(performOrderItemEo.getItemNum()) && Objects.isNull(performOrderItemEo.getRefundedItemNum()) && Objects.isNull(performOrderItemEo.getRefundedPayAmount()) && Objects.isNull(performOrderItemEo.getSurplusCanRefundPayAmount())) {
            throw new BizException("-1", "\u5546\u54c1\u884c\u66f4\u65b0\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public int changeSaleOrder(Long orderId, DgSaleOrderEo saleOrderEo, DgSaleOrderEo queryEo) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkUpdateSaleOrderItemInfo(saleOrderEo);
        int updateCount = this.saleOrderDas.changeSaleOrder(orderId, saleOrderEo);
        if (updateCount != 1) {
            throw new BizException("-1", orderId + "\u66f4\u65b0\u8ba2\u5355\u4fe1\u606f\u5931\u8d25");
        }
        return updateCount;
    }

    @Override
    public int changeSaleOrderItemInvoice(Long orderId, Long orderItemId, DgPerformOrderItemExtensionEo performOrderItemEo) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)orderItemId, (String)"orderItemId\u4e0d\u80fd\u4e3a\u7a7a");
        int updateCount = this.performOrderItemDas.changeSaleOrderItemInvoice(orderItemId, performOrderItemEo);
        return updateCount;
    }

    private void checkUpdateSaleOrderItemInfo(DgSaleOrderEo saleOrderEo) {
        if (Objects.isNull(saleOrderEo.getGoodsTotalNum()) && Objects.isNull(saleOrderEo.getMerchantReceivableAmount())) {
            throw new BizException("-1", "\u8ba2\u5355\u66f4\u65b0\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

