/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.mark.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateCargoRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.InventoryOperateRespDto;
import com.yunxi.dg.base.center.source.dto.extend.OrderItemResultRespDto;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderItemTypeEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderErrorDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IOrderLabelExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderErrorReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.service.mark.IDgLabelManageService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgLabelManageServiceImpl
implements IDgLabelManageService {
    private static final Logger log = LoggerFactory.getLogger(DgLabelManageServiceImpl.class);
    @Resource
    private IDgPerformOrderExtDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemDomain;
    @Resource
    private IOrderLabelExtDomain labelExtDomain;
    @Resource
    private IDgOrderLabelItemDomain orderLabelItemDomain;
    @Resource
    private IDgPerformOrderErrorDomain performOrderErrorDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;

    @Override
    public void markSplitTag(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.labelExtDomain.markSplitTag(saleOrderId);
    }

    @Override
    public void markSplitTagForChildOrder(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.labelExtDomain.markSplitTagForChildOrder(saleOrderId);
    }

    @Override
    public void markTagForChildOrder(Long saleOrderId) {
        this.labelExtDomain.markTagForChildOrder(saleOrderId);
    }

    @Override
    public void markLabelByExtendsParentOrder(List<DgPerformOrderRespDto> childOrderList) {
        this.labelExtDomain.markLabelByExtendsParentOrder(childOrderList);
    }

    @Override
    public void markVirtualOrderLabel(Long orderId) {
        log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u865a\u62df\u8ba2\u5355\u6807\u8bc6", (Object)orderId);
        this.labelExtDomain.markVirtualOrderLabel(orderId);
    }

    @Override
    public void markOrderGiftByOrderId(DgPerformOrderRespDto respDto) {
        this.labelExtDomain.markOrderGiftByOrderId(respDto);
    }

    @Override
    public void markByOrderCreate(DgBizPerformOrderReqDto reqDto) {
        List performOrderItemRespDtos = this.performOrderItemDomain.queryOrderItemByOrderId(reqDto.getId());
        AssertUtils.notEmpty((Collection)performOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{reqDto.getId()});
        this.markGift(performOrderItemRespDtos);
        this.markCombination(performOrderItemRespDtos);
        this.markOrderSource((DgPerformOrderReqDto)reqDto);
        this.markOrderType((DgPerformOrderReqDto)reqDto);
    }

    private void markOrderSource(DgPerformOrderReqDto reqDto) {
        ArrayList orderSourceOfHandLabelList = Lists.newArrayList((Object[])new Integer[]{DgSaleOrderSourceEnum.CREATE.getType(), DgSaleOrderSourceEnum.IMPORT.getType()});
        if (orderSourceOfHandLabelList.contains(reqDto.getOrderSource())) {
            log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u624b\u5de5\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            this.orderLabelRecordDomain.addOrderLabelRecord(reqDto.getId(), DgOrderLabelEnum.SALE_ORDER_CREATE);
        }
    }

    private void markOrderAgent(DgBizPerformOrderReqDto reqDto) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        Optional.ofNullable(reqDto.getItemList()).ifPresent(list -> {});
        if (atomicBoolean.get()) {
            log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u4ee3\u9500\u6807\u8bc6", (Object)reqDto.getId());
            this.orderLabelRecordDomain.addOrderLabelRecord(reqDto.getId(), DgOrderLabelEnum.AGENT_SALE_ORDER);
        }
    }

    private void markOrderType(DgPerformOrderReqDto reqDto) {
        if (DgSaleOrderTypeEnum.PRE_SALE_ORDER.getType().equals(reqDto.getOrderType())) {
            log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u624b\u5de5\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            this.orderLabelRecordDomain.addOrderLabelRecord(reqDto.getId(), DgOrderLabelEnum.PRE_SALE_ORDER);
        }
    }

    @Override
    public void markOrderSourcePromotion(DgBizPerformOrderReqDto reqDto) {
        this.labelExtDomain.markOrderSourcePromotion(reqDto);
    }

    @Override
    public void removeLackByOrderId(Long saleOrderId) {
        List orderLabelItemRespDtos = Optional.ofNullable(this.orderLabelItemDomain.queryByOrderId(saleOrderId)).orElseGet(Collections::emptyList).stream().filter(orderLabelItemRespDto -> DgOrderLabelEnum.ITEM_LACK.getCode().equals(orderLabelItemRespDto.getLabelCode())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderLabelItemRespDtos)) {
            log.info("[\u79fb\u9664\u7f3a\u8d27\u6807]\u8ba2\u5355id={}\u79fb\u9664\u7f3a\u8d27\u6807\u8bc6", (Object)saleOrderId);
            List idList = orderLabelItemRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
            Collections.sort(idList);
            for (Long id : idList) {
                this.orderLabelItemDomain.removeOrderLabelItemById(id);
            }
        }
    }

    @Override
    public void markLackByOrderId(Long saleOrderId) {
        this.markLackTagForItems(saleOrderId, null);
    }

    @Override
    public void markLackBySourceResult(SourceOrderResultRespDto respDto) {
        if (SourceStatusEnum.SOURCE_FAIL.getCode().equals(respDto.getSgStatus())) {
            DgPerformOrderRespDto performOrderRespDto = this.performOrderInfoDomain.queryDtoByOrderNo(respDto.getLinkOrderNo());
            List orderItemResultRespDtoList = respDto.getOrderItemResultRespDtoList();
            if (CollectionUtils.isEmpty((Collection)orderItemResultRespDtoList)) {
                log.info("[\u5bfb\u6e90\u7ed3\u679c\u6253\u7f3a\u8d27\u6807]\u5bfb\u6e90\u5931\u8d25\uff0c\u6574\u4e2a\u8ba2\u5355\u7684\u5546\u54c1\u90fd\u6253\u7f3a\u8d27\u6807\uff0c\u8ba2\u5355no={}", (Object)respDto.getLinkOrderNo());
                this.markLackByOrderId(performOrderRespDto.getId());
            } else {
                List orderItemRespDtoList = this.performOrderItemDomain.queryNormalItemByOrderId(performOrderRespDto.getId());
                AssertUtils.notEmpty((Collection)orderItemRespDtoList, (String)"%s \u8ba2\u5355\u5546\u54c1\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[]{performOrderRespDto.getSaleOrderNo()});
                Map sourceOrderItemsMap = orderItemResultRespDtoList.stream().collect(Collectors.toMap(OrderItemResultRespDto::getLinkOrderItemId, Function.identity(), (v1, v2) -> v2));
                log.info("[\u5bfb\u6e90\u7ed3\u679c\u6253\u7f3a\u8d27\u6807]\u5bfb\u6e90\u7ed3\u679c\u7684\u5546\u54c1\u4e3a\uff1a{}", (Object)JSON.toJSONString(sourceOrderItemsMap));
                orderItemRespDtoList.forEach(saleOrderItemRespDto -> {
                    OrderItemResultRespDto orderItemResultRespDto = (OrderItemResultRespDto)sourceOrderItemsMap.get(saleOrderItemRespDto.getId());
                    if (Objects.isNull(orderItemResultRespDto)) {
                        this.orderLabelItemDomain.addOrderLabelItem(performOrderRespDto.getId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK);
                    } else if (saleOrderItemRespDto.getItemNum().compareTo(orderItemResultRespDto.getDeliveryItemNum()) > 0) {
                        log.info("[\u5bfb\u6e90\u7ed3\u679c\u6253\u7f3a\u8d27\u6807]\u5546\u54c1id\uff1a{}\u3001skucode={}\uff0c\u5546\u54c1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u53ef\u7528\u5e93\u5b58\u4e3a\uff1a{}", new Object[]{saleOrderItemRespDto.getId(), saleOrderItemRespDto.getSkuCode(), saleOrderItemRespDto.getItemNum(), orderItemResultRespDto.getDeliveryItemNum()});
                        this.orderLabelItemDomain.addOrderLabelItem(performOrderRespDto.getId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK);
                    } else {
                        this.orderLabelItemDomain.removeOrderLabelItemById(performOrderRespDto.getId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK);
                    }
                });
            }
        }
    }

    @Override
    public void markLackTagForItems(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryNormalItems(saleOrderId, skuCodeList);
        log.debug("[\u8ba2\u5355\u5546\u54c1\u7f3a\u8d27\u6253\u6807]\u9700\u8981\u6253\u7f3a\u8d27\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderItemRespDtoList));
        if (CollectionUtils.isNotEmpty((Collection)saleOrderItemRespDtoList)) {
            for (DgPerformOrderItemRespDto saleOrderItemRespDto : saleOrderItemRespDtoList) {
                this.orderLabelItemDomain.addOrderLabelItem(saleOrderId, saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK);
            }
        }
    }

    @Override
    public void markLackByPreemtResult(InventoryOperateRespDto request) {
        if (CollectionUtils.isNotEmpty((Collection)request.getFailList())) {
            DgPerformOrderRespDto performOrderRespDto = this.performOrderInfoDomain.queryDtoByOrderNo(request.getSourceNo());
            List skuCodeOfLackList = request.getFailList().stream().map(InventoryOperateCargoRespDto::getLongCode).distinct().collect(Collectors.toList());
            List saleOrderItemRespDtoList = this.performOrderItemDomain.queryNormalItemByOrderId(performOrderRespDto.getId());
            List<DgPerformOrderItemRespDto> saleOrderItemsOfEnought = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> !skuCodeOfLackList.contains(saleOrderItemRespDto.getSkuCode())).collect(Collectors.toList());
            saleOrderItemsOfEnought.forEach(saleOrderItemRespDto -> this.orderLabelItemDomain.removeOrderLabelItemById(saleOrderItemRespDto.getOrderId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK));
            List<DgPerformOrderItemRespDto> saleOrderItemRespDtos = saleOrderItemRespDtoList.stream().filter(saleOrderItemRespDto -> skuCodeOfLackList.contains(saleOrderItemRespDto.getSkuCode())).collect(Collectors.toList());
            log.info("[\u6253\u6807]\u9700\u8981\u6253\u7f3a\u8d27\u6807\u8bc6\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(saleOrderItemRespDtos));
            saleOrderItemRespDtos.forEach(saleOrderItemRespDto -> this.orderLabelItemDomain.addOrderLabelItem(saleOrderItemRespDto.getOrderId(), saleOrderItemRespDto.getId(), DgOrderLabelEnum.ITEM_LACK));
        }
    }

    @Override
    public void markRefundByOrderId(Long saleOrderId) {
        List saleOrderItemRespDtos = this.performOrderItemDomain.queryOrderItemByOrderId(saleOrderId);
        AssertUtils.notEmpty((Collection)saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{saleOrderId});
        this.markRefund(saleOrderItemRespDtos);
    }

    @Override
    public void removeRefundByOrderId(Long saleOrderId, List<DgAfterSaleOrderItemRespDto> afterSaleOrderItemRespDtoList) {
        log.debug("[\u8ba2\u5355\u5546\u54c1\u9000\u6b3e\u6253\u6807]\u9700\u8981\u79fb\u9664\u6253\u9000\u6b3e\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(afterSaleOrderItemRespDtoList));
        Optional.ofNullable(afterSaleOrderItemRespDtoList).ifPresent(orderRefundRespDtoList -> orderRefundRespDtoList.forEach(item -> this.orderLabelItemDomain.removeOrderLabelItemById(saleOrderId, item.getSaleOrderItemId(), DgOrderLabelEnum.REFUND_ITEM)));
    }

    private void markRefund(List<DgPerformOrderItemRespDto> saleOrderItemRespDtos) {
        List orderRefundRespDtos = saleOrderItemRespDtos.stream().filter(item -> DgSaleOrderItemRefundStatusEnum.REFUNDED.getCode().equals(item.getRefundStatus()) || DgSaleOrderItemRefundStatusEnum.REFUNDING.getCode().equals(item.getRefundStatus())).collect(Collectors.toList());
        log.debug("[\u8ba2\u5355\u5546\u54c1\u9000\u6b3e\u6253\u6807]\u9700\u8981\u6253\u9000\u6b3e\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderRefundRespDtos));
        Optional.ofNullable(orderRefundRespDtos).ifPresent(orderRefundRespDtoList -> orderRefundRespDtoList.forEach(item -> this.orderLabelItemDomain.addOrderLabelItem(item.getOrderId(), item.getId(), DgOrderLabelEnum.REFUND_ITEM)));
    }

    @Override
    public void markErrorByOrderId(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6253\u6807]\u8ba2\u5355={}\u6253\u552e\u540e\u8ba2\u5355\u6807\u8bc6", (Object)saleOrderId);
        this.orderLabelItemDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.AFTER_SALE_ORDER_ERROR);
        DgPerformOrderErrorReqDto performOrderErrorReqDto = new DgPerformOrderErrorReqDto();
        performOrderErrorReqDto.setOrderId(saleOrderId);
        performOrderErrorReqDto.setErrorReason("\u53d1\u8d27\u524d\u4ec5\u9000\u6b3e\u5b8c\u6210\uff0c\u62e6\u622a\u5931\u8d25");
        performOrderErrorReqDto.setErrorType("\u53d1\u8d27\u524d\u4ec5\u9000\u6b3e\u5f02\u5e38");
        this.performOrderErrorDomain.addSaleOrderError(performOrderErrorReqDto);
    }

    @Override
    public void markArrWarehouseLabelByOrderId(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6253\u6807]\u8ba2\u5355={}\u6253\u6307\u5b9a\u53d1\u8d27\u4ed3\u6807\u8bc6", (Object)saleOrderId);
        this.orderLabelRecordDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.ARRANGE_WAREHOUSE);
    }

    @Override
    public void markArrShipmentLabelByOrderId(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        log.info("[\u6253\u6807]\u8ba2\u5355={}\u6253\u6307\u5b9a\u7269\u6d41\u5546\u6807\u8bc6", (Object)saleOrderId);
        this.orderLabelRecordDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.ARRANGE_SHIPMENT);
    }

    @Override
    public void markLabelForOrderItems(DgPerformOrderRespDto dto) {
        List saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderId(dto.getId());
        this.markCombination(saleOrderItemRespDtoList);
        this.markGift(saleOrderItemRespDtoList);
    }

    @Override
    public void markGiftByOrderId(Long saleOrderId) {
        List saleOrderItemRespDtos = this.performOrderItemDomain.queryOrderItemByOrderId(saleOrderId);
        AssertUtils.notEmpty((Collection)saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{saleOrderId});
        this.markGift(saleOrderItemRespDtos);
    }

    private void markCombination(List<DgPerformOrderItemRespDto> saleOrderItemRespDtos) {
        List orderCombinationRespDtos = saleOrderItemRespDtos.stream().filter(item -> DgSaleOrderItemTypeEnum.COMBINATION.getType().equals(item.getType())).collect(Collectors.toList());
        log.debug("[\u8ba2\u5355\u5546\u54c1\u7ec4\u5408\u5546\u54c1\u6253\u6807]\u9700\u8981\u6253\u7ec4\u5408\u5546\u54c1\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderCombinationRespDtos));
        Optional.ofNullable(orderCombinationRespDtos).ifPresent(orderGiftRespDtoList -> orderGiftRespDtoList.forEach(item -> this.orderLabelItemDomain.addOrderLabelItem(item.getOrderId(), item.getId(), DgOrderLabelEnum.ITEM_COMBINATION)));
    }

    private void markGift(List<DgPerformOrderItemRespDto> saleOrderItemRespDtos) {
        List orderGiftRespDtos = saleOrderItemRespDtos.stream().filter(item -> DgGiftEnum.GIFT.getType().equals(item.getGift())).collect(Collectors.toList());
        log.debug("[\u8ba2\u5355\u5546\u54c1\u8d60\u54c1\u6253\u6807]\u9700\u8981\u6253\u8d60\u54c1\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderGiftRespDtos));
        Optional.ofNullable(orderGiftRespDtos).ifPresent(orderGiftRespDtoList -> orderGiftRespDtoList.forEach(item -> this.orderLabelItemDomain.addOrderLabelItem(item.getOrderId(), item.getId(), DgOrderLabelEnum.ITEM_GIFT)));
    }
}

