/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderTagReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRelationRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRelationsRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderTagDomain;
import com.yunxi.dg.base.center.trade.eo.OrderTagEo;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagItemService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderTagServiceImpl
implements IOrderTagService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IOrderTagDomain orderTagDomain;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IOrderTagItemService orderTagItemService;
    @Resource
    private IOrderTagRecordService orderTagRecordService;

    @Override
    public Long addOrderTag(OrderTagReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getTagName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        OrderTagEo orderTagEo = new OrderTagEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderTagEo);
        if (StringUtils.isBlank((CharSequence)addReqDto.getTagCode())) {
            orderTagEo.setTagCode(this.noGreateUtil.generateTagNo());
        }
        this.checkTagCodeOnly(orderTagEo.getTagCode(), null);
        this.orderTagDomain.insert((BaseEo)orderTagEo);
        return orderTagEo.getId();
    }

    @Override
    public void modifyOrderTag(OrderTagReqDto modifyReqDto) {
        AssertUtils.notNull((Object)modifyReqDto.getId(), (String)"\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        OrderTagEo orderTagEo = new OrderTagEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderTagEo);
        this.checkTagCodeOnly(orderTagEo.getTagCode(), orderTagEo.getId());
        this.orderTagDomain.updateSelective((BaseEo)orderTagEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderTag(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderTagDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderTagRespDto queryById(Long id) {
        OrderTagEo orderTagEo = (OrderTagEo)this.orderTagDomain.selectByPrimaryKey(id);
        OrderTagRespDto orderTagRespDto = new OrderTagRespDto();
        DtoHelper.eo2Dto((BaseEo)orderTagEo, (BaseVo)orderTagRespDto);
        return orderTagRespDto;
    }

    @Override
    public PageInfo<OrderTagRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderTagReqDto orderTagReqDto = (OrderTagReqDto)JSON.parseObject((String)filter, OrderTagReqDto.class);
        OrderTagEo orderTagEo = new OrderTagEo();
        this.param(orderTagEo, orderTagReqDto);
        PageInfo eoPageInfo = this.orderTagDomain.selectPage((BaseEo)orderTagEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderTagRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public OrderTagRelationRespDto queryByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OrderTagReqDto orderTagReqDto = new OrderTagReqDto();
        orderTagReqDto.setOrderIds(Arrays.asList(orderId));
        OrderTagRelationsRespDto relationsRespDto = this.queryOrderTagRelations(orderTagReqDto);
        if (Objects.isNull(relationsRespDto)) {
            return null;
        }
        OrderTagRelationRespDto relationRespDto = new OrderTagRelationRespDto();
        if (Objects.nonNull(relationsRespDto.getOrderTagRecordMaps())) {
            relationRespDto.setOrderTagRecords((List)relationsRespDto.getOrderTagRecordMaps().get(orderId.toString()));
        }
        if (Objects.nonNull(relationsRespDto.getOrderTagItemMaps())) {
            relationRespDto.setOrderTagItems((List)relationsRespDto.getOrderTagItemMaps().get(orderId.toString()));
        }
        return relationRespDto;
    }

    @Override
    public OrderTagRelationsRespDto queryOrderTagRelations(OrderTagReqDto orderTagReqDto) {
        AssertUtils.notNull((Object)orderTagReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OrderTagRecordReqDto orderTagRecordReqDto = new OrderTagRecordReqDto();
        CubeBeanUtils.copyProperties((Object)orderTagRecordReqDto, (Object)orderTagReqDto, (String[])new String[0]);
        List<OrderTagRecordRespDto> orderTagRecordList = this.orderTagRecordService.queryByParam(orderTagRecordReqDto);
        OrderTagItemReqDto orderTagItemReqDto = new OrderTagItemReqDto();
        CubeBeanUtils.copyProperties((Object)orderTagItemReqDto, (Object)orderTagReqDto, (String[])new String[0]);
        List<OrderTagItemRespDto> orderTagItemList = this.orderTagItemService.queryByParam(orderTagItemReqDto);
        List<String> tagCodes = this.getTagCodes(orderTagRecordList, orderTagItemList);
        if (CollectionUtils.isEmpty(tagCodes)) {
            return null;
        }
        OrderTagReqDto reqDto = new OrderTagReqDto();
        reqDto.setTagCodes(tagCodes);
        List<OrderTagRespDto> orderTagRespDtos = this.queryByParam(reqDto);
        if (CollectionUtils.isEmpty(orderTagRespDtos)) {
            return null;
        }
        Map prototypeMaps = orderTagRespDtos.stream().collect(Collectors.toMap(OrderTagRespDto::getTagCode, Function.identity()));
        Map<Long, List<OrderTagRecordRespDto>> recordMaps = Optional.ofNullable(orderTagRecordList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(OrderTagBaseRespDto::getOrderId));
        Map<Long, List<OrderTagItemRespDto>> itemMaps = Optional.ofNullable(orderTagItemList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(OrderTagBaseRespDto::getOrderId));
        Map<String, List> orderTagRecordMaps = recordMaps.entrySet().stream().collect(Collectors.toMap(map -> ((Long)map.getKey()).toString(), map -> this.convertTag((List)map.getValue(), prototypeMaps)));
        Map<String, List> orderTagItemMaps = itemMaps.entrySet().stream().collect(Collectors.toMap(map -> ((Long)map.getKey()).toString(), map -> this.convertTag((List)map.getValue(), prototypeMaps)));
        OrderTagRelationsRespDto relationRespDto = new OrderTagRelationsRespDto();
        relationRespDto.setOrderTagRecordMaps(orderTagRecordMaps);
        relationRespDto.setOrderTagItemMaps(orderTagItemMaps);
        return relationRespDto;
    }

    @Override
    public void updateStatus(OrderTagReqDto reqDto) {
        this.logger.info("\u66f4\u65b0\u6807\u7b7e\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtils.notNull((Object)reqDto.getId(), (String)"\u6807\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        OrderTagEo tagEo = new OrderTagEo();
        tagEo.setId(reqDto.getId());
        tagEo.setTagStatus(reqDto.getTagStatus());
        this.orderTagDomain.updateSelective((BaseEo)tagEo);
    }

    @Override
    public PageInfo<OrderTagRespDto> queryByPageInfo(OrderTagReqDto reqDto) {
        this.logger.info("\u8ba2\u5355\u6807\u7b7e\u8868\u5206\u9875\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        ExtQueryChainWrapper wrapper = this.orderTagDomain.filter();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.like(StringUtils.isNotBlank((CharSequence)reqDto.getTagCode()), (Object)"tag_code", (Object)reqDto.getTagCode());
        wrapper.like(StringUtils.isNotBlank((CharSequence)reqDto.getTagName()), (Object)"tag_name", (Object)reqDto.getTagName());
        wrapper.eq(ObjectUtil.isNotEmpty((Object)reqDto.getTagStatus()), (Object)"tag_status", (Object)reqDto.getTagStatus());
        wrapper.eq(ObjectUtil.isNotEmpty((Object)reqDto.getExtend()), (Object)"extend", (Object)reqDto.getExtend());
        wrapper.eq(StringUtils.isNotBlank((CharSequence)reqDto.getTagType()), (Object)"tag_type", (Object)reqDto.getTagType());
        wrapper.orderByDesc((Object)"create_time");
        PageInfo eoPageInfo = wrapper.select(new String[0]).page(reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderTagRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    public List<OrderTagRespDto> queryByParam(OrderTagReqDto orderTagReqDto) {
        OrderTagEo orderTagEo = new OrderTagEo();
        orderTagEo.setDr(0);
        this.param(orderTagEo, orderTagReqDto);
        List orderTagEos = this.orderTagDomain.selectList((BaseEo)orderTagEo);
        if (CollectionUtils.isEmpty((Collection)orderTagEos)) {
            return null;
        }
        ArrayList<OrderTagRespDto> dtoList = new ArrayList<OrderTagRespDto>();
        DtoHelper.eoList2DtoList((Collection)orderTagEos, dtoList, OrderTagRespDto.class);
        return dtoList;
    }

    private void param(OrderTagEo orderTagEo, OrderTagReqDto orderTagReqDto) {
        ArrayList orderSqlFilter = Lists.newArrayList();
        if (Objects.nonNull(orderTagReqDto.getId())) {
            orderTagEo.setId(orderTagReqDto.getId());
        }
        if (Objects.nonNull(orderTagReqDto.getTagStatus())) {
            orderTagEo.setTagStatus(orderTagReqDto.getTagStatus());
        }
        if (Objects.nonNull(orderTagReqDto.getTagType())) {
            orderTagEo.setTagType(orderTagReqDto.getTagType());
        }
        if (Objects.nonNull(orderTagReqDto.getTagCode())) {
            orderSqlFilter.add(SqlFilter.like((String)"tag_code", (Object)orderTagReqDto.getTagCode()));
        }
        if (Objects.nonNull(orderTagReqDto.getTagName())) {
            orderSqlFilter.add(SqlFilter.like((String)"tag_name", (Object)orderTagReqDto.getTagName()));
        }
        if (Objects.nonNull(orderTagReqDto.getUpdateStartTime()) && Objects.nonNull(orderTagReqDto.getUpdateEndTime())) {
            orderSqlFilter.add(SqlFilter.ge((String)"updateTime", (Object)orderTagReqDto.getUpdateStartTime()));
            orderSqlFilter.add(SqlFilter.le((String)"updateTime", (Object)orderTagReqDto.getUpdateEndTime()));
        }
        if (CollectionUtils.isNotEmpty((Collection)orderTagReqDto.getTagCodes())) {
            orderSqlFilter.add(SqlFilter.in((String)"tag_code", (Object)orderTagReqDto.getTagCodes()));
        }
        orderTagEo.setOrderByDesc("update_time");
        orderTagEo.setSqlFilters((List)orderSqlFilter);
    }

    private List<String> getTagCodes(List<? extends OrderTagBaseRespDto> ... orderTagRecordList) {
        ArrayList tagCodes = Lists.newArrayList();
        for (List<? extends OrderTagBaseRespDto> orderTagBaseResp : orderTagRecordList) {
            List tagCodeList = Optional.ofNullable(orderTagBaseResp).orElse(Lists.newArrayList()).stream().map(OrderTagBaseRespDto::getTagCode).collect(Collectors.toList());
            tagCodes.addAll(tagCodeList);
        }
        return tagCodes;
    }

    private List<OrderTagRespDto> convertTag(List<? extends OrderTagBaseRespDto> orderTagBaseRespDtos, Map<String, OrderTagRespDto> orderTagRespDtoMaps) {
        return orderTagBaseRespDtos.stream().map(e -> {
            if (orderTagRespDtoMaps.containsKey(e.getTagCode())) {
                OrderTagRespDto orderTagRespDto = (OrderTagRespDto)orderTagRespDtoMaps.get(e.getTagCode());
                OrderTagRespDto newOrderTag = new OrderTagRespDto();
                CubeBeanUtils.copyProperties((Object)newOrderTag, (Object)orderTagRespDto, (String[])new String[0]);
                newOrderTag.setOrderId(e.getOrderId());
                if (e instanceof OrderTagItemRespDto) {
                    newOrderTag.setSkuCode(((OrderTagItemRespDto)e).getSkuCode());
                }
                return newOrderTag;
            }
            return null;
        }).collect(Collectors.toList());
    }

    private void checkTagCodeOnly(String code, Long id) {
        this.logger.info("\u6821\u9a8c\u7f16\u53f7\u552f\u4e00\uff1a{}\uff0c{}", (Object)code, (Object)id);
        if (StringUtils.isBlank((CharSequence)code)) {
            throw new BizException("-1", "\u6821\u9a8c\u7f16\u53f7\u552f\u4e00\u5931\u8d25\uff0c\u53c2\u6570\u5f02\u5e38");
        }
        ExtQueryChainWrapper wrapper = this.orderTagDomain.filter();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"tag_code", (Object)code);
        wrapper.ne(ObjectUtil.isNotEmpty((Object)id), (Object)"id", (Object)id);
        if (CollectionUtils.isNotEmpty((Collection)wrapper.select(new String[0]).list())) {
            throw new BizException("-1", "\u8be5\u7f16\u53f7\u5df2\u5b58\u5728");
        }
    }
}

