/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.center.source.api.constant.SourceStatusEnum;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.GiftEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.GiftTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OmsSaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ChangeOrderStatusMessageDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.LogicWarehouseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SourceOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SourceRecordRespDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.baseservice.BInventoryApiServcie;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.proxy.data.api.IPcpDictProxy;
import com.yunxi.dg.base.center.trade.proxy.data.entity.DictDto;
import com.yunxi.dg.base.center.trade.service.tc.ILabelManageService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderAddrService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderHandleService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.service.tc.ISourceOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISourceRecordService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SaleOrderHandleServiceImpl
implements ISaleOrderHandleService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderHandleServiceImpl.class);
    private static final String NEED_INVENTORY = "NEED_INVENTORY";
    private static final String NOT_NEED_INVENTORY = "NOT_NEED_INVENTORY";
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ISaleOrderItemService saleOrderItemService;
    @Resource
    private IPcpDictProxy pcpDictProxy;
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private BInventoryApiServcie inventoryApiServcie;
    @Resource
    private ISourceRecordService sourceRecordService;
    @Resource
    private ISourceOrderItemService sourceOrderItemService;
    @Resource
    private ISaleOrderAddrService saleOrderAddrService;
    @Resource
    private ILabelManageService tagManageService;

    @Override
    public void deductionInventoryAndChangeOrderStatus(List<SaleOrderRespDto> childOrderList) {
        ArrayList deliveriedOrderIdList = Lists.newArrayList();
        List orderIdList = childOrderList.stream().filter(saleOrderItem -> StringUtils.equals((CharSequence)SaleOrderTypeEnum.CONSIGNMENT_ORDER.getType(), (CharSequence)saleOrderItem.getOrderType())).map(SaleOrderRespDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderIdList)) {
            deliveriedOrderIdList.addAll(orderIdList);
        }
        this.sendMqMessage(deliveriedOrderIdList, OmsSaleOrderStatus.DELIVERED.getCode());
    }

    private void sendMqMessage(List<Long> deliveriedOrderIdList, String orderStatus) {
        if (CollectionUtils.isNotEmpty(deliveriedOrderIdList)) {
            ChangeOrderStatusMessageDto changeOrderStatusMessageDto = new ChangeOrderStatusMessageDto();
            changeOrderStatusMessageDto.setOrderIdList(deliveriedOrderIdList);
            changeOrderStatusMessageDto.setInitOrderStatus(orderStatus);
            MessageVo messageVo = new MessageVo();
            messageVo.setData((Object)changeOrderStatusMessageDto);
            LOGGER.info("[\u4fee\u6539\u8ba2\u5355\u72b6\u6001]\u53d1\u9001\u6d88\u606f\u4fee\u6539\u865a\u62df\u5546\u54c1\u8ba2\u5355\u72b6\u6001\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
            this.commonsMqService.sendSingleMessage("ORDER_STATUS_CHANGE_TAG", (Object)messageVo);
        }
    }

    @Override
    public void changeOrderStatusForVirtual(List<SaleOrderRespDto> childOrderList) {
        List orderIdList = childOrderList.stream().filter(saleOrderItem -> StringUtils.equals((CharSequence)SaleOrderTypeEnum.VIRTUAL_ORDER.getType(), (CharSequence)saleOrderItem.getOrderType())).map(SaleOrderRespDto::getId).collect(Collectors.toList());
        ArrayList deliveriedOrderIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(orderIdList)) {
            deliveriedOrderIdList.addAll(orderIdList);
        }
        this.sendMqMessage(deliveriedOrderIdList, OmsSaleOrderStatus.DELIVERED.getCode());
    }

    @Override
    public void changeOrderStatusForCommon(List<SaleOrderRespDto> childOrderList) {
        List orderIdList = childOrderList.stream().filter(saleOrderItem -> StringUtils.equals((CharSequence)SaleOrderTypeEnum.COMMON_ORDER.getType(), (CharSequence)saleOrderItem.getOrderType())).map(SaleOrderRespDto::getId).collect(Collectors.toList());
        ArrayList deliveriedOrderIdList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(orderIdList)) {
            deliveriedOrderIdList.addAll(orderIdList);
        }
        this.sendMqMessage(deliveriedOrderIdList, OmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode());
    }

    @Override
    public void changeGiftTypeForOrderItem(BizSaleOrderReqDto request) {
        AssertUtils.notNull((Object)request, (String)"request \u4e0d\u80fd\u4e3a\u7a7a");
        Integer giftType = GiftTypeEnum.PLATFORM.getType();
        if (request.getManualCreate().booleanValue()) {
            giftType = GiftTypeEnum.MANUAL.getType();
        }
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(request.getId());
        AssertUtils.notEmpty(saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{request.getId()});
        List orderGiftRespDtos = saleOrderItemRespDtos.stream().filter(item -> item.getGift() != null ? GiftEnum.GIFT.getType().equals(item.getGift()) : item.getPayAmount() == null || item.getPayAmount().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
        Integer finalGiftType = giftType;
        Optional.ofNullable(orderGiftRespDtos).ifPresent(orderGiftRespDtoList -> orderGiftRespDtoList.forEach(item -> {
            SaleOrderItemReqDto saleOrderItemReqDto = new SaleOrderItemReqDto();
            saleOrderItemReqDto.setId(item.getId());
            saleOrderItemReqDto.setGiftType(finalGiftType);
            this.saleOrderItemService.modifySaleOrderItem(saleOrderItemReqDto);
        }));
    }

    @Override
    public void deducateInventoryAndModifyOrderType(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, List<String>> virtualConfigMap = this.getVirtualConfig();
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(orderId);
        AssertUtils.notEmpty(saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u5546\u54c1\u4e3a\u7a7a", (Object[])new Object[]{orderId});
        long needInventoryCount = saleOrderItemRespDtos.stream().filter(item -> ((List)virtualConfigMap.get(NEED_INVENTORY)).contains(item.getSkuCode())).count();
        if ((long)saleOrderItemRespDtos.size() == needInventoryCount) {
            LOGGER.info("[\u540c\u79cd\u7c7b\u578b\u865a\u62df\u5546\u54c1]\u8be5\u8ba2\u5355\uff08{}\uff09\u6240\u6709\u5546\u54c1\u4e3a\u9700\u7ba1\u5e93\u5b58\u7684\u865a\u62df\u5546\u54c1", (Object)orderId);
            SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
            saleOrderReqDto.setId(orderId);
            saleOrderReqDto.setOrderType(SaleOrderTypeEnum.CONSIGNMENT_ORDER.getType());
            this.saleOrderService.modifySaleOrder(saleOrderReqDto);
        }
        long notInventoryCount = saleOrderItemRespDtos.stream().filter(item -> ((List)virtualConfigMap.get(NOT_NEED_INVENTORY)).contains(item.getSkuCode())).count();
        if ((long)saleOrderItemRespDtos.size() == notInventoryCount) {
            LOGGER.info("[\u540c\u79cd\u7c7b\u578b\u865a\u62df\u5546\u54c1]\u8be5\u8ba2\u5355\uff08{}\uff09\u6240\u6709\u5546\u54c1\u4e3a\u65e0\u9700\u8981\u7ba1\u5e93\u5b58\u7684\u865a\u62df\u5546\u54c1", (Object)orderId);
            SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
            saleOrderReqDto.setId(orderId);
            saleOrderReqDto.setOrderType(SaleOrderTypeEnum.VIRTUAL_ORDER.getType());
            this.saleOrderService.modifySaleOrder(saleOrderReqDto);
        }
    }

    private Map<String, List<String>> getVirtualConfig() {
        Object dictEnum = null;
        RestResponse dictDtoRestResponse = this.pcpDictProxy.queryByGroupCodeAndCode(dictEnum.getGroupCode(), dictEnum.getCode());
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)dictDtoRestResponse);
        Object dictEnum2 = null;
        RestResponse dictDto2RestResponse = this.pcpDictProxy.queryByGroupCodeAndCode(dictEnum2.getGroupCode(), dictEnum2.getCode());
        DictDto dictDto2 = (DictDto)RestResponseHelper.extractData((RestResponse)dictDto2RestResponse);
        ArrayList requireInventorySkuCodeList = Lists.newArrayList();
        ArrayList withoutInventorySkuCodeList = Lists.newArrayList();
        if (Objects.nonNull(dictDto)) {
            Object[] requiringInventorySkuCodes = Optional.ofNullable(dictDto.getValue()).orElse("").split(",");
            requireInventorySkuCodeList.addAll(Lists.newArrayList((Object[])requiringInventorySkuCodes));
        }
        if (Objects.nonNull(dictDto2)) {
            Object[] withoutInventorySkuCodes = Optional.ofNullable(dictDto2.getValue()).orElse("").split(",");
            withoutInventorySkuCodeList.addAll(Lists.newArrayList((Object[])withoutInventorySkuCodes));
        }
        HashMap virtualConfigMap = Maps.newHashMap();
        virtualConfigMap.put(NEED_INVENTORY, requireInventorySkuCodeList);
        virtualConfigMap.put(NOT_NEED_INVENTORY, withoutInventorySkuCodeList);
        return virtualConfigMap;
    }

    @Override
    public void preemptLogicInventoryByAppointDeliveryWarehouse(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        AssertUtils.notBlank((String)saleOrderRespDto.getLogicalWarehouseCode(), (String)"\u8ba2\u5355\u5c1a\u672a\u6307\u5b9a\u53d1\u8d27\u903b\u8f91\u4ed3");
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryNormalItems(orderId, null);
        saleOrderRespDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
    }

    @Override
    public void preemptLogicInventoryByDeliveryWarehouse(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryNormalItems(orderId, null);
    }

    @Override
    public void preemptLogicInventoryBySource(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        SourceRecordRespDto sourceRecordRespDto = this.sourceRecordService.querySourceRecordBySgOrderNo(sgOrderNo);
        AssertUtils.notNull((Object)sourceRecordRespDto, (String)"\u5bfb\u6e90\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<SourceOrderItemRespDto> sourceOrderItemRespDtos = this.sourceOrderItemService.querySourceItemBySgOrderNo(sgOrderNo);
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceRecordRespDto.getSgStatus())) {
            SourceOrderItemRespDto sourceOrderItemRespDto = sourceOrderItemRespDtos.get(0);
            BizSaleOrderRespDto saleOrderRespDto = this.saleOrderService.queryByOrderNo(sourceRecordRespDto.getOrderNo());
            List itemList = saleOrderRespDto.getItemList();
            ArrayList saleOrderItemRespDtoList = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)saleOrderItemRespDtoList, (Collection)itemList, SaleOrderItemRespDto.class);
            saleOrderRespDto.setDeliveryLogicalWarehouseCode(sourceOrderItemRespDto.getSgWarehouseCode());
            LogicWarehouseReqDto logicWarehouseReqDto = new LogicWarehouseReqDto();
            logicWarehouseReqDto.setDeliveryLogicWarehouseCode(sourceOrderItemRespDto.getSgWarehouseCode());
            this.updateDeliveryLogicWarehouse(saleOrderRespDto.getId(), logicWarehouseReqDto);
        }
    }

    @Override
    public void preemptOrderInventoryBySource(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        SourceRecordRespDto sourceRecordRespDto = this.sourceRecordService.querySourceRecordBySgOrderNo(sgOrderNo);
        AssertUtils.notNull((Object)sourceRecordRespDto, (String)"\u5bfb\u6e90\u7684\u8bb0\u5f55\u4e0d\u5b58\u5728");
        List<SourceOrderItemRespDto> sourceOrderItemRespDtos = this.sourceOrderItemService.querySourceItemBySgOrderNo(sgOrderNo);
        if (SourceStatusEnum.SOURCE_SUCCESS.getCode().equals(sourceRecordRespDto.getSgStatus())) {
            SourceOrderItemRespDto sourceOrderItemRespDto = sourceOrderItemRespDtos.get(0);
            DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoByOrderNo(sourceRecordRespDto.getOrderNo());
            AssertUtils.notNull((Object)saleOrderEo, (String)"%s \u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[]{sourceRecordRespDto.getOrderNo()});
            saleOrderEo.setDeliveryLogicalWarehouseCode(sourceOrderItemRespDto.getSgWarehouseCode());
            List<DgSaleOrderItemEo> saleOrderItemEos = this.saleOrderItemService.queryEoOrderItemByOrderId(saleOrderEo.getId());
            DgSaleOrderAddrEo saleOrderAddrEo = this.saleOrderAddrService.queryEoAddressByOrderId(saleOrderEo.getId());
            LOGGER.info("\u6839\u636e\u5bfb\u6e90\u7ed3\u679c\u8fdb\u884c\u6574\u5355\u9884\u5360\u903b\u8f91\u4ed3(\u6574\u5355\u9884\u5360)\uff1a\u9884\u5360\u53c2\u6570:saleOrderEo-{},saleOrderItemEos-{},saleOrderAddrEo-{}", new Object[]{JSON.toJSONString((Object)saleOrderEo), JSON.toJSONString(saleOrderItemEos), JSON.toJSONString((Object)saleOrderAddrEo)});
            try {
                RestResponseHelper.extractData(this.inventoryApiServcie.preemptOrderInventory(saleOrderEo, saleOrderItemEos, saleOrderAddrEo, 1, 1));
            }
            catch (Exception e) {
                this.tagManageService.markLackByOrderId(saleOrderEo.getId());
                return;
            }
            LogicWarehouseReqDto logicWarehouseReqDto = new LogicWarehouseReqDto();
            logicWarehouseReqDto.setDeliveryLogicWarehouseCode(sourceOrderItemRespDto.getSgWarehouseCode());
            this.updateDeliveryLogicWarehouse(saleOrderEo.getId(), logicWarehouseReqDto);
        }
    }

    @Override
    public void updateDeliveryLogicWarehouse(Long saleOrderId, LogicWarehouseReqDto logicWarehouseReqDto) {
        AssertUtils.notBlank((String)logicWarehouseReqDto.getDeliveryLogicWarehouseCode(), (String)"deliveryLogicWarehouseCode \u4e0d\u80fd\u4e3a\u7a7a");
        SaleOrderReqDto saleOrderReqDto = new SaleOrderReqDto();
        saleOrderReqDto.setId(saleOrderId);
        saleOrderReqDto.setDeliveryLogicalWarehouseCode(logicWarehouseReqDto.getDeliveryLogicWarehouseCode());
        LOGGER.info("[\u66f4\u65b0\u53d1\u8d27\u903b\u8f91\u4ed3]\u4fee\u6539\u53d1\u8d27\u903b\u8f91\u4ed3\u7684\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)logicWarehouseReqDto));
        this.saleOrderService.modifySaleOrder(saleOrderReqDto);
    }

    @Override
    public void deducateInventoryForOrder(Long orderId) {
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(orderId);
        this.inventoryApiServcie.deducateAllInventory(saleOrderRespDto, saleOrderItemRespDtos);
    }

    @Override
    public void preemptLogicoInventoryAndReleaseInventory(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        SaleOrderRespDto saleOrderRespDto = this.saleOrderService.querySaleOrderById(orderId);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        AssertUtils.notBlank((String)saleOrderRespDto.getLogicalWarehouseCode(), (String)"\u8ba2\u5355\u5c1a\u672a\u6307\u5b9a\u53d1\u8d27\u903b\u8f91\u4ed3");
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryNormalItems(orderId, null);
        saleOrderRespDto.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        this.inventoryApiServcie.releaseAndpreemptInventory(saleOrderRespDto, saleOrderItemRespDtos);
        LOGGER.info("[\u6307\u5b9a\u4ed3\u5e93\u9884\u5360\u5e93\u5b58]\u9884\u5360\u6210\u529f");
        SaleOrderReqDto modifySaleOrder = new SaleOrderReqDto();
        modifySaleOrder.setId(orderId);
        modifySaleOrder.setDeliveryLogicalWarehouseCode(saleOrderRespDto.getLogicalWarehouseCode());
        this.saleOrderService.modifySaleOrder(modifySaleOrder);
    }
}

