/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.util.IdGenrator;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.service.impl.DgStrategyAutoPickCustomerServiceImpl;
import com.yunxi.dg.base.center.trade.service.order.strategy.impl.DgBusinessDgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.service.order.strategy.impl.DgCustomerDgStrategyRuleServiceImpl;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NoGreateInUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoGreateInUtil.class);
    private static final int EXPIRETIME = 90000;
    @Resource
    private ICacheService cacheService;
    @Resource
    protected Map<String, IResetRedisNoIndexCommon> resetRedisNoIndexCommonMap;
    private static final String AFTER_SALE_ORDER_PREFIX = "AFAF";

    private static String getOrderIdPrefix(LocalDateTime now, String format) {
        return now.format(DateTimeFormatter.ofPattern(format));
    }

    private long generate(Class noServiceClzz, String key, int expireTime) {
        Long incrNo = this.cacheService.incr(key, (long)expireTime);
        if (incrNo == 1L) {
            incrNo = this.resetLastNo(noServiceClzz, key, expireTime);
        }
        return incrNo;
    }

    private Long resetLastNo(Class noServiceClzz, String key, int expireTime) {
        String beanServiceName = StringUtils.prefixToLower((String)noServiceClzz.getSimpleName(), (int)1);
        IResetRedisNoIndexCommon resetRedisNoIndexCommon = this.resetRedisNoIndexCommonMap.get(beanServiceName);
        AssertUtils.notNull((Object)resetRedisNoIndexCommon, (String)"%s\u6ca1\u6709\u5b9e\u73b0IResetRedisNoIndexCommon\u63a5\u53e3", (Object[])new Object[]{beanServiceName});
        String latestNo = resetRedisNoIndexCommon.getLatestNo();
        Long nextNo = 1L;
        if (latestNo.contains(key)) {
            Long latestNoL = Long.valueOf(latestNo.substring(key.length()));
            nextNo = latestNoL + 1L;
            LOGGER.info("\u91cd\u7f6eredis\u5355\u53f7 key\uff1a{}, no:{}", (Object)key, (Object)nextNo);
            this.cacheService.setCache(key, (Object)nextNo, expireTime);
        }
        return nextNo;
    }

    public String generateDefaultPlatformNo() {
        return String.format("PN%s", IdGenrator.getDistributedId());
    }

    public String generateCustomerRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "CR";
        String prefixCustomerRuleNo = prefix + orderIdPrefix;
        String ruleCode = prefixCustomerRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixCustomerRuleNo, 90000));
        return ruleCode;
    }

    public String generateLabelNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "BQ";
        String prefixCustomerRuleNo = prefix + orderIdPrefix;
        String ruleCode = prefixCustomerRuleNo + String.format("%1$04d", this.generate(DgCustomerDgStrategyRuleServiceImpl.class, prefixCustomerRuleNo, 90000));
        return ruleCode;
    }

    public String generateBusinessRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "BR";
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        String ruleCode = prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgBusinessDgStrategyRuleServiceImpl.class, prefixBusinessRuleNo, 90000));
        return ruleCode;
    }

    public String generateAutoCustomerRuleNo() {
        LocalDateTime now = LocalDateTime.now();
        String orderIdPrefix = NoGreateInUtil.getOrderIdPrefix(now, "yyyyMMddHHmmss");
        String prefix = "AC";
        String prefixBusinessRuleNo = prefix + orderIdPrefix;
        String ruleCode = prefixBusinessRuleNo + String.format("%1$04d", this.generate(DgStrategyAutoPickCustomerServiceImpl.class, prefixBusinessRuleNo, 90000));
        return ruleCode;
    }
}

