/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.baseservice.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.warehouse.ICsLogicWarehouseExposedQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.api.inventory.ICsTransferOrderApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.warehouse.CsLogicWarehousePageQueryDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehousePageRespDto;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.warehouse.CsLogicWarehouseRespDto;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventoryStrategyEnum;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsSourceSystemEnum;
import com.dtyunxi.yundt.cube.center.inventory.share.api.IVirtualWarehouseApi;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.ArrangeShipmentEnterpriseReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderBySourceInfoReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SplitOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.enums.UpdateOrderInventoryEnum;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.inventory.IDgLogicWarehouseApi;
import com.yunxi.dg.base.center.inventory.constants.DictEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.ContactDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.MaiyouWarehouseAreaMappingRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.BatchCancelLogicAndPhysicsOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsDeliveryNoticeOrderAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsDeliveryNoticeOrderDetailAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsInventoryOperateCargoReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsInventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsLogicPreemptInventoryAndAddSaleTransferOrderDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsLogicPreemptInventoryOperateReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsPcpInventoryExposedRespDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsTransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsTransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.CsTransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.inventory.IntransitCargoQueryDto;
import com.yunxi.dg.base.center.inventory.dto.report.DgLogicWarehouseDto;
import com.yunxi.dg.base.center.inventory.dto.report.DgLogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.IntransitCargoRespDto;
import com.yunxi.dg.base.center.inventory.dto.share.OperationDetailDto;
import com.yunxi.dg.base.center.inventory.dto.share.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.share.ReleasePreemptAndOutDto;
import com.yunxi.dg.base.center.inventory.dto.share.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.share.UpdatePreemptDto;
import com.yunxi.dg.base.center.inventory.emums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.proxy.inventory.ILogicInventoryExposedApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.inventory.IOutResultOrderQueryApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.share.IChannelInventoryExposedApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.IMaiyouWarehouseAreaMappingApiProxy;
import com.yunxi.dg.base.center.trade.baseservice.BInventoryApiServcie;
import com.yunxi.dg.base.center.trade.cache.SaleIntransitCache;
import com.yunxi.dg.base.center.trade.domain.entity.ISaleTransferExtDomain;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.SaleTransferExtEo;
import com.yunxi.dg.base.center.trade.proxy.data.api.IPcpDictProxy;
import com.yunxi.dg.base.center.trade.proxy.data.entity.DictDto;
import com.yunxi.dg.base.center.trade.service.tc.IOrderTagRecordService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class BInventoryApiServcieImpl
implements BInventoryApiServcie {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ILogicInventoryExposedApiProxy logicInventoryExposedApiProxy;
    @Resource
    private IChannelInventoryExposedApiProxy channelInventoryExposedApiProxy;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IOrderTagRecordService orderTagRecordService;
    @Resource
    private ICsTransferOrderApi csTransferOrderApi;
    @Resource
    private ICsLogicWarehouseExposedQueryApi csLogicWarehouseExposedQueryApi;
    @Resource
    private SaleIntransitCache saleIntransitCache;
    @Resource
    private ISaleTransferExtDomain saleTransferExtDomain;
    @Autowired
    private IOutResultOrderQueryApiProxy outResultOrderQueryApiProxy;
    @Resource
    private IPcpDictProxy pcpDictProxy;
    @Autowired
    private IVirtualWarehouseApi virtualWarehouseQueryApi;
    @Resource
    private IDgLogicWarehouseApi dgLogicWarehouseApi;
    @Resource
    private IMaiyouWarehouseAreaMappingApiProxy maiyouWarehouseAreaMappingApiProxy;
    private static final ExecutorService executorService = new ThreadPoolExecutor(2, 10, 1L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(5, true), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy());

    @Override
    public Boolean releaseLogicalAndChannel(SaleOrderRespDto saleOrderRespDto) {
        CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setReleaseStrategyList((List)Lists.newArrayList((Object[])new String[]{CsInventoryStrategyEnum.CHANNEL.getCode(), CsInventoryStrategyEnum.LOGIC.getCode()}));
        this.logger.info("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u903b\u8f91\u4ed3\u548c\u6e20\u9053\u4ed3\u9884\u5360\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApiProxy.releaseInventoryByStrategy(inventoryOperateReqDto);
        return (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    @Override
    public Boolean releaseLogical(SaleOrderRespDto saleOrderRespDto) {
        CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setReleaseStrategyList((List)Lists.newArrayList((Object[])new String[]{CsInventoryStrategyEnum.LOGIC.getCode(), CsInventoryStrategyEnum.PHYSICS.getCode()}));
        this.logger.info("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u903b\u8f91\u4ed3\u548c\u7269\u7406\u4ed3\u9884\u5360\u7684\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        RestResponse restResponse = this.logicInventoryExposedApiProxy.releaseInventoryByStrategy(inventoryOperateReqDto);
        return (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
    }

    @Override
    public CsPcpInventoryExposedRespDto preemptOrderInventory(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos, DgSaleOrderAddrEo orderAddrEo, Integer negativeValidate) {
        CsPcpInventoryExposedRespDto csPcpInventoryExposedRespDto = (CsPcpInventoryExposedRespDto)RestResponseHelper.extractData(this.preemptOrderInventory(saleOrderEo, orderItemEos, orderAddrEo, 0, negativeValidate));
        return csPcpInventoryExposedRespDto;
    }

    @Override
    public RestResponse<CsPcpInventoryExposedRespDto> preemptOrderInventory(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos, DgSaleOrderAddrEo orderAddrEo, Integer generateOutNoticeOrder, Integer negativeValidate) {
        CsLogicPreemptInventoryOperateReqDto preemptInventoryOperateReqDto = new CsLogicPreemptInventoryOperateReqDto();
        CsInventoryOperateReqDto inventoryOperateReqDto = this.getCsInventoryOperateReqDto(saleOrderEo, orderItemEos, negativeValidate);
        preemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
        CsDeliveryNoticeOrderAddReqDto deliveryNoticeOrderAddReqDto = this.getCsDeliveryNoticeOrderAddReqDto(saleOrderEo, orderItemEos, orderAddrEo);
        preemptInventoryOperateReqDto.setGenerateOutNoticeOrder(generateOutNoticeOrder);
        preemptInventoryOperateReqDto.setDeliveryNoticeOrderAddReqDto(deliveryNoticeOrderAddReqDto);
        this.logger.info("[\u9884\u5360\u5e93\u5b58]\u9500\u552e\u8ba2\u5355\u53d1\u8d27\uff0c\u9884\u5360\u5e93\u5b58\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptInventoryOperateReqDto));
        RestResponse csPcpInventoryExposedRespDtoRestResponse = this.logicInventoryExposedApiProxy.preemptOrderInventory(preemptInventoryOperateReqDto);
        this.logger.info("\u9500\u552e\u8ba2\u5355\u53d1\u8d27\uff0c\u9884\u5360\u5e93\u5b58\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)csPcpInventoryExposedRespDtoRestResponse));
        if (Objects.nonNull(csPcpInventoryExposedRespDtoRestResponse) && Objects.equals(csPcpInventoryExposedRespDtoRestResponse.getResultCode(), "0952777")) {
            csPcpInventoryExposedRespDtoRestResponse = this.logicInventoryExposedApiProxy.preemptOrderInventory(preemptInventoryOperateReqDto);
            this.logger.info("\u9500\u552e\u8ba2\u5355\u53d1\u8d27\uff0c\u9884\u5360\u5e93\u5b58\u91cd\u8bd5\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)csPcpInventoryExposedRespDtoRestResponse));
        }
        return csPcpInventoryExposedRespDtoRestResponse;
    }

    private String isKmhOrder(Long orderId) {
        List<OrderTagRecordRespDto> orderTagRecordRespDtos = this.orderTagRecordService.queryByOrderIds(Lists.newArrayList((Object[])new Long[]{orderId}));
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(orderTagRecordRespDtos)) {
            return null;
        }
        List tagCodeList = orderTagRecordRespDtos.stream().map(OrderTagBaseRespDto::getTagCode).collect(Collectors.toList());
        if (tagCodeList.contains("GS001")) {
            return "GS001";
        }
        return null;
    }

    @Override
    public List<CsPcpInventoryExposedRespDto> preemptOrderInventoryBatch(List<BizSaleOrderRespDto> childorderRespDtos) {
        Integer day = this.getZtStockDayNum();
        boolean ztSwitchFlag = this.isZtSwitchFlag();
        ArrayList csLogicPreemptInventoryOperateReqDtoList = Lists.newArrayList();
        for (BizSaleOrderRespDto childorderRespDto : childorderRespDtos) {
            List itemList = childorderRespDto.getItemList();
            SaleOrderAddrRespDto orderAddrRespDto = childorderRespDto.getOrderAddrRespDto();
            CsLogicPreemptInventoryOperateReqDto preemptInventoryOperateReqDto = new CsLogicPreemptInventoryOperateReqDto();
            CsInventoryOperateReqDto inventoryOperateReqDto = this.getCsInventoryOperateReqDto(childorderRespDto, itemList, day, ztSwitchFlag);
            preemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
            CsDeliveryNoticeOrderAddReqDto deliveryNoticeOrderAddReqDto = this.getCsDeliveryNoticeOrderAddReqDto(childorderRespDto, itemList, orderAddrRespDto);
            preemptInventoryOperateReqDto.setGenerateOutNoticeOrder(Integer.valueOf(0));
            preemptInventoryOperateReqDto.setDeliveryNoticeOrderAddReqDto(deliveryNoticeOrderAddReqDto);
            csLogicPreemptInventoryOperateReqDtoList.add(preemptInventoryOperateReqDto);
            this.saleIntransitCache.delSaleIntranst(childorderRespDto.getSaleOrderNo());
        }
        this.saleIntransitCache.delSaleIntranst(childorderRespDtos.get(0).getOriginalOrderNo());
        this.logger.info("[\u9884\u5360\u5e93\u5b58\u6279\u91cf]\u9500\u552e\u8ba2\u5355\u53d1\u8d27\uff0c\u6279\u91cf\u9884\u5360\u5e93\u5b58\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)csLogicPreemptInventoryOperateReqDtoList));
        List csPcpInventoryExposedRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApiProxy.preemptOrderInventoryBatch((List)csLogicPreemptInventoryOperateReqDtoList));
        return csPcpInventoryExposedRespDtos;
    }

    private boolean isZtSwitchFlag() {
        String inTransitInventorySwitch = Optional.ofNullable(this.pcpDictProxy.queryByGroupCodeAndCode(DictEnum.IN_TRANSIT_INVENTORY_SWITCH.getGroupCode(), DictEnum.IN_TRANSIT_INVENTORY_SWITCH.getCode()).getData()).map(DictDto::getValue).orElse(null);
        this.logger.info("\u67e5\u8be2\u53ef\u552e\u5728\u9014\u5e93\u5b58\u5f00\u5173\u901a\u7528\u914d\u7f6e:{}", (Object)inTransitInventorySwitch);
        boolean ztSwitchFlag = Objects.equals(inTransitInventorySwitch, "1");
        return ztSwitchFlag;
    }

    private Integer getZtStockDayNum() {
        Integer day = 0;
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.pcpDictProxy.queryByGroupCodeAndCode(DictEnum.INVENTORY_AVAILABLE_IN_TRANSIT_DAY.getGroupCode(), DictEnum.INVENTORY_AVAILABLE_IN_TRANSIT_DAY.getCode()));
        String value = dictDto.getValue();
        Map map = (Map)JSON.parseObject((String)value, Map.class);
        Integer status = Integer.valueOf(map.get("status").toString());
        if (Objects.equals(status, 1)) {
            day = Integer.valueOf(map.get("day").toString());
        }
        return day;
    }

    private CsDeliveryNoticeOrderAddReqDto getCsDeliveryNoticeOrderAddReqDto(BizSaleOrderRespDto childorderRespDto, List<SaleOrderItemExtRespDto> itemList, SaleOrderAddrRespDto orderAddrRespDto) {
        CsDeliveryNoticeOrderAddReqDto deliveryNoticeOrderAddReqDto = new CsDeliveryNoticeOrderAddReqDto();
        deliveryNoticeOrderAddReqDto.setPreOrderNo(childorderRespDto.getSaleOrderNo());
        deliveryNoticeOrderAddReqDto.setExternalOrderNo(childorderRespDto.getPlatformOrderNo());
        deliveryNoticeOrderAddReqDto.setBusinessType(childorderRespDto.getOrderType());
        deliveryNoticeOrderAddReqDto.setShopName(childorderRespDto.getShopName());
        deliveryNoticeOrderAddReqDto.setShopId(childorderRespDto.getShopId());
        deliveryNoticeOrderAddReqDto.setRemark(childorderRespDto.getSellerRemark());
        ContactDto contactDto = new ContactDto();
        contactDto.setPreOrderNo(childorderRespDto.getSaleOrderNo());
        contactDto.setReciveName(orderAddrRespDto.getReceiveName());
        contactDto.setRecivePhone(orderAddrRespDto.getReceivePhone());
        contactDto.setRemark(childorderRespDto.getSellerRemark());
        contactDto.setProvinceCode(orderAddrRespDto.getProvinceCode());
        contactDto.setProvince(orderAddrRespDto.getProvince());
        contactDto.setCity(orderAddrRespDto.getCity());
        contactDto.setCityCode(orderAddrRespDto.getCityCode());
        contactDto.setDistrict(orderAddrRespDto.getCounty());
        contactDto.setDistrictCode(orderAddrRespDto.getCountyCode());
        contactDto.setPostalCode(orderAddrRespDto.getPostcode());
        contactDto.setCustomerCode(childorderRespDto.getCustomerCode());
        contactDto.setDetailAddress(orderAddrRespDto.getReceiveAddress());
        contactDto.setContacts(orderAddrRespDto.getReceiveName());
        contactDto.setPhone(orderAddrRespDto.getReceivePhone());
        String fullAddress = String.format("%s%s%s%s", orderAddrRespDto.getProvince(), orderAddrRespDto.getCity(), orderAddrRespDto.getCounty(), orderAddrRespDto.getReceiveAddress());
        contactDto.setAddress(fullAddress);
        deliveryNoticeOrderAddReqDto.setContactDto(contactDto);
        double sum = itemList.stream().map(SaleOrderItemRespDto::getItemNum).mapToDouble(BigDecimal::doubleValue).sum();
        deliveryNoticeOrderAddReqDto.setTotalQuantity(new BigDecimal(sum));
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        for (SaleOrderItemExtRespDto item : itemList) {
            CsDeliveryNoticeOrderDetailAddReqDto dto = new CsDeliveryNoticeOrderDetailAddReqDto();
            dto.setBatch(item.getBatchNo());
            dto.setPlanQuantity(item.getItemNum());
            dto.setLongCode(item.getSkuCode());
            dto.setTradeOrderItemId(item.getId());
            detailAddReqDtoList.add(dto);
            deliveryNoticeOrderAddReqDto.setWarehouseCode(item.getLogicalWarehouseCode());
        }
        deliveryNoticeOrderAddReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        return deliveryNoticeOrderAddReqDto;
    }

    private CsInventoryOperateReqDto getCsInventoryOperateReqDto(BizSaleOrderRespDto childorderRespDto, List<SaleOrderItemExtRespDto> itemList, Integer day, Boolean ztSwitchFlag) {
        CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(childorderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setPlatformOrderNo(childorderRespDto.getPlatformOrderNo());
        inventoryOperateReqDto.setSourceType(childorderRespDto.getOrderType());
        inventoryOperateReqDto.setBusinessType(childorderRespDto.getOrderType());
        inventoryOperateReqDto.setExtension(this.isKmhOrder(childorderRespDto.getId()));
        HashSet<String> skuCodeList = new HashSet<String>();
        HashSet<String> logicalWarehouseCodeList = new HashSet<String>();
        boolean ztFlag = !Objects.equals(inventoryOperateReqDto.getNegativeValidate(), 0) && ztSwitchFlag != false;
        this.logger.info("\u5224\u65ad\u662f\u5426\u5f3a\u6821\u9a8c\u5e93\u5b58\u548c\u5f00\u542f\u5728\u9014\u9a8c\u8bc1={}", (Object)ztFlag);
        inventoryOperateReqDto.setIntransitPreemptFlag(Boolean.valueOf(ztFlag && this.saleIntransitCache.getSaleIntranst(childorderRespDto.getSaleOrderNo()) != false));
        Map saleItemIntranstMap = this.saleIntransitCache.getSaleItemIntranst(childorderRespDto.getSaleOrderNo());
        List operateCargoReqDtoList = itemList.stream().map(saleOrderItemEo -> {
            CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getLogicalWarehouseCode());
            inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getDeliveryItemBatchNo());
            inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
            skuCodeList.add(saleOrderItemEo.getSkuCode());
            String key = saleOrderItemEo.getId() + "_" + saleOrderItemEo.getLogicalWarehouseCode();
            if (Objects.nonNull(saleItemIntranstMap) && saleItemIntranstMap.containsKey(key)) {
                inventoryOperateCargoReqDto.setIntransitPreemptFlag(Boolean.valueOf(ztFlag && (Boolean)saleItemIntranstMap.get(key) != false));
            }
            logicalWarehouseCodeList.add(saleOrderItemEo.getLogicalWarehouseCode());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        if (inventoryOperateReqDto.getIntransitPreemptFlag().booleanValue()) {
            try {
                DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
                CubeBeanUtils.copyProperties((Object)saleOrderEo, (Object)childorderRespDto, (String[])new String[0]);
                this.saveSaleTransferExt(saleOrderEo, day, skuCodeList, logicalWarehouseCodeList);
            }
            catch (Exception e) {
                this.logger.info("\u65b0\u589e\u9500\u552e\u5355\u5bf9\u5e94\u7684\u5728\u9014\u8c03\u62e8\u5355\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        return inventoryOperateReqDto;
    }

    private void saveSaleTransferExt(DgSaleOrderEo saleOrderEo, Integer day, Set<String> skuCodeList, Set<String> logicalWarehouseCodeList) {
        List<IntransitCargoRespDto> intransitCargoRespDtos = this.queryZtCargoBatchNum(Lists.newArrayList(logicalWarehouseCodeList), Lists.newArrayList(skuCodeList), day);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(intransitCargoRespDtos)) {
            Map<String, List<IntransitCargoRespDto>> ztStockMap = intransitCargoRespDtos.stream().collect(Collectors.groupingBy(IntransitCargoRespDto::getCargoCode));
            ArrayList addList = Lists.newArrayList();
            for (String skuCode : skuCodeList) {
                if (ztStockMap.containsKey(skuCode)) {
                    for (IntransitCargoRespDto intransitCargoRespDto : ztStockMap.get(skuCode)) {
                        SaleTransferExtEo addExt = new SaleTransferExtEo();
                        addExt.setOrderId(saleOrderEo.getId());
                        addExt.setOrganizationCode(saleOrderEo.getOrganizationCode());
                        addExt.setOrganizationId(saleOrderEo.getOrganizationId());
                        addExt.setOrganizationName(saleOrderEo.getOrganizationName());
                        addExt.setTransferOrderNo(intransitCargoRespDto.getTransferOrderNo());
                        addExt.setCarLicenseNo(intransitCargoRespDto.getCarLicenseNo());
                        addExt.setPlanArriveTime(intransitCargoRespDto.getPlanArriveTime());
                        addExt.setSkuCode(skuCode);
                        addList.add(addExt);
                    }
                    continue;
                }
                SaleTransferExtEo addExt = new SaleTransferExtEo();
                addExt.setOrderId(saleOrderEo.getId());
                addExt.setOrganizationCode(saleOrderEo.getOrganizationCode());
                addExt.setOrganizationId(saleOrderEo.getOrganizationId());
                addExt.setOrganizationName(saleOrderEo.getOrganizationName());
                addExt.setNum(BigDecimal.ZERO);
                addExt.setSkuCode(skuCode);
                addList.add(addExt);
            }
            this.saleTransferExtDomain.batchSave(saleOrderEo.getId(), (List)addList);
        }
    }

    @Override
    public void deducateAllInventory(SaleOrderRespDto saleOrderRespDto, List<SaleOrderItemRespDto> saleOrderItemRespDtos) {
    }

    @Override
    public Boolean updateOrderShipmentInfo(SaleOrderRespDto respDto, ArrangeShipmentEnterpriseReqDto reqDto) {
        return false;
    }

    @Override
    public Boolean orderShipmentCheck(SaleOrderRespDto respDto) {
        return false;
    }

    @Override
    public void releaseAndpreemptInventory(SaleOrderRespDto saleOrderRespDto, List<SaleOrderItemRespDto> saleOrderItemRespDtoList) {
        CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
        inventoryOperateReqDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        List operateCargoReqDtoList = saleOrderItemRespDtoList.stream().map(saleOrderItemEo -> {
            CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderRespDto.getDeliveryLogicalWarehouseCode());
            inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getBatchNo());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderRespDto.getPlatformOrderNo());
        this.logger.info("[\u9884\u5360\u903b\u8f91\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
    }

    @Override
    public void releaseInventory(String saleOrderNo, String platformOrderNo, String orderType, Boolean isShoutLogicWarehouse, String mainOrdeerNo) {
        ReleasePreemptDto csInventoryOperateReqDto = new ReleasePreemptDto();
        csInventoryOperateReqDto.setSourceNo(saleOrderNo);
        csInventoryOperateReqDto.setSourceType(orderType);
        csInventoryOperateReqDto.setExternalOrderNo(platformOrderNo);
        this.logger.info("\u9500\u552e\u5355\u91ca\u653e\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)csInventoryOperateReqDto));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApiProxy.releasePreempt(csInventoryOperateReqDto));
    }

    @Override
    public void updateInventoryByPreemption(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos) {
        UpdatePreemptDto shUpdatePreemptParam = new UpdatePreemptDto();
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(saleOrderEo.getSaleOrderNo());
        preemptParam.setSourceType(saleOrderEo.getOrderType());
        preemptParam.setExternalOrderNo(saleOrderEo.getPlatformOrderNo());
        preemptParam.setValidNegative(Boolean.FALSE);
        this.logger.info("AllowSplitFlag==>{},StoragePlace==>{}", (Object)saleOrderEo.getAllowSplitFlag(), (Object)saleOrderEo.getStoragePlace());
        if (Objects.equals(saleOrderEo.getAllowSplitFlag(), YesOrNoEnum.NO.getType()) && StringUtils.isNotBlank((CharSequence)saleOrderEo.getStoragePlace())) {
            preemptParam.setIsShoutVirtualWarehouse(Boolean.TRUE);
            preemptParam.setShoutVirtualWarehouseCode(saleOrderEo.getStoragePlace());
        }
        List detailParams = orderItemEos.stream().map(saleOrderItemEo -> {
            OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
            inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setNum(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getChannelWarehouseCode());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        preemptParam.setDetails(detailParams);
        shUpdatePreemptParam.setPreemptParamList((List)Lists.newArrayList((Object[])new PreemptDto[]{preemptParam}));
        this.logger.info("\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)shUpdatePreemptParam));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApiProxy.updatePreempt(shUpdatePreemptParam));
    }

    @Override
    public void preemptInventory(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos) {
        if (SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType().equals(saleOrderEo.getOrderType())) {
            this.logger.info("[\u5b50\u516c\u53f8\u76f4\u9500\u8ba2\u5355]\uff0c\u63d0\u4ea4\u8ba2\u5355\u4e0d\u9884\u5360\u5e93\u5b58");
            return;
        }
        if (SaleOrderTypeEnum.PRESALE_ORDER.getType().equals(saleOrderEo.getOrderType())) {
            this.logger.info("[\u9884\u552e\u8ba2\u5355]\uff0c\u63d0\u4ea4\u8ba2\u5355\u4e0d\u9884\u5360\u5e93\u5b58");
            return;
        }
        PreemptDto inventoryOperateReqDto = new PreemptDto();
        inventoryOperateReqDto.setSourceNo(saleOrderEo.getSaleOrderNo());
        inventoryOperateReqDto.setSourceType(saleOrderEo.getOrderType());
        inventoryOperateReqDto.setExternalOrderNo(saleOrderEo.getPlatformOrderNo());
        this.logger.info("AllowSplitFlag==>{},StoragePlace==>{}", (Object)saleOrderEo.getAllowSplitFlag(), (Object)saleOrderEo.getStoragePlace());
        if (Objects.equals(saleOrderEo.getAllowSplitFlag(), YesOrNoEnum.NO.getType()) && StringUtils.isNotBlank((CharSequence)saleOrderEo.getStoragePlace())) {
            inventoryOperateReqDto.setIsShoutVirtualWarehouse(Boolean.TRUE);
            inventoryOperateReqDto.setShoutVirtualWarehouseCode(saleOrderEo.getStoragePlace());
        }
        List details = orderItemEos.stream().map(saleOrderItemEo -> {
            OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
            inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setNum(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getChannelWarehouseCode());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setDetails(details);
        this.logger.info("\u63d0\u4ea4\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)inventoryOperateReqDto));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApiProxy.preempt(inventoryOperateReqDto));
    }

    @Override
    public void updateOrderInventory(UpdateOrderInventoryEnum orderInventoryEnum, DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos, List<BizSaleOrderRespDto> childorderRespDtos) {
        switch (orderInventoryEnum) {
            case PARENT_CHILD: {
                this.resleaseParentPreemptChild(saleOrderEo, childorderRespDtos);
                break;
            }
            case COMPLETE_RELEASE: {
                this.releasePreemptAndOut(saleOrderEo);
                break;
            }
        }
    }

    private void releasePreemptAndOut(DgSaleOrderEo saleOrderEo) {
        ReleasePreemptAndOutDto shReleasePreemptAndOutParam = new ReleasePreemptAndOutDto();
        shReleasePreemptAndOutParam.setSourceType(saleOrderEo.getOrderType());
        shReleasePreemptAndOutParam.setSourceNo(saleOrderEo.getSaleOrderNo());
        shReleasePreemptAndOutParam.setExternalOrderNo(saleOrderEo.getPlatformOrderNo());
        this.logger.info("\u8ba2\u5355\u5b8c\u6210\u91ca\u653e\u6e20\u9053\u4ed3\u5e93\u5b58\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)shReleasePreemptAndOutParam));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApiProxy.releasePreemptAndOut(shReleasePreemptAndOutParam));
    }

    private void resleaseParentPreemptChild(DgSaleOrderEo saleOrderEo, List<BizSaleOrderRespDto> childorderRespDtos) {
        UpdatePreemptDto parentOrderPreemt = new UpdatePreemptDto();
        ReleasePreemptDto shReleasePreemptParam = new ReleasePreemptDto();
        shReleasePreemptParam.setSourceNo(saleOrderEo.getSaleOrderNo());
        shReleasePreemptParam.setSourceType(saleOrderEo.getOrderType());
        shReleasePreemptParam.setExternalOrderNo(saleOrderEo.getPlatformOrderNo());
        parentOrderPreemt.setReleasePreemptParamList((List)Lists.newArrayList((Object[])new ReleasePreemptDto[]{shReleasePreemptParam}));
        ArrayList preemptParamList = Lists.newArrayList();
        for (BizSaleOrderRespDto saleOrderRespDto : childorderRespDtos) {
            PreemptDto shPreemptParam = new PreemptDto();
            shPreemptParam.setValidNegative(Boolean.FALSE);
            shPreemptParam.setExternalOrderNo(saleOrderRespDto.getPlatformOrderNo());
            shPreemptParam.setSourceNo(saleOrderRespDto.getSaleOrderNo());
            shPreemptParam.setSourceType(saleOrderRespDto.getOrderType());
            if (Objects.equals(saleOrderRespDto.getAllowSplitFlag(), YesOrNoEnum.NO.getType()) && StringUtils.isNotBlank((CharSequence)saleOrderRespDto.getStoragePlace())) {
                shPreemptParam.setIsShoutVirtualWarehouse(Boolean.TRUE);
                shPreemptParam.setShoutVirtualWarehouseCode(saleOrderEo.getStoragePlace());
            }
            ArrayList details = Lists.newArrayList();
            for (SaleOrderItemExtRespDto saleOrderItemExtRespDto : saleOrderRespDto.getItemList()) {
                OperationDetailDto itemDetail = new OperationDetailDto();
                itemDetail.setSkuCode(saleOrderItemExtRespDto.getSkuCode());
                itemDetail.setNum(saleOrderItemExtRespDto.getItemNum());
                itemDetail.setWarehouseCode(saleOrderRespDto.getChannelWarehouseCode());
                details.add(itemDetail);
            }
            shPreemptParam.setDetails((List)details);
            preemptParamList.add(shPreemptParam);
        }
        parentOrderPreemt.setPreemptParamList((List)preemptParamList);
        this.logger.info("\u91ca\u653e\u4e3b\u5355\u9884\u5360\uff0c\u91cd\u65b0\u6309\u5b50\u5355\u9884\u5360\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)parentOrderPreemt));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApiProxy.updatePreempt(parentOrderPreemt));
    }

    @Override
    public void sendChildOrderPreemptLogic(List<BizSaleOrderRespDto> childorderRespDtos) {
        for (BizSaleOrderRespDto childOrderRespDto : childorderRespDtos) {
            MessageVo messageVo = new MessageVo();
            PreemptDto shPreemptParam = new PreemptDto();
            shPreemptParam.setSourceType(childOrderRespDto.getOrderType());
            shPreemptParam.setSourceNo(childOrderRespDto.getSaleOrderNo());
            shPreemptParam.setExternalOrderNo(childOrderRespDto.getPlatformOrderNo());
            ArrayList detailParams = Lists.newArrayList();
            for (SaleOrderItemExtRespDto saleOrderItemExtRespDto : childOrderRespDto.getItemList()) {
                OperationDetailDto itemDetail = new OperationDetailDto();
                itemDetail.setSkuCode(saleOrderItemExtRespDto.getSkuCode());
                itemDetail.setNum(saleOrderItemExtRespDto.getItemNum());
                itemDetail.setWarehouseCode(saleOrderItemExtRespDto.getLogicalWarehouseCode());
                detailParams.add(itemDetail);
            }
            shPreemptParam.setDetails((List)detailParams);
            messageVo.setData((Object)JSON.toJSONString((Object)shPreemptParam));
            this.logger.info("\u5bfb\u6e90\u62c6\u5355\u6210\u529f\u53d1\u9001mq\u9884\u5360\u903b\u8f91\u4ed3\u5e93\u5b58:{}", (Object)JSON.toJSONString((Object)shPreemptParam));
            this.commonsMqService.publishMessage("CHILD_ORDER_PREEMPT_LOGIC_TAG", (Object)messageVo);
        }
    }

    @Override
    public void preemptOrderInventoryAndAddSaleTransfer(List<CsLogicPreemptInventoryOperateReqDto> csLogicPreemptInventoryOperateReqDtos, List<CsTransferOrderComboReqDto> csTransferOrderComboReqDtos) {
        CsLogicPreemptInventoryAndAddSaleTransferOrderDto dto = new CsLogicPreemptInventoryAndAddSaleTransferOrderDto();
        dto.setCsLogicPreemptInventoryOperateReqDtos(csLogicPreemptInventoryOperateReqDtos);
        dto.setCsTransferOrderComboReqDtos(csTransferOrderComboReqDtos);
        this.logger.info("\u6279\u91cf\u751f\u6210\u53d1\u8d27\u901a\u77e5\u5355\u548c\u9500\u552e\u8c03\u62e8\u5355:{}", (Object)JSON.toJSONString((Object)dto));
        try {
            RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApiProxy.preemptOrderInventoryAndAddSaleTransfer(dto));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.logger.info("\u5e93\u5b58\u4e2d\u5fc3preemptOrderInventoryAndAddSaleTransfer\u65b9\u6cd5\u5f02\u5e38\u8fdb\u884c\u91cd\u8bd5\u4e00\u6b21,{}", (Object)e.getMessage());
            RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApiProxy.preemptOrderInventoryAndAddSaleTransfer(dto));
        }
    }

    @Override
    public CsLogicPreemptInventoryOperateReqDto getSaleOrderToLogicPreempt(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos, DgSaleOrderAddrEo orderAddrEo, Integer negativeValidate) {
        CsLogicPreemptInventoryOperateReqDto preemptInventoryOperateReqDto = new CsLogicPreemptInventoryOperateReqDto();
        CsInventoryOperateReqDto inventoryOperateReqDto = this.getCsInventoryOperateReqDto(saleOrderEo, orderItemEos, negativeValidate);
        preemptInventoryOperateReqDto.setInventoryOperateReqDto(inventoryOperateReqDto);
        CsDeliveryNoticeOrderAddReqDto deliveryNoticeOrderAddReqDto = this.getCsDeliveryNoticeOrderAddReqDto(saleOrderEo, orderItemEos, orderAddrEo);
        preemptInventoryOperateReqDto.setDeliveryNoticeOrderAddReqDto(deliveryNoticeOrderAddReqDto);
        preemptInventoryOperateReqDto.setGenerateOutNoticeOrder(Integer.valueOf(0));
        return preemptInventoryOperateReqDto;
    }

    private CsInventoryOperateReqDto getCsInventoryOperateReqDto(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos, Integer negativeValidate) {
        boolean ztSwitchFlag = this.isZtSwitchFlag();
        CsInventoryOperateReqDto inventoryOperateReqDto = new CsInventoryOperateReqDto();
        inventoryOperateReqDto.setSourceNo(saleOrderEo.getSaleOrderNo());
        inventoryOperateReqDto.setPlatformOrderNo(saleOrderEo.getPlatformOrderNo());
        inventoryOperateReqDto.setNegativeValidate(negativeValidate);
        inventoryOperateReqDto.setSourceType(saleOrderEo.getOrderType());
        inventoryOperateReqDto.setBusinessType(saleOrderEo.getOrderType());
        inventoryOperateReqDto.setExtension(this.isKmhOrder(saleOrderEo.getId()));
        Map saleItemIntranstMap = this.saleIntransitCache.getSaleItemIntranst(saleOrderEo.getSaleOrderNo());
        boolean ztFlag = !Objects.equals(negativeValidate, 0) && ztSwitchFlag;
        this.logger.info("\u5224\u65ad\u662f\u5426\u5f3a\u6821\u9a8c\u5e93\u5b58\u548c\u5f00\u542f\u5728\u9014\u9a8c\u8bc1={}", (Object)ztFlag);
        inventoryOperateReqDto.setIntransitPreemptFlag(Boolean.valueOf(ztFlag && this.saleIntransitCache.getSaleIntranst(saleOrderEo.getSaleOrderNo()) != false));
        this.saleIntransitCache.delSaleIntranst(saleOrderEo.getSaleOrderNo());
        this.saleIntransitCache.delSaleIntranst(saleOrderEo.getOriginalOrderNo());
        HashSet<String> skuCodeList = new HashSet<String>();
        HashSet<String> logicalWarehouseCodeList = new HashSet<String>();
        List operateCargoReqDtoList = orderItemEos.stream().map(saleOrderItemEo -> {
            CsInventoryOperateCargoReqDto inventoryOperateCargoReqDto = new CsInventoryOperateCargoReqDto();
            inventoryOperateCargoReqDto.setLongCode(saleOrderItemEo.getSkuCode());
            inventoryOperateCargoReqDto.setChangeInventory(saleOrderItemEo.getItemNum());
            inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getLogicalWarehouseCode());
            inventoryOperateCargoReqDto.setBatch(saleOrderItemEo.getDeliveryItemBatchNo());
            inventoryOperateCargoReqDto.setTradeOrderItemId(saleOrderItemEo.getId());
            String key = saleOrderItemEo.getId() + "_" + saleOrderItemEo.getLogicalWarehouseCode();
            if (Objects.nonNull(saleItemIntranstMap) && saleItemIntranstMap.containsKey(key)) {
                inventoryOperateCargoReqDto.setIntransitPreemptFlag(Boolean.valueOf(ztFlag && (Boolean)saleItemIntranstMap.get(key) != false));
            }
            skuCodeList.add(saleOrderItemEo.getSkuCode());
            logicalWarehouseCodeList.add(saleOrderItemEo.getLogicalWarehouseCode());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        inventoryOperateReqDto.setOperateCargoReqDtoList(operateCargoReqDtoList);
        if (inventoryOperateReqDto.getIntransitPreemptFlag().booleanValue()) {
            try {
                this.saveSaleTransferExt(saleOrderEo, this.getZtStockDayNum(), skuCodeList, logicalWarehouseCodeList);
            }
            catch (Exception e) {
                this.logger.info("\u65b0\u589e\u9500\u552e\u5355\u5bf9\u5e94\u7684\u5728\u9014\u8c03\u62e8\u5355\u5931\u8d25\uff1a{}", (Throwable)e);
            }
        }
        return inventoryOperateReqDto;
    }

    private CsDeliveryNoticeOrderAddReqDto getCsDeliveryNoticeOrderAddReqDto(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos, DgSaleOrderAddrEo orderAddrEo) {
        CsDeliveryNoticeOrderAddReqDto deliveryNoticeOrderAddReqDto = new CsDeliveryNoticeOrderAddReqDto();
        deliveryNoticeOrderAddReqDto.setPreOrderNo(saleOrderEo.getSaleOrderNo());
        deliveryNoticeOrderAddReqDto.setExternalOrderNo(saleOrderEo.getPlatformOrderNo());
        deliveryNoticeOrderAddReqDto.setBusinessType(saleOrderEo.getOrderType());
        deliveryNoticeOrderAddReqDto.setShopName(saleOrderEo.getShopName());
        deliveryNoticeOrderAddReqDto.setShopId(saleOrderEo.getShopId());
        deliveryNoticeOrderAddReqDto.setRemark(saleOrderEo.getSellerRemark());
        ContactDto contactDto = new ContactDto();
        contactDto.setPreOrderNo(saleOrderEo.getSaleOrderNo());
        contactDto.setReciveName(orderAddrEo.getReceiveName());
        contactDto.setRecivePhone(orderAddrEo.getReceivePhone());
        contactDto.setRemark(saleOrderEo.getSellerRemark());
        contactDto.setProvinceCode(orderAddrEo.getProvinceCode());
        contactDto.setProvince(orderAddrEo.getProvince());
        contactDto.setCity(orderAddrEo.getCity());
        contactDto.setCityCode(orderAddrEo.getCityCode());
        contactDto.setDistrict(orderAddrEo.getCounty());
        contactDto.setDistrictCode(orderAddrEo.getCountyCode());
        contactDto.setPostalCode(orderAddrEo.getPostcode());
        contactDto.setCustomerCode(saleOrderEo.getCustomerCode());
        contactDto.setDetailAddress(orderAddrEo.getReceiveAddress());
        contactDto.setContacts(orderAddrEo.getReceiveName());
        contactDto.setPhone(orderAddrEo.getReceivePhone());
        String fullAddress = String.format("%s%s%s%s", orderAddrEo.getProvince(), orderAddrEo.getCity(), orderAddrEo.getCounty(), orderAddrEo.getReceiveAddress());
        contactDto.setAddress(fullAddress);
        deliveryNoticeOrderAddReqDto.setContactDto(contactDto);
        double sum = orderItemEos.stream().map(DgSaleOrderItemEo::getItemNum).mapToDouble(BigDecimal::doubleValue).sum();
        deliveryNoticeOrderAddReqDto.setTotalQuantity(new BigDecimal(sum));
        ArrayList detailAddReqDtoList = Lists.newArrayList();
        for (DgSaleOrderItemEo item : orderItemEos) {
            CsDeliveryNoticeOrderDetailAddReqDto dto = new CsDeliveryNoticeOrderDetailAddReqDto();
            dto.setBatch(item.getBatchNo());
            dto.setPlanQuantity(item.getItemNum());
            dto.setLongCode(item.getSkuCode());
            dto.setTradeOrderItemId(item.getId());
            detailAddReqDtoList.add(dto);
            deliveryNoticeOrderAddReqDto.setWarehouseCode(item.getLogicalWarehouseCode());
        }
        deliveryNoticeOrderAddReqDto.setDetailAddReqDtoList((List)detailAddReqDtoList);
        return deliveryNoticeOrderAddReqDto;
    }

    @Override
    public List<CsLogicWarehousePageRespDto> queryCsLogicWarehousePageRespDtoListByCodeList(List<String> codeList) {
        CsLogicWarehousePageQueryDto pageQueryDto = new CsLogicWarehousePageQueryDto();
        pageQueryDto.setPageNum(Integer.valueOf(1));
        pageQueryDto.setPageSize(Integer.valueOf(codeList.size()));
        pageQueryDto.setWarehouseCodeList(codeList.stream().collect(Collectors.toSet()));
        this.logger.info("\u6839\u636e\u903b\u8f91\u4ed3\u7f16\u7801\u83b7\u53d6\u903b\u8f91\u4ed3\u5e93\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)pageQueryDto));
        PageInfo csLogicWarehousePageRespDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.csLogicWarehouseExposedQueryApi.queryPageInfo(pageQueryDto));
        return csLogicWarehousePageRespDtoPageInfo.getList();
    }

    @Override
    public List<DgLogicWarehouseDto> queryLogicWarehouseByCodes(List<String> codeList) {
        DgLogicWarehousePageReqDto csLogicWarehouseParamQueryDto = new DgLogicWarehousePageReqDto();
        csLogicWarehouseParamQueryDto.setWarehouseCodes((List)Lists.newArrayList(codeList));
        this.logger.info("[\u62a5\u8868\u4e2d\u5fc3\u63a5\u53e3]\u6839\u636e\u903b\u8f91\u4ed3\u7f16\u7801\u83b7\u53d6\u903b\u8f91\u4ed3\u5e93\u5217\u8868\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)csLogicWarehouseParamQueryDto));
        List csLogicWarehousePageRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgLogicWarehouseApi.queryList(csLogicWarehouseParamQueryDto));
        return csLogicWarehousePageRespDtos;
    }

    @Override
    public List<MaiyouWarehouseAreaMappingRespDto> queryMaiyouMappingByLogicWarehouse(String allotInWarehouseCode, List<String> warehouseCodeList) {
        MaiyouWarehouseAreaMappingPageReqDto maiyouMappingPageDto = new MaiyouWarehouseAreaMappingPageReqDto();
        maiyouMappingPageDto.setPageNum(Integer.valueOf(1));
        maiyouMappingPageDto.setStatus(YesOrNoEnum.YES.getType());
        maiyouMappingPageDto.setPageSize(Integer.valueOf(warehouseCodeList.size() * 2));
        maiyouMappingPageDto.setTransferInLogicalWarehouseCode(allotInWarehouseCode);
        maiyouMappingPageDto.setTransferOutLogicalWarehouseCodeList(warehouseCodeList);
        this.logger.info("\u6839\u636e\u8c03\u5165\u4ed3+\u8c03\u51fa\u903b\u8f91\u4ed3\u67e5\u8be2\u53d1\u8d27\u914d\u7f6e={}", JSON.toJSON((Object)maiyouMappingPageDto));
        PageInfo maiyouLogicMappingPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.maiyouWarehouseAreaMappingApiProxy.page(maiyouMappingPageDto));
        return maiyouLogicMappingPage.getList();
    }

    @Override
    public List<MaiyouWarehouseAreaMappingRespDto> queryMaiyouMappingByPhysicsWarehouse(String allotInWarehouseCode, List<String> physicsWarehouseCodeList) {
        MaiyouWarehouseAreaMappingPageReqDto maiyouMappingPageDto = new MaiyouWarehouseAreaMappingPageReqDto();
        maiyouMappingPageDto.setPageNum(Integer.valueOf(1));
        maiyouMappingPageDto.setStatus(YesOrNoEnum.YES.getType());
        maiyouMappingPageDto.setPageSize(Integer.valueOf(physicsWarehouseCodeList.size() * 2));
        maiyouMappingPageDto.setTransferInLogicalWarehouseCode(allotInWarehouseCode);
        maiyouMappingPageDto.setDeliveryPhysicalWarehouseCodeList(physicsWarehouseCodeList);
        this.logger.info("\u6839\u636e\u8c03\u5165\u4ed3+\u8c03\u51fa\u7269\u7406\u4ed3\u67e5\u8be2\u53d1\u8d27\u914d\u7f6e={}", JSON.toJSON((Object)maiyouMappingPageDto));
        PageInfo maiyouLogicMappingPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.maiyouWarehouseAreaMappingApiProxy.page(maiyouMappingPageDto));
        return maiyouLogicMappingPage.getList();
    }

    @Override
    public CsTransferOrderComboReqDto getSaleOrderToTransferOrder(DgSaleOrderEo saleOrderEo, List<DgSaleOrderItemEo> orderItemEos, CsLogicWarehousePageRespDto outLogicDto, CsLogicWarehousePageRespDto inLogicDto, CsLogicWarehousePageRespDto centerLogicDto, SplitOrderBySourceInfoReqDto splitOrderBySourceInfoReqDto) {
        String type;
        if (Objects.isNull(outLogicDto)) {
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u51fa\u903b\u8f91\u4ed3\u4fe1\u606f\u4e3a\u7a7a"});
        }
        if (Objects.isNull(inLogicDto)) {
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u8c03\u5165\u903b\u8f91\u4ed3\u4fe1\u606f\u4e3a\u7a7a"});
        }
        CsTransferOrderReqDto csTransferOrderReqDto = new CsTransferOrderReqDto();
        csTransferOrderReqDto.setSaleOrderNo(saleOrderEo.getSaleOrderNo());
        String string = type = Objects.nonNull(saleOrderEo.getAllotType()) ? saleOrderEo.getAllotType() : CsInventorySourceTypeEnum.ALLOT_SALE.getCode();
        if (Objects.equals(type, AllotTypeEnum.MAIYOU_CC_ALLOT.getType()) || Objects.equals(type, AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType())) {
            type = CsPcpBusinessTypeEnum.CC_ALLOT.getCode();
        }
        if (Objects.equals(type, AllotTypeEnum.MAIYOU_BC_ALLOT.getType())) {
            type = CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode();
            if (Objects.nonNull(centerLogicDto)) {
                csTransferOrderReqDto.setNextType(CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode());
                type = CsPcpBusinessTypeEnum.MAIYOU_ALLOT_OUT.getCode();
            }
        }
        csTransferOrderReqDto.setType(type);
        csTransferOrderReqDto.setTransferOrderNo(this.getBcOrCcTransferNo(type, outLogicDto, inLogicDto));
        csTransferOrderReqDto.setOutLogicWarehouseCode(outLogicDto.getWarehouseCode());
        csTransferOrderReqDto.setOutLogicWarehouseName(outLogicDto.getWarehouseName());
        csTransferOrderReqDto.setInLogicWarehouseCode(inLogicDto.getWarehouseCode());
        csTransferOrderReqDto.setInLogicWarehouseName(inLogicDto.getWarehouseName());
        csTransferOrderReqDto.setOutOrganization(outLogicDto.getCargoEscheatageName());
        AssertUtils.notNull((Object)outLogicDto.getCargoEscheatageId(), (String)"\u8c03\u51fa\u5e93\u4ed3\u8d27\u6743\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        csTransferOrderReqDto.setOutOrganizationId(Long.valueOf(outLogicDto.getOrganizationId()));
        csTransferOrderReqDto.setInOrganization(inLogicDto.getCargoEscheatageName());
        AssertUtils.notNull((Object)inLogicDto.getCargoEscheatageId(), (String)"\u8c03\u5165\u5e93\u4ed3\u8d27\u6743\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        csTransferOrderReqDto.setInOrganizationId(Long.valueOf(inLogicDto.getOrganizationId()));
        csTransferOrderReqDto.setInPhysicsWarehouseCode(inLogicDto.getSubordinatePhysicsWarehouseCode());
        csTransferOrderReqDto.setInPhysicsWarehouseName(inLogicDto.getSubordinatePhysicsWarehouseName());
        csTransferOrderReqDto.setOutPhysicsWarehouseCode(outLogicDto.getSubordinatePhysicsWarehouseCode());
        csTransferOrderReqDto.setOutPhysicsWarehouseName(outLogicDto.getSubordinatePhysicsWarehouseName());
        csTransferOrderReqDto.setPlanInTime(new Date());
        csTransferOrderReqDto.setPlanOutTime(csTransferOrderReqDto.getPlanInTime());
        csTransferOrderReqDto.setSourceSystem(CsSourceSystemEnum.PCP.getCode());
        csTransferOrderReqDto.setTotalQuantity(orderItemEos.stream().map(DgSaleOrderItemEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        csTransferOrderReqDto.setIntransitPreemptFlag(splitOrderBySourceInfoReqDto.getIntransitPreemptFlag());
        if (Objects.nonNull(centerLogicDto)) {
            csTransferOrderReqDto.setInLogicWarehouseCode(centerLogicDto.getWarehouseCode());
            csTransferOrderReqDto.setInLogicWarehouseName(centerLogicDto.getWarehouseName());
            csTransferOrderReqDto.setInOrganization(centerLogicDto.getCargoEscheatageName());
            csTransferOrderReqDto.setInOrganizationId(Long.valueOf(centerLogicDto.getOrganizationId()));
            csTransferOrderReqDto.setInPhysicsWarehouseCode(centerLogicDto.getSubordinatePhysicsWarehouseCode());
            csTransferOrderReqDto.setInPhysicsWarehouseName(centerLogicDto.getSubordinatePhysicsWarehouseName());
            csTransferOrderReqDto.setNextLogicWarehouseCode(inLogicDto.getWarehouseCode());
            csTransferOrderReqDto.setNextPhysicsWarehouseCode(inLogicDto.getSubordinatePhysicsWarehouseCode());
        }
        Map<String, Boolean> saleItemInMap = splitOrderBySourceInfoReqDto.getGoodsList().stream().collect(Collectors.toMap(SplitOrderItemReqDto::getGoodsSku, result -> Objects.nonNull(result.getZtDeliveryWarehouseItemNum()) && result.getZtDeliveryWarehouseItemNum().compareTo(BigDecimal.ZERO) > 0, (k1, k2) -> k1 != false ? k1 : k2));
        Map<String, List<DgSaleOrderItemEo>> collect = orderItemEos.stream().collect(Collectors.groupingBy(DgSaleOrderItemEo::getSkuCode));
        ArrayList detailList = new ArrayList();
        collect.forEach((key, value) -> {
            CsTransferOrderDetailReqDto detailReqDto = new CsTransferOrderDetailReqDto();
            detailReqDto.setCargoId(((DgSaleOrderItemEo)value.get(0)).getItemId());
            detailReqDto.setCargoCode(((DgSaleOrderItemEo)value.get(0)).getSkuCode());
            detailReqDto.setLongCode(((DgSaleOrderItemEo)value.get(0)).getSkuCode());
            detailReqDto.setCargoName(((DgSaleOrderItemEo)value.get(0)).getItemName());
            detailReqDto.setQuantity(value.stream().map(DgSaleOrderItemEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            if (Objects.nonNull(saleItemInMap) && saleItemInMap.containsKey(key)) {
                detailReqDto.setIntransitPreemptFlag((Boolean)saleItemInMap.get(key));
            }
            detailReqDto.setVolume(value.stream().map(DgSaleOrderItemEo::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add));
            detailReqDto.setWeight(value.stream().map(DgSaleOrderItemEo::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add));
            detailList.add(detailReqDto);
        });
        CsTransferOrderComboReqDto comboReqDto = new CsTransferOrderComboReqDto();
        comboReqDto.setCsOtherStorageOrderReqDto(csTransferOrderReqDto);
        comboReqDto.setDetailList(detailList);
        return comboReqDto;
    }

    public String getBcOrCcTransferNo(String type, CsLogicWarehousePageRespDto outLogicDto, CsLogicWarehousePageRespDto inLogicDto) {
        String no = "";
        if (CsPcpBusinessTypeEnum.MAIYOU_BC_ALLOT.getCode().equals(type) || CsPcpBusinessTypeEnum.CC_ALLOT.getCode().equals(type)) {
            this.logger.info("inLogicDto: {}", JSON.toJSON((Object)inLogicDto));
            this.logger.info("outLogicDto: {}", JSON.toJSON((Object)outLogicDto));
            no = !StringUtils.equals((CharSequence)inLogicDto.getOrganizationCode(), (CharSequence)outLogicDto.getOrganizationCode()) ? (String)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApiProxy.getBcOrCcTransferNo(type)) : (String)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.getTransferOrderNo());
        } else {
            no = (String)RestResponseHelper.extractData((RestResponse)this.csTransferOrderApi.getTransferOrderNo());
        }
        return no;
    }

    @Override
    public void batchCancelLogicAndPhysicsOrder(List<String> cancelLogicOrderNoList, List<String> cancelPhysicsOrderNoList) {
        BatchCancelLogicAndPhysicsOrderReqDto cancelLogicAndPhysicsOrderReqDto = new BatchCancelLogicAndPhysicsOrderReqDto();
        cancelLogicAndPhysicsOrderReqDto.setCancelLogicOrderNoList(cancelLogicOrderNoList);
        cancelLogicAndPhysicsOrderReqDto.setCancelPhysicsOrderNoList(cancelPhysicsOrderNoList);
        this.logger.info("\u6279\u91cf\u53d6\u6d88\u53d1\u8d27\u901a\u77e5\u5355\u548c\u51fa\u5e93\u901a\u77e5\u5355\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)cancelLogicAndPhysicsOrderReqDto));
        RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApiProxy.batchCancelLogicAndPhysicsOrder(cancelLogicAndPhysicsOrderReqDto));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchReleaseInventory(List<SaleOrderRespDto> orderRespDtos) {
        for (final SaleOrderRespDto orderRespDto : orderRespDtos) {
            if (Objects.equals(orderRespDto.getOrderStatus(), SaleOrderStatusEnum.SPLIT.getCode())) {
                this.logger.info("\u88ab\u62c6\u5206\u8ba2\u5355\u4e0d\u9700\u8981\u91ca\u653e\u5e93\u5b58");
                continue;
            }
            if (Objects.equals(orderRespDto.getOrderType(), SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType())) {
                this.logger.info("\u5b50\u516c\u53f8\u76f4\u9500\u8ba2\u5355\u4e0d\u9700\u8981\u91ca\u653e\u5e93\u5b58");
                continue;
            }
            final String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                public void afterCommit() {
                    executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            MDC.put((String)"yes.req.requestId", (String)reqId);
                            ServiceContext.getContext().setAttachment("yes.req.requestId", reqId);
                            Boolean isShoutLogicWarehouse = false;
                            try {
                                BInventoryApiServcieImpl.this.logger.info("[\u91ca\u653e\u5e93\u5b58]\u8ba2\u5355\u5df2\u4f5c\u5e9f\uff0c\u8ba2\u5355\u53f7\u4e3a\uff1a{}", (Object)orderRespDto.getSaleOrderNo());
                                BInventoryApiServcieImpl.this.releaseInventory(orderRespDto.getSaleOrderNo(), orderRespDto.getPlatformOrderNo(), orderRespDto.getOrderType(), isShoutLogicWarehouse, orderRespDto.getMainOrderNo());
                            }
                            catch (Exception e) {
                                BInventoryApiServcieImpl.this.logger.error("[\u91ca\u653e\u5e93\u5b58]\u5931\u8d25\uff1a{},{}", (Object)e.getMessage(), (Object)e);
                                TrackOptLogUtils.addOrderTrackOptLog((Long)orderRespDto.getId(), (String)("\u4f5c\u5e9f\u8ba2\u5355\u91ca\u653e\u6e20\u9053\u4ed3\u5e93\u5b58\u5931\u8d25:" + e.getMessage()));
                            }
                        }
                    });
                }
            });
        }
    }

    public List<IntransitCargoRespDto> queryZtCargoBatchNum(List<String> warehouseCodes, List<String> skuCodes, Integer configDay) {
        if (CollectionUtils.isEmpty(warehouseCodes)) {
            this.logger.info("\u5728\u9014\u4ed3\u7f16\u7801\u96c6\u5408\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        List warehouseInventoryVoList = Lists.newArrayList();
        IntransitCargoQueryDto queryDto = new IntransitCargoQueryDto();
        queryDto.setLogicWarehouseCodes(warehouseCodes);
        queryDto.setCargoCodes(skuCodes);
        queryDto.setConfigDay(configDay);
        try {
            this.logger.info("\u67e5\u8be2\u5728\u9014\u4ed3\u5e93\u5b58\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)queryDto));
            warehouseInventoryVoList = (List)RestResponseHelper.extractData((RestResponse)this.outResultOrderQueryApiProxy.queryIntransitCargoNum(queryDto));
            this.logger.info("\u83b7\u53d6\u5728\u9014\u4ed3\u5e93\u5b58\u7ed3\u679c==>{}", (Object)JSON.toJSONString((Object)warehouseInventoryVoList));
            if (CollectionUtils.isEmpty((Collection)warehouseInventoryVoList)) {
                return warehouseInventoryVoList;
            }
        }
        catch (BizException e) {
            this.logger.info(e.getMessage(), (Throwable)e);
        }
        return warehouseInventoryVoList;
    }

    @Override
    public void preemptAndReleaseStock(List<DgBizSaleOrderRespDto> preemptOrderList, List<SaleOrderRespDto> releaseOrderList) {
        UpdatePreemptDto shUpdatePreemptParam = new UpdatePreemptDto();
        ArrayList preemptParamList = Lists.newArrayList();
        for (DgBizSaleOrderRespDto bizSaleOrderRespDto : preemptOrderList) {
            PreemptDto preemptParam = new PreemptDto();
            preemptParam.setSourceNo(bizSaleOrderRespDto.getSaleOrderNo());
            preemptParam.setSourceType(bizSaleOrderRespDto.getOrderType());
            preemptParam.setExternalOrderNo(bizSaleOrderRespDto.getPlatformOrderNo());
            preemptParam.setValidNegative(Boolean.FALSE);
            this.logger.info("AllowSplitFlag==>{},StoragePlace==>{}", (Object)bizSaleOrderRespDto.getAllowSplitFlag(), (Object)bizSaleOrderRespDto.getStoragePlace());
            if (Objects.equals(bizSaleOrderRespDto.getAllowSplitFlag(), YesOrNoEnum.NO.getType()) && StringUtils.isNotBlank((CharSequence)bizSaleOrderRespDto.getStoragePlace())) {
                preemptParam.setIsShoutVirtualWarehouse(Boolean.TRUE);
                preemptParam.setShoutVirtualWarehouseCode(bizSaleOrderRespDto.getStoragePlace());
            }
            List itemList = bizSaleOrderRespDto.getItemList();
            List detailParams = itemList.stream().map(saleOrderItemEo -> {
                OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
                inventoryOperateCargoReqDto.setSkuCode(saleOrderItemEo.getSkuCode());
                inventoryOperateCargoReqDto.setNum(saleOrderItemEo.getItemNum());
                inventoryOperateCargoReqDto.setWarehouseCode(saleOrderItemEo.getChannelWarehouseCode());
                return inventoryOperateCargoReqDto;
            }).collect(Collectors.toList());
            preemptParam.setDetails(detailParams);
            preemptParamList.add(preemptParam);
        }
        shUpdatePreemptParam.setPreemptParamList((List)preemptParamList);
        ArrayList releasePreemptParamList = Lists.newArrayList();
        for (SaleOrderRespDto saleOrderRespDto : releaseOrderList) {
            ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
            releasePreemptDto.setSourceNo(saleOrderRespDto.getSaleOrderNo());
            releasePreemptDto.setSourceType(saleOrderRespDto.getOrderType());
            releasePreemptDto.setExternalOrderNo(saleOrderRespDto.getPlatformOrderNo());
            releasePreemptParamList.add(releasePreemptDto);
        }
        shUpdatePreemptParam.setReleasePreemptParamList((List)releasePreemptParamList);
        this.logger.info("\u9884\u5360\u91ca\u653e\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)shUpdatePreemptParam));
        RestResponseHelper.extractData((RestResponse)this.channelInventoryExposedApiProxy.updatePreempt(shUpdatePreemptParam));
    }

    @Override
    public void cancelPhysicsOrder(String orderNo) {
        RestResponseHelper.checkOrThrow((RestResponse)this.logicInventoryExposedApiProxy.cancelPhysicsOrder(orderNo));
    }

    @Override
    public void cancelLogicOrder(String orderNo) {
        RestResponseHelper.checkOrThrow((RestResponse)this.logicInventoryExposedApiProxy.cancelLogicOrder(orderNo));
    }

    @Override
    public List<CsLogicWarehouseRespDto> queryByCode(String warehouseCode) {
        List csLogicWarehouseRespDtos = Lists.newArrayList();
        try {
            csLogicWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.virtualWarehouseQueryApi.queryLogicWarehouse(warehouseCode));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)csLogicWarehouseRespDtos)) {
            return csLogicWarehouseRespDtos;
        }
        return csLogicWarehouseRespDtos;
    }

    @Override
    public void supplyByChannelWarehouseCode(String channelWarehouseCode, List<String> cargoCodes) {
        this.logger.info("\u901a\u8fc7\u6e20\u9053\u4ed3\u7f16\u7801\u548c\u8d27\u54c1\u7f16\u7801\u5237\u65b0\u6e20\u9053\u4ed3\u5e93\u5b58={},{}", (Object)channelWarehouseCode, JSON.toJSON(cargoCodes));
        RestResponseHelper.checkOrThrow((RestResponse)this.channelInventoryExposedApiProxy.supplyByChannelWarehouseCode(channelWarehouseCode, cargoCodes));
    }
}

