/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderLabelItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderLabelRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderLabelReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelBaseRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelRelationRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelRelationsItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelRelationsRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderLabelRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLabelDomain;
import com.yunxi.dg.base.center.trade.eo.OrderLabelEo;
import com.yunxi.dg.base.center.trade.service.tc.IOrderLabelItemService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderLabelRecordService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderLabelService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderLabelServiceImpl
implements IOrderLabelService {
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IOrderLabelDomain orderLabelDomain;
    @Resource
    private IOrderLabelItemService orderLabelItemService;
    @Resource
    private IOrderLabelRecordService orderLabelRecordService;

    @Override
    public Long addOrderLabel(OrderLabelReqDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto.getLabelName(), (String)"\u6807\u7b7e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        OrderLabelEo orderLabelEo = new OrderLabelEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)orderLabelEo);
        orderLabelEo.setLabelCode(this.noGreateUtil.generateLabelNo());
        this.orderLabelDomain.insert((BaseEo)orderLabelEo);
        return orderLabelEo.getId();
    }

    @Override
    public void modifyOrderLabel(OrderLabelReqDto modifyReqDto) {
        OrderLabelEo orderLabelEo = new OrderLabelEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)orderLabelEo);
        this.orderLabelDomain.updateSelective((BaseEo)orderLabelEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeOrderLabel(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.orderLabelDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public OrderLabelRespDto queryById(Long id) {
        OrderLabelEo orderLabelEo = (OrderLabelEo)this.orderLabelDomain.selectByPrimaryKey(id);
        OrderLabelRespDto orderLabelRespDto = new OrderLabelRespDto();
        DtoHelper.eo2Dto((BaseEo)orderLabelEo, (BaseVo)orderLabelRespDto);
        return orderLabelRespDto;
    }

    @Override
    public PageInfo<OrderLabelRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        OrderLabelReqDto orderLabelReqDto = (OrderLabelReqDto)JSON.parseObject((String)filter, OrderLabelReqDto.class);
        OrderLabelEo orderLabelEo = new OrderLabelEo();
        DtoHelper.dto2Eo((BaseVo)orderLabelReqDto, (BaseEo)orderLabelEo);
        orderLabelEo.setOrderByDesc("update_time");
        PageInfo eoPageInfo = this.orderLabelDomain.selectPage((BaseEo)orderLabelEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, OrderLabelRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public OrderLabelRelationRespDto queryByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OrderLabelReqDto orderLabelReqDto = new OrderLabelReqDto();
        orderLabelReqDto.setOrderIds(Arrays.asList(orderId));
        OrderLabelRelationsRespDto relationsRespDto = this.queryOrderLabelRelations(orderLabelReqDto);
        if (Objects.isNull(relationsRespDto.getOrderLabelRecordMaps()) && Objects.isNull(relationsRespDto.getOrderLabelItemMaps())) {
            return null;
        }
        OrderLabelRelationRespDto relationRespDto = new OrderLabelRelationRespDto();
        if (Objects.nonNull(relationsRespDto.getOrderLabelRecordMaps())) {
            relationRespDto.setOrderLabelRecords((List)relationsRespDto.getOrderLabelRecordMaps().get(orderId.toString()));
        }
        if (Objects.nonNull(relationsRespDto.getOrderLabelItemMaps())) {
            relationRespDto.setOrderLabelItems((List)relationsRespDto.getOrderLabelItemMaps().get(orderId.toString()));
        }
        return relationRespDto;
    }

    @Override
    public OrderLabelRelationsRespDto queryOrderLabelRelations(OrderLabelReqDto orderLabelReqDto) {
        AssertUtils.notNull((Object)orderLabelReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Map<String, List<OrderLabelRespDto>> orderLabelRecordMaps = this.queryOrderLabelRecord(orderLabelReqDto);
        Map<String, List<OrderLabelRespDto>> orderLabelItemMaps = this.queryOrderLabelItem(orderLabelReqDto);
        OrderLabelRelationsRespDto relationRespDto = new OrderLabelRelationsRespDto();
        relationRespDto.setOrderLabelRecordMaps(orderLabelRecordMaps);
        relationRespDto.setOrderLabelItemMaps(orderLabelItemMaps);
        return relationRespDto;
    }

    @Override
    public OrderLabelRelationsItemRespDto queryOrderLabelRecordExt(OrderLabelReqDto orderLabelReqDto) {
        OrderLabelRelationsItemRespDto relationsItemRespDto = new OrderLabelRelationsItemRespDto();
        Map<String, List<OrderLabelRespDto>> recordMaps = this.queryOrderLabelRecord(orderLabelReqDto);
        if (recordMaps.isEmpty()) {
            return null;
        }
        relationsItemRespDto.setOrderLabelItemMaps(recordMaps);
        if (CollectionUtils.isNotEmpty((Collection)orderLabelReqDto.getLabelCodes())) {
            HashMap codeExistMaps = Maps.newHashMap();
            ArrayList orderLabelRespDtos = Lists.newArrayList();
            recordMaps.entrySet().stream().forEach(e -> orderLabelRespDtos.addAll((Collection)e.getValue()));
            List labelCodes = orderLabelRespDtos.stream().map(OrderLabelRespDto::getLabelCode).distinct().collect(Collectors.toList());
            orderLabelReqDto.getLabelCodes().forEach(e -> {
                boolean codeExist = false;
                if (labelCodes.contains(e)) {
                    codeExist = true;
                }
                codeExistMaps.put(e, codeExist);
            });
            relationsItemRespDto.setCodeExistMaps((Map)codeExistMaps);
        }
        return relationsItemRespDto;
    }

    @Override
    public Map<String, List<OrderLabelRespDto>> queryOrderLabelRecord(OrderLabelReqDto orderLabelReqDto) {
        AssertUtils.notNull((Object)orderLabelReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OrderLabelRecordReqDto orderLabelRecordReqDto = new OrderLabelRecordReqDto();
        CubeBeanUtils.copyProperties((Object)orderLabelRecordReqDto, (Object)orderLabelReqDto, (String[])new String[0]);
        List<OrderLabelRecordRespDto> orderLabelRecordList = this.orderLabelRecordService.queryByParam(orderLabelRecordReqDto);
        List<String> labelCodes = this.getLabelCodes(orderLabelRecordList);
        if (CollectionUtils.isEmpty(labelCodes)) {
            return null;
        }
        OrderLabelReqDto reqDto = new OrderLabelReqDto();
        reqDto.setLabelCodes(labelCodes);
        List<OrderLabelRespDto> orderLabelRespDtos = this.queryByParam(reqDto);
        if (CollectionUtils.isEmpty(orderLabelRespDtos)) {
            return null;
        }
        Map prototypeMaps = orderLabelRespDtos.stream().collect(Collectors.toMap(OrderLabelRespDto::getLabelCode, Function.identity()));
        Map<Long, List<OrderLabelRecordRespDto>> recordMaps = Optional.ofNullable(orderLabelRecordList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(OrderLabelBaseRespDto::getOrderId));
        Map<String, List<OrderLabelRespDto>> orderLabelRecordMaps = recordMaps.entrySet().stream().collect(Collectors.toMap(map -> ((Long)map.getKey()).toString(), map -> this.convertLabel((List)map.getValue(), prototypeMaps)));
        return orderLabelRecordMaps;
    }

    @Override
    public OrderLabelRelationsItemRespDto queryOrderLabelItemExt(OrderLabelReqDto orderLabelReqDto) {
        OrderLabelRelationsItemRespDto relationsItemRespDto = new OrderLabelRelationsItemRespDto();
        Map<String, List<OrderLabelRespDto>> recordMaps = this.queryOrderLabelItem(orderLabelReqDto);
        if (recordMaps.isEmpty()) {
            return null;
        }
        relationsItemRespDto.setOrderLabelItemMaps(recordMaps);
        if (CollectionUtils.isNotEmpty((Collection)orderLabelReqDto.getLabelCodes())) {
            HashMap codeExistMaps = Maps.newHashMap();
            ArrayList orderLabelRespDtos = Lists.newArrayList();
            recordMaps.entrySet().stream().forEach(e -> orderLabelRespDtos.addAll((Collection)e.getValue()));
            List labelCodes = orderLabelRespDtos.stream().map(OrderLabelRespDto::getLabelCode).distinct().collect(Collectors.toList());
            orderLabelReqDto.getLabelCodes().forEach(e -> {
                boolean codeExist = false;
                if (labelCodes.contains(e)) {
                    codeExist = true;
                }
                codeExistMaps.put(e, codeExist);
            });
            relationsItemRespDto.setCodeExistMaps((Map)codeExistMaps);
        }
        return relationsItemRespDto;
    }

    @Override
    public Map<String, List<OrderLabelRespDto>> queryOrderLabelItem(OrderLabelReqDto orderLabelReqDto) {
        AssertUtils.notNull((Object)orderLabelReqDto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        OrderLabelItemReqDto orderLabelItemReqDto = new OrderLabelItemReqDto();
        CubeBeanUtils.copyProperties((Object)orderLabelItemReqDto, (Object)orderLabelReqDto, (String[])new String[0]);
        List<OrderLabelItemRespDto> orderLabelItemList = this.orderLabelItemService.queryByParam(orderLabelItemReqDto);
        List<String> labelCodes = this.getLabelCodes(orderLabelItemList);
        if (CollectionUtils.isEmpty(labelCodes)) {
            return null;
        }
        OrderLabelReqDto reqDto = new OrderLabelReqDto();
        reqDto.setLabelCodes(labelCodes);
        List<OrderLabelRespDto> orderLabelRespDtos = this.queryByParam(reqDto);
        if (CollectionUtils.isEmpty(orderLabelRespDtos)) {
            return null;
        }
        Map prototypeMaps = orderLabelRespDtos.stream().collect(Collectors.toMap(OrderLabelRespDto::getLabelCode, Function.identity()));
        Map<Long, List<OrderLabelItemRespDto>> itemMaps = Optional.ofNullable(orderLabelItemList).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(OrderLabelBaseRespDto::getOrderId));
        Map<String, List<OrderLabelRespDto>> orderLabelItemMaps = itemMaps.entrySet().stream().collect(Collectors.toMap(map -> ((Long)map.getKey()).toString(), map -> this.convertLabel((List)map.getValue(), prototypeMaps)));
        return orderLabelItemMaps;
    }

    public OrderLabelRespDto queryByOrderLabel(OrderLabelReqDto orderLabelReqDto) {
        OrderLabelEo orderLabelEo = new OrderLabelEo();
        orderLabelEo.setDr(0);
        this.param(orderLabelEo, orderLabelReqDto);
        OrderLabelEo eo = (OrderLabelEo)this.orderLabelDomain.selectOne((BaseEo)orderLabelEo);
        if (Objects.isNull(eo)) {
            return null;
        }
        OrderLabelRespDto orderLabelRespDto = new OrderLabelRespDto();
        DtoHelper.eo2Dto((BaseEo)eo, (BaseVo)orderLabelRespDto);
        return orderLabelRespDto;
    }

    public List<OrderLabelRespDto> queryByParam(OrderLabelReqDto orderLabelReqDto) {
        OrderLabelEo orderLabelEo = new OrderLabelEo();
        orderLabelEo.setDr(0);
        this.param(orderLabelEo, orderLabelReqDto);
        List orderLabelEos = this.orderLabelDomain.selectList((BaseEo)orderLabelEo);
        if (CollectionUtils.isEmpty((Collection)orderLabelEos)) {
            return null;
        }
        ArrayList<OrderLabelRespDto> dtoList = new ArrayList<OrderLabelRespDto>();
        DtoHelper.eoList2DtoList((Collection)orderLabelEos, dtoList, OrderLabelRespDto.class);
        return dtoList;
    }

    private void param(OrderLabelEo orderLabelEo, OrderLabelReqDto orderLabelReqDto) {
        ArrayList orderSqlFilter = Lists.newArrayList();
        if (Objects.nonNull(orderLabelReqDto.getId())) {
            orderLabelEo.setId(orderLabelReqDto.getId());
        }
        if (Objects.nonNull(orderLabelReqDto.getLabelStatus())) {
            orderLabelEo.setLabelStatus(orderLabelReqDto.getLabelStatus());
        }
        if (Objects.nonNull(orderLabelReqDto.getLabelType())) {
            orderLabelEo.setLabelType(orderLabelReqDto.getLabelType());
        }
        if (Objects.nonNull(orderLabelReqDto.getLabelCode())) {
            orderSqlFilter.add(SqlFilter.like((String)"label_code", (Object)orderLabelReqDto.getLabelCode()));
        }
        if (Objects.nonNull(orderLabelReqDto.getLabelName())) {
            orderSqlFilter.add(SqlFilter.like((String)"label_name", (Object)orderLabelReqDto.getLabelName()));
        }
        if (Objects.nonNull(orderLabelReqDto.getUpdateStartTime()) && Objects.nonNull(orderLabelReqDto.getUpdateEndTime())) {
            orderSqlFilter.add(SqlFilter.ge((String)"updateTime", (Object)orderLabelReqDto.getUpdateStartTime()));
            orderSqlFilter.add(SqlFilter.le((String)"updateTime", (Object)orderLabelReqDto.getUpdateEndTime()));
        }
        if (CollectionUtils.isNotEmpty((Collection)orderLabelReqDto.getLabelCodes())) {
            orderSqlFilter.add(SqlFilter.in((String)"label_code", (Object)orderLabelReqDto.getLabelCodes()));
        }
        orderLabelEo.setSqlFilters((List)orderSqlFilter);
    }

    private List<String> getLabelCodes(List<? extends OrderLabelBaseRespDto> ... orderLabelRecordList) {
        ArrayList labelCodes = Lists.newArrayList();
        for (List<? extends OrderLabelBaseRespDto> orderLabelBaseResp : orderLabelRecordList) {
            List labelCodeList = Optional.ofNullable(orderLabelBaseResp).orElse(Lists.newArrayList()).stream().map(OrderLabelBaseRespDto::getLabelCode).collect(Collectors.toList());
            labelCodes.addAll(labelCodeList);
        }
        return labelCodes;
    }

    private List<OrderLabelRespDto> convertLabel(List<? extends OrderLabelBaseRespDto> orderLabelBaseRespDtos, Map<String, OrderLabelRespDto> orderLabelRespDtoMaps) {
        return orderLabelBaseRespDtos.stream().map(e -> {
            if (orderLabelRespDtoMaps.containsKey(e.getLabelCode())) {
                OrderLabelRespDto orderLabelRespDto = (OrderLabelRespDto)orderLabelRespDtoMaps.get(e.getLabelCode());
                OrderLabelRespDto newOrderLabel = new OrderLabelRespDto();
                CubeBeanUtils.copyProperties((Object)newOrderLabel, (Object)orderLabelRespDto, (String[])new String[0]);
                newOrderLabel.setOrderId(e.getOrderId());
                if (e instanceof OrderLabelItemRespDto) {
                    newOrderLabel.setSkuCode(((OrderLabelItemRespDto)e).getSkuCode());
                }
                return newOrderLabel;
            }
            return null;
        }).collect(Collectors.toList());
    }
}

