/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.track;

import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.anno.LogIgnore;
import com.yunxi.dg.base.center.trade.anno.OperationType;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationTypeHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationTypeHelper.class);
    private static final Map<String, OperationTypeMetadata> OPERATIONTYPECACHE = Maps.newHashMap();
    private static Object operationTypecacheLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperationTypeMetadata getOperationType(String nodeApiClass, String nodeApiMethod) {
        String operationTypeKey = nodeApiClass + "#" + nodeApiMethod;
        OperationTypeMetadata cacheOperationTypeMetadata = OPERATIONTYPECACHE.get(operationTypeKey);
        if (cacheOperationTypeMetadata != null) {
            return cacheOperationTypeMetadata;
        }
        OperationTypeMetadata methodOperationType = OperationTypeHelper.getMethodOperationType(nodeApiClass, nodeApiMethod);
        Object object = operationTypecacheLock;
        synchronized (object) {
            OPERATIONTYPECACHE.put(operationTypeKey, methodOperationType);
        }
        return methodOperationType;
    }

    private static OperationTypeMetadata getMethodOperationType(String nodeApiClass, String nodeApiMethod) {
        OperationTypeMetadata operationTypeMetadata = new OperationTypeMetadata();
        operationTypeMetadata.setClassName(nodeApiClass);
        operationTypeMetadata.setMethodName(nodeApiMethod);
        try {
            Class<?> apiClass = Class.forName(nodeApiClass);
            Method[] methods = apiClass.getMethods();
            Class<?>[] interfaces = apiClass.getInterfaces();
            Class<?> anInterface = interfaces[0];
            Method[] interfaceMethods = anInterface.getMethods();
            Map interfaceMethodMap = Arrays.stream(interfaceMethods).collect(Collectors.toMap(Method::getName, Function.identity(), (v1, v2) -> v2));
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                Method interfaceMethod = (Method)interfaceMethodMap.get(method.getName());
                if (!method.getName().equals(nodeApiMethod)) continue;
                LogIgnore logIgnoreAnno = Optional.ofNullable(method.getAnnotation(LogIgnore.class)).orElse(interfaceMethod.getAnnotation(LogIgnore.class));
                if (logIgnoreAnno != null) {
                    return null;
                }
                OperationType annotation = Optional.ofNullable(method.getAnnotation(OperationType.class)).orElse(interfaceMethod.getAnnotation(OperationType.class));
                if (annotation != null) {
                    String value = annotation.value();
                    operationTypeMetadata.setOperationTypeName(value);
                    return operationTypeMetadata;
                }
                OrderOperationTypeEnum orderOperationTypeEnum = OrderOperationTypeEnum.forCode(nodeApiMethod.toUpperCase());
                if (orderOperationTypeEnum != null) {
                    operationTypeMetadata.setOperationTypeName(orderOperationTypeEnum.getDesc());
                    return operationTypeMetadata;
                }
                ApiOperation apiOperation = Optional.ofNullable(method.getAnnotation(ApiOperation.class)).orElse(interfaceMethod.getDeclaredAnnotation(ApiOperation.class));
                operationTypeMetadata.setOperationTypeName(apiOperation.value());
                return operationTypeMetadata;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    static class OperationTypeMetadata {
        private String className;
        private String methodName;
        private String operationTypeKey;
        private String operationTypeName;

        OperationTypeMetadata() {
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getOperationTypeKey() {
            return this.className + "#" + this.methodName;
        }

        public void setOperationTypeKey(String operationTypeKey) {
            this.operationTypeKey = operationTypeKey;
        }

        public String getOperationTypeName() {
            return this.operationTypeName;
        }

        public void setOperationTypeName(String operationTypeName) {
            this.operationTypeName = operationTypeName;
        }
    }
}

