/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.GoodItemDeliveryStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleItemStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.RefOrderGoodsItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleGoodsItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.amount.tc.ICalculatorAmountMode;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.dao.vo.OrderItemAmoutVo;
import com.yunxi.dg.base.center.trade.dao.vo.SaleGoodsItemQueryVo;
import com.yunxi.dg.base.center.trade.dao.vo.SaleOrderItermChangeVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleGoodsItemDomain;
import com.yunxi.dg.base.center.trade.eo.DgSaleGoodsItemEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.service.tc.IRefOrderGoodsItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleGoodsItemService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaleGoodsItemServiceImpl
implements ISaleGoodsItemService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleGoodsItemServiceImpl.class);
    private static final Integer BATCH_INSERT_THRESHOLD = 2000;
    @Resource
    private IDgSaleGoodsItemDomain dgSaleGoodsItemDomain;
    @Resource
    private IRefOrderGoodsItemService refOrderGoodsItemService;
    @Resource
    private ICalculatorAmountMode calculatorAmountMode;

    @Override
    public void saveGoodsItems(SaleOrderItermChangeVo saleOrderItermChangeVo) {
        List saleOrderItemEos = saleOrderItermChangeVo.getSaleOrderItemEos();
        Long saleOrderId = saleOrderItermChangeVo.getSaleOrderId();
        Long originOrderId = saleOrderItermChangeVo.getOriginOrderId();
        String saleOrderNo = saleOrderItermChangeVo.getSaleOrderNo();
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"saleOrderItemEos \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)originOrderId, (String)"originOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)saleOrderNo, (String)"saleOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal totalItemCount = saleOrderItemEos.stream().map(DgSaleOrderItemEo::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u9700\u8981\u63d2\u5165\u5546\u54c1\u884c\u7684\u603b\u91cf\u4e3a\uff1a{}", (Object)totalItemCount);
        long start = System.currentTimeMillis();
        ArrayList batchInsertEoList = Lists.newArrayList();
        for (DgSaleOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            SaleOrderItemRespDto saleOrderItemRespDto = new SaleOrderItemRespDto();
            DtoHelper.eo2Dto((BaseEo)saleOrderItemEo, (BaseVo)saleOrderItemRespDto);
            BigDecimal averageAmount = this.calculatorAmountMode.calculateAverageAmount(saleOrderItemEo.getPayAmount(), saleOrderItemEo.getItemNum(), 2, 4);
            LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}", (Object)saleOrderItemEo.getSkuCode(), (Object)averageAmount);
            BigDecimal discountAmount = this.calculatorAmountMode.calculateAverageAmount(saleOrderItemEo.getDiscountAmount(), saleOrderItemEo.getItemNum(), 2, 4);
            LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u4f18\u60e0\u91d1\u989d\u4e3a\uff1a{}", (Object)saleOrderItemEo.getSkuCode(), (Object)discountAmount);
            for (int i = 0; i < saleOrderItemEo.getItemNum().intValue(); ++i) {
                DgSaleGoodsItemEo saleGoodsItemEo = new DgSaleGoodsItemEo();
                CubeBeanUtils.copyProperties((Object)saleGoodsItemEo, (Object)saleOrderItemEo, (String[])new String[0]);
                saleGoodsItemEo.setOrderItemId(saleOrderItemEo.getId());
                saleGoodsItemEo.setOrderNo(saleOrderNo);
                saleGoodsItemEo.setItemNum(BigDecimal.ONE);
                saleGoodsItemEo.setOrderId(saleOrderId);
                saleGoodsItemEo.setId(null);
                saleGoodsItemEo.setOriginOrderId(originOrderId);
                saleGoodsItemEo.setDeliveryStatus(GoodItemDeliveryStatusEnum.WAIT_DELIVERY.getCode());
                if (StringUtils.isBlank((CharSequence)saleOrderItemEo.getStatus())) {
                    saleGoodsItemEo.setStatus(SaleItemStatusEnum.NORMAL.getCode());
                    this.calculatorAmountMode.calculatorGoodItemAmountForCreate(saleOrderItemRespDto, saleGoodsItemEo, averageAmount, discountAmount, i);
                }
                batchInsertEoList.add(saleGoodsItemEo);
                if (batchInsertEoList.size() < BATCH_INSERT_THRESHOLD) continue;
                this.insertBatchItems(batchInsertEoList);
                batchInsertEoList = Lists.newArrayList();
            }
            this.insertBatchItems(batchInsertEoList);
            batchInsertEoList = Lists.newArrayList();
            this.generalRefOrderAndGoods(saleOrderItemEo.getId());
        }
        long end = System.currentTimeMillis();
        LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u6279\u91cf\u64cd\u4f5c\u6267\u884c\u7684\u603b\u65f6\u957f\uff1a{}", (Object)(end - start));
    }

    private void insertBatchItems(List<DgSaleGoodsItemEo> batchInsertEo) {
        if (CollectionUtils.isNotEmpty(batchInsertEo)) {
            this.dgSaleGoodsItemDomain.insertBatch(batchInsertEo);
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#modifyGoodsItemRowVo.querySaleOrderId")
    @Transactional(rollbackFor={Exception.class})
    public int modifyGoodsItems(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getQuerySaleOrderId(), (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId(), (String)"\u5f52\u5c5e\u8ba2\u5355\u5546\u54c1\u884c\u4e3b\u952eid\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getChangeNum(), (String)"\u4fee\u6539\u7684\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        LOGGER.info("[\u4fee\u6539\u5546\u54c1\u884c]\u4fee\u6539\u5546\u54c1\u884c\u7684\u8bf7\u6c42\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)modifyGoodsItemRowVo));
        LambdaQueryWrapper queryGoodsItemsWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryGoodsItemsWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleGoodsItemEo::getOrderId, (Object)modifyGoodsItemRowVo.getQuerySaleOrderId())).eq(DgSaleGoodsItemEo::getOrderItemId, (Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryOriDeliveryStatus()})) {
            queryGoodsItemsWrapper.eq(DgSaleGoodsItemEo::getDeliveryStatus, (Object)modifyGoodsItemRowVo.getQueryOriDeliveryStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryStatus()})) {
            queryGoodsItemsWrapper.eq(DgSaleGoodsItemEo::getStatus, (Object)modifyGoodsItemRowVo.getQueryStatus());
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{modifyGoodsItemRowVo.getQueryRefundStatus()})) {
            queryGoodsItemsWrapper.eq(DgSaleGoodsItemEo::getDeliveryStatus, (Object)modifyGoodsItemRowVo.getQueryRefundStatus());
        }
        int fitCount = this.dgSaleGoodsItemDomain.getMapper().selectCount((Wrapper)queryGoodsItemsWrapper);
        if (modifyGoodsItemRowVo.getChangeNum() > fitCount) {
            LOGGER.error("[\u4fee\u6539\u5546\u54c1\u884c]\u5f53\u524d\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e0d\u6ee1\u8db3\uff0c\u53ef\u4fee\u6539\u7684\u5546\u54c1\u884c\u6570\u91cf\u4e3a\uff1a{}", (Object)fitCount);
            throw PcpTradeExceptionCode.FIT_GOOD_IEM_COUNT_NOT_ENOUGHT.builderException();
        }
        int affectRow = this.dgSaleGoodsItemDomain.updateGoodsItems(modifyGoodsItemRowVo);
        if (affectRow != modifyGoodsItemRowVo.getChangeNum()) {
            LOGGER.error("[\u4fee\u6539\u5546\u54c1\u884c]\u5f53\u524d\u4fee\u6539\u751f\u6548\u7684\u5546\u54c1\u884c\u6570\u4e3a\uff1a{}\uff0c \u671f\u671b\u7684\u4fee\u6539\u884c\u6570\u4e3a\uff1a{}", (Object)affectRow, (Object)modifyGoodsItemRowVo.getChangeNum());
            throw PcpTradeExceptionCode.MODIFY_GOOD_IEM_FAIL.builderException();
        }
        return affectRow;
    }

    @Override
    public void removeOrderItem(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        AssertUtils.notNull((Object)modifyGoodsItemRowVo.getQueryBelongOrderItemId(), (String)"belongOrderItemId \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleGoodsItemEo removeEo = new DgSaleGoodsItemEo();
        removeEo.setOrderItemId(modifyGoodsItemRowVo.getQueryBelongOrderItemId());
        this.dgSaleGoodsItemDomain.logicDelete((BaseEo)removeEo);
    }

    @Override
    public List<SaleGoodsItemRespDto> queryAfterSaleOrderLinkGoodsItems(SaleGoodsItemQueryVo saleGoodsItemQueryVo, Long firstId, Integer pageSize) {
        if (CollectionUtils.isEmpty((Collection)saleGoodsItemQueryVo.getOrderIds()) && CollectionUtils.isEmpty((Collection)saleGoodsItemQueryVo.getPlatformOrderItemNos())) {
            AssertUtils.notEmpty((Collection)saleGoodsItemQueryVo.getOrderIds(), (String)"\u8ba2\u5355id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notEmpty((Collection)saleGoodsItemQueryVo.getPlatformOrderItemNos(), (String)"\u5173\u8054\u5e73\u53f0\u5546\u54c1\u552f\u4e00\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryGoodsItemsWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryGoodsItemsWrapper.eq(BaseEo::getDr, (Object)0)).orderByAsc(BaseEo::getId);
        if (CollectionUtils.isNotEmpty((Collection)saleGoodsItemQueryVo.getOrderIds())) {
            queryGoodsItemsWrapper.in(DgSaleGoodsItemEo::getOrderId, (Collection)saleGoodsItemQueryVo.getOrderIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)saleGoodsItemQueryVo.getOrderItemIds())) {
            queryGoodsItemsWrapper.in(DgSaleGoodsItemEo::getOrderItemId, (Collection)saleGoodsItemQueryVo.getOrderItemIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)saleGoodsItemQueryVo.getPlatformOrderItemNos())) {
            queryGoodsItemsWrapper.in(DgSaleGoodsItemEo::getPlatformOrderItemNo, (Collection)saleGoodsItemQueryVo.getPlatformOrderItemNos());
        }
        if (firstId != null) {
            queryGoodsItemsWrapper.gt(BaseEo::getId, (Object)firstId);
        }
        if (saleGoodsItemQueryVo.isGourdByOrderId() && saleGoodsItemQueryVo.isGourdPlatformOrderItemNo()) {
            queryGoodsItemsWrapper.groupBy((Object[])new SFunction[]{DgSaleGoodsItemEo::getOrderId, DgSaleGoodsItemEo::getPlatformOrderItemNo});
        } else if (saleGoodsItemQueryVo.isGourdByOrderId()) {
            queryGoodsItemsWrapper.groupBy(DgSaleGoodsItemEo::getOrderId);
        } else if (saleGoodsItemQueryVo.isGourdPlatformOrderItemNo()) {
            queryGoodsItemsWrapper.groupBy(DgSaleGoodsItemEo::getPlatformOrderItemNo);
        }
        Page page = new Page((long)((Integer)ObjectUtil.defaultIfNull((Object)0, (Object)1)).intValue(), (long)((Integer)ObjectUtil.defaultIfNull((Object)pageSize, (Object)10)).intValue(), false);
        page = (Page)this.dgSaleGoodsItemDomain.getMapper().selectPage((IPage)page, (Wrapper)queryGoodsItemsWrapper);
        ArrayList<SaleGoodsItemRespDto> saleGoodsItemRespDtos = new ArrayList<SaleGoodsItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)page.getRecords(), saleGoodsItemRespDtos, SaleGoodsItemRespDto.class);
        return saleGoodsItemRespDtos;
    }

    @Override
    public void modifyGoodsItemRelation(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        this.modifyGoodsItems(modifyGoodsItemRowVo);
        this.generalRefOrderAndGoods(modifyGoodsItemRowVo.getOrderItemId());
    }

    private void generalRefOrderAndGoods(Long orderItemId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleGoodsItemEo::getOrderItemId, (Object)orderItemId);
        List goodsItemEos = this.dgSaleGoodsItemDomain.getMapper().selectList((Wrapper)queryWrapper);
        ArrayList batchInsertList = Lists.newArrayList();
        for (DgSaleGoodsItemEo goodsItemEo : goodsItemEos) {
            RefOrderGoodsItemReqDto refOrderGoodsItemReqDto = new RefOrderGoodsItemReqDto();
            refOrderGoodsItemReqDto.setOrderNo(goodsItemEo.getOrderNo());
            refOrderGoodsItemReqDto.setOrderItemId(goodsItemEo.getOrderItemId());
            refOrderGoodsItemReqDto.setGoodsItemId(goodsItemEo.getId());
            batchInsertList.add(refOrderGoodsItemReqDto);
        }
        this.refOrderGoodsItemService.addRefOrderGoodsItemList(batchInsertList);
    }

    @Override
    public List<OrderItemAmoutVo> calculatorOrderItemAmount(List<Long> orderIdList) {
        return this.dgSaleGoodsItemDomain.calculatorOrderItemAmount(orderIdList);
    }
}

