/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.track.handle;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.component.track.commons.constant.TransactionStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.StrategyOptLogReqDto;
import com.yunxi.dg.base.center.trade.anno.LogIntercepts;
import com.yunxi.dg.base.center.trade.dao.vo.TradeTrackDataBizVo;
import com.yunxi.dg.base.center.trade.service.tc.IStrategyOptLogService;
import com.yunxi.dg.base.center.trade.track.enums.OrderOperationTypeEnum;
import com.yunxi.dg.base.center.trade.track.handle.TrackLogHandle;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@LogIntercepts(transactionStatus={TransactionStatusEnum.T_ERROR, TransactionStatusEnum.T_SUCCESS, TransactionStatusEnum.T_ACCEPT, TransactionStatusEnum.T_FAIL}, bizCodes={"strategy"})
@Component
public class StrategyTrackHandle
implements TrackLogHandle {
    @Resource
    private IStrategyOptLogService strategyOptLogService;

    @Override
    public void intercept(List<TradeTrackDataBizVo.OptDataVo> logList) {
        logList = this.filterSuccessLogs(logList);
        logList.forEach(result -> {
            StrategyOptLogReqDto strategyOptLogReqDto = new StrategyOptLogReqDto();
            strategyOptLogReqDto.setStrategyId(result.getBizId());
            strategyOptLogReqDto.setOptTime(result.getOptTime());
            strategyOptLogReqDto.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)""));
            OrderOperationTypeEnum orderOperationTypeEnum = OrderOperationTypeEnum.forCode(result.getOperationType());
            if (orderOperationTypeEnum != null) {
                strategyOptLogReqDto.setOptType(orderOperationTypeEnum.getDesc());
            } else {
                strategyOptLogReqDto.setOptType(result.getOperationType());
            }
            strategyOptLogReqDto.setOptContent(result.getOptResult());
            this.strategyOptLogService.addStrategyOptLog(strategyOptLogReqDto);
        });
    }
}

