/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SourceRecordReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SourceRecordRespDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.source.dto.extend.SourceOrderResultRespDto;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceRecordDomain;
import com.yunxi.dg.base.center.trade.eo.SourceOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.SourceRecordEo;
import com.yunxi.dg.base.center.trade.service.tc.ISourceRecordService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SourceRecordServiceImpl
implements ISourceRecordService {
    @Resource
    private ISourceRecordDomain sourceRecordDomain;
    @Resource
    private ISourceOrderItemDomain sourceOrderItemDomain;

    protected IBaseDomain<SourceRecordEo> baseDas() {
        return this.sourceRecordDomain;
    }

    @Override
    public Long addSourceRecord(SourceRecordReqDto addReqDto) {
        SourceRecordEo sourceRecordEo = new SourceRecordEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)sourceRecordEo);
        this.sourceRecordDomain.insert((BaseEo)sourceRecordEo);
        return sourceRecordEo.getId();
    }

    @Override
    public void saveSourceRecord(SourceOrderResultRespDto sourceOrderResultRespDto) {
        SourceRecordEo sourceRecordEo = new SourceRecordEo();
        sourceRecordEo.setOrderNo(sourceOrderResultRespDto.getLinkOrderNo());
        sourceRecordEo.setSgStatus(sourceOrderResultRespDto.getSgStatus());
        sourceRecordEo.setSgOrderNo(sourceOrderResultRespDto.getSgOrderNo());
        this.baseDas().insert((BaseEo)sourceRecordEo);
        List orderItemResultRespDtoList = sourceOrderResultRespDto.getOrderItemResultRespDtoList();
        if (CollectionUtils.isNotEmpty((Collection)orderItemResultRespDtoList)) {
            ArrayList batchInsertEoList = Lists.newArrayList();
            orderItemResultRespDtoList.forEach(orderItemResultRespDto -> {
                SourceOrderItemEo sourceOrderItemEo = new SourceOrderItemEo();
                sourceOrderItemEo.setSgOrderNo(sourceOrderResultRespDto.getSgOrderNo());
                sourceOrderItemEo.setOrderItemId(orderItemResultRespDto.getLinkOrderItemId());
                sourceOrderItemEo.setBatchNo(orderItemResultRespDto.getDeliveryItemBatchNo());
                sourceOrderItemEo.setSkuCode(orderItemResultRespDto.getLinkItemSkuCode());
                sourceOrderItemEo.setSgItemNum(orderItemResultRespDto.getDeliveryItemNum());
                sourceOrderItemEo.setSgWarehouseCode(orderItemResultRespDto.getDeliveryLogicWarehouseCode());
                batchInsertEoList.add(sourceOrderItemEo);
            });
            this.sourceOrderItemDomain.insertBatch((List)batchInsertEoList);
        }
    }

    @Override
    public void modifySourceRecord(SourceRecordReqDto modifyReqDto) {
        SourceRecordEo sourceRecordEo = new SourceRecordEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)sourceRecordEo);
        this.sourceRecordDomain.updateSelective((BaseEo)sourceRecordEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSourceRecord(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.sourceRecordDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SourceRecordRespDto querySourceRecordBySgOrderNo(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u5bfb\u6e90\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryRecordWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryRecordWrapper.eq(BaseEo::getDr, (Object)0)).eq(SourceRecordEo::getSgOrderNo, (Object)sgOrderNo);
        SourceRecordEo sourceRecordEo = (SourceRecordEo)this.sourceRecordDomain.getMapper().selectOne((Wrapper)queryRecordWrapper);
        SourceRecordRespDto sourceRecordRespDto = new SourceRecordRespDto();
        DtoHelper.eo2Dto((BaseEo)sourceRecordEo, (BaseVo)sourceRecordRespDto);
        return sourceRecordRespDto;
    }
}

