/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.order.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.DateUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.inventory.ILogicInventoryExposedApi;
import com.yunxi.dg.base.center.inventory.proxy.inventory.ILogicInventoryExposedApiProxy;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderOptLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditResultEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleAuditTypeEnum;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyPlanDeliveryDateVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderErrorDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAuditDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgArrangeWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgConfirmReceiveOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderErrorReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderOptLogReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.exception.PcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderOptLogService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderOptService;
import com.yunxi.dg.base.center.trade.service.proxy.IDgInventoryApiServcie;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgPerformOrderOptServiceImpl
implements IDgPerformOrderOptService {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderOptServiceImpl.class);
    @Resource
    private ILogicInventoryExposedApiProxy logicInventoryExposedApiProxy;
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderItemExtDomain performOrderItemExtDomain;
    @Resource
    private IDgPerformOrderAddrExtDomain performOrderAddrDomain;
    @Resource
    private IDgPerformOrderErrorDomain performOrderErrorDomain;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private ILogicInventoryExposedApi logicInventoryExposedApi;
    @Resource
    private IDgInventoryApiServcie inventoryApiServcie;
    @Resource
    private IDgPerformOrderOptLogService performOrderOptLogService;
    @Resource
    private IDgSaleOrderAuditDomain saleOrderAuditDomain;

    @Override
    public void saveShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getShipmentEnterpriseId(), (String)"shipmentEnterpriseId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(reqDto.getOrderId());
        updateReqDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        updateReqDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        updateReqDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        this.performOrderDomain.update(updateReqDto);
        log.info("[\u4fdd\u5b58\u5b9e\u9645\u53d1\u8d27\u7269\u6d41\u5546]\u8ba2\u5355\uff08{}\uff09\u7269\u6d41\u5546\u4fe1\u606f\u4e3a\uff1a{}", (Object)reqDto.getOrderId(), (Object)JSON.toJSONString((Object)reqDto));
    }

    @Override
    public void arrangeShipmentEnterprise(DgArrangeShipmentEnterpriseReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getShipmentEnterpriseId(), (String)"shipmentEnterpriseId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderReqDto modifyReqDto = new DgPerformOrderReqDto();
        modifyReqDto.setId(reqDto.getOrderId());
        modifyReqDto.setPlanShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        modifyReqDto.setPlanShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setPlanShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        modifyReqDto.setShipmentEnterpriseId(reqDto.getShipmentEnterpriseId());
        modifyReqDto.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        modifyReqDto.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        this.performOrderDomain.update(modifyReqDto);
        log.info("[\u6307\u5b9a\u7269\u6d41\u5546]\u8ba2\u5355\uff08{}\uff09\u6307\u5b9a\u7269\u6d41\u5546\u4fe1\u606f\u4e3a\uff1a{}", (Object)reqDto.getOrderId(), (Object)JSON.toJSONString((Object)reqDto));
    }

    @Override
    public boolean addRefundIntercept(Long orderId) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT))).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty((Collection)labelCodes)) {
            return true;
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.LOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.addOrderLabelRecord(orderId, DgOrderLabelEnum.REFUND_INTERCEPT);
        this.saveOptLogRecord(orderId);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void arrangeWarehouse(Long orderId, DgArrangeWarehouseReqDto reqDto) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto, (String)"reqDto \u4e0d\u80fd\u4e3a\u7a7a");
        List saleOrderItemRespDtos = this.performOrderItemExtDomain.queryOrderItemByOrderId(orderId);
        AssertUtils.notEmpty((Collection)saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u5546\u54c1\u4e0d\u5b58\u5728", (Object[])new Object[]{orderId});
        Collections.sort(saleOrderItemRespDtos, Comparator.comparing(BaseDto::getId));
        for (int i = 0; i < saleOrderItemRespDtos.size(); ++i) {
            DgPerformOrderItemRespDto orderItem = (DgPerformOrderItemRespDto)saleOrderItemRespDtos.get(i);
            DgPerformOrderItemReqDto updateItem = new DgPerformOrderItemReqDto();
            updateItem.setId(orderItem.getId());
            updateItem.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
            updateItem.setLogicalWarehouseId((Long)Optional.ofNullable(reqDto.getLogicalWarehouseId()).orElse(null));
            updateItem.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
            int updateSelective = this.performOrderItemExtDomain.updateSelective(updateItem);
            if (updateSelective == 1) continue;
            log.warn("\u3010\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u3011\u6307\u5b9a\u7684\u8ba2\u5355\u5546\u54c1\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5tr_order_item\u8868\u4e2did={}\u7684\u6570\u636e\u662f\u5426\u5b58\u5728\u5f02\u5e38\uff0c\u5f71\u54cd\u7684\u6570\u636e\u6761\u6570\u4e3a\uff1a{}", (Object)reqDto.getOrderItemId(), (Object)updateSelective);
            throw DgPcpTradeExceptionCode.ORDER_ITEM_EXCEPTION.builderException();
        }
        DgPerformOrderReqDto saleOrderReqDto = new DgPerformOrderReqDto();
        saleOrderReqDto.setId(orderId);
        saleOrderReqDto.setLogicalWarehouseId(reqDto.getLogicalWarehouseId());
        saleOrderReqDto.setLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        saleOrderReqDto.setLogicalWarehouseName(reqDto.getLogicalWarehouseName());
        saleOrderReqDto.setDeliveryLogicalWarehouseCode(reqDto.getLogicalWarehouseCode());
        this.performOrderDomain.update(saleOrderReqDto);
        log.info("\u3010\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u3011\u8ba2\u5355={}\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u6210\u529f\uff0c\u4fee\u6539\u7684\u4ed3\u5e93\u4fe1\u606f\u4e3a\uff1a{}", (Object)orderId, (Object)JSON.toJSONString((Object)reqDto));
        if (reqDto.getNeedCleanShipmentEnterprise().booleanValue()) {
            log.info("\u3010\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u3011\u8ba2\u5355={}\u4fee\u6539\u6307\u5b9a\u53d1\u8d27\u4ed3\u6210\u529f\uff0c\u6e05\u9664\u6307\u5b9a\u7269\u6d41\u4fe1\u606f", (Object)orderId);
            this.performOrderDomain.removeShipmentEnterprise(orderId);
            this.performOrderDomain.removePlanShipmentEnterpriseInfo(orderId);
        }
    }

    @Override
    public void removeRefundIntercept(Long orderId) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT))).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)labelCodes)) {
            log.info("[\u5220\u9664\u8ba2\u5355\u8bb0\u5f55\u6807\u8bc6]\u8ba2\u5355\u672a\u5904\u4e8e\u62e6\u622a\u4e2d\uff0c\u65e0\u9700\u79fb\u9664\u62e6\u622a\u6807\u8bc6orderId={}", (Object)orderId);
            return;
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkCancelHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw DgPcpTradeExceptionCode.UNLOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.removeOrderLabelRecordById(orderId, DgOrderLabelEnum.REFUND_INTERCEPT);
    }

    public DgPerformOrderRespDto querySaleOrderById(Long orderId) {
        DgPerformOrderRespDto saleOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        return saleOrderRespDto;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void revocationAudit(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.querySaleOrderById(orderId);
        Boolean releaseLogicalAndChannel = this.inventoryApiServcie.releaseLogicalAndPhysics(saleOrderRespDto);
        if (releaseLogicalAndChannel.booleanValue()) {
            log.info("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u5e93\u5b58\u9884\u5360\u6210\u529f");
            if (StringUtils.isBlank((CharSequence)saleOrderRespDto.getPlanShipmentEnterpriseCode())) {
                this.performOrderDomain.removeShipmentEnterprise(orderId);
            }
        } else {
            log.warn("[\u64a4\u9500\u5ba1\u6838]\u53d6\u6d88\u5e93\u5b58\u9884\u5360\u5931\u8d25");
            throw DgPcpTradeExceptionCode.REVET_BS_STATUS_FAIL_EXCEPTION.buildBizException(new Object[]{saleOrderRespDto.getSaleOrderNo()});
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void cancelPick(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto saleOrderRespDto = this.querySaleOrderById(orderId);
        Boolean releaseLogicalAndChannel = this.inventoryApiServcie.releaseLogicalAndPhysics(saleOrderRespDto);
        if (Boolean.FALSE.equals(releaseLogicalAndChannel)) {
            throw DgPcpTradeExceptionCode.CANCEL_PICK_FAIL_EXCEPTION.buildBizException(new Object[]{saleOrderRespDto.getSaleOrderNo()});
        }
    }

    @Override
    public void modifyAddress(DgPerformOrderAddrReqDto reqDto) {
        this.performOrderAddrDomain.modifySaleOrderAddr(reqDto);
        if (StringUtils.isNotBlank((CharSequence)reqDto.getOaid())) {
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(reqDto.getOrderId());
            updateReqDto.setOaid(reqDto.getOaid());
            this.performOrderDomain.update(updateReqDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyPlanDeliveryDate(Long orderId, String newDate) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        ModifyPlanDeliveryDateVo modifyPlanDeliveryDateVo = new ModifyPlanDeliveryDateVo();
        modifyPlanDeliveryDateVo.setSaleOrderId(orderId);
        if (StringUtils.isNotBlank((CharSequence)newDate)) {
            modifyPlanDeliveryDateVo.setPlanDeliveryTime(DateUtil.parse((String)newDate));
        } else {
            modifyPlanDeliveryDateVo.setPlanDeliveryTime(null);
        }
        log.info("[\u4fee\u6539\u8ba2\u5355\u9884\u8ba1\u53d1\u8d27\u65e5\u671f]\u4fee\u6539\u8ba2\u5355\uff08{}\uff09\u9884\u8ba1\u53d1\u8d27\u65e5\u5fd7\u4e3a\uff1a{}", (Object)orderId, (Object)newDate);
        this.performOrderDomain.modifyPlanDeliveryDate(modifyPlanDeliveryDateVo);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean continueDeliver(Long orderId) {
        DgPerformOrderInfoDto performOrderInfoDto = this.performOrderDomain.queryBaseInfoById(orderId);
        RestResponse restResponse = this.logicInventoryExposedApiProxy.continueDelivery(performOrderInfoDto.getSaleOrderNo());
        Boolean result = (Boolean)RestResponseHelper.extractData((RestResponse)restResponse);
        if (result.booleanValue()) {
            this.performOrderDomain.removeLabel(performOrderInfoDto.getId(), performOrderInfoDto.getOptLabel(), new String[]{DgOrderOptLabelEnum.CANCEL_APPOINT.getCode()});
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean cancelDeliver(Long orderId) {
        DgPerformOrderRespDto performOrderInfoDto = this.performOrderDomain.queryDtoById(orderId);
        return this.inventoryApiServcie.releasePhysics(performOrderInfoDto);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void cancelSaleOrder(Long orderId, String cancelReason) {
        DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(performOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
        DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
        updateReqDto.setId(orderId);
        updateReqDto.setCancelReason(cancelReason);
        this.performOrderDomain.update(updateReqDto);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void releaseChannelInventory(Long orderId) {
        DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        Boolean cancelResult = this.inventoryApiServcie.releaseChannelInventory(performOrderRespDto);
        if (!cancelResult.booleanValue()) {
            throw PcpTradeExceptionCode.CHECK_STATUS_ORDER_CANCEL_INVENTORY_CANCEL_FAIL.builderException();
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public boolean doStatusLock(Long orderId) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(DgOrderLabelEnum.LOCK))).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty((Collection)labelCodes)) {
            return true;
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.LOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.addOrderLabelRecord(orderId, DgOrderLabelEnum.LOCK);
        return true;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void doStatusUnLock(Long orderId) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(orderId, Arrays.asList(DgOrderLabelEnum.LOCK))).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty((Collection)labelCodes)) {
            throw PcpTradeExceptionCode.LOCK_NOT_EXIST.builderException();
        }
        Boolean resultFlag = (Boolean)RestResponseHelper.extractData((RestResponse)this.logicInventoryExposedApi.checkCancelHangUp(orderId.toString()));
        if (!resultFlag.booleanValue()) {
            throw PcpTradeExceptionCode.UNLOCK_FAIL.builderException();
        }
        this.orderLabelRecordDomain.removeOrderLabelRecordById(orderId, DgOrderLabelEnum.LOCK);
    }

    private void saveOptLogRecord(Long orderId) {
        DgPerformOrderOptLogReqDto saleOrderOptLogReqDto = new DgPerformOrderOptLogReqDto();
        saleOrderOptLogReqDto.setSaleOrderId(orderId);
        saleOrderOptLogReqDto.setOptTime(new Date());
        saleOrderOptLogReqDto.setOptPerson("system");
        saleOrderOptLogReqDto.setOptType("\u9000\u6b3e\u62e6\u622a");
        saleOrderOptLogReqDto.setOptTypeEn("REFUND_INTERCEPT");
        this.performOrderOptLogService.addSaleOrderOptLog(saleOrderOptLogReqDto);
    }

    @Override
    public boolean addAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        List labelCodes = Optional.ofNullable(this.orderLabelRecordDomain.queryExistLabelCode(respDto.getId(), Arrays.asList(DgOrderLabelEnum.REFUND_INTERCEPT))).orElse(Lists.newArrayList());
        if (CollectionUtils.isNotEmpty((Collection)labelCodes)) {
            return true;
        }
        this.orderLabelRecordDomain.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.ORDER_RELAX_ACCOUNT_FAIL_INTERCEPT);
        this.orderLabelRecordDomain.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.AFTER_SALE_ORDER_ERROR);
        DgPerformOrderErrorReqDto saleOrderErrorReqDto = new DgPerformOrderErrorReqDto();
        saleOrderErrorReqDto.setOrderId(respDto.getId());
        saleOrderErrorReqDto.setErrorReason("\u8ba2\u5355\u9884\u5360\u989d\u5ea6\u91ca\u653e\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u91ca\u653e\u540e\u518d\u91cd\u8bd5\u64cd\u4f5c");
        saleOrderErrorReqDto.setErrorType("\u989d\u5ea6\u91ca\u653e\u5931\u8d25");
        this.performOrderErrorDomain.addSaleOrderError(saleOrderErrorReqDto);
        return true;
    }

    @Override
    public boolean removeAccountRelaxFailIntercept(DgPerformOrderRespDto respDto) {
        log.info("\u5220\u9664\u6240\u6709\u6807\u8bb0\u548c\u62e6\u622a\u6807\u8bb0");
        this.orderLabelRecordDomain.removeOrderLabelRecordById(respDto.getId(), DgOrderLabelEnum.ORDER_RELAX_ACCOUNT_FAIL_INTERCEPT);
        this.orderLabelRecordDomain.removeOrderLabelRecordById(respDto.getId(), DgOrderLabelEnum.AFTER_SALE_ORDER_ERROR);
        this.performOrderErrorDomain.removeSaleOrderErrorByOrderId(respDto.getId());
        return false;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public Boolean confirmSignGoods(Long orderId, DgConfirmReceiveOrderReqDto request) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderRespDto performOrderRespDto = this.performOrderDomain.queryDtoById(orderId);
        List saleOrderItemEos = this.performOrderItemExtDomain.queryOrderItemByOrderId(orderId);
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        BigDecimal totalOutDeliveryCount = saleOrderItemEos.stream().map(DgPerformOrderItemDto::getOutItemNum).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (performOrderRespDto.getGoodsTotalNum().compareTo(totalOutDeliveryCount) == 0) {
            DgPerformOrderReqDto updateEo = new DgPerformOrderReqDto();
            updateEo.setId(orderId);
            updateEo.setConfirmReceiveTime(Optional.ofNullable(request.getConfirmOrderTime()).orElse(new Date()));
            this.performOrderDomain.update(updateEo);
            log.info("[\u786e\u8ba4\u6536\u8d27][\u786e\u8ba4\u6536\u8d27]\u8ba2\u5355({})\u7b7e\u6536\u6210\u529f", (Object)performOrderRespDto.getSaleOrderNo());
            return Boolean.TRUE;
        }
        log.info("[\u786e\u8ba4\u6536\u8d27]\u5546\u54c1\u51fa\u5e93\u603b\u6570\u4e3a\uff1a{}, \u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)totalOutDeliveryCount, (Object)JSON.toJSONString((Object)performOrderRespDto));
        DgPerformOrderReqDto updateEo = new DgPerformOrderReqDto();
        updateEo.setConfirmReceiveTime(Optional.ofNullable(request.getConfirmOrderTime()).orElse(new Date()));
        this.performOrderDomain.update(updateEo);
        log.error(PcpTradeExceptionCode.CANNOT_CONFIRM_RECEIPT.getMsg(), (Throwable)PcpTradeExceptionCode.CANNOT_CONFIRM_RECEIPT.builderException());
        return Boolean.TRUE;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void businessAuditPass(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderRespDto saleOrderRespDto = this.querySaleOrderById(orderId);
        List orderItems = this.performOrderItemExtDomain.queryNormalItemByOrderId(orderId);
        Boolean preemptChannelInventory = this.inventoryApiServcie.preemptChannelInventoryForBSAudit(orderItems, saleOrderRespDto);
        if (!preemptChannelInventory.booleanValue()) {
            throw PcpTradeExceptionCode.BUSINESS_AUDIT_FAIL.builderException();
        }
        this.saleOrderAuditDomain.saveSaleOrderAudit(orderId, DgSaleAuditTypeEnum.BUSINESS_AUDIT, DgSaleAuditResultEnum.PASS);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#orderId")
    public void addAuditLog(Long orderId, DgSaleAuditResultEnum auditResultEnum) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        this.saleOrderAuditDomain.saveSaleOrderAudit(orderId, DgSaleAuditTypeEnum.AUDIT, auditResultEnum);
    }
}

