/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.PascalNameFilter;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.component.track.commons.constant.pcp.ExternalDispatchBaseEnum;
import com.dtyunxi.cube.component.track.commons.vo.pcp.ExternalDispatchBaseVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.cs.order.ICsDeliveryResultOrderQueryApi;
import com.dtyunxi.yundt.cube.center.inventory.dto.response.cs.order.CsDeliveryResultOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.constant.AllotTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.LockTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.NextOptTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OmsSaleOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderAssignStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderLevelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderStatusFlowTemplate;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleTransferTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SecondSaleOrderStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.TradeStatusFlowSelector;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderQueryReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SaleTransferOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SapOrderLineItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SapOrderLineUpdateReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderDetailRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.BizSaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.LogisticsRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderStatusLogRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.OrderTagRecordRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.RelatedOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderAddrRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemExtRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTradeMessageVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleTransferOrderRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PcpOrderReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderAddrReqDto;
import com.dtyunxi.yundt.cube.center.transform.api.dto.request.PlatformOrderItemReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.anno.DgRedisLock;
import com.yunxi.dg.base.center.trade.baseservice.BInventoryApiServcie;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderTagRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.ISaleTransferExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderAddrExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.event.AddSaleOrderEvent;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.tc.TcBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.tc.TcPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.tc.TcPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.service.tc.IPcpDeliveryRecordService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleTransferOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.OrderOptLabelUtils;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Service
public class SaleOrderServiceImpl
implements ISaleOrderService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaleOrderServiceImpl.class);
    private static final List<String> orderTypeList = Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType(), SaleOrderTypeEnum.ACTIVITY_ORDER.getType(), SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType(), SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.getType(), SaleOrderTypeEnum.REPLENISH_ORDER.getType(), SaleOrderTypeEnum.OTHER_OUT_STOCK.getType(), SaleOrderTypeEnum.QUALITY_REFUNDING_ORDER.getType()});
    @Resource
    private IOrderTagRecordDomain orderTagRecordDomain;
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IDgPerformOrderAddrExtDomain dgPerformOrderAddrExtDomain;
    @Resource
    private ICsDeliveryResultOrderQueryApi deliveryResultOrderQueryApi;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IPcpDeliveryRecordService pcpDeliveryRecordService;
    @Resource
    private BInventoryApiServcie bInventoryApiServcie;
    @Resource
    private ISaleTransferOrderService saleTransferOrderService;
    @Resource
    private ISaleTransferExtDomain saleTransferExtDomain;
    @Resource
    private IDgPerformOrderExtDomain dgPerformOrderExtDomain;
    @Resource
    private IDgPerformOrderItemExtDomain dgPerformOrderItemExtDomain;
    @Resource
    private IDgSaleOrderDomain dgSaleOrderDomain;
    @Resource
    private IDgSaleOrderItemDomain dgSaleOrderItemDomain;
    private List<OrderStatusLogRespDto> orderStatusLogRespDtoList = new ArrayList<OrderStatusLogRespDto>();

    public SaleOrderServiceImpl() {
        this.orderStatusLogRespDtoList.add(new OrderStatusLogRespDto(SaleOrderStatusEnum.WAIT_CHECK.getCode()));
        this.orderStatusLogRespDtoList.add(new OrderStatusLogRespDto(SaleOrderStatusEnum.WAIT_PICK.getCode()));
        this.orderStatusLogRespDtoList.add(new OrderStatusLogRespDto(SaleOrderStatusEnum.WAIT_DELIVERY.getCode()));
        this.orderStatusLogRespDtoList.add(new OrderStatusLogRespDto(SaleOrderStatusEnum.COMPLETE.getCode()));
        this.orderStatusLogRespDtoList.add(new OrderStatusLogRespDto(SaleOrderStatusEnum.RECEIVED.getCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @DgRedisLock(lockName="saleOrder", key="#addReqDto.platformOrderNo", condition="#addReqDto.platformOrderNo!=null")
    public String addSaleOrder(BizSaleOrderReqDto addReqDto) {
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = new DgBizPerformOrderReqDto();
        BeanUtil.copyProperties((Object)addReqDto, (Object)dgBizPerformOrderReqDto, (String[])new String[0]);
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)addReqDto.getItemList(), DgPerformOrderItemReqDto.class);
        dgBizPerformOrderReqDto.setItemList((List)itemList);
        ArrayList giftList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)giftList, (Collection)addReqDto.getGiftList(), DgPerformOrderItemReqDto.class);
        dgBizPerformOrderReqDto.setGiftList((List)giftList);
        DgPerformOrderAddrReqDto dgPerformOrderAddrReqDto = new DgPerformOrderAddrReqDto();
        BeanUtil.copyProperties((Object)addReqDto.getOrderAddrReqDto(), (Object)dgPerformOrderAddrReqDto, (String[])new String[0]);
        dgBizPerformOrderReqDto.setOrderAddrReqDto(dgPerformOrderAddrReqDto);
        return this.dgPerformOrderExtDomain.addCisSaleOrder(dgBizPerformOrderReqDto);
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={AddSaleOrderEvent.class})
    public void handleAddSaleOrderEvent(AddSaleOrderEvent addSaleOrderEvent) {
        DgSaleOrderEo saleOrderEo = addSaleOrderEvent.getDgSaleOrderEo();
        LOGGER.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u8ba2\u5355\u65b0\u589e\u4e8b\u52a1\u63d0\u4ea4\u6210\u529f\uff0c\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderEo));
        SaleTradeMessageVo saleTradeMessageVo = new SaleTradeMessageVo();
        saleTradeMessageVo.setOrderNo(saleOrderEo.getSaleOrderNo());
        saleTradeMessageVo.setNextOptType(NextOptTypeEnum.AUTO_CHECK.getType());
        saleTradeMessageVo.setOrderId(saleOrderEo.getId());
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)saleTradeMessageVo);
        this.commonsMqService.sendSingleMessage("DELAY_AUTO_CHECK", (Object)messageVo);
    }

    private void sendEasSaleOrder(BizSaleOrderReqDto addReqDto) {
        if (!addReqDto.getManualCreate().booleanValue() && !Objects.equals(addReqDto.getOrderSource(), SaleOrderSourceEnum.IMPORT.getType())) {
            return;
        }
        if (Objects.equals(addReqDto.getIfButtThirdParty(), 0)) {
            LOGGER.info("\u4e0d\u5bf9\u63a5\u8d22\u52a1\u4e2d\u53f0\u6216eas\u5e73\u53f0");
            return;
        }
        LOGGER.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u624b\u52a8\u521b\u5efa\u9500\u552e\u8ba2\u5355\uff0c\u9700\u8981\u63a8\u9001EAS");
        PcpOrderReqDto pcpOrderReqDto = new PcpOrderReqDto();
        CubeBeanUtils.copyProperties((Object)pcpOrderReqDto, (Object)addReqDto, (String[])new String[]{"platformOrderPcpExtendReqDto", "itemReqDtoList", "platformOrderAddrReqDto"});
        pcpOrderReqDto.setOrderChannelName(addReqDto.getChannelName());
        pcpOrderReqDto.setOrderChannelId(addReqDto.getChannelId());
        pcpOrderReqDto.setOrderChannelCode(addReqDto.getChannelCode());
        ArrayList itemReqDtoList = Lists.newArrayList();
        ArrayList itemAllList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getItemList())) {
            itemAllList.addAll(addReqDto.getItemList());
        }
        if (CollectionUtils.isNotEmpty((Collection)addReqDto.getGiftList())) {
            itemAllList.addAll(addReqDto.getGiftList());
        }
        CubeBeanUtils.copyCollection((Collection)itemReqDtoList, (Collection)itemAllList, PlatformOrderItemReqDto.class);
        pcpOrderReqDto.setItemReqDtoList((List)itemReqDtoList);
        PlatformOrderAddrReqDto platformOrderAddrReqDto = new PlatformOrderAddrReqDto();
        CubeBeanUtils.copyProperties((Object)platformOrderAddrReqDto, (Object)addReqDto.getOrderAddrReqDto(), (String[])new String[0]);
        pcpOrderReqDto.setPlatformOrderAddrReqDto(platformOrderAddrReqDto);
        ExternalDispatchBaseVo baseVo = new ExternalDispatchBaseVo();
        ExternalDispatchBaseEnum baseEnum = ExternalDispatchBaseEnum.API_EAS008;
        baseVo.setExternalDispatchBaseEnum(baseEnum);
        baseVo.setData((Object)pcpOrderReqDto);
        LOGGER.info("\u53d1\u9001\u5185\u5bb9\uff1a{}", (Object)JSON.toJSONString((Object)baseVo, (SerializeFilter)new PascalNameFilter(), (SerializerFeature[])new SerializerFeature[0]));
        this.commonsMqService.sendDelaySingleMessage(baseEnum.getTopicKey(), baseEnum.getTagKey(), (Object)JSON.toJSONString((Object)baseVo), Long.valueOf(60L));
    }

    @Override
    public void modifySaleOrder(SaleOrderReqDto modifyReqDto) {
        TcBizPerformOrderReqDto tcBizPerformOrderReqDto = new TcBizPerformOrderReqDto();
        tcBizPerformOrderReqDto.setSaleOrderReqDto(modifyReqDto);
        this.dgPerformOrderExtDomain.modifySaleOrder((DgBizPerformOrderReqDto)tcBizPerformOrderReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSaleOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dgPerformOrderExtDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BizSaleOrderRespDto queryByOrderNo(String orderNo) {
        TcPerformOrderRespDto dgPerformOrderRespDto = (TcPerformOrderRespDto)this.dgPerformOrderExtDomain.queryDtoByOrderNo(orderNo);
        if (dgPerformOrderRespDto == null) {
            return null;
        }
        BizSaleOrderRespDto saleOrderRespDto = dgPerformOrderRespDto.getBizSaleOrderRespDto();
        DgPerformOrderReqDto dgPerformOrderReqDto = new DgPerformOrderReqDto();
        BeanUtil.copyProperties((Object)saleOrderRespDto, (Object)dgPerformOrderReqDto, (String[])new String[0]);
        List relatedOrderRespDtos = this.dgPerformOrderExtDomain.queryRelatedOrder(dgPerformOrderReqDto);
        ArrayList relatedOrderList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)relatedOrderList, (Collection)relatedOrderRespDtos, RelatedOrderRespDto.class);
        saleOrderRespDto.setRelatedOrderList((List)relatedOrderList);
        DgPerformOrderAddrDto dgPerformOrderAddrDto = this.dgPerformOrderAddrExtDomain.queryAddressByOrderId(saleOrderRespDto.getId());
        SaleOrderAddrRespDto orderAddrRespDto = new SaleOrderAddrRespDto();
        BeanUtil.copyProperties((Object)dgPerformOrderAddrDto, (Object)orderAddrRespDto, (String[])new String[0]);
        saleOrderRespDto.setOrderAddrRespDto(orderAddrRespDto);
        List dgPerformOrderItemRespDtos = this.dgPerformOrderItemExtDomain.queryOrderItemByOrderId(saleOrderRespDto.getId());
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)dgPerformOrderItemRespDtos, SaleOrderItemExtRespDto.class);
        saleOrderRespDto.setItemList((List)itemList);
        saleOrderRespDto.setTagList(this.orderTagRecordDomain.queryTagById(saleOrderRespDto.getId()).stream().map(r -> (OrderTagRecordRespDto)BeanUtil.copyProperties((Object)r, OrderTagRecordRespDto.class, (String[])new String[0])).collect(Collectors.toList()));
        return saleOrderRespDto;
    }

    @Override
    public BizSaleOrderRespDto queryByOrderId(Long orderId) {
        TcPerformOrderRespDto dgPerformOrderRespDto = (TcPerformOrderRespDto)this.dgPerformOrderExtDomain.queryByOrderId(orderId);
        if (dgPerformOrderRespDto == null) {
            return null;
        }
        BizSaleOrderRespDto saleOrderRespDto = dgPerformOrderRespDto.getBizSaleOrderRespDto();
        DgPerformOrderReqDto dgPerformOrderReqDto = new DgPerformOrderReqDto();
        BeanUtil.copyProperties((Object)saleOrderRespDto, (Object)dgPerformOrderReqDto, (String[])new String[0]);
        List relatedOrderRespDtos = this.dgPerformOrderExtDomain.queryRelatedOrder(dgPerformOrderReqDto);
        ArrayList relatedOrderList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)relatedOrderList, (Collection)relatedOrderRespDtos, RelatedOrderRespDto.class);
        saleOrderRespDto.setRelatedOrderList((List)relatedOrderList);
        DgPerformOrderAddrDto dgPerformOrderAddrDto = this.dgPerformOrderAddrExtDomain.queryAddressByOrderId(saleOrderRespDto.getId());
        SaleOrderAddrRespDto orderAddrRespDto = new SaleOrderAddrRespDto();
        BeanUtil.copyProperties((Object)dgPerformOrderAddrDto, (Object)orderAddrRespDto, (String[])new String[0]);
        saleOrderRespDto.setOrderAddrRespDto(orderAddrRespDto);
        List dgPerformOrderItemRespDtos = this.dgPerformOrderItemExtDomain.queryOrderItemByOrderId(saleOrderRespDto.getId());
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)dgPerformOrderItemRespDtos, SaleOrderItemExtRespDto.class);
        saleOrderRespDto.setItemList((List)itemList);
        return saleOrderRespDto;
    }

    @Override
    public PageInfo<SaleOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SaleOrderReqDto saleOrderReqDto = (SaleOrderReqDto)JSON.parseObject((String)filter, SaleOrderReqDto.class);
        TcPerformOrderReqDto tcPerformOrderReqDto = new TcPerformOrderReqDto();
        tcPerformOrderReqDto.setSaleOrderReqDto(saleOrderReqDto);
        PageInfo dgPerformOrderRespDtoPageInfo = this.dgPerformOrderExtDomain.queryByPage((DgPerformOrderReqDto)tcPerformOrderReqDto, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)dgPerformOrderRespDtoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List dtoList = dgPerformOrderRespDtoPageInfo.getList().stream().map(e -> {
            TcPerformOrderRespDto tcPerformOrderRespDto = (TcPerformOrderRespDto)e;
            return tcPerformOrderRespDto.getBizSaleOrderRespDto();
        }).collect(Collectors.toList());
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public SaleOrderRespDto queryById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TcPerformOrderRespDto dgPerformOrderRespDto = (TcPerformOrderRespDto)this.dgPerformOrderExtDomain.queryByOrderId(id);
        if (dgPerformOrderRespDto == null) {
            return null;
        }
        BizSaleOrderRespDto saleOrderRespDto = dgPerformOrderRespDto.getBizSaleOrderRespDto();
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
        DgPerformOrderReqDto dgPerformOrderReqDto = new DgPerformOrderReqDto();
        BeanUtil.copyProperties((Object)saleOrderRespDto, (Object)dgPerformOrderReqDto, (String[])new String[0]);
        List relatedOrderRespDtos = this.dgPerformOrderExtDomain.queryRelatedOrder(dgPerformOrderReqDto);
        ArrayList relatedOrderList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)relatedOrderList, (Collection)relatedOrderRespDtos, RelatedOrderRespDto.class);
        saleOrderRespDto.setRelatedOrderList((List)relatedOrderList);
        return saleOrderRespDto;
    }

    @Override
    public SaleOrderRespDto querySaleOrderById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TcPerformOrderRespDto dgPerformOrderRespDto = (TcPerformOrderRespDto)this.dgPerformOrderExtDomain.queryByOrderId(id);
        if (dgPerformOrderRespDto == null) {
            return null;
        }
        BizSaleOrderRespDto saleOrderRespDto = dgPerformOrderRespDto.getBizSaleOrderRespDto();
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
        return saleOrderRespDto;
    }

    @Override
    public int updateSaleOrderById(Long orderId, DgSaleOrderEo updateEo) {
        return this.dgPerformOrderExtDomain.updateSaleOrderById(orderId, updateEo);
    }

    @Override
    public DgSaleOrderEo queryEoById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        TcPerformOrderRespDto dgPerformOrderRespDto = (TcPerformOrderRespDto)this.dgPerformOrderExtDomain.queryByOrderId(id);
        if (dgPerformOrderRespDto == null) {
            return null;
        }
        DgSaleOrderEo dgSaleOrderEo = new DgSaleOrderEo();
        BeanUtil.copyProperties((Object)dgPerformOrderRespDto.getBizSaleOrderRespDto(), (Object)dgSaleOrderEo, (String[])new String[0]);
        return dgSaleOrderEo;
    }

    @Override
    public List<DgSaleOrderEo> queryEoByIds(List<Long> ids) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        List dgPerformOrderRespDtos = this.dgPerformOrderExtDomain.queryListByOrderIds(ids);
        List<DgSaleOrderEo> dgSaleOrderEos = dgPerformOrderRespDtos.stream().map(e -> {
            TcPerformOrderRespDto tcPerformOrderRespDto = (TcPerformOrderRespDto)e;
            DgSaleOrderEo dgSaleOrderEo = new DgSaleOrderEo();
            BeanUtil.copyProperties((Object)tcPerformOrderRespDto.getBizSaleOrderRespDto(), (Object)dgSaleOrderEo, (String[])new String[0]);
            return dgSaleOrderEo;
        }).collect(Collectors.toList());
        return dgSaleOrderEos;
    }

    @Override
    public DgSaleOrderEo queryEoByOrderNo(String orderNo) {
        TcPerformOrderRespDto dgPerformOrderRespDto = (TcPerformOrderRespDto)this.dgPerformOrderExtDomain.queryDtoByOrderNo(orderNo);
        if (dgPerformOrderRespDto == null) {
            return null;
        }
        BizSaleOrderRespDto saleOrderRespDto = dgPerformOrderRespDto.getBizSaleOrderRespDto();
        DgSaleOrderEo dgSaleOrderEo = new DgSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)saleOrderRespDto, (BaseEo)dgSaleOrderEo);
        return dgSaleOrderEo;
    }

    @Override
    public int optimisticModifySaleOrder(DgSaleOrderEo saleOrderEo, UpdateWrapper<DgSaleOrderEo> queryWrapper, int idealCount, boolean needThrow) {
        return this.dgPerformOrderExtDomain.optimisticModifySaleOrder(saleOrderEo, queryWrapper, idealCount, needThrow);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeDeliveredForOrder(OutDeliveryResultReqDto reqDto) {
        AssertUtils.notBlank((String)reqDto.getOrderNo(), (String)"orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u4fee\u6539\u7684\u8ba2\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        DgSaleOrderEo saleOrderEo = this.queryEoByOrderNo(reqDto.getOrderNo());
        AssertUtils.notNull((Object)saleOrderEo, (String)"\u8ba2\u5355\u4e0d\u5b58\u5728");
        BigDecimal totalOutDeliveryCount = this.dgPerformOrderItemExtDomain.getOrderOutDeliveredCount(saleOrderEo.getId());
        TcPerformOrderReqDto tcPerformOrderReqDto = new TcPerformOrderReqDto();
        tcPerformOrderReqDto.setOutDeliveryResultReqDto(reqDto);
        tcPerformOrderReqDto.setId(saleOrderEo.getId());
        if (reqDto.getTotalQuantity() != null) {
            if (totalOutDeliveryCount.add(reqDto.getTotalQuantity()).compareTo(saleOrderEo.getGoodsTotalNum()) >= 0) {
                LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1\u5df2\u5168\u90e8\u51fa\u5e93");
                tcPerformOrderReqDto.setSecondOrderStatus(SecondSaleOrderStatusEnum.ALL_OUT_DELIVERY.getCode());
                tcPerformOrderReqDto.setDeliveryCompleteDate(new Date());
            } else if (BigDecimal.ZERO.compareTo(reqDto.getTotalQuantity()) < 0) {
                LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1\u90e8\u5206\u51fa\u5e93\uff0c\u51fa\u5e93\u6570\u91cf\u4e3a\uff1a{}", (Object)reqDto.getTotalQuantity());
                tcPerformOrderReqDto.setSecondOrderStatus(SecondSaleOrderStatusEnum.PART_OUT_DELIVERY.getCode());
            }
            this.dgPerformOrderExtDomain.changeDeliveredForOrder((DgPerformOrderReqDto)tcPerformOrderReqDto);
            this.pcpDeliveryRecordService.saveDeliveryRecord(reqDto, tcPerformOrderReqDto.getSecondOrderStatus());
        }
    }

    @Override
    public void changeOrderInfo(SaleOrderReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto.getId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)updateEo);
        int updateSelective = this.dgPerformOrderExtDomain.updateSaleOrderById(reqDto.getId(), updateEo);
        if (updateSelective != 1) {
            throw PcpTradeExceptionCode.UPDATE_EXCEPTION.builderException();
        }
    }

    @Override
    public List<OrderStatusLogRespDto> queryOrderStatus(Long orderId) {
        return this.queryOrderStatus(orderId, TradeStatusFlowSelector.TC.getCode());
    }

    @Override
    public List<OrderStatusLogRespDto> queryOrderStatus(Long orderId, String type) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderRespDto orderDasOne = this.dgPerformOrderExtDomain.queryDtoById(orderId);
        AssertUtils.notNull((Object)orderDasOne, (String)String.format("orderId=%s\u7684\u8ba2\u5355\u4e0d\u5b58\u5728", orderId));
        TradeStatusFlowSelector statusFlowSelector = TradeStatusFlowSelector.enumOf((String)type);
        Map orderStatusMap = statusFlowSelector.getLookup();
        List saleOrderStatusList = statusFlowSelector.getSaleOrderStatusList();
        List<OrderStatusLogRespDto> orderStatusTemplateList = this.getOrderStatusTemplate(saleOrderStatusList);
        String orderSteps = orderDasOne.getOrderSteps();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            List orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, OrderStatusLogRespDto.class);
            orderStatusLogRespDtos.sort(Comparator.comparing(OrderStatusLogRespDto::getOptDate).reversed());
            Map<String, List<OrderStatusLogRespDto>> listMap = orderStatusLogRespDtos.stream().collect(Collectors.groupingBy(OrderStatusLogRespDto::getOrderStatus));
            LOGGER.info("[\u8ba2\u5355\u72b6\u6001]\u5f53\u524d\u9500\u552e\u8ba2\u5355\uff08orderId={}\uff09\u7684\u72b6\u6001\u5217\u8868:{}", (Object)orderId, (Object)orderSteps);
            for (OrderStatusLogRespDto item : orderStatusTemplateList) {
                List<OrderStatusLogRespDto> statusList = listMap.get(item.getOrderStatus());
                if (statusList != null) {
                    OrderStatusLogRespDto statusLogRespDto = statusList.get(0);
                    item.setOptDate(statusLogRespDto.getOptDate());
                }
                if (!orderDasOne.getOrderStatus().equals(item.getOrderStatus())) continue;
                break;
            }
        }
        for (int i = 0; i < orderStatusTemplateList.size(); ++i) {
            SaleOrderStatusFlowTemplate saleOrderStatus;
            OrderStatusLogRespDto item = orderStatusTemplateList.get(i);
            if (i == 0) {
                item.setOptDate(orderDasOne.getCreateTime());
            }
            if (orderDasOne.getOrderStatus().equals(item.getOrderStatus())) {
                item.setActive(Boolean.TRUE);
            }
            if ((saleOrderStatus = (SaleOrderStatusFlowTemplate)orderStatusMap.get(item.getOrderStatus())) == null) continue;
            item.setOrderStatus(saleOrderStatus.getDesc());
        }
        LOGGER.info("[\u8ba2\u5355\u72b6\u6001]\u5f53\u524d\u9500\u552e\u8ba2\u5355\uff08orderId={}\uff09\u7684\u72b6\u6001\u5217\u8868:{}", (Object)orderId, (Object)JSON.toJSONString(orderStatusTemplateList));
        return orderStatusTemplateList;
    }

    private List<OrderStatusLogRespDto> getOrderStatusTemplate(List<SaleOrderStatusFlowTemplate> saleOrderStatusList) {
        return saleOrderStatusList.stream().map(item -> {
            OrderStatusLogRespDto orderStatusLogRespDto = new OrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(item.getCode());
            return orderStatusLogRespDto;
        }).collect(Collectors.toList());
    }

    @Override
    public List<SaleOrderRespDto> queryByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        List dgPerformOrderRespDtos = this.dgPerformOrderExtDomain.queryListByOrderIds(orderIds);
        List saleOrderEos = dgPerformOrderRespDtos.stream().map(e -> {
            TcPerformOrderRespDto tcPerformOrderRespDto = (TcPerformOrderRespDto)e;
            DgSaleOrderEo dgSaleOrderEo = new DgSaleOrderEo();
            BeanUtil.copyProperties((Object)tcPerformOrderRespDto.getBizSaleOrderRespDto(), (Object)dgSaleOrderEo, (String[])new String[0]);
            return dgSaleOrderEo;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(saleOrderEos)) {
            return null;
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList(saleOrderEos, (Collection)resultList, SaleOrderRespDto.class);
        return resultList;
    }

    @Override
    public List<CsDeliveryResultOrderRespDto> queryDeliveryInfo(String orderNo) {
        AssertUtils.notBlank((String)orderNo, (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!");
        RestResponse listRestResponse = this.deliveryResultOrderQueryApi.queryByOrderNo(orderNo);
        return (List)RestResponseHelper.extractData((RestResponse)listRestResponse);
    }

    @Override
    public DgSaleOrderEo createChildOrder(DgSaleOrderEo childOrderEo) {
        childOrderEo.setSaleOrderNo(this.noGreateUtil.generateOrderNo());
        childOrderEo.setOrderLevel(SaleOrderLevelEnum.CHILD.getType());
        this.dgPerformOrderExtDomain.insert(childOrderEo);
        TrackOptLogUtils.addOrderTrackOptLog((Long)childOrderEo.getId(), (String)("\u62c6\u5355\u521b\u5efa\u8ba2\u5355" + childOrderEo.getSaleOrderNo()));
        LOGGER.info("[\u62c6\u5355]\u5b50\u8ba2\u5355({})\u7684\u57fa\u672c\u4fe1\u606f\u4e3a\uff1a{}", (Object)childOrderEo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)childOrderEo));
        return childOrderEo;
    }

    @Override
    public void markLabel(Long saleOrderId, String oriLabel, String optLabel) {
        LOGGER.info("[\u8ba2\u5355\u6253\u6807] saleOrderId={}, oriLabel={}, optLabel={}", new Object[]{saleOrderId, oriLabel, optLabel});
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)optLabel, (String)"optLabel \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(saleOrderId);
        String newLabel = OrderOptLabelUtils.appendLabel(oriLabel, optLabel);
        updateEo.setOptLabel(newLabel);
        this.updateSaleOrderById(saleOrderId, updateEo);
    }

    @Override
    public void removeLabel(Long saleOrderId, String oriLabel, String ... optLabels) {
        LOGGER.info("[\u8ba2\u5355\u6253\u6807\u79fb\u9664] saleOrderId={}, oriLabel={}, optLabel={}", new Object[]{saleOrderId, oriLabel, optLabels});
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)optLabels, (String)"optLabels \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(saleOrderId);
        String newLabel = OrderOptLabelUtils.removeLabel(oriLabel, optLabels);
        updateEo.setOptLabel(newLabel);
        this.updateSaleOrderById(saleOrderId, updateEo);
    }

    @Override
    public void removeAllLabel(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(saleOrderId);
        updateEo.setOptLabel(" ");
        this.updateSaleOrderById(saleOrderId, updateEo);
    }

    @Override
    public void markAndRemoveLabel(Long saleOrderId, String oriLabel, List<String> addLabels, List<String> removeLabels) {
        LOGGER.info("[\u8ba2\u5355\u6253\u6807\u6dfb\u52a0\u5e76\u79fb\u9664] saleOrderId={}, oriLabel={}, addLabels={},removeLabels={} ", new Object[]{saleOrderId, oriLabel, JSON.toJSONString(addLabels), JSON.toJSONString(removeLabels)});
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(saleOrderId);
        String labelResult = OrderOptLabelUtils.appendLabel(oriLabel, StringUtils.join(addLabels, (String)","));
        if (CollectionUtils.isNotEmpty(removeLabels)) {
            for (String removeLabel : removeLabels) {
                labelResult = OrderOptLabelUtils.removeLabel(labelResult, removeLabel);
            }
        }
        updateEo.setOptLabel(labelResult);
        this.updateSaleOrderById(saleOrderId, updateEo);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void removeLogicalWarehouseInfo(String saleOrderNo) {
        this.dgPerformOrderExtDomain.removeLogicalWarehouseInfo(saleOrderNo);
    }

    @Override
    public List<SaleOrderRespDto> queryByPlatformOrderId(Long platformOrderId) {
        List saleOrderEos = this.dgPerformOrderExtDomain.queryByPlatformOrderId(platformOrderId);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, SaleOrderRespDto.class);
        return resultList;
    }

    @Override
    public List<SaleOrderRespDto> queryChildByOriOrderNo(String originalOrderNo) {
        List dgPerformOrderRespDtos = this.dgPerformOrderExtDomain.queryChildByOriOrderNo(originalOrderNo);
        List<SaleOrderRespDto> respDtoList = dgPerformOrderRespDtos.stream().map(e -> {
            TcPerformOrderRespDto tcPerformOrderRespDto = (TcPerformOrderRespDto)e;
            SaleOrderRespDto saleOrderRespDto = new SaleOrderRespDto();
            BeanUtil.copyProperties((Object)tcPerformOrderRespDto.getBizSaleOrderRespDto(), (Object)saleOrderRespDto, (String[])new String[0]);
            return saleOrderRespDto;
        }).collect(Collectors.toList());
        return respDtoList;
    }

    @Override
    public List<SaleOrderRespDto> queryByPlatFormOrderNo(String platFormOrderNo, String platFormOrderSelectTypeCode) {
        List saleOrderEos = this.dgPerformOrderExtDomain.queryByPlatFormOrderNo(platFormOrderNo, platFormOrderSelectTypeCode);
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)respDtoList, SaleOrderRespDto.class);
        return respDtoList;
    }

    @Override
    public void sendMsgForDeliveryResult(SaleOrderRespDto saleOrderRespDto, OmsSaleOrderStatus saleOrderStatus, OutDeliveryResultReqDto outDeliveryResultReqDto) {
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"saleOrderRespDto \u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Integer status = 0;
        switch (saleOrderStatus) {
            case WAIT_DELIVERY: {
                status = 1;
                break;
            }
            case DELIVERY_ALL: {
                status = 3;
                break;
            }
            case COMPLETE: {
                status = 4;
                break;
            }
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("orderNo", saleOrderRespDto.getPlatformOrderNo());
        msgMap.put("status", status);
        if (Objects.nonNull(outDeliveryResultReqDto)) {
            msgMap.put("saleOrderNo", outDeliveryResultReqDto.getOrderNo());
            msgMap.put("saleOrderId", saleOrderRespDto.getId());
            msgMap.put("shipmentEnterpriseCode", outDeliveryResultReqDto.getShipmentEnterpriseCode());
            msgMap.put("shipmentEnterpopriseName", outDeliveryResultReqDto.getShipmentEnterpriseName());
            msgMap.put("shippingNo", outDeliveryResultReqDto.getShippingNo());
            msgMap.put("outNoticeOrderNo", outDeliveryResultReqDto.getOutNoticeOrderNo());
            List saleOrderItemRespDtos = this.dgPerformOrderItemExtDomain.queryOrderItemByOrderId(saleOrderRespDto.getId());
            Map itemRespDtoMap = saleOrderItemRespDtos.stream().collect(Collectors.toMap(DgPerformOrderItemDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
            ArrayList itemMapList = Lists.newArrayList();
            outDeliveryResultReqDto.getDeliveryDetailList().forEach(item -> Optional.ofNullable(itemRespDtoMap.get(item.getLongCode())).ifPresent(saleOrderItemRespDto -> {
                HashMap itemMap = Maps.newHashMap();
                itemMap.put("itemCode", saleOrderItemRespDto.getItemCode());
                itemMap.put("skuCode", saleOrderItemRespDto.getSkuCode());
                itemMap.put("packId", saleOrderItemRespDto.getPackId());
                itemMap.put("itemNum", item.getOutQuantity());
                itemMap.put("platformOrderItemNo", saleOrderItemRespDto.getPlatformOrderItemNo());
                itemMapList.add(itemMap);
            }));
            msgMap.put("goodsList", itemMapList);
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString(msgMap));
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20\u53d1\u9001mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("DELIVERY_RESULT_B2B_MESSAGE_TAG", (Object)messageVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSaleOrderAssignStatus(Long id, SaleOrderAssignStatusEnum assignStatusEnum) {
        DgSaleOrderEo updateEo = new DgSaleOrderEo();
        updateEo.setId(id);
        updateEo.setAssignStatus(assignStatusEnum.getCode());
        updateEo.setInterceptInfo("");
        this.dgPerformOrderExtDomain.updateSaleOrderById(id, updateEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateEasVerifyStatus(String saleOrderNo) {
        this.dgPerformOrderExtDomain.updateEasVerifyStatus(saleOrderNo);
    }

    @Override
    public List<SaleOrderRespDto> queryByParamList(SaleOrderQueryReqDto queryReqDto) {
        TcPerformOrderReqDto tcPerformOrderReqDto = new TcPerformOrderReqDto();
        tcPerformOrderReqDto.setSaleOrderReqDto((SaleOrderReqDto)queryReqDto);
        List dgPerformOrderRespDtos = this.dgPerformOrderExtDomain.queryByParamList((DgPerformOrderReqDto)tcPerformOrderReqDto);
        List<SaleOrderRespDto> resultList = dgPerformOrderRespDtos.stream().map(this::converDto).collect(Collectors.toList());
        return resultList;
    }

    @Override
    public BizSaleOrderRespDto queryNewestOrderByCustomerId(Long customerId) {
        DgPerformOrderRespDto dgPerformOrderRespDto = this.dgPerformOrderExtDomain.queryNewestOrderByCustomerId(customerId);
        return this.converDto(dgPerformOrderRespDto);
    }

    @Override
    public String getSaleOrderNo() {
        return this.noGreateUtil.generateOrderNo();
    }

    @Override
    public boolean isClaimOrder(String orderType) {
        return SaleOrderTypeEnum.CLAIM_POSTING.getType().equals(orderType) || SaleOrderTypeEnum.CLAIM_REISSUE.getType().equals(orderType) || SaleOrderTypeEnum.BB_TRANSFER_CLAIM_NOT_REISSUE.getType().equals(orderType) || SaleOrderTypeEnum.DS_TRANSFER_CLAIMS_NOT_REISSUE.getType().equals(orderType);
    }

    @Override
    public void updateEasOutOrderNo(List<String> saleOrders, String easOutOrderNo) {
        LOGGER.info("\u66f4\u65b0eas\u51fa\u5e93\u5355\u53f7\uff1a{}\uff0c{}", (Object)JSON.toJSONString(saleOrders), (Object)easOutOrderNo);
        List saleOrderEos = this.dgPerformOrderExtDomain.queryEoByOrderNos(saleOrders);
        if (CollectionUtils.isNotEmpty((Collection)saleOrderEos)) {
            saleOrderEos.forEach(eo -> {
                DgSaleOrderEo update = new DgSaleOrderEo();
                update.setId(eo.getId());
                update.setEasOutOrderNo(easOutOrderNo);
                this.dgPerformOrderExtDomain.updateSaleOrderById(eo.getId(), update);
            });
            return;
        }
        throw new BizException("-1", "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u9500\u552e\u5355");
    }

    @Override
    public boolean isYyJOrder(String orderType) {
        return SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.REPLENISHMENT_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.NUTRITION_INTEGRAL.getType().equals(orderType);
    }

    @Override
    public void sendEasSaleOrderRest(String saleOrderNo) {
        AssertUtils.notEmpty((String)saleOrderNo, (String)"\u9500\u552e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BizSaleOrderRespDto saleOrderRespDto = this.queryByOrderNo(saleOrderNo);
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u9500\u552e\u5355\u53f7\u5bf9\u5e94\u9500\u552e\u5355\u4e0d\u5b58\u5728");
        BizSaleOrderReqDto bizSaleOrderReqDto = new BizSaleOrderReqDto();
        CubeBeanUtils.copyProperties((Object)bizSaleOrderReqDto, (Object)saleOrderRespDto, (String[])new String[]{"itemList"});
        bizSaleOrderReqDto.setSaleCreateTime(saleOrderRespDto.getCreateTime());
        bizSaleOrderReqDto.setManualCreate(Boolean.TRUE);
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)saleOrderRespDto.getItemList(), SaleOrderItemReqDto.class);
        bizSaleOrderReqDto.setItemList((List)itemList);
        SaleOrderAddrReqDto saleOrderAddrReqDto = new SaleOrderAddrReqDto();
        CubeBeanUtils.copyProperties((Object)saleOrderAddrReqDto, (Object)saleOrderRespDto.getOrderAddrRespDto(), (String[])new String[0]);
        bizSaleOrderReqDto.setOrderAddrReqDto(saleOrderAddrReqDto);
        LOGGER.info("\u53d1\u9001Eas\u9500\u552e\u5355\u91cd\u8bd5\u63a5\u53e3");
        this.sendEasSaleOrder(bizSaleOrderReqDto);
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#platformOrderNo")
    @Transactional(rollbackFor={Exception.class})
    public void easCancelOrderLock(String platformOrderNo) {
        LOGGER.info("easCancelOrder==>{}", (Object)platformOrderNo);
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
        saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
        List<SaleOrderRespDto> saleOrderRespDtos = this.queryByParamList(saleOrderQueryReqDto);
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            LOGGER.info("\u6839\u636e\u5e73\u53f0\u5355\u672a\u67e5\u8be2\u5230\u6709\u6548\u9500\u552e\u5355\u4fe1\u606f");
            return;
        }
        List<SaleOrderRespDto> orderRespDtos = this.easCheckOrderStatus(saleOrderRespDtos);
        for (SaleOrderRespDto orderRespDto : orderRespDtos) {
            if (SaleOrderStatusEnum.SPLIT.getCode().equals(orderRespDto.getOrderStatus())) continue;
            DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
            updateSaleOrder.setLockStatus(LockStatusEnum.LOCK.getType());
            updateSaleOrder.setLockType(LockTypeEnum.EAS_CANCEL.getType());
            DgSaleOrderEo queryEo = new DgSaleOrderEo();
            queryEo.setId(orderRespDto.getId());
            UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
            this.dgPerformOrderExtDomain.optimisticModifySaleOrder(updateSaleOrder, updateWrapper, 1, true);
        }
    }

    private List<SaleOrderRespDto> easCheckOrderStatus(List<SaleOrderRespDto> saleOrderRespDtos) {
        ArrayList orderRespDtos = Lists.newArrayList();
        StringBuffer errorMsg = new StringBuffer();
        for (SaleOrderRespDto saleOrderRespDto : saleOrderRespDtos) {
            String orderType = saleOrderRespDto.getOrderType();
            if (LockStatusEnum.LOCK.getType().equals(saleOrderRespDto.getLockStatus()) && LockTypeEnum.SYSTEM.getType().equals(saleOrderRespDto.getLockType())) {
                if (Objects.equals(orderType, SaleOrderTypeEnum.MAIYOU_ALLOT.getType())) {
                    errorMsg = errorMsg.append("\u5355\u53f7[").append(saleOrderRespDto.getSaleOrderNo()).append("]\u5df2\u53d1\u8d77\u8c03\u62e8\u4e0d\u53ef\u53cd\u5ba1;");
                    continue;
                }
                errorMsg = errorMsg.append("\u5355\u53f7[").append(saleOrderRespDto.getSaleOrderNo()).append("]\u8c03\u62e8\u7c7b\u578b\u6302\u8d77\u4e0d\u53ef\u53cd\u5ba1;");
                continue;
            }
            if (!SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType().equals(orderType)) {
                if (SaleOrderStatusEnum.COMPLETE.getCode().equals(saleOrderRespDto.getOrderStatus()) || SaleOrderStatusEnum.RECEIVED.getCode().equals(saleOrderRespDto.getOrderStatus()) || SaleOrderStatusEnum.WAIT_DELIVERY.getCode().equals(saleOrderRespDto.getOrderStatus())) {
                    errorMsg = errorMsg.append("\u5355\u53f7[").append(saleOrderRespDto.getSaleOrderNo()).append("]\u72b6\u6001[").append(SaleOrderStatusEnum.forCode((String)saleOrderRespDto.getOrderStatus()).getDesc()).append("]\u4e0d\u53ef\u64cd\u4f5c;");
                    continue;
                }
                boolean orderTransferFlag = this.checkOrderTransfer(saleOrderRespDto.getSaleOrderNo());
                if (orderTransferFlag) {
                    errorMsg = errorMsg.append("\u5355\u53f7[").append(saleOrderRespDto.getSaleOrderNo()).append("\u5df2\u5173\u8054\u9500\u552e\u8c03\u62e8\u5355,\u4e0d\u53ef\u64cd\u4f5c");
                    continue;
                }
            }
            orderRespDtos.add(saleOrderRespDto);
        }
        if (StringUtils.isNotEmpty((CharSequence)errorMsg.toString())) {
            throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{errorMsg.toString()});
        }
        return orderRespDtos;
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#platformOrderNo")
    @Transactional(rollbackFor={Exception.class})
    public void easDeleteOrderLock(String platformOrderNo) {
        LOGGER.info("easDeleteOrderLock==>{}", (Object)platformOrderNo);
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
        saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
        List<SaleOrderRespDto> saleOrderRespDtos = this.queryByParamList(saleOrderQueryReqDto);
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            LOGGER.info("\u6839\u636e\u5e73\u53f0\u5355\u672a\u67e5\u8be2\u5230\u6709\u6548\u9500\u552e\u5355\u4fe1\u606f");
            return;
        }
        List<SaleOrderRespDto> orderRespDtos = this.easCheckOrderStatus(saleOrderRespDtos);
        ArrayList cancelLogicOrderList = Lists.newArrayList();
        ArrayList cancelChannelOrderList = Lists.newArrayList();
        for (SaleOrderRespDto orderRespDto : orderRespDtos) {
            boolean pickStatus;
            if (Objects.nonNull(orderRespDto.getPlatformOrderId()) && SaleOrderStatusEnum.SPLIT.getCode().equals(orderRespDto.getOrderStatus()) && !SaleOrderTypeEnum.BAIJIAN_DIRECT_SALES.getType().equals(orderRespDto.getOrderType())) continue;
            DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
            updateSaleOrder.setOrderStatus(SaleOrderStatusEnum.CANCEL.getCode());
            updateSaleOrder.setLockStatus(LockStatusEnum.LOCK.getType());
            updateSaleOrder.setLockType(LockTypeEnum.EAS_DEL.getType());
            boolean bl = pickStatus = Objects.equals(orderRespDto.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode()) && Objects.equals(orderRespDto.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
            if (pickStatus) {
                cancelLogicOrderList.add(orderRespDto.getSaleOrderNo());
                try {
                    this.saleTransferExtDomain.delByOrderId(orderRespDto.getId());
                }
                catch (Exception e) {
                    LOGGER.info("\u5220\u9664\u8ba2\u5355\u5173\u8054\u7684\u8c03\u62e8\u5355\u62a5\u9519:{}", (Object)e.getMessage());
                }
            }
            if (Objects.isNull(orderRespDto.getPlatformOrderId()) || SaleOrderTypeEnum.BAIJIAN_DIRECT_SALES.getType().equals(orderRespDto.getOrderType())) {
                updateSaleOrder.setOrderStatus(SaleOrderStatusEnum.OBSOLETE.getCode());
                updateSaleOrder.setSecondOrderStatus("");
                updateSaleOrder.setLockStatus(LockStatusEnum.UNLOCK.getType());
                updateSaleOrder.setLockType(LockTypeEnum.MANUAL.getType());
                if (!SaleOrderTypeEnum.CHILD_DIRECT_SALES.getType().equals(orderRespDto.getOrderType()) && !SaleOrderStatusEnum.SPLIT.getCode().equals(orderRespDto.getOrderStatus())) {
                    cancelChannelOrderList.add(orderRespDto);
                }
            }
            DgSaleOrderEo queryEo = new DgSaleOrderEo();
            queryEo.setId(orderRespDto.getId());
            UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
            this.dgPerformOrderExtDomain.optimisticModifySaleOrder(updateSaleOrder, updateWrapper, 1, true);
        }
        if (CollectionUtils.isNotEmpty((Collection)cancelLogicOrderList)) {
            this.bInventoryApiServcie.batchCancelLogicAndPhysicsOrder(cancelLogicOrderList, new ArrayList<String>());
        }
        if (CollectionUtils.isNotEmpty((Collection)cancelChannelOrderList)) {
            this.bInventoryApiServcie.batchReleaseInventory(cancelChannelOrderList);
        }
    }

    @Override
    @DgRedisLock(lockName="saleOrder", key="#platformOrderNo")
    @Transactional(rollbackFor={Exception.class})
    public void cspCancelOrderLock(String platformOrderNo) {
        LOGGER.info("easCancelOrder==>{}", (Object)platformOrderNo);
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
        saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
        List<SaleOrderRespDto> saleOrderRespDtos = this.queryByParamList(saleOrderQueryReqDto);
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            LOGGER.info("\u6839\u636e\u5e73\u53f0\u5355\u672a\u67e5\u8be2\u5230\u6709\u6548\u9500\u552e\u5355\u4fe1\u606f");
            return;
        }
        List<SaleOrderRespDto> orderRespDtos = this.easCheckOrderStatus(saleOrderRespDtos);
        ArrayList cancelLogicOrderList = Lists.newArrayList();
        for (SaleOrderRespDto orderRespDto : orderRespDtos) {
            if (SaleOrderStatusEnum.SPLIT.getCode().equals(orderRespDto.getOrderStatus())) continue;
            if (!SaleOrderStatusEnum.allowAuditNotPassStatus().contains(orderRespDto.getOrderStatus())) {
                throw PcpTradeExceptionCode.NORMAL_EXCEPTION.buildBizException(new Object[]{"\u9500\u552e\u5355\u72b6\u6001\u4e0d\u7b26\u5408\u53cd\u5ba1\u6761\u4ef6"});
            }
            DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
            updateSaleOrder.setLockType(LockTypeEnum.CSP_CANCEL.getType());
            String orderType = orderRespDto.getOrderType();
            if (SaleOrderTypeEnum.saleOutOrderTypeList.contains(orderType)) {
                updateSaleOrder.setOrderStatus(SaleOrderStatusEnum.OBSOLETE.getCode());
                this.bInventoryApiServcie.batchReleaseInventory(saleOrderRespDtos);
            } else if (SaleOrderTypeEnum.otherOutOrderTypeList.contains(orderType)) {
                boolean pickStatus;
                boolean bl = pickStatus = Objects.equals(orderRespDto.getOrderStatus(), SaleOrderStatusEnum.WAIT_PICK.getCode()) && Objects.equals(orderRespDto.getSecondOrderStatus(), SecondSaleOrderStatusEnum.WAIT_PICK_LOCK_UN_APPOINT.getCode());
                if (pickStatus) {
                    cancelLogicOrderList.add(orderRespDto.getSaleOrderNo());
                    try {
                        this.saleTransferExtDomain.delByOrderId(orderRespDto.getId());
                    }
                    catch (Exception e) {
                        LOGGER.info("\u5220\u9664\u8ba2\u5355\u5173\u8054\u7684\u8c03\u62e8\u5355\u62a5\u9519:{}", (Object)e.getMessage());
                    }
                }
                updateSaleOrder.setOrderStatus(SaleOrderStatusEnum.OBSOLETE.getCode());
            }
            DgSaleOrderEo queryEo = new DgSaleOrderEo();
            queryEo.setId(orderRespDto.getId());
            UpdateWrapper updateWrapper = Wrappers.update((Object)queryEo);
            this.dgPerformOrderExtDomain.optimisticModifySaleOrder(updateSaleOrder, updateWrapper, 1, true);
            try {
                this.saleTransferExtDomain.delByOrderId(orderRespDto.getId());
            }
            catch (Exception e) {
                LOGGER.info("\u5220\u9664\u8ba2\u5355\u5173\u8054\u7684\u8c03\u62e8\u5355\u62a5\u9519:{}", (Object)e.getMessage());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)cancelLogicOrderList)) {
            LOGGER.info("\u53d6\u6d88\u8ba2\u5355\uff0c\u91ca\u653e\u5e93\u5b58,\u6e20\u9053\u5355\u53f7\u4e3a:{}", (Object)platformOrderNo);
            this.bInventoryApiServcie.batchCancelLogicAndPhysicsOrder(cancelLogicOrderList, new ArrayList<String>());
        }
    }

    @Override
    public void cspObsoleteByPlatformOrderNo(String platformOrderNo) {
        LOGGER.info("orderObsoleteByPlatformOrderNo==>{}", (Object)platformOrderNo);
        SaleOrderQueryReqDto saleOrderQueryReqDto = new SaleOrderQueryReqDto();
        saleOrderQueryReqDto.setPlatformOrderNo(platformOrderNo);
        saleOrderQueryReqDto.setNotOrderStatusList((List)Lists.newArrayList((Object[])new String[]{SaleOrderStatusEnum.OBSOLETE.getCode()}));
        List<SaleOrderRespDto> saleOrderRespDtos = this.queryByParamList(saleOrderQueryReqDto);
        if (CollectionUtils.isEmpty(saleOrderRespDtos)) {
            LOGGER.info("\u6839\u636e\u5e73\u53f0\u5355\u4f5c\u5e9f\u8ba2\u5355\u672a\u67e5\u8be2\u5230\u6709\u6548\u9500\u552e\u5355\u4fe1\u606f");
            return;
        }
        ArrayList cancelChannelOrderList = Lists.newArrayList();
        for (SaleOrderRespDto orderRespDto : saleOrderRespDtos) {
            if (SaleOrderTypeEnum.PRESALE_ORDER.getType().equals(orderRespDto.getOrderType()) && !SaleOrderStatusEnum.WAIT_CHECK.getCode().equals(orderRespDto.getOrderStatus())) {
                cancelChannelOrderList.add(orderRespDto);
            }
            DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
            updateSaleOrder.setLockStatus(LockStatusEnum.UNLOCK.getType());
            updateSaleOrder.setLockType(LockTypeEnum.MANUAL.getType());
            updateSaleOrder.setOrderStatus(SaleOrderStatusEnum.OBSOLETE.getCode());
            updateSaleOrder.setSecondOrderStatus("");
            this.updateSaleOrderById(orderRespDto.getId(), updateSaleOrder);
        }
        if (CollectionUtils.isNotEmpty((Collection)cancelChannelOrderList)) {
            this.bInventoryApiServcie.batchReleaseInventory(cancelChannelOrderList);
        }
    }

    private boolean checkOrderTransfer(String saleOrderNo) {
        SaleTransferOrderReqDto saleTransferOrderReqDto = new SaleTransferOrderReqDto();
        saleTransferOrderReqDto.setSaleOrderNo(saleOrderNo);
        saleTransferOrderReqDto.setTransferTypeList((List)Lists.newArrayList((Object[])new String[]{SaleTransferTypeEnum.SALE.getCode(), AllotTypeEnum.MAIYOU_CC_ALLOT.getType(), AllotTypeEnum.MAIYOU_BC_ALLOT.getType(), AllotTypeEnum.MAIYOU_CC_ALLOT_OUT.getType()}));
        List<SaleTransferOrderRespDto> saleTransferOrderRespDtos = this.saleTransferOrderService.queryByParam(saleTransferOrderReqDto);
        return CollectionUtils.isNotEmpty(saleTransferOrderRespDtos);
    }

    @Override
    public Boolean verifySaleOrderEntireSign(Long orderId, String saleOrderNo) {
        return this.dgPerformOrderExtDomain.verifySaleOrderEntireSign(orderId, saleOrderNo);
    }

    @Override
    public BizSaleOrderDetailRespDto queryOrderDetail(String saleOrderNo) {
        BizSaleOrderRespDto saleOrderRespDto = this.queryByOrderNo(saleOrderNo);
        LOGGER.info("[\u7b2c\u4e09\u65b9\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5]\u67e5\u8be2\u7684\u9500\u552e\u5355\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderRespDto));
        List<OrderStatusLogRespDto> orderStatusLogRespDtos = this.queryOrderStatus(saleOrderRespDto.getId());
        LOGGER.info("[\u7b2c\u4e09\u65b9\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5]\u67e5\u8be2\u7684\u9500\u552e\u5355\u72b6\u6001\u6d41\u8f6c\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderStatusLogRespDtos));
        List<CsDeliveryResultOrderRespDto> deliveryResultOrderRespDtos = this.queryDeliveryInfo(saleOrderNo);
        LOGGER.info("[\u7b2c\u4e09\u65b9\u67e5\u8be2\u9500\u552e\u5355\u8be6\u60c5]\u67e5\u8be2\u7684\u9500\u552e\u5355\u7269\u6d41\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString(deliveryResultOrderRespDtos));
        BizSaleOrderDetailRespDto saleOrderDetailRespDto = new BizSaleOrderDetailRespDto();
        ArrayList itemRespDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemRespDtoList, (Collection)saleOrderRespDto.getItemList(), BizSaleOrderItemRespDto.class);
        CubeBeanUtils.copyProperties((Object)saleOrderDetailRespDto, (Object)saleOrderRespDto, (String[])new String[]{"itemList", "relatedOrderList", ""});
        saleOrderDetailRespDto.setItemList((List)itemRespDtoList);
        saleOrderDetailRespDto.setRelatedOrderList(saleOrderDetailRespDto.getRelatedOrderList());
        saleOrderDetailRespDto.setOrderAddrRespDto(saleOrderDetailRespDto.getOrderAddrRespDto());
        saleOrderDetailRespDto.setOrderStatusList(orderStatusLogRespDtos);
        if (CollectionUtils.isNotEmpty(deliveryResultOrderRespDtos)) {
            CsDeliveryResultOrderRespDto deliveryResultOrderRespDto = deliveryResultOrderRespDtos.get(0);
            LogisticsRespDto logisticsRespDto = new LogisticsRespDto();
            CubeBeanUtils.copyProperties((Object)logisticsRespDto, (Object)deliveryResultOrderRespDto, (String[])new String[0]);
            saleOrderDetailRespDto.setLogisticsInfo(logisticsRespDto);
        }
        return saleOrderDetailRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void sapOrderLineUpdate(SapOrderLineUpdateReqDto reqDto) {
        Map itemMap = reqDto.getItems().stream().collect(Collectors.toMap(SapOrderLineItemReqDto::getItemId, Function.identity()));
        SaleOrderQueryReqDto queryReqDto = new SaleOrderQueryReqDto();
        queryReqDto.setPlatformOrderNo(reqDto.getCustomerOrderNumber());
        queryReqDto.setOrderLevelList((List)Lists.newArrayList((Object[])new Integer[]{SaleOrderLevelEnum.MAIN.getType(), SaleOrderLevelEnum.ORIGINAL.getType()}));
        BizSaleOrderRespDto mainOrder = this.queryMainSaleOrderByPlatFormOrderNo(queryReqDto);
        AssertUtils.isFalse((mainOrder == null ? 1 : 0) != 0, (String)"\u4e3b\u5355\u6216\u539f\u5355\u4fe1\u606f\u672a\u627e\u5230");
        ArrayList updateSaleOrders = Lists.newArrayList();
        DgSaleOrderEo updateSaleOrder = new DgSaleOrderEo();
        updateSaleOrder.setEasOrderNo(reqDto.getSapOrderNo());
        updateSaleOrder.setId(mainOrder.getId());
        updateSaleOrders.add(updateSaleOrder);
        List mainOrderItemEos = ((ExtQueryChainWrapper)this.dgSaleOrderItemDomain.filter().eq((Object)"order_id", (Object)mainOrder.getId())).list();
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)mainOrderItemEos), (String)"\u4e3b\u5355\u5546\u54c1\u4fe1\u606f\u672a\u627e\u5230");
        ArrayList updateItemEos = Lists.newArrayList();
        for (Object mainOrderItemEo : mainOrderItemEos) {
            SapOrderLineItemReqDto itemReqDto = (SapOrderLineItemReqDto)itemMap.get(mainOrderItemEo.getId().toString());
            String extension = mainOrderItemEo.getExtension();
            DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
            updateItemEo.setId(mainOrderItemEo.getId());
            Map map = (Map)JSON.parseObject((String)extension, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            map.put("sapLineNo", itemReqDto.getSapOrderLine());
            updateItemEo.setExtension(JSON.toJSONString((Object)map));
            updateItemEos.add(updateItemEo);
        }
        List subSaleOrderEos = ((ExtQueryChainWrapper)this.dgSaleOrderDomain.filter().eq((Object)"platform_order_no", (Object)reqDto.getCustomerOrderNumber())).list();
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)subSaleOrderEos), (String)"\u5b50\u5355\u4fe1\u606f\u672a\u627e\u5230");
        for (DgSaleOrderEo subSaleOrderEo : subSaleOrderEos) {
            DgSaleOrderEo updateSubSaleOrder = new DgSaleOrderEo();
            updateSubSaleOrder.setId(subSaleOrderEo.getId());
            updateSubSaleOrder.setEasOrderNo(reqDto.getSapOrderNo());
            updateSaleOrders.add(updateSubSaleOrder);
        }
        List orderIds = subSaleOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List saleOrderItemEos = ((ExtQueryChainWrapper)this.dgSaleOrderItemDomain.filter().in((Object)"order_id", orderIds)).list();
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)saleOrderItemEos), (String)"\u5546\u54c1\u4fe1\u606f\u672a\u627e\u5230");
        for (DgSaleOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            SapOrderLineItemReqDto itemReqDto = (SapOrderLineItemReqDto)itemMap.get(saleOrderItemEo.getId().toString());
            String extension = saleOrderItemEo.getExtension();
            DgSaleOrderItemEo updateItemEo = new DgSaleOrderItemEo();
            updateItemEo.setId(saleOrderItemEo.getId());
            Map map = (Map)JSON.parseObject((String)extension, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            map.put("sapLineNo", itemReqDto.getSapOrderLine());
            updateItemEo.setExtension(JSON.toJSONString((Object)map));
            updateItemEos.add(updateItemEo);
        }
        for (DgSaleOrderEo saleOrder : updateSaleOrders) {
            this.dgSaleOrderDomain.updateSelective((BaseEo)saleOrder);
        }
        for (DgSaleOrderItemEo updateItemEo : updateItemEos) {
            this.dgSaleOrderItemDomain.updateSelective((BaseEo)updateItemEo);
        }
    }

    @Override
    public BizSaleOrderRespDto queryMainSaleOrderByPlatFormOrderNo(SaleOrderQueryReqDto reqDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getPlatformOrderNo()), (String)"\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)reqDto.getOrderLevelList()), (String)"\u53c2\u6570orderLevelList\u4e0d\u80fd\u4e3a\u7a7a");
        List orderList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgSaleOrderDomain.filter().eq((Object)"platform_order_no", (Object)reqDto.getPlatformOrderNo())).eq((Object)"dr", (Object)0)).in((Object)"order_level", (Collection)reqDto.getOrderLevelList())).list();
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)orderList), (String)"\u6839\u636e\u5e73\u53f0\u5355\u53f7\u672a\u67e5\u5230\u9500\u552e\u5355\u4fe1\u606f");
        AssertUtils.isFalse((orderList.size() > 1 ? 1 : 0) != 0, (String)"\u6839\u636e\u5e73\u53f0\u5355\u53f7\u67e5\u5230\u591a\u6761\u9500\u552e\u5355\u4e3b\u5355/\u539f\u5355\u4fe1\u606f");
        BizSaleOrderRespDto bizSaleOrderRespDto = new BizSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)bizSaleOrderRespDto, orderList.get(0), (String[])new String[0]);
        List itemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgSaleOrderItemDomain.filter().eq((Object)"order_id", (Object)((DgSaleOrderEo)orderList.get(0)).getId())).eq((Object)"dr", (Object)0)).list();
        ArrayList itemList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)itemList, (Collection)itemEoList, SaleOrderItemExtRespDto.class);
        bizSaleOrderRespDto.setItemList((List)itemList);
        return bizSaleOrderRespDto;
    }

    private BizSaleOrderRespDto converDto(DgPerformOrderRespDto dgPerformOrderRespDto) {
        TcPerformOrderRespDto tcPerformOrderRespDto = (TcPerformOrderRespDto)dgPerformOrderRespDto;
        return tcPerformOrderRespDto.getBizSaleOrderRespDto();
    }
}

