/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.api.warehouse.ILogicWarehouseApi;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderAbolishEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderBizSystemEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.convert.entity.DgAfterSaleOrderConverter;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.dao.mapper.DgAfterSaleOrderMapper;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterBatchReturnWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderBatchReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderTagRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderValidReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterUpdateLogisticsNoReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderTagRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderTagDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderTagRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.service.IDgAfterSaleOrderTagRecordService;
import com.yunxi.dg.base.center.trade.service.mark.IDgOrderTagService;
import com.yunxi.dg.base.center.trade.service.order.IDgPerformOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.center.trade.vo.DgRelationBillVO;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgAfterSaleOrderServiceImpl
extends BaseServiceImpl<DgAfterSaleOrderDto, DgAfterSaleOrderEo, IDgAfterSaleOrderDomain>
implements IDgAfterSaleOrderService {
    private final Logger logger = LoggerFactory.getLogger(DgAfterSaleOrderServiceImpl.class);
    @Resource
    private IDgAfterSaleOrderDas afterSaleOrderDas;
    @Resource
    private DgAfterSaleOrderMapper dgAfterSaleOrderMapper;
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;
    @Resource
    private IDgOrderTagService orderTagService;
    @Resource
    private IDgAfterSaleOrderTagRecordService afterSaleOrderTagRecordService;
    @Resource
    private IDgPerformOrderService performOrderService;
    @Resource
    private ILogicWarehouseApi logicWarehouseApi;

    public DgAfterSaleOrderServiceImpl(IDgAfterSaleOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgAfterSaleOrderDto, DgAfterSaleOrderEo> converter() {
        return DgAfterSaleOrderConverter.INSTANCE;
    }

    @Override
    public Long addAfterSaleOrder(DgAfterSaleOrderDto addReqDto) {
        if (StringUtils.isEmpty((CharSequence)addReqDto.getAfterSaleOrderNo())) {
            addReqDto.setAfterSaleOrderNo(this.dgNoGreateUtil.generateAfterSaleOrderNo());
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)addReqDto, (String[])new String[0]);
        if (StringUtils.isEmpty((CharSequence)dgAfterSaleOrderEo.getBizSystem())) {
            dgAfterSaleOrderEo.setBizSystem(DgAfterSaleOrderBizSystemEnum.DEFAULT.getCode());
        }
        this.afterSaleOrderDas.insert((BaseEo)dgAfterSaleOrderEo);
        return dgAfterSaleOrderEo.getId();
    }

    @Override
    public void modifyAfterSaleOrder(DgAfterSaleOrderReqDto modifyReqDto) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)dgAfterSaleOrderEo);
        dgAfterSaleOrderEo.setUpdateTime(new Date());
        this.afterSaleOrderDas.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAfterSaleOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.afterSaleOrderDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DgAfterSaleOrderRespDto queryById(Long id) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)this.afterSaleOrderDas.selectByPrimaryKey(id);
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, (Object)dgAfterSaleOrderEo, (String[])new String[0]);
        return afterSaleOrderRespDto;
    }

    @Override
    public DgAfterSaleOrderRespDto queryByNo(String afterSaleOrderNo) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).one();
        DgAfterSaleOrderTagRecordReqDto orderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
        orderTagRecordReqDto.setOrderId(dgAfterSaleOrderEo.getId());
        List<DgAfterSaleOrderTagRecordRespDto> afterSaleOrderTagRecordRespDtos = this.afterSaleOrderTagRecordService.queryByParam(orderTagRecordReqDto);
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, (Object)dgAfterSaleOrderEo, (String[])new String[0]);
        if (CollectionUtils.isNotEmpty(afterSaleOrderTagRecordRespDtos)) {
            List<String> tagCodes = afterSaleOrderTagRecordRespDtos.stream().map(DgAfterSaleOrderTagRecordDto::getTagCode).collect(Collectors.toList());
            List<DgOrderTagRespDto> tagEoList = this.orderTagService.queryByTagCodes(tagCodes);
            Map tagEoMap = tagEoList.stream().collect(Collectors.toMap(DgOrderTagDto::getTagCode, Function.identity()));
            afterSaleOrderRespDto.setTagRecordCodes(afterSaleOrderTagRecordRespDtos.stream().map(e -> (DgOrderTagRespDto)tagEoMap.get(e.getTagCode())).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderRespDto.getAfterSalesVoucher())) {
            afterSaleOrderRespDto.setAfterSalesVoucherList(Arrays.asList(afterSaleOrderRespDto.getAfterSalesVoucher().split(",")));
        }
        this.setRelateBillInfo(afterSaleOrderRespDto);
        return afterSaleOrderRespDto;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByBizAfterSaleOrderReqDto(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        List saleOrderEos;
        if (StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformOrderNo()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getSaleOrderNo()) && CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformOrderNo(), (String)"platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn(), (String)"platformRefundOrderSn\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getSaleOrderNo(), (String)"saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            if (CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
                throw new BizException("platformRefundOrderSnList\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)bizAfterSaleOrderReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)dgAfterSaleOrderEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.eq(DgAfterSaleOrderEo::getAbolishFlag, (Object)DgAfterSaleOrderAbolishEnum.NO.getCode());
        queryWrapper.orderByDesc(DgAfterSaleOrderEo::getPlatformCreated);
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
            queryWrapper.in(DgAfterSaleOrderEo::getPlatformRefundOrderSn, (Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderTypeList())) {
            queryWrapper.in(DgAfterSaleOrderEo::getAfterSaleOrderType, (Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderTypeList());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.afterSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper)))) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgAfterSaleOrderRespDto.class);
        return resultList;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> querNeedRefreshSaleOrderStatusList(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        AssertUtils.notNull((Object)bizAfterSaleOrderReqDto.getUpdateBeginTime(), (String)"\u66f4\u65b0\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u672a\u7a7a");
        AssertUtils.notNull((Object)bizAfterSaleOrderReqDto.getUpdateEndTime(), (String)"\u66f4\u65b0\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u672a\u7a7a");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)bizAfterSaleOrderReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)dgAfterSaleOrderEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.eq(DgAfterSaleOrderEo::getAbolishFlag, (Object)DgAfterSaleOrderAbolishEnum.NO.getCode());
        queryWrapper.eq(DgAfterSaleOrderEo::getStatus, (Object)DgAfterSaleOrderStatusEnum.FINISH.getCode());
        queryWrapper.and(wrapper -> {
            wrapper.isNull(DgAfterSaleOrderEo::getRelateToPlatformOrder);
            wrapper.or(wp -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)wp.eq(DgAfterSaleOrderEo::getRelateToPlatformOrder, (Object)"0");
            });
        });
        queryWrapper.orderByDesc(DgAfterSaleOrderEo::getPlatformCreated);
        queryWrapper.between(BaseEo::getUpdateTime, (Object)bizAfterSaleOrderReqDto.getUpdateBeginTime(), (Object)bizAfterSaleOrderReqDto.getUpdateEndTime());
        List saleOrderEos = this.afterSaleOrderDas.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgAfterSaleOrderRespDto.class);
        return resultList;
    }

    @Override
    public PageInfo<DgAfterSaleOrderRespDto> queryByPage(DgAfterSaleOrderValidReqDto afterSaleOrderReqDto, Integer pageNum, Integer pageSize) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)afterSaleOrderReqDto, (BaseEo)dgAfterSaleOrderEo);
        ArrayList selectFilter = new ArrayList();
        QueryWrapper builder = new QueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderReqDto.getReason())) {
            builder.like((Object)"reason", (Object)afterSaleOrderReqDto.getReason());
            dgAfterSaleOrderEo.setReason(null);
        }
        if (afterSaleOrderReqDto.getStartPlatformCreated() != null) {
            builder.ge((Object)"platform_created", (Object)afterSaleOrderReqDto.getStartPlatformCreated());
        }
        if (afterSaleOrderReqDto.getEndPlatformCreated() != null) {
            builder.lt((Object)"platform_created", (Object)afterSaleOrderReqDto.getEndPlatformCreated());
        }
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderReqDto.getOrderNo())) {
            builder.and(wrapper -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.in((Object)"after_sale_order_no", (Collection)afterSaleOrderReqDto.getOrderNo())).or()).in((Object)"sale_order_no", (Collection)afterSaleOrderReqDto.getOrderNo())).or()).in((Object)"platform_refund_order_sn", (Collection)afterSaleOrderReqDto.getOrderNo())).or()).in((Object)"platform_order_no", (Collection)afterSaleOrderReqDto.getOrderNo());
            });
        }
        if (afterSaleOrderReqDto.getInWarehouseDateStart() != null) {
            builder.ge((Object)"in_warehouse_date", (Object)afterSaleOrderReqDto.getInWarehouseDateStart());
        }
        if (afterSaleOrderReqDto.getInWarehouseDateEnd() != null) {
            builder.lt((Object)"in_warehouse_date", (Object)afterSaleOrderReqDto.getInWarehouseDateEnd());
        }
        if (afterSaleOrderReqDto.getCompleteDateStart() != null) {
            builder.ge((Object)"complete_date", (Object)afterSaleOrderReqDto.getCompleteDateStart());
        }
        if (afterSaleOrderReqDto.getCompleteDateEnd() != null) {
            builder.lt((Object)"complete_date", (Object)afterSaleOrderReqDto.getCompleteDateEnd());
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getReturnWarehouseCode())) {
            builder.eq((Object)"return_warehouse_code", (Object)afterSaleOrderReqDto.getReturnWarehouseCode());
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getStatus())) {
            builder.eq((Object)"status", (Object)afterSaleOrderReqDto.getStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getRefundStatus())) {
            builder.eq((Object)"refund_status", (Object)afterSaleOrderReqDto.getRefundStatus());
        }
        if (afterSaleOrderReqDto.getShopId() != null) {
            builder.eq((Object)"shop_id", (Object)afterSaleOrderReqDto.getShopId());
        }
        if (afterSaleOrderReqDto.getReturnType() != null) {
            builder.eq((Object)"return_type", (Object)afterSaleOrderReqDto.getReturnType());
        }
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderReqDto.getAfterSaleOrderType())) {
            builder.eq((Object)"after_sale_order_type", (Object)afterSaleOrderReqDto.getAfterSaleOrderType());
        }
        if (afterSaleOrderReqDto.getDeliveryStatus() != null) {
            builder.eq((Object)"delivery_status", (Object)afterSaleOrderReqDto.getDeliveryStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderReqDto.getSaleOrderNo())) {
            builder.eq((Object)"sale_order_no", (Object)afterSaleOrderReqDto.getSaleOrderNo());
        }
        builder.orderByDesc((Object)"platform_created");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List dgAfterSaleOrderEos = this.dgAfterSaleOrderMapper.selectList((Wrapper)builder);
        PageInfo eoPageInfo = new PageInfo(dgAfterSaleOrderEos);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        List<Object> dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgAfterSaleOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        List orderIds = dtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(orderIds)) {
            DgAfterSaleOrderTagRecordReqDto orderTagRecordReqDto = new DgAfterSaleOrderTagRecordReqDto();
            orderTagRecordReqDto.setOrderIds(orderIds);
            List<DgAfterSaleOrderTagRecordRespDto> afterSaleOrderTagRecordRespDtos = this.afterSaleOrderTagRecordService.queryByParam(orderTagRecordReqDto);
            if (ObjectUtils.isNotEmpty((Object)afterSaleOrderReqDto.getNeedTag()) && StringUtils.isNotBlank((CharSequence)afterSaleOrderReqDto.getTagCode())) {
                if (afterSaleOrderReqDto.getNeedTag() == 1) {
                    List selectTagOrderIds = afterSaleOrderTagRecordRespDtos.stream().filter(afterSaleOrderRespDto -> afterSaleOrderRespDto.getTagCode().equals(afterSaleOrderReqDto.getTagCode())).map(DgAfterSaleOrderTagRecordDto::getOrderId).collect(Collectors.toList());
                    List respDtos = dtoPageInfo.getList().stream().filter(dgAfterSaleOrderRespDto -> selectTagOrderIds.contains(dgAfterSaleOrderRespDto.getId())).collect(Collectors.toList());
                    dtoList = respDtos;
                } else if (afterSaleOrderReqDto.getNeedTag() == 0) {
                    List hasTagIds = afterSaleOrderTagRecordRespDtos.stream().map(DgAfterSaleOrderTagRecordDto::getOrderId).collect(Collectors.toList());
                    List notHasTagIds = orderIds.stream().filter(orderId -> !hasTagIds.contains(orderId)).collect(Collectors.toList());
                    List selectTagOrderIds = afterSaleOrderTagRecordRespDtos.stream().filter(afterSaleOrderRespDto -> !afterSaleOrderRespDto.getTagCode().equals(afterSaleOrderReqDto.getTagCode())).map(DgAfterSaleOrderTagRecordDto::getOrderId).collect(Collectors.toList());
                    selectTagOrderIds.addAll(notHasTagIds);
                    List respDtos = dtoPageInfo.getList().stream().filter(dgAfterSaleOrderRespDto -> selectTagOrderIds.contains(dgAfterSaleOrderRespDto.getId())).collect(Collectors.toList());
                    dtoList = respDtos;
                }
                dtoPageInfo.setList(dtoList);
            }
            if (CollectionUtils.isNotEmpty(afterSaleOrderTagRecordRespDtos)) {
                List<String> tagCodes = afterSaleOrderTagRecordRespDtos.stream().map(DgAfterSaleOrderTagRecordDto::getTagCode).collect(Collectors.toList());
                List<DgOrderTagRespDto> tagEoList = this.orderTagService.queryByTagCodes(tagCodes);
                Map tagEoMap = tagEoList.stream().collect(Collectors.toMap(DgOrderTagDto::getTagCode, Function.identity()));
                Map<Long, List<DgAfterSaleOrderTagRecordRespDto>> tagRecordMap = afterSaleOrderTagRecordRespDtos.stream().collect(Collectors.groupingBy(DgAfterSaleOrderTagRecordDto::getOrderId));
                dtoList.forEach(dto -> {
                    if (CollectionUtils.isNotEmpty((Collection)((Collection)tagRecordMap.get(dto.getId())))) {
                        dto.setTagRecordCodes(((List)tagRecordMap.get(dto.getId())).stream().map(e -> (DgOrderTagRespDto)tagEoMap.get(e.getTagCode())).collect(Collectors.toList()));
                    }
                });
            }
        }
        return dtoPageInfo;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryBySaleOrderNo(String saleOrderNo) {
        return ((IDgAfterSaleOrderDomain)this.domain).queryBySaleOrderNo(saleOrderNo);
    }

    @Override
    public void batchModifyInnerRemark(DgAfterSaleOrderBatchReqDto dto) {
        List afterSaleOrderIds = dto.getAfterSaleOrderIds();
        List afterSaleOrderEos = ((IDgAfterSaleOrderDomain)this.domain).selectByIds(afterSaleOrderIds);
        Map orderEoMap = afterSaleOrderEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (Long orderId : afterSaleOrderIds) {
            DgAfterSaleOrderEo saleOrderEo = (DgAfterSaleOrderEo)orderEoMap.get(orderId);
            if (Objects.isNull(saleOrderEo)) {
                throw new BizException(orderId + ":\u4e0d\u5b58\u5728");
            }
            String remark = dto.getInnerRemark();
            if (remark.length() > 100) {
                throw new BizException("\u5907\u6ce8\u957f\u5ea6\u8d85\u8fc7\u9650\u5236");
            }
            DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
            eo.setId(orderId);
            eo.setInnerRemark(remark);
            ((IDgAfterSaleOrderDomain)this.domain).updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void batchModifyAfterSaleOrderReason(DgAfterSaleOrderBatchReqDto dto) {
        List afterSaleOrderIds = dto.getAfterSaleOrderIds();
        List afterSaleOrderEos = ((IDgAfterSaleOrderDomain)this.domain).selectByIds(afterSaleOrderIds);
        Map orderEoMap = afterSaleOrderEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        for (Long orderId : afterSaleOrderIds) {
            DgAfterSaleOrderEo saleOrderEo = (DgAfterSaleOrderEo)orderEoMap.get(orderId);
            if (Objects.isNull(saleOrderEo)) {
                throw new BizException(orderId + ":\u4e0d\u5b58\u5728");
            }
            String afterSaleOrderReason = dto.getAfterSaleOrderReason();
            DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
            eo.setId(orderId);
            eo.setAfterSaleOrderReason(afterSaleOrderReason);
            ((IDgAfterSaleOrderDomain)this.domain).updateSelective((BaseEo)eo);
        }
    }

    @Override
    public void batchReturnWarehouse(DgAfterBatchReturnWarehouseReqDto dto) {
        LogicWarehousePageReqDto queryDto = new LogicWarehousePageReqDto();
        queryDto.setWarehouseCode(dto.getReturnWarehouseCode());
        List logicWarehouseRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApi.queryList(queryDto));
        if (CollectionUtils.isEmpty((Collection)logicWarehouseRespDtos)) {
            throw new BizException("1000001", "\u9000\u8d27\u4ed3\u4e0d\u5b58\u5728");
        }
        LogicWarehouseRespDto warehouseRespDto = (LogicWarehouseRespDto)logicWarehouseRespDtos.get(0);
        dto.getAfterSaleOrderIds().stream().forEach(orderId -> {
            DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
            eo.setId(orderId);
            eo.setReturnWarehouseCode(warehouseRespDto.getWarehouseCode());
            eo.setReturnWarehouseName(warehouseRespDto.getWarehouseName());
            eo.setReturnWarehouseId(warehouseRespDto.getId());
            this.afterSaleOrderDas.updateSelective((BaseEo)eo);
        });
    }

    @Override
    public void updateLogisticsNo(DgAfterUpdateLogisticsNoReqDto reqDto) {
        DgAfterSaleOrderEo eo = new DgAfterSaleOrderEo();
        eo.setDr(0);
        eo.setAfterSaleOrderNo(reqDto.getOrderNo());
        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)((IDgAfterSaleOrderDomain)this.domain).selectOne((BaseEo)eo);
        if (Objects.isNull(afterSaleOrderEo)) {
            throw new BizException("\u552e\u540e\u5355\u4e0d\u5b58\u5728");
        }
        DgAfterSaleOrderEo update = new DgAfterSaleOrderEo();
        update.setId(afterSaleOrderEo.getId());
        update.setReturnShippingSn(reqDto.getLogisticsNo());
        update.setShippingName(reqDto.getLogisticsCompany());
        update.setShippingCode(reqDto.getLogisticsCode());
        ((IDgAfterSaleOrderDomain)this.domain).updateSelective((BaseEo)update);
    }

    private void setRelateBillInfo(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        DgPerformOrderRespDto saleOrderRespDto;
        if (ObjectUtil.isNotNull((Object)afterSaleOrderRespDto.getSaleOrderId()) && ObjectUtil.isNotNull((Object)(saleOrderRespDto = this.performOrderService.querySaleOrderById((long)afterSaleOrderRespDto.getSaleOrderId())))) {
            ArrayList<DgRelationBillVO> relateBillList = new ArrayList<DgRelationBillVO>(1);
            DgRelationBillVO relateBillInfoVO = new DgRelationBillVO();
            relateBillInfoVO.setBillId(saleOrderRespDto.getId());
            relateBillInfoVO.setBillNo(saleOrderRespDto.getSaleOrderNo());
            relateBillInfoVO.setBillStatus(saleOrderRespDto.getOrderStatus());
            relateBillInfoVO.setBillType("sale_order");
            relateBillInfoVO.setOperationRemark(saleOrderRespDto.getRemark());
            relateBillInfoVO.setCreateTime(saleOrderRespDto.getCreateTime());
            relateBillList.add(relateBillInfoVO);
            afterSaleOrderRespDto.setRelationBillList(relateBillList);
        }
    }
}

