/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.impl;

import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import com.fasterxml.jackson.core.type.TypeReference;
import com.yunxi.dg.base.center.connector.dto.connector.ExpressReqDto;
import com.yunxi.dg.base.center.connector.dto.connector.QueryTrackRespDto;
import com.yunxi.dg.base.center.connector.proxy.IExpressQueryApiProxy;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgExpressReqDto;
import com.yunxi.dg.base.center.trade.service.IDgLogisticsTrajectoryService;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class DgLogisticsTrajectoryServiceServiceImpl
implements IDgLogisticsTrajectoryService {
    private final Logger logger = LoggerFactory.getLogger(DgLogisticsTrajectoryServiceServiceImpl.class);
    public static final String PHONE_REGEX = ".*[a-zA-z#@&*].*";
    @Resource
    IExpressQueryApiProxy expressQueryApi;
    @Resource
    ICacheService cacheService;

    @Override
    public RestResponse<Object> getLogisticsTrajectory(DgExpressReqDto expressParam) {
        if (expressParam == null || StringUtils.isEmpty((CharSequence)expressParam.getLogisticsNo())) {
            this.logger.info("\u5feb\u9012\u5355\u53f7\u4e3a\u7a7a,\u4e0d\u5904\u7406");
            return new RestResponse((Object)new QueryTrackRespDto());
        }
        this.logger.info("logisticsNo:{},receivePhone:{},deliveryPhone:{}", new Object[]{expressParam.getLogisticsNo(), expressParam.getReceivePhone(), expressParam.getDeliveryPhone()});
        QueryTrackRespDto cacheVal = (QueryTrackRespDto)this.cacheService.getCache(this.getExpressKey(expressParam.getLogisticsNo()), (TypeReference)new TypeReference<QueryTrackRespDto>(){});
        if (cacheVal != null) {
            this.logger.info("\u6839\u636ekey\u67e5\u8be2\u7f13\u5b58\u4fe1\u606fkey:{}", (Object)this.getExpressKey(expressParam.getLogisticsNo()));
            return new RestResponse((Object)cacheVal);
        }
        ExpressReqDto expressReqDto = new ExpressReqDto();
        expressReqDto.setNum(expressParam.getLogisticsNo());
        expressReqDto.setPhone(expressParam.getReceivePhone());
        QueryTrackRespDto queryTrackRespDto = (QueryTrackRespDto)this.expressQueryApi.queryTrack(expressReqDto).getData();
        if ("ok".equals(queryTrackRespDto.getMessage())) {
            this.cacheService.setCache(this.getExpressKey(expressParam.getLogisticsNo()), (Object)queryTrackRespDto, 300);
            return new RestResponse((Object)queryTrackRespDto);
        }
        String deliveryPhone = expressParam.getDeliveryPhone();
        if (StringUtils.isEmpty((CharSequence)deliveryPhone) || deliveryPhone.matches(PHONE_REGEX)) {
            this.logger.info("\u53d1\u8d27\u4eba\u624b\u673a\u53f7\u4e3a\u7a7a\u6216\u542b\u6709\u5bc6\u6587\uff1adeliveryPhone:{}", (Object)deliveryPhone);
            deliveryPhone = "22139888-8961";
        }
        expressReqDto.setPhone(deliveryPhone);
        QueryTrackRespDto respDto = (QueryTrackRespDto)this.expressQueryApi.queryTrack(expressReqDto).getData();
        if ("ok".equals(respDto.getMessage())) {
            this.cacheService.setCache(this.getExpressKey(expressParam.getLogisticsNo()), (Object)respDto, 300);
        } else {
            this.cacheService.setCache(this.getExpressKey(expressParam.getLogisticsNo()), (Object)respDto, 60);
        }
        return new RestResponse((Object)respDto);
    }

    private String getExpressKey(String logisticsNo) {
        return "express:" + logisticsNo;
    }
}

