/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.SourceOrderItemReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SourceOrderItemRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.ISourceOrderItemDomain;
import com.yunxi.dg.base.center.trade.eo.SourceOrderItemEo;
import com.yunxi.dg.base.center.trade.service.tc.ISourceOrderItemService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SourceOrderItemServiceImpl
implements ISourceOrderItemService {
    @Resource
    private ISourceOrderItemDomain sourceOrderItemDomain;

    @Override
    public Long addSourceOrderItem(SourceOrderItemReqDto addReqDto) {
        SourceOrderItemEo sourceOrderItemEo = new SourceOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)sourceOrderItemEo);
        this.sourceOrderItemDomain.insert((BaseEo)sourceOrderItemEo);
        return sourceOrderItemEo.getId();
    }

    @Override
    public void modifySourceOrderItem(SourceOrderItemReqDto modifyReqDto) {
        SourceOrderItemEo sourceOrderItemEo = new SourceOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)sourceOrderItemEo);
        this.sourceOrderItemDomain.updateSelective((BaseEo)sourceOrderItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeSourceOrderItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.sourceOrderItemDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public SourceOrderItemRespDto queryById(Long id) {
        SourceOrderItemEo sourceOrderItemEo = (SourceOrderItemEo)this.sourceOrderItemDomain.selectByPrimaryKey(id);
        SourceOrderItemRespDto sourceOrderItemRespDto = new SourceOrderItemRespDto();
        DtoHelper.eo2Dto((BaseEo)sourceOrderItemEo, (BaseVo)sourceOrderItemRespDto);
        return sourceOrderItemRespDto;
    }

    @Override
    public PageInfo<SourceOrderItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        SourceOrderItemReqDto sourceOrderItemReqDto = (SourceOrderItemReqDto)JSON.parseObject((String)filter, SourceOrderItemReqDto.class);
        SourceOrderItemEo sourceOrderItemEo = new SourceOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)sourceOrderItemReqDto, (BaseEo)sourceOrderItemEo);
        PageInfo eoPageInfo = this.sourceOrderItemDomain.selectPage((BaseEo)sourceOrderItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, SourceOrderItemRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<SourceOrderItemRespDto> querySourceItemBySgOrderNo(String sgOrderNo) {
        AssertUtils.notBlank((String)sgOrderNo, (String)"sgOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper querySourceOrderItemEoWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)querySourceOrderItemEoWrapper.eq(BaseEo::getDr, (Object)0)).eq(SourceOrderItemEo::getSgOrderNo, (Object)sgOrderNo);
        List sourceOrderItemEos = this.sourceOrderItemDomain.getMapper().selectList((Wrapper)querySourceOrderItemEoWrapper);
        ArrayList sourceOrderItemRespDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)sourceOrderItemEos, (Collection)sourceOrderItemRespDtoList, SourceOrderItemRespDto.class);
        return sourceOrderItemRespDtoList;
    }
}

