/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.trade.constants.strategy.CisStrategyFitStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IStrategyPoolDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgStrategyPoolReqDto;
import com.yunxi.dg.base.center.trade.dto.strategy.DgStrategyPoolRespDto;
import com.yunxi.dg.base.center.trade.eo.StrategyPoolEo;
import com.yunxi.dg.base.center.trade.service.IDgStrategyPoolService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgStrategyPoolServiceImpl
implements IDgStrategyPoolService {
    @Resource
    private IStrategyPoolDomain strategyPoolDas;

    @Override
    public Long addStrategyPool(DgStrategyPoolReqDto addReqDto) {
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)strategyPoolEo);
        this.strategyPoolDas.insert((BaseEo)strategyPoolEo);
        return strategyPoolEo.getId();
    }

    @Override
    public void modifyStrategyPool(DgStrategyPoolReqDto modifyReqDto) {
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)strategyPoolEo);
        this.strategyPoolDas.updateSelective((BaseEo)strategyPoolEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeStrategyPool(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.strategyPoolDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public void removeStrategyPool(List<Long> removePoolList) {
        for (Long id : removePoolList) {
            this.strategyPoolDas.logicDeleteById(id);
        }
    }

    @Override
    public DgStrategyPoolRespDto queryById(Long id) {
        StrategyPoolEo strategyPoolEo = (StrategyPoolEo)this.strategyPoolDas.selectByPrimaryKey(id);
        DgStrategyPoolRespDto strategyPoolRespDto = new DgStrategyPoolRespDto();
        CubeBeanUtils.copyProperties((Object)strategyPoolRespDto, (Object)strategyPoolEo, (String[])new String[0]);
        return strategyPoolRespDto;
    }

    @Override
    public DgStrategyPoolRespDto queryWaitHitByOrderId(Long orderId, String poolType) {
        AssertUtils.notNull((Object)orderId, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)poolType, (String)"\u5f85\u5339\u914d\u7b56\u7565\u7c7b\u578bpoolType\u4e0d\u80fd\u4e3a\u7a7a");
        StrategyPoolEo queryEo = new StrategyPoolEo();
        queryEo.setPoolType(poolType);
        queryEo.setSaleOrderId(orderId);
        queryEo.setFitStatus(CisStrategyFitStatusEnum.WAIT_FIT.getCode());
        StrategyPoolEo resultEo = (StrategyPoolEo)this.strategyPoolDas.selectOne((BaseEo)queryEo);
        if (resultEo == null) {
            return null;
        }
        DgStrategyPoolRespDto strategyPoolRespDto = new DgStrategyPoolRespDto();
        CubeBeanUtils.copyProperties((Object)strategyPoolRespDto, (Object)resultEo, (String[])new String[0]);
        return strategyPoolRespDto;
    }

    @Override
    public PageInfo<DgStrategyPoolRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DgStrategyPoolReqDto strategyPoolReqDto = (DgStrategyPoolReqDto)JSON.parseObject((String)filter, DgStrategyPoolReqDto.class);
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        DtoHelper.dto2Eo((BaseVo)strategyPoolReqDto, (BaseEo)strategyPoolEo);
        PageInfo eoPageInfo = this.strategyPoolDas.selectPage((BaseEo)strategyPoolEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgStrategyPoolRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void removeStrategyPool(DgStrategyPoolReqDto strategyPoolReqDto) {
        AssertUtils.notNull((Object)strategyPoolReqDto.getSaleOrderId(), (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        strategyPoolEo.setSaleOrderId(strategyPoolReqDto.getSaleOrderId());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{strategyPoolReqDto.getPoolType()})) {
            strategyPoolEo.setPoolType(strategyPoolReqDto.getPoolType());
        }
        this.strategyPoolDas.logicDelete((BaseEo)strategyPoolEo);
    }

    @Override
    public PageInfo<DgStrategyPoolRespDto> queryPayge(Integer pageNum, Integer pageSize, String poolType) {
        StrategyPoolEo strategyPoolEo = new StrategyPoolEo();
        strategyPoolEo.setPoolType(poolType);
        strategyPoolEo.setFitStatus(CisStrategyFitStatusEnum.WAIT_FIT.getCode());
        PageInfo eoPageInfo = this.strategyPoolDas.selectPage((BaseEo)strategyPoolEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgStrategyPoolRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void cleanStrategyPool(int beforeDate) {
        this.strategyPoolDas.cleanStrategyPool(beforeDate);
    }
}

