/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.yundt.cube.center.trade.api.constant.OrderLabelEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderItemRefundStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderItemTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderSourceEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.SaleOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderItemRespDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.ILabelManageService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderLabelItemService;
import com.yunxi.dg.base.center.trade.service.tc.IOrderLabelRecordService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderItemService;
import com.yunxi.dg.base.center.trade.service.tc.ISaleOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LabelManageServiceImpl
implements ILabelManageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(LabelManageServiceImpl.class);
    @Resource
    private ISaleOrderService saleOrderService;
    @Resource
    private IOrderLabelRecordService labelRecordService;
    @Resource
    private ISaleOrderItemService saleOrderItemService;
    @Resource
    private IOrderLabelItemService orderLabelItemService;

    @Override
    public void markSplitTagForChildOrder(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgSaleOrderEo saleOrderEo = this.saleOrderService.queryEoById(saleOrderId);
        List<SaleOrderRespDto> childOrderList = this.saleOrderService.queryChildByOriOrderNo(saleOrderEo.getSaleOrderNo());
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            for (SaleOrderRespDto saleOrderRespDto : childOrderList) {
                this.labelRecordService.addOrderLabelRecord(saleOrderRespDto.getId(), OrderLabelEnum.SPLIT);
            }
            LOGGER.info("[\u5b50\u8ba2\u5355\u6253\u6807]\u5b8c\u6210\u6253\u6807\u5b50\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(childOrderList));
        }
    }

    @Override
    public void markLackTagForItems(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        List<SaleOrderItemRespDto> saleOrderItemRespDtoList = this.saleOrderItemService.queryNormalItems(saleOrderId, skuCodeList);
        LOGGER.debug("[\u8ba2\u5355\u5546\u54c1\u7f3a\u8d27\u6253\u6807]\u9700\u8981\u6253\u7f3a\u8d27\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(saleOrderItemRespDtoList));
        if (CollectionUtils.isNotEmpty(saleOrderItemRespDtoList)) {
            for (SaleOrderItemRespDto saleOrderItemRespDto : saleOrderItemRespDtoList) {
                this.orderLabelItemService.addOrderLabelItem(saleOrderId, saleOrderItemRespDto.getId(), OrderLabelEnum.ITEM_LACK);
            }
        }
    }

    @Override
    public void markLackByOrderId(Long saleOrderId) {
        this.markLackTagForItems(saleOrderId, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void markByOrderCreate(BizSaleOrderReqDto reqDto) {
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(reqDto.getId());
        AssertUtils.notEmpty(saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{reqDto.getId()});
        this.markGift(saleOrderItemRespDtos);
        this.markCombination(saleOrderItemRespDtos);
        this.markOrderSource(reqDto);
        this.markOrderType(reqDto);
    }

    @Override
    public void markCombinationByOrderId(Long saleOrderId) {
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(saleOrderId);
        AssertUtils.notEmpty(saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{saleOrderId});
        this.markCombination(saleOrderItemRespDtos);
    }

    private void markCombination(List<SaleOrderItemRespDto> saleOrderItemRespDtos) {
        List orderCombinationRespDtos = saleOrderItemRespDtos.stream().filter(item -> SaleOrderItemTypeEnum.COMBINATION.getType().equals(item.getType())).collect(Collectors.toList());
        LOGGER.debug("[\u8ba2\u5355\u5546\u54c1\u7ec4\u5408\u5546\u54c1\u6253\u6807]\u9700\u8981\u6253\u7ec4\u5408\u5546\u54c1\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderCombinationRespDtos));
        Optional.ofNullable(orderCombinationRespDtos).ifPresent(orderGiftRespDtoList -> orderGiftRespDtoList.forEach(item -> this.orderLabelItemService.addOrderLabelItem(item.getOrderId(), item.getId(), OrderLabelEnum.ITEM_COMBINATION)));
    }

    private void markOrderSource(BizSaleOrderReqDto reqDto) {
        if (SaleOrderSourceEnum.CREATE.getType().equals(reqDto.getOrderSource())) {
            LOGGER.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u624b\u5de5\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            this.labelRecordService.addOrderLabelRecord(reqDto.getId(), OrderLabelEnum.SALE_ORDER_CREATE);
        }
    }

    private void markOrderType(BizSaleOrderReqDto reqDto) {
        if (SaleOrderTypeEnum.PRE_SALE_ORDER.getType().equals(reqDto.getOrderType())) {
            LOGGER.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u624b\u5de5\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            this.labelRecordService.addOrderLabelRecord(reqDto.getId(), OrderLabelEnum.PRE_SALE_ORDER);
        }
    }

    @Override
    public void markGiftByOrderId(Long saleOrderId) {
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(saleOrderId);
        AssertUtils.notEmpty(saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{saleOrderId});
        this.markGift(saleOrderItemRespDtos);
    }

    private void markGift(List<SaleOrderItemRespDto> saleOrderItemRespDtos) {
        List orderGiftRespDtos = saleOrderItemRespDtos.stream().filter(item -> item.getPayAmount().compareTo(BigDecimal.ZERO) == 0).collect(Collectors.toList());
        LOGGER.debug("[\u8ba2\u5355\u5546\u54c1\u8d60\u54c1\u6253\u6807]\u9700\u8981\u6253\u8d60\u54c1\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderGiftRespDtos));
        Optional.ofNullable(orderGiftRespDtos).ifPresent(orderGiftRespDtoList -> orderGiftRespDtoList.forEach(item -> this.orderLabelItemService.addOrderLabelItem(item.getOrderId(), item.getId(), OrderLabelEnum.ITEM_GIFT)));
    }

    @Override
    public void markHadPromotionLabel(Long orderId) {
        LOGGER.info("[\u6253\u6807]\u8ba2\u5355={}\u6253\u6267\u884c\u4fc3\u9500\u6807\u8bc6", (Object)orderId);
        this.labelRecordService.addOrderLabelRecord(orderId, OrderLabelEnum.ORDER_PROMOTION);
    }

    @Override
    public void markRefundByOrderId(Long saleOrderId) {
        List<SaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemService.queryOrderItemByOrderId(saleOrderId);
        AssertUtils.notEmpty(saleOrderItemRespDtos, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728\u5546\u54c1", (Object[])new Object[]{saleOrderId});
        this.markRefund(saleOrderItemRespDtos);
    }

    private void markRefund(List<SaleOrderItemRespDto> saleOrderItemRespDtos) {
        List orderRefundRespDtos = saleOrderItemRespDtos.stream().filter(item -> SaleOrderItemRefundStatusEnum.REFUNDED.getCode().equals(item.getRefundStatus())).collect(Collectors.toList());
        LOGGER.debug("[\u8ba2\u5355\u5546\u54c1\u9000\u6b3e\u6253\u6807]\u9700\u8981\u6253\u9000\u6b3e\u6807\u7b7e\u7684\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString(orderRefundRespDtos));
        Optional.ofNullable(orderRefundRespDtos).ifPresent(orderRefundRespDtoList -> orderRefundRespDtoList.forEach(item -> this.orderLabelItemService.addOrderLabelItem(item.getOrderId(), item.getId(), OrderLabelEnum.REFUND_ITEM)));
    }

    @Override
    public void markErrorByOrderId(Long saleOrderId) {
        LOGGER.info("[\u6253\u6807]\u8ba2\u5355={}\u6253\u552e\u540e\u8ba2\u5355\u6807\u8bc6", (Object)saleOrderId);
        this.labelRecordService.addOrderLabelRecord(saleOrderId, OrderLabelEnum.ORDER_PROMOTION);
    }
}

