/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.service.tc.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.inventory.api.utils.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.AfterSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.BizAfterSaleOrderReqDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.AfterSaleOrderRespDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.service.tc.IAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.TrackOptLogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AfterSaleOrderServiceImpl
implements IAfterSaleOrderService {
    private final Logger logger = LoggerFactory.getLogger(AfterSaleOrderServiceImpl.class);
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private NoGreateUtil noGreateUtil;

    @Override
    public Long addAfterSaleOrder(AfterSaleOrderReqDto addReqDto) {
        if (StringUtils.isEmpty((CharSequence)addReqDto.getAfterSaleOrderNo())) {
            addReqDto.setAfterSaleOrderNo(this.noGreateUtil.generateAfterSaleOrderNo());
        }
        AfterSaleOrderEo afterDgSaleOrderEo = new AfterSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)afterDgSaleOrderEo);
        this.afterSaleOrderDomain.insert((BaseEo)afterDgSaleOrderEo);
        return afterDgSaleOrderEo.getId();
    }

    @Override
    public void modifyAfterSaleOrder(AfterSaleOrderReqDto modifyReqDto) {
        AfterSaleOrderEo afterDgSaleOrderEo = new AfterSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)afterDgSaleOrderEo);
        afterDgSaleOrderEo.setUpdateTime(new Date());
        this.afterSaleOrderDomain.updateSelective((BaseEo)afterDgSaleOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeAfterSaleOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.afterSaleOrderDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public AfterSaleOrderRespDto queryById(Long id) {
        AfterSaleOrderEo afterDgSaleOrderEo = (AfterSaleOrderEo)this.afterSaleOrderDomain.selectByPrimaryKey(id);
        AfterSaleOrderRespDto afterSaleOrderRespDto = new AfterSaleOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)afterDgSaleOrderEo, (BaseVo)afterSaleOrderRespDto);
        return afterSaleOrderRespDto;
    }

    @Override
    public AfterSaleOrderRespDto queryByNo(String afterSaleOrderNo) {
        AfterSaleOrderEo afterDgSaleOrderEo = (AfterSaleOrderEo)((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).one();
        AfterSaleOrderRespDto afterSaleOrderRespDto = new AfterSaleOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)afterDgSaleOrderEo, (BaseVo)afterSaleOrderRespDto);
        return afterSaleOrderRespDto;
    }

    @Override
    public List<AfterSaleOrderRespDto> queryByBizAfterSaleOrderReqDto(BizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        if (StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformOrderNo()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn())) {
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformOrderNo(), (String)"platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn(), (String)"platformRefundOrderSn\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AfterSaleOrderEo afterDgSaleOrderEo = new AfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)afterDgSaleOrderEo, (Object)bizAfterSaleOrderReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)afterDgSaleOrderEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        List saleOrderEos = this.afterSaleOrderDomain.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)resultList, AfterSaleOrderRespDto.class);
        return resultList;
    }

    @Override
    public PageInfo<AfterSaleOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        AfterSaleOrderReqDto afterSaleOrderReqDto = (AfterSaleOrderReqDto)JSON.parseObject((String)filter, AfterSaleOrderReqDto.class);
        AfterSaleOrderEo afterDgSaleOrderEo = new AfterSaleOrderEo();
        DtoHelper.dto2Eo((BaseVo)afterSaleOrderReqDto, (BaseEo)afterDgSaleOrderEo);
        SqlFilterBuilder builder = SqlFilterBuilder.create(AfterSaleOrderEo.class);
        if (StringUtils.isNotEmpty((CharSequence)afterSaleOrderReqDto.getReason())) {
            builder.like("reason", (Object)afterSaleOrderReqDto.getReason());
            afterDgSaleOrderEo.setReason(null);
        }
        if (afterSaleOrderReqDto.getStartPlatformCreated() != null) {
            builder.ge("platform_created", (Object)afterSaleOrderReqDto.getStartPlatformCreated());
        }
        if (afterSaleOrderReqDto.getEndPlatformCreated() != null) {
            builder.lt("platform_created", (Object)DateUtil.addDays((Date)afterSaleOrderReqDto.getEndPlatformCreated(), (int)1));
        }
        afterDgSaleOrderEo.setSqlFilters(builder.filters());
        PageInfo eoPageInfo = this.afterSaleOrderDomain.selectPage((BaseEo)afterDgSaleOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, AfterSaleOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public int optimisticModifyAfterSale(AfterSaleOrderEo afterDgSaleOrderEo, LambdaQueryWrapper<AfterSaleOrderEo> queryWrapper, int idealCount, boolean needThrow) {
        this.logger.info("optimisticModifyAfterSale\u5165\u53c2afterDgSaleOrderEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)afterDgSaleOrderEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        TrackOptLogUtils.addOrderTrackOptLog((Long)((AfterSaleOrderEo)queryWrapper.getEntity()).getId(), (String)("\u66f4\u65b0\u5185\u5bb9:" + JSON.toJSONString((Object)afterDgSaleOrderEo)));
        this.afterSaleOrderDomain.setUpdateSystemFields(afterDgSaleOrderEo);
        int optCount = this.afterSaleOrderDomain.getMapper().update((Object)afterDgSaleOrderEo, queryWrapper);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u552e\u540e\u5355\u72b6\u6001\u5931\u8d25, idealCount: " + idealCount + ", optCount: " + optCount);
        }
        return optCount;
    }
}

