/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.ObjectConvertor;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgAddressModifyReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgAddressRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerInfoRespDto;
import com.yunxi.dg.base.center.customer.proxy.query.IDgAddressQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.query.ITransactionCustomerQueryApiProxy;
import com.yunxi.dg.base.center.customer.proxy.tob.IDgTobAddressApiProxy;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationRespDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelInventoryService;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelAbstractOrderCreate {
    private static final Logger log = LoggerFactory.getLogger(ChannelAbstractOrderCreate.class);
    @Resource
    private IChannelInventoryService channelInventoryService;
    @Resource
    private IDgOrderConfigurationService dgOrderConfigurationService;
    @Resource
    private IDgAddressQueryApiProxy dgAddressQueryApiProxy;
    @Resource
    private IDgTobAddressApiProxy dgTobAddressApiProxy;
    @Resource
    private ITransactionCustomerQueryApiProxy transactionCustomerQueryApiProxy;

    DgOrderResultRespDto saveAfterExecute(DgOrderResultRespDto resultRespDto, DgOrderReqDto dgOrderReqDto) {
        log.info("\u63d0\u4ea4\u8ba2\u5355\u540e\u7f6e\u64cd\u4f5c\uff1a{}", (Object)JSON.toJSONString((Object)resultRespDto));
        log.info("\u63d0\u4ea4\u8ba2\u5355\u540e\u7f6e\u64cd\u4f5c\u5e93\u5b58\u6821\u9a8c\u53c2\u6570\uff0c\u6e20\u9053\u5e93\u5b58\uff1a{}\uff0c\u4f9b\u8d27\u5e93\u5b58\uff1a{}", (Object)dgOrderReqDto.getIsVerifyChannelInventory(), (Object)dgOrderReqDto.getIsVerifySupplyInventory());
        Optional.ofNullable(dgOrderReqDto.getIsVerifyChannelInventory()).filter(Boolean::booleanValue).ifPresent(p -> this.channelInventoryService.vaildInventory(resultRespDto.getDgBizPerformOrderReqDto()));
        this.channelInventoryService.preemptByBatch(resultRespDto, dgOrderReqDto);
        this.addOrModifyCustomerAddress(resultRespDto, dgOrderReqDto);
        log.info("\u63d0\u4ea4\u8ba2\u5355\u540e\u7f6e\u64cd\u7ed3\u675f");
        return resultRespDto;
    }

    private void addOrModifyCustomerAddress(DgOrderResultRespDto resultRespDto, DgOrderReqDto dgOrderReqDto) {
        DgBizPerformOrderReqDto bizPerformOrderReqDto = resultRespDto.getDgBizPerformOrderReqDto();
        DgOrderConfigurationRespDto configDto = this.dgOrderConfigurationService.queryDetailByShopCode(bizPerformOrderReqDto.getPerformOrderSnapshotDto().getShopCode());
        List customerInfoRespDtos = (List)this.transactionCustomerQueryApiProxy.queryIds((List)Lists.newArrayList((Object[])new Long[]{bizPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerId()})).getData();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)customerInfoRespDtos), (String)"\u4ea4\u6613\u5ba2\u6237\u4fe1\u606f\u4e3a\u7a7a");
        DgShopOrderReqDto dgShopOrderReqDto = (DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0);
        DgPerformOrderAddrReqDto dto = dgShopOrderReqDto.getOrderAddrReqDtoWaitAudit();
        if (!Objects.equals(configDto.getEnableAddressPushExternal(), EnableEnum.ENABLE.getCode()) && dto != null && Objects.equals(dto.getAddressType(), 1)) {
            if (dto.getAddressId() == null) {
                DgAddressAddReqDto addressAddReqDto = new DgAddressAddReqDto();
                addressAddReqDto.setProvince(dto.getProvince());
                addressAddReqDto.setProvinceCode(dto.getProvinceCode());
                addressAddReqDto.setCity(dto.getCity());
                addressAddReqDto.setCityCode(dto.getCityCode());
                addressAddReqDto.setDistrict(dto.getCounty());
                addressAddReqDto.setDistrictCode(dto.getCountyCode());
                addressAddReqDto.setDetailAddr(dto.getReceiveAddress());
                addressAddReqDto.setContact(dto.getReceiveName());
                addressAddReqDto.setPhone(dto.getReceivePhone());
                addressAddReqDto.setCustomerId(bizPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerId());
                addressAddReqDto.setCustomerCode(bizPerformOrderReqDto.getPerformOrderSnapshotDto().getCustomerCode());
                addressAddReqDto.setOrgInfoId(((DgCustomerInfoRespDto)customerInfoRespDtos.get(0)).getCompanyId());
                addressAddReqDto.setIsDefault(Optional.ofNullable(dto.getIsDefault()).orElse(0));
                addressAddReqDto.setAddressType("1");
                log.info("\u65b0\u589e\u5ba2\u6237\u5730\u5740\uff1a{}", (Object)JSON.toJSONString((Object)addressAddReqDto));
                RestResponseHelper.extractData((RestResponse)this.dgTobAddressApiProxy.addCustomerAddress(addressAddReqDto));
            } else {
                DgAddressRespDto addressRespDto = (DgAddressRespDto)this.dgAddressQueryApiProxy.queryAddressById(dto.getAddressId()).getData();
                DgAddressModifyReqDto modifyReqDto = (DgAddressModifyReqDto)ObjectConvertor.convert((Object)addressRespDto, DgAddressModifyReqDto.class);
                modifyReqDto.setProvince(dto.getProvince());
                modifyReqDto.setProvinceCode(dto.getProvinceCode());
                modifyReqDto.setCity(dto.getCity());
                modifyReqDto.setCityCode(dto.getCityCode());
                modifyReqDto.setDistrict(dto.getCounty());
                modifyReqDto.setDistrictCode(dto.getCountyCode());
                modifyReqDto.setDetailAddr(dto.getReceiveAddress());
                modifyReqDto.setContact(dto.getReceiveName());
                modifyReqDto.setPhone(dto.getReceivePhone());
                modifyReqDto.setIsDefault(Optional.ofNullable(dto.getIsDefault()).orElse(0));
                log.info("\u4fee\u6539\u5ba2\u6237\u5730\u5740\uff1a{}", (Object)JSON.toJSONString((Object)modifyReqDto));
                RestResponseHelper.extractData((RestResponse)this.dgTobAddressApiProxy.updateCustomerAddress(modifyReqDto));
            }
        }
    }
}

