/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgRefundBizOrderTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.PayStatusEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constants.YesNoEnum;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.account.constants.AccountCategoryEnum;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeBatchReqDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeItemDto;
import com.yunxi.dg.base.center.account.dto.biz.AccountTradeReqDto;
import com.yunxi.dg.base.center.account.proxy.biz.IAccountTradeApiProxy;
import com.yunxi.dg.base.center.inventory.dto.share.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgInventoryPreemptionShopApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderCancelAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderPayAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IDgF2BMqMessageAction;
import com.yunxi.dg.base.center.trade.constants.DgOmsOrderLineStatusEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderRefundStatusEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAdvanceRelevanceOrderExtDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundDetailDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.ItemPayRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRefundDetailExtReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgRefundExtReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.ChannelOptB2BOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AdvanceOrderRelevanceTypeEnum;
import com.yunxi.dg.base.center.trade.enums.F2BOrderDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.enums.NewDgRefundDetailStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgAdvanceRelevanceOrderService;
import com.yunxi.dg.base.center.trade.service.entity.IDgRefundService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.utils.TradeUtil;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelOrderCancelActionImpl
implements IChannelOrderCancelAction {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderCancelActionImpl.class);
    private static final String COMPLETE_ORDER_RESON = "\u5b8c\u7ed3\u8ba2\u5355\u9000\u6b3e";
    @Resource
    private IAccountTradeApiProxy accountTradeApiProxy;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgInventoryPreemptionShopApiProxy dgInventoryPreemptionShopApiProxy;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgRefundDomain dgRefundDomain;
    @Resource
    private IDgRefundDetailDomain dgRefundDetailDomain;
    @Resource
    private IDgRefundService dgRefundService;
    @Resource
    private IChannelOrderPayAction channelOrderPayAction;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain orderItemLineDomain;
    @Resource
    private IDgPerformOrderLineDomain orderLineDomain;
    @Resource
    private IDgAdvanceRelevanceOrderService dgAdvanceRelevanceOrderService;
    @Resource
    private IDgPerformOrderLineAmountDomain dgPerformOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain dgPerformOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgF2BMqMessageAction dgF2BMqMessageAction;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> orderCancel(DgPerformOrderRespDto throughDtoDefine, String cancelReason) {
        List performOrderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(throughDtoDefine.getId());
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)performOrderLineDtos), (String)"\u6574\u5355\u53d6\u6d88\uff0c\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        for (DgPerformOrderLineDto orderLineDto : performOrderLineDtos) {
            DgPerformOrderLineEo upEo = new DgPerformOrderLineEo();
            upEo.setId(orderLineDto.getId());
            upEo.setStatus(DgOmsOrderLineStatusEnum.CANCEL.getCode());
            this.orderLineDomain.updateSelective((BaseEo)upEo);
        }
        if (StringUtils.isNotBlank((String)cancelReason)) {
            DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
            dgPerformOrderInfoEo.setId(throughDtoDefine.getId());
            dgPerformOrderInfoEo.setCancelReason(cancelReason);
            this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        }
        DgPerformOrderInfoEo eo = (DgPerformOrderInfoEo)this.dgPerformOrderInfoDomain.selectByPrimaryKey(throughDtoDefine.getId());
        this.dgF2BMqMessageAction.dealWithActivityExpense(eo.getSaleOrderNo(), Objects.equals(eo.getOrderStatus(), DgF2BOrderStatus.WAIT_PAY.getCode()) ? 4 : 3);
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> partCancelAndRefund(DgPerformOrderRespDto throughDtoDefine, String req) {
        AssertUtils.isFalse((throughDtoDefine == null || throughDtoDefine.getId() == null ? 1 : 0) != 0, (String)"\u8ba2\u5355\u53d6\u6d88\uff0c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        List itemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemLineDomain.filter().eq((Object)"order_id", (Object)throughDtoDefine.getId())).eq((Object)"delivery_status", (Object)ItemLineCancelStatusEnum.NO.getType())).eq((Object)"cancel_status", (Object)ItemLineCancelStatusEnum.NO.getType())).list();
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)itemLineEos), (String)"\u8ba2\u5355\u53d6\u6d88\uff0c\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        ArrayList accountTradeReqDtos = Lists.newArrayList();
        ArrayList operationDetailDtos = Lists.newArrayList();
        for (DgPerformOrderItemLineEo itemLineEo : itemLineEos) {
            if (StringUtils.isNotBlank((String)itemLineEo.getCostDetails())) {
                List itemPayRecordDtos = JSON.parseArray((String)itemLineEo.getCostDetails(), ItemPayRecordDto.class);
                for (ItemPayRecordDto itemPayRecordDto : itemPayRecordDtos) {
                    AccountTradeReqDto accountTradeReqDto = new AccountTradeReqDto();
                    accountTradeReqDto.setAccountType(itemPayRecordDto.getAccountType());
                    accountTradeReqDto.setAmount(itemPayRecordDto.getAmount());
                    accountTradeReqDto.setSaleCompanyCode(itemPayRecordDto.getSaleCompanyCode());
                    if (YesNoEnum.YES.getValue().equals(itemPayRecordDto.getItemCountsType())) {
                        AccountTradeItemDto accountTradeItemDto = new AccountTradeItemDto();
                        accountTradeItemDto.setAmount(itemPayRecordDto.getAmount());
                        accountTradeItemDto.setSkuCode(itemLineEo.getSkuCode());
                        accountTradeReqDto.setItems((List)Lists.newArrayList((Object[])new AccountTradeItemDto[]{accountTradeItemDto}));
                    }
                    accountTradeReqDtos.add(accountTradeReqDto);
                }
            }
            DgPerformOrderItemLineEo orderItemLineEo = new DgPerformOrderItemLineEo();
            orderItemLineEo.setCancelStatus(ItemLineCancelStatusEnum.YES.getType());
            orderItemLineEo.setUpdateTime(new Date());
            orderItemLineEo.setId(itemLineEo.getId());
            this.dgPerformOrderItemLineDomain.updateSelective((BaseEo)orderItemLineEo);
            OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
            inventoryOperateCargoReqDto.setSkuCode(itemLineEo.getSkuCode());
            inventoryOperateCargoReqDto.setNum(itemLineEo.getItemNum());
            inventoryOperateCargoReqDto.setShopCode(throughDtoDefine.getPerformOrderSnapshotDto().getShopCode());
            operationDetailDtos.add(inventoryOperateCargoReqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)operationDetailDtos)) {
            ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
            releasePreemptParam.setSourceNo(throughDtoDefine.getSaleOrderNo());
            releasePreemptParam.setSourceType(throughDtoDefine.getOrderType());
            releasePreemptParam.setDetails((List)operationDetailDtos);
            log.info("[\u90e8\u4efd\u53d6\u6d88\u91ca\u653e\u5e93\u5b58]\uff1a{}", JSON.toJSON((Object)releasePreemptParam));
            RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionShopApiProxy.releasePreempt(releasePreemptParam));
        }
        DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
        dgPerformOrderInfoEo.setId(throughDtoDefine.getId());
        dgPerformOrderInfoEo.setDeliveryStatus(F2BOrderDeliveryStatusEnum.DELIVERY.getCode());
        this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        if (CollectionUtils.isNotEmpty((Collection)accountTradeReqDtos)) {
            AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
            accountTradeBatchReqDto.setOrderNo(throughDtoDefine.getSaleOrderNo());
            accountTradeBatchReqDto.setSaleCompanyCode(throughDtoDefine.getPerformOrderSnapshotDto().getEnterpriseCode());
            accountTradeBatchReqDto.setCustomerNo(throughDtoDefine.getPerformOrderSnapshotDto().getCustomerCode());
            accountTradeBatchReqDto.setShopCode(throughDtoDefine.getPerformOrderSnapshotDto().getShopCode());
            accountTradeBatchReqDto.setTradeReqDtos((List)accountTradeReqDtos);
            log.info("[\u90e8\u4efd\u53d6\u6d88\u91ca\u653e\u8d26\u6237]:{}", JSON.toJSON((Object)accountTradeBatchReqDto));
            RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.cancelRelease(accountTradeBatchReqDto));
        }
        return RestResponse.VOID;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ChannelOptB2BOrderRespDto partCancelAndRefund(DgPerformOrderRespDto throughDtoDefine, ChannelOptB2BOrderRespDto channelOptB2BOrderRespDto) {
        log.info("\u90e8\u4efd\u53d6\u6d88\u5165\u53c2\uff1a{}", JSON.toJSON((Object)channelOptB2BOrderRespDto));
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(throughDtoDefine.getId());
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)orderLineDtos), (String)"\u8ba2\u5355\u53d6\u6d88\uff0c\u672a\u67e5\u8be2\u5230\u6e20\u9053\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        ArrayList operationDetailDtos = Lists.newArrayList();
        Map<String, List<DgPerformOrderItemRespDto>> succItemNumMap = Optional.ofNullable(channelOptB2BOrderRespDto.getSuccItemList()).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getPlatformOrderItemNo));
        Map<Long, List<DgPerformOrderItemLineDto>> cancelItemMap = Optional.ofNullable(channelOptB2BOrderRespDto.getRefundItemList()).orElse(Lists.newArrayList()).stream().collect(Collectors.groupingBy(DgPerformOrderItemLineDto::getOrderLineId));
        DgRefundExtReqDto dgRefundDto = new DgRefundExtReqDto();
        dgRefundDto.setOrganizationId(throughDtoDefine.getPerformOrderSnapshotDto().getOrganizationId());
        dgRefundDto.setOrganizationName(throughDtoDefine.getPerformOrderSnapshotDto().getOrganizationName());
        dgRefundDto.setBizOrderId(throughDtoDefine.getId());
        dgRefundDto.setBizOrderNo(throughDtoDefine.getSaleOrderNo());
        dgRefundDto.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
        dgRefundDto.setRefundNo(TradeUtil.generateTradeNo((String)throughDtoDefine.getSaleOrderNo()));
        dgRefundDto.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
        dgRefundDto.setRefundDesc(COMPLETE_ORDER_RESON);
        HashMap accountNameMap = Maps.newHashMap();
        List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(throughDtoDefine.getSaleOrderNo());
        Map payRecordDtoMap = payRecordDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
        Map<Long, Map<String, List<ItemPayRecordDto>>> itemPayRecordMap = payRecordDtos.stream().filter(recordDto -> !Objects.equals(PayStatusEnum.BACKED.getCode(), recordDto.getPayStatus())).peek(recordDto -> accountNameMap.put(recordDto.getPayMethod(), recordDto.getPayMethodName())).map(recordDto -> new ArrayList(recordDto.getItemPayRecordDtos())).flatMap(Collection::stream).map(itemPayRecord -> {
            PayRecordDto payRecordDto = (PayRecordDto)payRecordDtoMap.get(itemPayRecord.getPayRecordId());
            if (null != payRecordDto) {
                itemPayRecord.setSaleCompanyCode(payRecordDto.getSellerId());
            }
            return itemPayRecord;
        }).collect(Collectors.groupingBy(ItemPayRecordDto::getOrderItemId, Collectors.groupingBy(itemPayRecord -> itemPayRecord.getAccountType() + "&" + itemPayRecord.getSaleCompanyCode())));
        log.info("\u652f\u4ed8\u8bb0\u5f55\u7c7b\u578b\uff1a{}", itemPayRecordMap);
        HashMap refundDtoMap = new HashMap();
        List<Object> sellerIds = new ArrayList();
        for (Object orderLineDto : orderLineDtos) {
            Map<String, List<ItemPayRecordDto>> map = itemPayRecordMap.get(orderLineDto.getId());
            BigDecimal payRefundNum = BigDecimal.ZERO;
            HashMap<String, BigDecimal> orderLineAmountTypeMap = new HashMap<String, BigDecimal>();
            List<DgPerformOrderItemRespDto> omsOrderItemRespDtos = succItemNumMap.get(orderLineDto.getId().toString());
            if (CollectionUtil.isNotEmpty(omsOrderItemRespDtos)) {
                for (DgPerformOrderItemRespDto dgPerformOrderItemRespDto : omsOrderItemRespDtos) {
                    List<DgPerformOrderItemLineDto> omsCancelItemList = cancelItemMap.get(dgPerformOrderItemRespDto.getId());
                    if (CollectionUtil.isNotEmpty(omsCancelItemList)) {
                        for (DgPerformOrderItemLineDto omsCancelItemLine : omsCancelItemList) {
                            List<Object> orderItemLineAmountDtoList = Lists.newArrayList();
                            orderItemLineAmountDtoList = throughDtoDefine.getPerformOrderSnapshotDto().getKneadeFlag().equals(YesOrNoEnum.YES.getType()) ? omsCancelItemLine.getPerformOrderItemLineAmountDtoList().stream().filter(a -> a.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode()) && (a.getAccountCategory().equals(AccountCategoryEnum.COST.getCode()) || a.getAccountCategory().equals(AccountCategoryEnum.CAPITAL.getCode()))).collect(Collectors.toList()) : omsCancelItemLine.getPerformOrderItemLineAmountDtoList().stream().filter(a -> a.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_AMOUNT.getCode()) || a.getAmountSource().equals(DgOrderAmountSourceEnum.COST.getCode())).collect(Collectors.toList());
                            for (DgPerformOrderItemLineAmountDto orderLineAmount : orderItemLineAmountDtoList) {
                                String key = orderLineAmount.getAccountType() + "&" + orderLineAmount.getSellerId();
                                if (!orderLineAmountTypeMap.containsKey(key)) {
                                    orderLineAmountTypeMap.put(key, orderLineAmount.getAmount());
                                } else {
                                    BigDecimal amount = ((BigDecimal)orderLineAmountTypeMap.get(key)).add(orderLineAmount.getAmount());
                                    orderLineAmountTypeMap.put(key, amount);
                                }
                                sellerIds.add(orderLineAmount.getSellerId());
                            }
                        }
                        payRefundNum = payRefundNum.add(omsCancelItemList.stream().map(DgPerformOrderItemLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                        continue;
                    }
                    log.error("\u4f9b\u5e94\u94fe\u8ba2\u5355\u884c\u5bf9\u5e94\u7684\u9700\u8981\u53d6\u6d88\u7684\u4f9b\u5e94\u94fe\u5546\u54c1\u884c\u4e0d\u5b58\u5728:{}", (Object)dgPerformOrderItemRespDto.getId());
                }
            } else {
                log.info("\u6e20\u9053\u8ba2\u5355\u884c\u5bf9\u5e94\u7684\u4f9b\u5e94\u94fe\u8ba2\u5355\u884c\u90fd\u65e0\u9700\u53d6\u6d88:{}", (Object)orderLineDto.getId());
            }
            log.info("\u6e20\u9053\u8ba2\u5355\u884c:{} || \u53d6\u6d88\u6570\u91cf====>>>>{}", (Object)orderLineDto.getId(), (Object)payRefundNum);
            log.info("\u6e20\u9053\u8ba2\u5355\u884c:{} || \u8d26\u6237\u7c7b\u578b\u7edf\u8ba1\u7ed3\u679c===>>>>>{}", (Object)orderLineDto.getId(), orderLineAmountTypeMap);
            for (Map.Entry entry : orderLineAmountTypeMap.entrySet()) {
                DgRefundDetailExtReqDto refundDetailDto;
                String refundWay = StringUtils.substringBefore((String)((String)entry.getKey()), (String)"&");
                DgRefundItemDto dgRefundItemDto = new DgRefundItemDto();
                dgRefundItemDto.setBizItemId(orderLineDto.getId());
                dgRefundItemDto.setSaleOrderItemId(orderLineDto.getId());
                dgRefundItemDto.setEnterpriseCode(throughDtoDefine.getPerformOrderSnapshotDto().getEnterpriseCode());
                dgRefundItemDto.setItemId(orderLineDto.getItemId());
                dgRefundItemDto.setItemCode(orderLineDto.getItemCode());
                dgRefundItemDto.setItemName(orderLineDto.getItemName());
                dgRefundItemDto.setItemUnit(orderLineDto.getOrderItemUnit());
                dgRefundItemDto.setSkuCode(orderLineDto.getSkuCode());
                dgRefundItemDto.setSkuName(orderLineDto.getSkuName());
                dgRefundItemDto.setRefundWay(refundWay);
                dgRefundItemDto.setRefundAccount(refundWay);
                dgRefundItemDto.setRefundAmount((BigDecimal)entry.getValue());
                dgRefundItemDto.setRefundNum(Integer.valueOf(payRefundNum.setScale(0, RoundingMode.DOWN).intValue()));
                dgRefundItemDto.setRemark(COMPLETE_ORDER_RESON);
                if (CollectionUtil.isNotEmpty(map)) {
                    List<ItemPayRecordDto> list = map.get(entry.getKey());
                    if (CollectionUtil.isNotEmpty(list)) {
                        dgRefundItemDto.setRefundType(list.get(0).getItemCountsType());
                        dgRefundItemDto.setAccountCategory(list.get(0).getAccountCategory());
                    } else {
                        dgRefundItemDto.setRemark("\u6ca1\u6709\u5bf9\u5e94\u7684\u9000\u6b3e\u8d26\u6237\u7c7b\u578b");
                    }
                } else {
                    dgRefundItemDto.setRemark("\u8d60\u54c1\u9000\u6b3e");
                }
                if (refundDtoMap.containsKey(entry.getKey())) {
                    log.info("\u66f4\u65b0\u8d26\u6237\u7c7b\u578b\u3010{}\u3011\u5bf9\u5e94\u5546\u54c1dto\uff1a{}", entry.getKey(), (Object)JSON.toJSONString((Object)dgRefundDto));
                    refundDetailDto = (DgRefundDetailExtReqDto)refundDtoMap.get(entry.getKey());
                    List items = refundDetailDto.getDgRefundItemDtos();
                    items.add(dgRefundItemDto);
                    refundDetailDto.setDgRefundItemDtos(items);
                    BigDecimal refundAmount = refundDetailDto.getRefundAmount().add((BigDecimal)entry.getValue());
                    refundDetailDto.setRefundAmount(refundAmount);
                    refundDtoMap.put(entry.getKey(), refundDetailDto);
                    continue;
                }
                log.info("\u65b0\u589e\u8d26\u6237\u7c7b\u578b\u3010{}\u3011\u5bf9\u5e94\u5546\u54c1dto\uff1a{}", entry.getKey(), (Object)JSON.toJSONString((Object)dgRefundDto));
                refundDetailDto = new DgRefundDetailExtReqDto();
                refundDetailDto.setRefundId(dgRefundDto.getId());
                refundDetailDto.setRefundOrderNo(dgRefundDto.getRefundNo());
                refundDetailDto.setRefundTradeNo(dgRefundDto.getBizOrderNo());
                refundDetailDto.setRefundWay(refundWay);
                refundDetailDto.setRefundAccount(refundWay);
                refundDetailDto.setRefundAccountName((String)accountNameMap.get(refundWay));
                refundDetailDto.setBizOrderId(throughDtoDefine.getId());
                refundDetailDto.setBizOrderNo(throughDtoDefine.getSaleOrderNo());
                refundDetailDto.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
                refundDetailDto.setStatus(NewDgRefundDetailStatusEnum.REFUND_SUCCESSFUL.getCode());
                refundDetailDto.setRefundTime(new Date());
                refundDetailDto.setEnterpriseCode(dgRefundItemDto.getEnterpriseCode());
                refundDetailDto.setDgRefundItemDtos((List)Lists.newArrayList((Object[])new DgRefundItemDto[]{dgRefundItemDto}));
                refundDetailDto.setRefundAmount((BigDecimal)entry.getValue());
                refundDtoMap.put(entry.getKey(), refundDetailDto);
            }
            OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
            inventoryOperateCargoReqDto.setSkuCode(orderLineDto.getSkuCode());
            inventoryOperateCargoReqDto.setNum(payRefundNum);
            inventoryOperateCargoReqDto.setShopCode(throughDtoDefine.getPerformOrderSnapshotDto().getShopCode());
            operationDetailDtos.add(inventoryOperateCargoReqDto);
        }
        ArrayList detailEos = Lists.newArrayList();
        for (Map.Entry entry : refundDtoMap.entrySet()) {
            detailEos.add(entry.getValue());
        }
        dgRefundDto.setRefundAmount(detailEos.stream().map(DgRefundDetailDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        dgRefundDto.setDgRefundDetailExtReqDtos((List)detailEos);
        log.info("\u9000\u6b3e\u843d\u5e93\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dgRefundDto));
        this.dgRefundService.addRefund(dgRefundDto);
        sellerIds = sellerIds.stream().distinct().collect(Collectors.toList());
        sellerIds.forEach(sellerId -> {
            AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
            accountTradeBatchReqDto.setOrderNo(throughDtoDefine.getSaleOrderNo());
            accountTradeBatchReqDto.setSaleCompanyCode(sellerId);
            accountTradeBatchReqDto.setCustomerNo(throughDtoDefine.getPerformOrderSnapshotDto().getCustomerCode());
            accountTradeBatchReqDto.setShopCode(throughDtoDefine.getPerformOrderSnapshotDto().getShopCode());
            log.info("[\u90e8\u4efd\u53d6\u6d88\u91ca\u653e\u8d26\u6237]:{}", JSON.toJSON((Object)accountTradeBatchReqDto));
            RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.cancelRelease(accountTradeBatchReqDto));
        });
        if (CollectionUtils.isNotEmpty((Collection)operationDetailDtos)) {
            ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
            releasePreemptParam.setSourceNo(throughDtoDefine.getSaleOrderNo());
            releasePreemptParam.setSourceType(throughDtoDefine.getOrderType());
            releasePreemptParam.setDetails((List)operationDetailDtos);
            releasePreemptParam.setIsErrorForNotFoundPreempt(Boolean.FALSE);
            log.info("[\u90e8\u4efd\u53d6\u6d88\u91ca\u653e\u5e93\u5b58]\uff1a{}", JSON.toJSON((Object)releasePreemptParam));
            RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionShopApiProxy.releasePreempt(releasePreemptParam));
        }
        return channelOptB2BOrderRespDto;
    }

    @Override
    public RestResponse<Void> updateDeliveryStatus(DgPerformOrderRespDto throughDtoDefine) {
        DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
        dgPerformOrderInfoEo.setId(throughDtoDefine.getId());
        dgPerformOrderInfoEo.setDeliveryStatus(F2BOrderDeliveryStatusEnum.DELIVERY.getCode());
        this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> updateFailMessage(DgPerformOrderRespDto dto, ChannelOptB2BOrderRespDto req) {
        String errorMsg = req.getErrorMsg();
        if (errorMsg != null) {
            CompletableFuture.runAsync(() -> {
                DgPerformOrderInfoEo dgPerformOrderInfoEo = new DgPerformOrderInfoEo();
                dgPerformOrderInfoEo.setId(dto.getId());
                dgPerformOrderInfoEo.setFailMessage(errorMsg);
                this.dgPerformOrderInfoDomain.updateSelective((BaseEo)dgPerformOrderInfoEo);
            });
            throw new BizException(errorMsg);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> clearOrderLinePayRecord(DgPerformOrderRespDto dto) {
        this.channelOrderPayAction.updatePayStatus(dto, 0);
        this.dgPerformOrderLineDomain.updateOrderLinePayRecord(dto.getId());
        this.dgPerformOrderItemLineDomain.updateOrderLinePayRecord(dto.getId());
        this.dgPerformOrderLineAmountDomain.deleteByOrderIdAndAmountSources(dto.getId(), (List)Lists.newArrayList((Object[])new String[]{DgOrderAmountSourceEnum.ORDER_LINE_AMOUNT.getCode(), DgOrderAmountSourceEnum.COST.getCode()}));
        this.dgPerformOrderItemLineAmountDomain.deleteByOrderIdAndAmountSources(dto.getId(), (List)Lists.newArrayList((Object[])new String[]{DgOrderAmountSourceEnum.ORDER_ITEM_AMOUNT.getCode(), DgOrderAmountSourceEnum.COST.getCode()}));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> advanceOrderDelete(DgPerformOrderRespDto orderRespDto) {
        if (!Objects.equals(orderRespDto.getOrderType(), DgSaleOrderTypeEnum.CUSTOM_ORDER.getType())) {
            log.info("\u975e\u5b9a\u5236\u54c1\u8ba2\u5355\u4e0d\u5904\u7406\u9884\u5b9a\u91d1\u8d26\u6237\u91d1\u989d");
            return RestResponse.VOID;
        }
        List orderLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderLineDomain.filter().eq((Object)"order_id", (Object)orderRespDto.getId())).eq((Object)"dr", (Object)0)).list();
        DgAdvanceRelevanceOrderExtDto advanceRelevanceOrderExtDto = new DgAdvanceRelevanceOrderExtDto();
        advanceRelevanceOrderExtDto.setAdvanceOrderNo(orderRespDto.getPerformOrderExtensionDto().getBeforeOrderNo());
        advanceRelevanceOrderExtDto.setRelevanceOrderNo(orderRespDto.getSaleOrderNo());
        advanceRelevanceOrderExtDto.setType(AdvanceOrderRelevanceTypeEnum.CANCEL.getType());
        ArrayList relevanceOrderDtoList = Lists.newArrayList();
        for (DgPerformOrderLineEo orderLine : orderLineEos) {
            DgAdvanceRelevanceOrderDto advanceRelevanceOrderDto = new DgAdvanceRelevanceOrderDto();
            advanceRelevanceOrderDto.setRelevanceOrderNo(orderRespDto.getSaleOrderNo());
            advanceRelevanceOrderDto.setAdvanceOrderNo(orderRespDto.getPerformOrderExtensionDto().getBeforeOrderNo());
            advanceRelevanceOrderDto.setSkuCode(orderLine.getSkuCode());
            advanceRelevanceOrderDto.setSkuId(orderLine.getSkuId());
            advanceRelevanceOrderDto.setDeliveryNum(orderLine.getItemNum());
            advanceRelevanceOrderDto.setAdvanceItemLineId(orderLine.getBeforeOrderItemId());
            advanceRelevanceOrderDto.setRelevanceItemLineId(orderLine.getId());
            relevanceOrderDtoList.add(advanceRelevanceOrderDto);
        }
        advanceRelevanceOrderExtDto.setRelevanceOrderDtoList((List)relevanceOrderDtoList);
        log.info("\u5220\u9664\u8ba2\u8d27\u5355\u83b7\u53d6\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\u5165\u53c2={}", JSON.toJSON((Object)advanceRelevanceOrderExtDto));
        BigDecimal advanceAmount = this.dgAdvanceRelevanceOrderService.updateItemLineByRelevanceOrder(advanceRelevanceOrderExtDto);
        log.info("\u5220\u9664\u8ba2\u8d27\u5355\u83b7\u53d6\u9884\u8ba2\u5355\u91ca\u653e\u91d1\u989d\u7ed3\u679c={}", (Object)advanceAmount);
        return RestResponse.VOID;
    }

    @Override
    public ChannelOptB2BOrderRespDto partCancelAndRefund(DgPerformOrderRespDto throughDtoDefine) {
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(throughDtoDefine.getId());
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty((Collection)orderLineDtos), (String)"\u8ba2\u5355\u53d6\u6d88\uff0c\u672a\u67e5\u8be2\u5230\u6e20\u9053\u8ba2\u5355\u5546\u54c1\u4fe1\u606f");
        Map orderLineDtoMap = orderLineDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        List itemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(throughDtoDefine.getId());
        ArrayList operationDetailDtos = Lists.newArrayList();
        DgRefundExtReqDto dgRefundDto = new DgRefundExtReqDto();
        dgRefundDto.setOrganizationId(throughDtoDefine.getPerformOrderSnapshotDto().getOrganizationId());
        dgRefundDto.setOrganizationName(throughDtoDefine.getPerformOrderSnapshotDto().getOrganizationName());
        dgRefundDto.setBizOrderId(throughDtoDefine.getId());
        dgRefundDto.setBizOrderNo(throughDtoDefine.getSaleOrderNo());
        dgRefundDto.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
        dgRefundDto.setRefundNo(TradeUtil.generateTradeNo((String)throughDtoDefine.getSaleOrderNo()));
        dgRefundDto.setStatus(DgAfterSaleOrderRefundStatusEnum.REFUNDED.getCode());
        dgRefundDto.setRefundDesc(COMPLETE_ORDER_RESON);
        HashMap accountNameMap = Maps.newHashMap();
        List<PayRecordDto> payRecordDtos = this.payRecordService.selectListByOrderNo(throughDtoDefine.getSaleOrderNo());
        Map payRecordDtoMap = payRecordDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (a, b) -> a));
        Map<Long, Map<String, List<ItemPayRecordDto>>> itemPayRecordMap = payRecordDtos.stream().filter(recordDto -> !Objects.equals(PayStatusEnum.BACKED.getCode(), recordDto.getPayStatus())).peek(recordDto -> accountNameMap.put(recordDto.getPayMethod(), recordDto.getPayMethodName())).map(recordDto -> new ArrayList(recordDto.getItemPayRecordDtos())).flatMap(Collection::stream).map(itemPayRecord -> {
            PayRecordDto payRecordDto = (PayRecordDto)payRecordDtoMap.get(itemPayRecord.getPayRecordId());
            if (null != payRecordDto) {
                itemPayRecord.setSaleCompanyCode(payRecordDto.getSellerId());
            }
            return itemPayRecord;
        }).collect(Collectors.groupingBy(ItemPayRecordDto::getOrderItemId, Collectors.groupingBy(itemPayRecord -> itemPayRecord.getAccountType() + "&" + itemPayRecord.getSaleCompanyCode())));
        log.info("\u652f\u4ed8\u8bb0\u5f55\u7c7b\u578b\uff1a{}", itemPayRecordMap);
        HashMap refundDtoMap = new HashMap();
        List<Object> sellerIds = new ArrayList();
        for (Object itemLineDto : itemLineDtos) {
            Object orderLineAmount22;
            if (Objects.equals(itemLineDto.getDeliveryStatus(), ItemLineDeliveryStatusEnum.YES.getType()) || BigDecimalUtils.equals((BigDecimal)itemLineDto.getItemNum(), (BigDecimal)itemLineDto.getOutItemNum()).booleanValue()) {
                log.info("\u5f53\u524d\u884c\u5df2\u5168\u90e8\u53d1\u8d27\uff0c\u8df3\u8fc7\u53d6\u6d88\uff0csku\uff1a{}", (Object)itemLineDto.getSkuCode());
                continue;
            }
            Map<String, List<ItemPayRecordDto>> map = itemPayRecordMap.get(itemLineDto.getOrderLineId());
            BigDecimal payRefundNum = BigDecimal.ZERO;
            HashMap<String, BigDecimal> orderLineAmountTypeMap = new HashMap<String, BigDecimal>();
            List<Object> orderItemLineAmountDtoList = Lists.newArrayList();
            orderItemLineAmountDtoList = throughDtoDefine.getPerformOrderSnapshotDto().getKneadeFlag().equals(YesOrNoEnum.YES.getType()) ? itemLineDto.getPerformOrderItemLineAmountDtoList().stream().filter(a -> a.getAmountSource().equals(DgOrderAmountSourceEnum.KNEAD.getCode()) && (a.getAccountCategory().equals(AccountCategoryEnum.COST.getCode()) || a.getAccountCategory().equals(AccountCategoryEnum.CAPITAL.getCode()))).collect(Collectors.toList()) : itemLineDto.getPerformOrderItemLineAmountDtoList().stream().filter(a -> a.getAmountSource().equals(DgOrderAmountSourceEnum.ORDER_ITEM_AMOUNT.getCode()) || a.getAmountSource().equals(DgOrderAmountSourceEnum.COST.getCode())).collect(Collectors.toList());
            for (Object orderLineAmount22 : orderItemLineAmountDtoList) {
                String key = orderLineAmount22.getAccountType() + "&" + orderLineAmount22.getSellerId();
                BigDecimal refundAmount = this.calcPartCancelRefundAmount((DgPerformOrderItemLineDto)itemLineDto, itemLineDto.getOutItemNum(), orderLineAmount22.getAmount());
                if (!orderLineAmountTypeMap.containsKey(key)) {
                    orderLineAmountTypeMap.put(key, refundAmount);
                } else {
                    BigDecimal amount = ((BigDecimal)orderLineAmountTypeMap.get(key)).add(refundAmount);
                    orderLineAmountTypeMap.put(key, amount);
                }
                sellerIds.add(orderLineAmount22.getSellerId());
            }
            payRefundNum = payRefundNum.add(BigDecimalUtils.subtract((BigDecimal)itemLineDto.getItemNum(), (BigDecimal)itemLineDto.getOutItemNum()));
            log.info("\u6e20\u9053\u8ba2\u5355\u884c:{} || \u53d6\u6d88\u6570\u91cf====>>>>{}", (Object)itemLineDto.getId(), (Object)payRefundNum);
            log.info("\u6e20\u9053\u8ba2\u5355\u884c:{} || \u8d26\u6237\u7c7b\u578b\u7edf\u8ba1\u7ed3\u679c===>>>>>{}", (Object)itemLineDto.getId(), orderLineAmountTypeMap);
            DgPerformOrderLineDto orderLineDto = (DgPerformOrderLineDto)orderLineDtoMap.get(itemLineDto.getOrderLineId());
            orderLineAmount22 = orderLineAmountTypeMap.entrySet().iterator();
            while (orderLineAmount22.hasNext()) {
                DgRefundDetailExtReqDto refundDetailDto;
                Map.Entry entry = (Map.Entry)orderLineAmount22.next();
                String refundWay = StringUtils.substringBefore((String)((String)entry.getKey()), (String)"&");
                DgRefundItemDto dgRefundItemDto = new DgRefundItemDto();
                dgRefundItemDto.setBizItemId(itemLineDto.getId());
                dgRefundItemDto.setSaleOrderItemId(itemLineDto.getId());
                dgRefundItemDto.setEnterpriseCode(throughDtoDefine.getPerformOrderSnapshotDto().getEnterpriseCode());
                dgRefundItemDto.setItemId(orderLineDto.getItemId());
                dgRefundItemDto.setItemCode(itemLineDto.getItemCode());
                dgRefundItemDto.setItemName(itemLineDto.getItemName());
                dgRefundItemDto.setItemUnit(orderLineDto.getOrderItemUnit());
                dgRefundItemDto.setSkuCode(itemLineDto.getSkuCode());
                dgRefundItemDto.setSkuName(itemLineDto.getSkuName());
                dgRefundItemDto.setRefundWay(refundWay);
                dgRefundItemDto.setRefundAccount(refundWay);
                dgRefundItemDto.setRefundAmount((BigDecimal)entry.getValue());
                dgRefundItemDto.setRefundNum(Integer.valueOf(payRefundNum.setScale(0, RoundingMode.DOWN).intValue()));
                dgRefundItemDto.setRemark(COMPLETE_ORDER_RESON);
                if (CollectionUtil.isNotEmpty(map)) {
                    List<ItemPayRecordDto> list = map.get(entry.getKey());
                    if (CollectionUtil.isNotEmpty(list)) {
                        dgRefundItemDto.setRefundType(list.get(0).getItemCountsType());
                        dgRefundItemDto.setAccountCategory(list.get(0).getAccountCategory());
                    } else {
                        dgRefundItemDto.setRemark("\u6ca1\u6709\u5bf9\u5e94\u7684\u9000\u6b3e\u8d26\u6237\u7c7b\u578b");
                    }
                } else {
                    dgRefundItemDto.setRemark("\u8d60\u54c1\u9000\u6b3e");
                }
                if (refundDtoMap.containsKey(entry.getKey())) {
                    log.info("\u66f4\u65b0\u8d26\u6237\u7c7b\u578b\u3010{}\u3011\u5bf9\u5e94\u5546\u54c1dto\uff1a{}", entry.getKey(), (Object)JSON.toJSONString((Object)dgRefundDto));
                    refundDetailDto = (DgRefundDetailExtReqDto)refundDtoMap.get(entry.getKey());
                    List items = refundDetailDto.getDgRefundItemDtos();
                    items.add(dgRefundItemDto);
                    refundDetailDto.setDgRefundItemDtos(items);
                    BigDecimal refundAmount = refundDetailDto.getRefundAmount().add((BigDecimal)entry.getValue());
                    refundDetailDto.setRefundAmount(refundAmount);
                    refundDtoMap.put(entry.getKey(), refundDetailDto);
                    continue;
                }
                log.info("\u65b0\u589e\u8d26\u6237\u7c7b\u578b\u3010{}\u3011\u5bf9\u5e94\u5546\u54c1dto\uff1a{}", entry.getKey(), (Object)JSON.toJSONString((Object)dgRefundDto));
                refundDetailDto = new DgRefundDetailExtReqDto();
                refundDetailDto.setRefundId(dgRefundDto.getId());
                refundDetailDto.setRefundOrderNo(dgRefundDto.getRefundNo());
                refundDetailDto.setRefundTradeNo(dgRefundDto.getBizOrderNo());
                refundDetailDto.setRefundWay(refundWay);
                refundDetailDto.setRefundAccount(refundWay);
                refundDetailDto.setRefundAccountName((String)accountNameMap.get(refundWay));
                refundDetailDto.setBizOrderId(throughDtoDefine.getId());
                refundDetailDto.setBizOrderNo(throughDtoDefine.getSaleOrderNo());
                refundDetailDto.setBizOrderType(DgRefundBizOrderTypeEnum.ORDER.getCode());
                refundDetailDto.setStatus(NewDgRefundDetailStatusEnum.REFUND_SUCCESSFUL.getCode());
                refundDetailDto.setRefundTime(new Date());
                refundDetailDto.setEnterpriseCode(dgRefundItemDto.getEnterpriseCode());
                refundDetailDto.setDgRefundItemDtos((List)Lists.newArrayList((Object[])new DgRefundItemDto[]{dgRefundItemDto}));
                refundDetailDto.setRefundAmount((BigDecimal)entry.getValue());
                refundDtoMap.put(entry.getKey(), refundDetailDto);
            }
            OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
            inventoryOperateCargoReqDto.setSkuCode(itemLineDto.getSkuCode());
            inventoryOperateCargoReqDto.setNum(payRefundNum);
            inventoryOperateCargoReqDto.setShopCode(throughDtoDefine.getPerformOrderSnapshotDto().getShopCode());
            operationDetailDtos.add(inventoryOperateCargoReqDto);
        }
        ArrayList detailEos = Lists.newArrayList();
        for (Map.Entry entry : refundDtoMap.entrySet()) {
            detailEos.add(entry.getValue());
        }
        dgRefundDto.setRefundAmount(detailEos.stream().map(DgRefundDetailDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
        dgRefundDto.setDgRefundDetailExtReqDtos((List)detailEos);
        log.info("\u9000\u6b3e\u843d\u5e93\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dgRefundDto));
        this.dgRefundService.addRefund(dgRefundDto);
        sellerIds = sellerIds.stream().distinct().collect(Collectors.toList());
        sellerIds.forEach(sellerId -> {
            AccountTradeBatchReqDto accountTradeBatchReqDto = new AccountTradeBatchReqDto();
            accountTradeBatchReqDto.setOrderNo(throughDtoDefine.getSaleOrderNo());
            accountTradeBatchReqDto.setSaleCompanyCode(sellerId);
            accountTradeBatchReqDto.setCustomerNo(throughDtoDefine.getPerformOrderSnapshotDto().getCustomerCode());
            accountTradeBatchReqDto.setShopCode(throughDtoDefine.getPerformOrderSnapshotDto().getShopCode());
            log.info("[\u90e8\u4efd\u53d6\u6d88\u91ca\u653e\u8d26\u6237]:{}", JSON.toJSON((Object)accountTradeBatchReqDto));
            RestResponseHelper.extractData((RestResponse)this.accountTradeApiProxy.cancelRelease(accountTradeBatchReqDto));
        });
        if (CollectionUtils.isNotEmpty((Collection)operationDetailDtos)) {
            ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
            releasePreemptParam.setSourceNo(throughDtoDefine.getSaleOrderNo());
            releasePreemptParam.setSourceType(throughDtoDefine.getOrderType());
            releasePreemptParam.setDetails((List)operationDetailDtos);
            releasePreemptParam.setIsErrorForNotFoundPreempt(Boolean.FALSE);
            log.info("[\u90e8\u4efd\u53d6\u6d88\u91ca\u653e\u5e93\u5b58]\uff1a{}", JSON.toJSON((Object)releasePreemptParam));
            RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionShopApiProxy.releasePreempt(releasePreemptParam));
        }
        return new ChannelOptB2BOrderRespDto();
    }

    private BigDecimal calcPartCancelRefundAmount(DgPerformOrderItemLineDto itemLineDto, BigDecimal outItemNum, BigDecimal amount) {
        return BigDecimalUtils.subtract((BigDecimal)amount, (BigDecimal)BigDecimalUtils.multiply((BigDecimal)amount, (BigDecimal)outItemNum).divide(itemLineDto.getItemNum(), 2, RoundingMode.HALF_UP));
    }
}

