/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.inventory.enums.CsInventorySourceTypeEnum;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BOrderStatus;
import com.dtyunxi.yundt.cube.center.trade.api.constants.TradeSchedulerEnum;
import com.github.pagehelper.PageInfo;
import com.github.pagehelper.PageSerializable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.dto.entity.CustomerDiscountConfigDto;
import com.yunxi.dg.base.center.customer.proxy.entity.ICustomerDiscountConfigApiProxy;
import com.yunxi.dg.base.center.inventory.dto.share.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptExtDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventoryPreemptionSupplyDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventoryPreemptionSupplyPageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.SupplyWarehouseSourcingConfigureDto;
import com.yunxi.dg.base.center.share.dto.entity.SupplyWarehouseSourcingConfigurePageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderDetailDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderExtDto;
import com.yunxi.dg.base.center.share.proxy.entity.ISupplyWarehouseSourcingConfigureApiProxy;
import com.yunxi.dg.base.center.share.proxy.entity.ITransferGoodsOrderApiProxy;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgInventoryPreemptionShopApiProxy;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgInventoryPreemptionSupplyApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderCreateAction;
import com.yunxi.dg.base.center.trade.constants.CustomOrderTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IBizInfoRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.config.DgOrderConfigurationRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgOrderWarehouseReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.DgShopOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderBatchPushReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.custom.DgCustomPackageOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.custom.DgCustomPackageOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.DgOrderPreviewReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.preview.OrderPreviewItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.order.DgShopOrderResultRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.eo.BizInfoRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrItemEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderAddrItemService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.service.oms.common.IOrderCommonHandleService;
import com.yunxi.dg.base.center.trade.service.oms.common.IScheduleService;
import com.yunxi.dg.base.center.trade.service.orderConfig.IDgOrderConfigurationService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.utils.NoGreateUtil;
import com.yunxi.dg.base.center.trade.utils.OrderExpiredUtil;
import com.yunxi.dg.base.center.trade.utils.selector.ChannelOrderCreateSelector;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ChannelOrderCreateActionImpl
implements IChannelOrderCreateAction {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderCreateActionImpl.class);
    @Resource
    private NoGreateUtil noGreateUtil;
    @Resource
    private IDgOrderConfigurationService dgOrderConfigurationService;
    @Resource
    private IDgInventoryPreemptionShopApiProxy dgInventoryPreemptionShopApiProxy;
    @Resource
    private IDgPerformOrderAddrItemService dgPerformOrderAddrItemService;
    @Resource
    private IDgInventoryPreemptionSupplyApiProxy dgInventoryPreemptionSupplyApiProxy;
    @Resource
    private ICustomerDiscountConfigApiProxy customerDiscountConfigApiProxy;
    @Resource
    private ITransferGoodsOrderApiProxy transferGoodsOrderApiProxy;
    @Resource
    private ISupplyWarehouseSourcingConfigureApiProxy supplyWarehouseSourcingConfigureApiProxy;
    @Resource
    private IScheduleService scheduleService;
    @Resource
    private IChannelOrderService channelOrderService;
    @Resource
    private IOrderCommonHandleService orderCommonHandleService;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderInfoDomain omsOrderInfoDomain;
    @Resource
    private IBizInfoRecordDomain bizInfoRecordDomain;

    @Override
    public String generateF2BNo(String prefix, Integer footLength) {
        return this.noGreateUtil.generateF2BNo(prefix, footLength);
    }

    @Override
    public List<DgF2BOrderPreviewContext> channelOrderPreviewV2(DgOrderPreviewReqDto previewReqDto) {
        log.info("\u8ba2\u5355\u9884\u89c8\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)previewReqDto));
        DgF2BOrderPreviewContext f2BOrderPreviewContext = ChannelOrderCreateSelector.newInstance(previewReqDto.getOrderType()).execute(previewReqDto);
        ArrayList previewOrderResult = Lists.newArrayList();
        previewOrderResult.add(f2BOrderPreviewContext);
        return previewOrderResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DgOrderResultRespDto saveChannelOrderV2(DgOrderReqDto dgOrderReqDto) {
        log.info("\u8ba2\u5355\u4fdd\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dgOrderReqDto));
        dgOrderReqDto.setDefPreviewOpt(dgOrderReqDto.getDefPreviewOpt() == 2 ? 2 : 1);
        DgOrderResultRespDto resultRespDto = ChannelOrderCreateSelector.newInstance(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getOrderType()).saveExecute(dgOrderReqDto);
        BizInfoRecordEo bizInfoRecord = new BizInfoRecordEo();
        bizInfoRecord.setBizId(((DgShopOrderResultRespDto)resultRespDto.getShopOrderResultRespDtos().get(0)).getOrderId().toString());
        BizInfoRecordEo bizInfoRecordEo = (BizInfoRecordEo)this.bizInfoRecordDomain.selectOne((BaseEo)bizInfoRecord);
        if (null == bizInfoRecordEo) {
            bizInfoRecord.setBizText(JSON.toJSONString((Object)dgOrderReqDto));
            this.bizInfoRecordDomain.insert((BaseEo)bizInfoRecord);
        } else {
            bizInfoRecordEo.setBizText(JSON.toJSONString((Object)dgOrderReqDto));
            this.bizInfoRecordDomain.updateSelective((BaseEo)bizInfoRecordEo);
        }
        return resultRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public DgOrderResultRespDto submitChannelOrderV2(DgOrderReqDto dgOrderReqDto) {
        log.info("\u8ba2\u5355\u63d0\u4ea4\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dgOrderReqDto));
        dgOrderReqDto.setDefPreviewOpt(2);
        dgOrderReqDto.setCostAccountControl(Boolean.TRUE);
        DgOrderResultRespDto resultRespDto = this.saveChannelOrderV2(dgOrderReqDto);
        return ChannelOrderCreateSelector.newInstance(((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).getOrderType()).saveAfterExecute(resultRespDto, dgOrderReqDto);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> checkOrder(DgPerformOrderRespDto dto, DgOrderReqDto dgOrderReqDto) {
        log.info("\u8ba2\u5355\u786e\u8ba4\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dgOrderReqDto));
        dgOrderReqDto.getShopOrderReqDtoList().forEach(dgShopOrderReqDto -> dgShopOrderReqDto.setSaleOrderNo(dto.getSaleOrderNo()));
        DgOrderResultRespDto dgOrderResultRespDto = this.submitChannelOrderV2(dgOrderReqDto);
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(dto.getId());
        BeanUtil.copyProperties((Object)performOrderRespDto, (Object)dto, (String[])new String[0]);
        return new RestResponse((Object)dgOrderResultRespDto);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> batchPush(DgPerformOrderRespDto dto, OrderBatchPushReqDto reqDto) {
        log.info("\u6279\u91cf\u63d0\u4ea4\u5165\u53c2--\u5355\u4e2a\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        BizInfoRecordEo bizInfoRecord = new BizInfoRecordEo();
        bizInfoRecord.setBizId(reqDto.getOrderId().toString());
        BizInfoRecordEo bizInfoRecordEo = (BizInfoRecordEo)this.bizInfoRecordDomain.selectOne((BaseEo)bizInfoRecord);
        if (null == bizInfoRecordEo) {
            throw new BizException("\u8ba2\u5355\u4fdd\u5b58\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        DgOrderReqDto dgOrderReqDto = (DgOrderReqDto)JSON.parseObject((String)bizInfoRecordEo.getBizText(), DgOrderReqDto.class);
        ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).setId(reqDto.getOrderId());
        ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).setMatchActivity(Boolean.TRUE);
        ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).setActivityList(new ArrayList());
        dgOrderReqDto.setIsVerifyChannelInventory(reqDto.getIsVerifyChannelInventory());
        dgOrderReqDto.setIsVerifySupplyInventory(reqDto.getIsVerifySupplyInventory());
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getItemList())) {
            ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).setItemList(reqDto.getItemList());
        }
        if (CollectionUtil.isNotEmpty((Collection)reqDto.getGiftList())) {
            ((DgShopOrderReqDto)dgOrderReqDto.getShopOrderReqDtoList().get(0)).setGiftList(reqDto.getGiftList());
        }
        DgOrderResultRespDto dgOrderResultRespDto = this.submitChannelOrderV2(dgOrderReqDto);
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(dto.getId());
        BeanUtil.copyProperties((Object)performOrderRespDto, (Object)dto, (String[])new String[0]);
        return new RestResponse((Object)dgOrderResultRespDto);
    }

    @Override
    public RestResponse<Void> logicDeleteOrder(DgPerformOrderRespDto dto) {
        this.channelOrderService.logicDeleteOrder(dto.getId());
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DgOrderResultRespDto> financeRecalculateOrder(DgPerformOrderRespDto dto, DgOrderReqDto req) {
        Object jsonObject;
        Object shoutVirtualWarehouseList;
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)req.getShopOrderReqDtoList()), (String)"\u8ba2\u5355\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        DgBizPerformOrderRespDto dgBizPerformOrderRespDto = this.orderCommonHandleService.queryOrderRespDtoByOrderNo(dto.getSaleOrderNo());
        DgPerformOrderAddrRespDto orderAddrRespDto = dgBizPerformOrderRespDto.getOrderAddrRespDto();
        List dgPerformOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(dto.getId());
        Map oldItemMap = dgPerformOrderItemRespDtos.stream().collect(Collectors.toMap(DgPerformOrderLineDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        DgShopOrderReqDto dgShopOrderReqDto = (DgShopOrderReqDto)req.getShopOrderReqDtoList().stream().findFirst().get();
        DgPerformOrderAddrReqDto dgPerformOrderAddrReqDto = new DgPerformOrderAddrReqDto();
        BeanUtil.copyProperties((Object)orderAddrRespDto, (Object)dgPerformOrderAddrReqDto, (String[])new String[0]);
        dgShopOrderReqDto.setOrderAddrReqDto(dgPerformOrderAddrReqDto);
        dgShopOrderReqDto.setPlanShipmentEnterpriseId(Optional.ofNullable(dgShopOrderReqDto.getPlanShipmentEnterpriseId()).orElse(dto.getPlanShipmentEnterpriseId()));
        dgShopOrderReqDto.setPlanShipmentEnterpriseCode(Optional.ofNullable(dgShopOrderReqDto.getPlanShipmentEnterpriseCode()).orElse(dto.getPlanShipmentEnterpriseCode()));
        dgShopOrderReqDto.setPlanShipmentEnterpriseName(Optional.ofNullable(dgShopOrderReqDto.getPlanShipmentEnterpriseName()).orElse(dto.getPlanShipmentEnterpriseName()));
        dgShopOrderReqDto.setRemark(Optional.ofNullable(dgShopOrderReqDto.getRemark()).orElse(dto.getRemark()));
        dgShopOrderReqDto.setSellerRemark(Optional.ofNullable(dgShopOrderReqDto.getSellerRemark()).orElse(dto.getSellerRemark()));
        dgShopOrderReqDto.setReceiveSceneCode(Optional.ofNullable(dgShopOrderReqDto.getReceiveSceneCode()).orElse(dto.getPerformOrderExtensionDto().getReceiveSceneCode()));
        dgShopOrderReqDto.setReceiveSceneName(Optional.ofNullable(dgShopOrderReqDto.getReceiveSceneName()).orElse(dto.getPerformOrderExtensionDto().getReceiveSceneName()));
        dgShopOrderReqDto.setCostCenterId(Optional.ofNullable(dgShopOrderReqDto.getCostCenterId()).orElse(dto.getPerformOrderExtensionDto().getCostCenterId()));
        dgShopOrderReqDto.setCostCenter(Optional.ofNullable(dgShopOrderReqDto.getCostCenter()).orElse(dto.getPerformOrderExtensionDto().getCostCenter()));
        dgShopOrderReqDto.setCostCenterName(Optional.ofNullable(dgShopOrderReqDto.getCostCenterName()).orElse(dto.getPerformOrderExtensionDto().getCostCenterName()));
        dgShopOrderReqDto.setEmployeeId(Optional.ofNullable(dgShopOrderReqDto.getEmployeeId()).orElse(dto.getPerformOrderExtensionDto().getEmployeeId()));
        dgShopOrderReqDto.setEmployeeNo(Optional.ofNullable(dgShopOrderReqDto.getEmployeeNo()).orElse(dto.getPerformOrderExtensionDto().getEmployeeNo()));
        dgShopOrderReqDto.setEmployeeName(Optional.ofNullable(dgShopOrderReqDto.getEmployeeName()).orElse(dto.getPerformOrderExtensionDto().getEmployeeName()));
        dgShopOrderReqDto.setBizDate(Optional.ofNullable(dgShopOrderReqDto.getBizDate()).orElse(dto.getBizDate()));
        dgShopOrderReqDto.setShippingType(Optional.ofNullable(dgShopOrderReqDto.getShippingType()).orElse(dto.getShippingType()));
        dgShopOrderReqDto.setHsEnterpriseId(Optional.ofNullable(dgShopOrderReqDto.getHsEnterpriseId()).orElse(dto.getPerformOrderSnapshotDto().getHsEnterpriseId()));
        dgShopOrderReqDto.setHsEnterpriseCode(Optional.ofNullable(dgShopOrderReqDto.getHsEnterpriseCode()).orElse(dto.getPerformOrderSnapshotDto().getHsEnterpriseCode()));
        dgShopOrderReqDto.setHsEnterpriseName(Optional.ofNullable(dgShopOrderReqDto.getHsEnterpriseName()).orElse(dto.getPerformOrderSnapshotDto().getHsEnterpriseName()));
        dgShopOrderReqDto.setReceivingStoreId(Optional.ofNullable(dgShopOrderReqDto.getReceivingStoreId()).orElse(dto.getPerformOrderExtensionDto().getReceivingStoreId()));
        dgShopOrderReqDto.setReceivingStoreCode(Optional.ofNullable(dgShopOrderReqDto.getReceivingStoreCode()).orElse(dto.getPerformOrderExtensionDto().getReceivingStoreCode()));
        dgShopOrderReqDto.setReceivingStoreName(Optional.ofNullable(dgShopOrderReqDto.getReceivingStoreName()).orElse(dto.getPerformOrderExtensionDto().getReceivingStoreName()));
        dgShopOrderReqDto.setChannelWarehouseId(Optional.ofNullable(dgShopOrderReqDto.getChannelWarehouseId()).orElse(dto.getPerformOrderSnapshotDto().getChannelWarehouseId()));
        dgShopOrderReqDto.setChannelWarehouseCode(Optional.ofNullable(dgShopOrderReqDto.getChannelWarehouseCode()).orElse(dto.getPerformOrderSnapshotDto().getChannelWarehouseCode()));
        dgShopOrderReqDto.setChannelWarehouseName(Optional.ofNullable(dgShopOrderReqDto.getChannelWarehouseName()).orElse(dto.getPerformOrderSnapshotDto().getChannelWarehouseName()));
        dgShopOrderReqDto.setExtension(dto.getPerformOrderExtensionDto().getExtension());
        String extension = dto.getPerformOrderExtensionDto().getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension) && (shoutVirtualWarehouseList = (jsonObject = JSON.parseObject((String)extension)).get((Object)"shoutVirtualWarehouseList")) != null) {
            dgShopOrderReqDto.setShoutVirtualWarehouseList(JSON.parseArray((String)shoutVirtualWarehouseList.toString(), DgOrderWarehouseReqDto.class));
        }
        dgShopOrderReqDto.setOrderStatus(dto.getOrderStatus());
        dgShopOrderReqDto.setSaleOrderNo(dto.getSaleOrderNo());
        req.setCustomerId(dto.getPerformOrderSnapshotDto().getCustomerId());
        req.setOrganizationId(dto.getPerformOrderSnapshotDto().getOrganizationId());
        for (DgShopOrderReqDto shopOrderReqDto : req.getShopOrderReqDtoList()) {
            for (OrderPreviewItemReqDto orderPreviewItemReqDto : shopOrderReqDto.getItemList()) {
                DgPerformOrderLineDto dgPerformOrderItemRespDto = (DgPerformOrderLineDto)oldItemMap.get(orderPreviewItemReqDto.getSkuId());
                if (null == dgPerformOrderItemRespDto) continue;
                orderPreviewItemReqDto.setPlaceItemNum(dgPerformOrderItemRespDto.getPlaceItemNum());
                orderPreviewItemReqDto.setOrderItemUnit(dgPerformOrderItemRespDto.getOrderItemUnit());
                orderPreviewItemReqDto.setOrderItemUnitName(dgPerformOrderItemRespDto.getOrderItemUnitName());
            }
        }
        log.info("\u91cd\u65b0\u8ba1\u7b97\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)req));
        DgOrderResultRespDto dgOrderResultRespDto = this.submitChannelOrderV2(req);
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(dto.getId());
        BeanUtil.copyProperties((Object)performOrderRespDto, (Object)dto, (String[])new String[0]);
        return new RestResponse((Object)dgOrderResultRespDto);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> csAuditRecalculateOrder(DgPerformOrderRespDto dto, DgOrderReqDto req) {
        JSONObject jsonObject;
        Object shoutVirtualWarehouseList;
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)req.getShopOrderReqDtoList()), (String)"\u8ba2\u5355\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        DgBizPerformOrderRespDto dgBizPerformOrderRespDto = this.orderCommonHandleService.queryOrderRespDtoByOrderNo(dto.getSaleOrderNo());
        DgPerformOrderAddrRespDto orderAddrRespDto = dgBizPerformOrderRespDto.getOrderAddrRespDto();
        List dgPerformOrderItemRespDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(dto.getId());
        Map oldItemMap = dgPerformOrderItemRespDtos.stream().collect(Collectors.toMap(DgPerformOrderLineDto::getSkuId, Function.identity(), (e1, e2) -> e1));
        DgShopOrderReqDto dgShopOrderReqDto = (DgShopOrderReqDto)req.getShopOrderReqDtoList().stream().findFirst().get();
        DgPerformOrderAddrReqDto dgPerformOrderAddrReqDto = new DgPerformOrderAddrReqDto();
        BeanUtil.copyProperties((Object)orderAddrRespDto, (Object)dgPerformOrderAddrReqDto, (String[])new String[0]);
        dgShopOrderReqDto.setOrderAddrReqDto(dgPerformOrderAddrReqDto);
        dgShopOrderReqDto.setPlanShipmentEnterpriseId(Optional.ofNullable(dgShopOrderReqDto.getPlanShipmentEnterpriseId()).orElse(dto.getPlanShipmentEnterpriseId()));
        dgShopOrderReqDto.setPlanShipmentEnterpriseCode(Optional.ofNullable(dgShopOrderReqDto.getPlanShipmentEnterpriseCode()).orElse(dto.getPlanShipmentEnterpriseCode()));
        dgShopOrderReqDto.setPlanShipmentEnterpriseName(Optional.ofNullable(dgShopOrderReqDto.getPlanShipmentEnterpriseName()).orElse(dto.getPlanShipmentEnterpriseName()));
        dgShopOrderReqDto.setRemark(Optional.ofNullable(dgShopOrderReqDto.getRemark()).orElse(dto.getRemark()));
        dgShopOrderReqDto.setSellerRemark(Optional.ofNullable(dgShopOrderReqDto.getSellerRemark()).orElse(dto.getSellerRemark()));
        dgShopOrderReqDto.setOrderStatus(dto.getOrderStatus());
        dgShopOrderReqDto.setSaleOrderNo(dto.getSaleOrderNo());
        for (DgShopOrderReqDto shopOrderReqDto : req.getShopOrderReqDtoList()) {
            for (OrderPreviewItemReqDto orderPreviewItemReqDto : shopOrderReqDto.getItemList()) {
                DgPerformOrderLineDto dgPerformOrderItemRespDto = (DgPerformOrderLineDto)oldItemMap.get(orderPreviewItemReqDto.getSkuId());
                if (null == dgPerformOrderItemRespDto) continue;
                orderPreviewItemReqDto.setOrderItemUnit(dgPerformOrderItemRespDto.getOrderItemUnit());
                orderPreviewItemReqDto.setOrderItemUnitName(dgPerformOrderItemRespDto.getOrderItemUnitName());
            }
        }
        req.setCustomerId(dto.getPerformOrderSnapshotDto().getCustomerId());
        req.setOrganizationId(dto.getPerformOrderSnapshotDto().getOrganizationId());
        dgShopOrderReqDto.setReceiveSceneCode(Optional.ofNullable(dgShopOrderReqDto.getReceiveSceneCode()).orElse(dto.getPerformOrderExtensionDto().getReceiveSceneCode()));
        dgShopOrderReqDto.setReceiveSceneName(Optional.ofNullable(dgShopOrderReqDto.getReceiveSceneName()).orElse(dto.getPerformOrderExtensionDto().getReceiveSceneName()));
        dgShopOrderReqDto.setCostCenterId(Optional.ofNullable(dgShopOrderReqDto.getCostCenterId()).orElse(dto.getPerformOrderExtensionDto().getCostCenterId()));
        dgShopOrderReqDto.setCostCenter(Optional.ofNullable(dgShopOrderReqDto.getCostCenter()).orElse(dto.getPerformOrderExtensionDto().getCostCenter()));
        dgShopOrderReqDto.setCostCenterName(Optional.ofNullable(dgShopOrderReqDto.getCostCenterName()).orElse(dto.getPerformOrderExtensionDto().getCostCenterName()));
        dgShopOrderReqDto.setEmployeeId(Optional.ofNullable(dgShopOrderReqDto.getEmployeeId()).orElse(dto.getPerformOrderExtensionDto().getEmployeeId()));
        dgShopOrderReqDto.setEmployeeNo(Optional.ofNullable(dgShopOrderReqDto.getEmployeeNo()).orElse(dto.getPerformOrderExtensionDto().getEmployeeNo()));
        dgShopOrderReqDto.setEmployeeName(Optional.ofNullable(dgShopOrderReqDto.getEmployeeName()).orElse(dto.getPerformOrderExtensionDto().getEmployeeName()));
        dgShopOrderReqDto.setBizDate(Optional.ofNullable(dgShopOrderReqDto.getBizDate()).orElse(dto.getBizDate()));
        dgShopOrderReqDto.setShippingType(Optional.ofNullable(dgShopOrderReqDto.getShippingType()).orElse(dto.getShippingType()));
        dgShopOrderReqDto.setHsEnterpriseId(Optional.ofNullable(dgShopOrderReqDto.getHsEnterpriseId()).orElse(dto.getPerformOrderSnapshotDto().getHsEnterpriseId()));
        dgShopOrderReqDto.setHsEnterpriseCode(Optional.ofNullable(dgShopOrderReqDto.getHsEnterpriseCode()).orElse(dto.getPerformOrderSnapshotDto().getHsEnterpriseCode()));
        dgShopOrderReqDto.setHsEnterpriseName(Optional.ofNullable(dgShopOrderReqDto.getHsEnterpriseName()).orElse(dto.getPerformOrderSnapshotDto().getHsEnterpriseName()));
        dgShopOrderReqDto.setReceivingStoreId(Optional.ofNullable(dgShopOrderReqDto.getReceivingStoreId()).orElse(dto.getPerformOrderExtensionDto().getReceivingStoreId()));
        dgShopOrderReqDto.setReceivingStoreCode(Optional.ofNullable(dgShopOrderReqDto.getReceivingStoreCode()).orElse(dto.getPerformOrderExtensionDto().getReceivingStoreCode()));
        dgShopOrderReqDto.setReceivingStoreName(Optional.ofNullable(dgShopOrderReqDto.getReceivingStoreName()).orElse(dto.getPerformOrderExtensionDto().getReceivingStoreName()));
        dgShopOrderReqDto.setChannelWarehouseId(Optional.ofNullable(dgShopOrderReqDto.getChannelWarehouseId()).orElse(dto.getPerformOrderSnapshotDto().getChannelWarehouseId()));
        dgShopOrderReqDto.setChannelWarehouseCode(Optional.ofNullable(dgShopOrderReqDto.getChannelWarehouseCode()).orElse(dto.getPerformOrderSnapshotDto().getChannelWarehouseCode()));
        dgShopOrderReqDto.setChannelWarehouseName(Optional.ofNullable(dgShopOrderReqDto.getChannelWarehouseName()).orElse(dto.getPerformOrderSnapshotDto().getChannelWarehouseName()));
        dgShopOrderReqDto.setExtension(dto.getPerformOrderExtensionDto().getExtension());
        String extension = dto.getPerformOrderExtensionDto().getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension) && (shoutVirtualWarehouseList = (jsonObject = JSON.parseObject((String)extension)).get((Object)"shoutVirtualWarehouseList")) != null) {
            dgShopOrderReqDto.setShoutVirtualWarehouseList(JSON.parseArray((String)shoutVirtualWarehouseList.toString(), DgOrderWarehouseReqDto.class));
        }
        log.info("\u91cd\u65b0\u8ba1\u7b97\u8ba2\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)req));
        DgOrderResultRespDto dgOrderResultRespDto = this.submitChannelOrderV2(req);
        DgPerformOrderRespDto performOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(dto.getId());
        BeanUtil.copyProperties((Object)performOrderRespDto, (Object)dto, (String[])new String[0]);
        return new RestResponse((Object)dgOrderResultRespDto);
    }

    @Override
    public RestResponse<Void> releaseChannelInventory(DgPerformOrderRespDto dto) {
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(dto.getSaleOrderNo());
        releasePreemptParam.setSourceType(dto.getOrderType());
        releasePreemptParam.setIsErrorForNotFoundPreempt(Boolean.FALSE);
        log.info("[\u91ca\u653e\u5e93\u5b58\u5165\u53c2]\uff1a{}", JSON.toJSON((Object)releasePreemptParam));
        RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionShopApiProxy.releasePreempt(releasePreemptParam));
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageSubmitOrder(DgPerformOrderRespDto dto, DgCustomPackageOrderReqDto req) {
        DgOrderReqDto orderReqDto = this.converOrderReqDto(req, dto);
        orderReqDto.setOrderStatus(DgF2BOrderStatus.WAIT_CS_AUDIT.getCode());
        DgOrderResultRespDto dgOrderResultRespDto = this.submitChannelOrderV2(orderReqDto);
        Long orderId = ((DgShopOrderResultRespDto)dgOrderResultRespDto.getShopOrderResultRespDtos().stream().findFirst().get()).getOrderId();
        if (orderId != null) {
            DgPerformOrderRespDto dgPerformOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
            BeanUtil.copyProperties((Object)dgPerformOrderRespDto, (Object)dto, (String[])new String[0]);
        }
        return new RestResponse((Object)dgOrderResultRespDto);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageSaveOrder(DgPerformOrderRespDto dto, DgCustomPackageOrderReqDto req) {
        DgOrderReqDto orderReqDto = this.converOrderReqDto(req, dto);
        orderReqDto.setOrderStatus(DgF2BOrderStatus.WAIT_CHECK.getCode());
        DgOrderResultRespDto dgOrderResultRespDto = this.saveChannelOrderV2(orderReqDto);
        Long orderId = ((DgShopOrderResultRespDto)dgOrderResultRespDto.getShopOrderResultRespDtos().stream().findFirst().get()).getOrderId();
        if (orderId != null) {
            DgPerformOrderRespDto dgPerformOrderRespDto = this.omsOrderInfoQueryDomain.queryDtoById(orderId);
            BeanUtil.copyProperties((Object)dgPerformOrderRespDto, (Object)dto, (String[])new String[0]);
        }
        return new RestResponse((Object)dgOrderResultRespDto);
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageModifyOrder(DgPerformOrderRespDto dto, DgCustomPackageOrderReqDto req) {
        DgOrderReqDto orderReqDto = this.converOrderReqDto(req, dto);
        return new RestResponse((Object)this.saveChannelOrderV2(orderReqDto));
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageCheckOrder(DgPerformOrderRespDto dto, DgCustomPackageOrderReqDto req) {
        DgOrderReqDto orderReqDto = this.converOrderReqDto(req, dto);
        return new RestResponse((Object)this.submitChannelOrderV2(orderReqDto));
    }

    @Override
    public RestResponse<DgOrderResultRespDto> customPackageRecalculateOrder(DgPerformOrderRespDto dto, DgCustomPackageOrderReqDto req) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)req.getOrderAddrReqDtos()), (String)"\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List<DgPerformOrderAddrItemDto> performOrderAddrItemDtos = this.dgPerformOrderAddrItemService.queryByOrderId(dto.getId());
        Map addrItemRelMap = performOrderAddrItemDtos.stream().collect(Collectors.groupingBy(DgPerformOrderAddrItemDto::getOrderAddrId, Collectors.toMap(DgPerformOrderAddrItemDto::getOrderItemId, Function.identity(), (e1, e2) -> e1)));
        req.setProductionLotNumber(Optional.ofNullable(req.getProductionLotNumber()).orElse(dto.getPerformOrderExtensionDto().getProductionLotNumber()));
        for (DgCustomPackageOrderAddrReqDto orderAddrReqDto : req.getOrderAddrReqDtos()) {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)orderAddrReqDto.getItemList()), (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            Map addrMap = addrItemRelMap.get(orderAddrReqDto.getId());
            for (OrderPreviewItemReqDto orderPreviewItemReqDto : orderAddrReqDto.getItemList()) {
                BigDecimal placeItemNum = orderPreviewItemReqDto.getItemNum();
                if (addrMap != null) {
                    placeItemNum = Optional.ofNullable(addrMap.get(orderPreviewItemReqDto.getSkuId())).map(DgPerformOrderAddrItemDto::getPlaceItemNum).orElse(placeItemNum);
                }
                orderPreviewItemReqDto.setPlaceItemNum(placeItemNum);
            }
        }
        DgOrderReqDto orderReqDto = this.converOrderReqDto(req, dto);
        for (DgShopOrderReqDto dgShopOrderReqDto : orderReqDto.getShopOrderReqDtoList()) {
            for (DgPerformOrderAddrItemDto addrItemDto : dgShopOrderReqDto.getAddrItemDtos()) {
                Map addrItemDtoMap = addrItemRelMap.getOrDefault(addrItemDto.getOrderAddrId(), Maps.newHashMap());
                DgPerformOrderAddrItemDto oldAddrItemDto = (DgPerformOrderAddrItemDto)addrItemDtoMap.get(addrItemDto.getOrderItemId());
                if (oldAddrItemDto == null) continue;
                addrItemDto.setStockoutNum(oldAddrItemDto.getStockoutNum());
                addrItemDto.setFulfillmentedNum(oldAddrItemDto.getFulfillmentedNum());
                addrItemDto.setDeliveryReformNum(oldAddrItemDto.getDeliveryReformNum());
                addrItemDto.setProductionReformNum(oldAddrItemDto.getProductionReformNum());
                addrItemDto.setSpotGoodsNum(oldAddrItemDto.getSpotGoodsNum());
            }
        }
        return new RestResponse((Object)this.submitChannelOrderV2(orderReqDto));
    }

    @Override
    public List<DgInventoryPreemptionSupplyDto> queryPreemptInventoryResult(DgPerformOrderRespDto dto) {
        DgInventoryPreemptionSupplyPageReqDto pageReqDto = new DgInventoryPreemptionSupplyPageReqDto();
        pageReqDto.setSourceNo(dto.getSaleOrderNo());
        pageReqDto.setValid("enable");
        pageReqDto.setPageNum(Integer.valueOf(1));
        pageReqDto.setPageSize(Integer.valueOf(1000));
        log.info("\u67e5\u8be2\u9884\u5360\u6d41\u6c34\uff1a{}", JSON.toJSON((Object)pageReqDto));
        PageInfo preemptionSupplyDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionSupplyApiProxy.page(pageReqDto));
        return Optional.ofNullable(preemptionSupplyDtoPageInfo).map(PageSerializable::getList).orElse(Lists.newArrayList());
    }

    @Override
    public Boolean checkPreemptInventoryResult(DgPerformOrderRespDto dto, List<DgInventoryPreemptionSupplyDto> req) {
        if (CollectionUtils.isEmpty(req)) {
            return false;
        }
        Boolean flag = Boolean.FALSE;
        List orderLineDtos = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(dto.getId());
        Map orderLineDtoMap = orderLineDtos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        Map<Long, List<DgInventoryPreemptionSupplyDto>> group = req.stream().collect(Collectors.groupingBy(DgInventoryPreemptionSupplyDto::getPreOrderItemId));
        for (Map.Entry<Long, List<DgInventoryPreemptionSupplyDto>> entry : group.entrySet()) {
            DgPerformOrderLineDto orderLineDto = (DgPerformOrderLineDto)orderLineDtoMap.get(entry.getKey());
            BigDecimal itemBasicNum = orderLineDto.getBasicNum();
            BigDecimal itemNum = orderLineDto.getItemNum();
            BigDecimal rate = itemNum.divide(itemBasicNum, 2, RoundingMode.HALF_UP);
            for (DgInventoryPreemptionSupplyDto preemptionSupplyDto : entry.getValue()) {
                preemptionSupplyDto.setPreemptItemNum(preemptionSupplyDto.getPreemptNum().multiply(rate));
                preemptionSupplyDto.setLessItemNum(Optional.ofNullable(preemptionSupplyDto.getLessNum()).orElse(BigDecimal.ZERO).multiply(rate));
                preemptionSupplyDto.setSaleUnitToBasicRate(rate);
            }
            BigDecimal actualPreemptNum = entry.getValue().stream().map(supplyDto -> supplyDto.getPreemptNum().subtract(supplyDto.getLessNum())).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (itemBasicNum.compareTo(actualPreemptNum) <= 0) continue;
            flag = Boolean.TRUE;
        }
        return flag;
    }

    @Override
    public TransferGoodsOrderExtDto updateOrderLessNum(DgPerformOrderRespDto dto, List<DgInventoryPreemptionSupplyDto> req) {
        TransferGoodsOrderExtDto transferGoodsOrderExtDto = new TransferGoodsOrderExtDto();
        ArrayList transferGoodsOrderItems = Lists.newArrayList();
        List<DgPerformOrderAddrItemDto> performOrderAddrItemDtos = this.dgPerformOrderAddrItemService.queryByOrderId(dto.getId());
        Map<Long, BigDecimal> preemptNumMap = req.stream().collect(Collectors.groupingBy(DgInventoryPreemptionSupplyDto::getPreOrderItemId, Collectors.reducing(BigDecimal.ZERO, preemptionSupplyDto -> preemptionSupplyDto.getPreemptItemNum().subtract(preemptionSupplyDto.getLessItemNum()), BigDecimal::add)));
        Map<Long, BigDecimal> rateMap = req.stream().collect(Collectors.toMap(DgInventoryPreemptionSupplyDto::getPreOrderItemId, DgInventoryPreemptionSupplyDto::getSaleUnitToBasicRate, (e1, e2) -> e1));
        for (DgPerformOrderAddrItemDto addrItemDto : performOrderAddrItemDtos) {
            BigDecimal rate = rateMap.getOrDefault(addrItemDto.getOrderItemId(), BigDecimal.ONE);
            BigDecimal preemptItemNum = preemptNumMap.getOrDefault(addrItemDto.getOrderItemId(), BigDecimal.ZERO);
            AssertUtils.isTrue((preemptItemNum.compareTo(addrItemDto.getItemNum()) <= 0 ? 1 : 0) != 0, (String)"\u9884\u5360\u6570\u91cf\u5927\u4e8e\u8ba2\u5355\u884c\u9700\u6c42\u6570\u91cf");
            DgPerformOrderAddrItemEo addrItemEo = new DgPerformOrderAddrItemEo();
            addrItemEo.setStockoutNum(addrItemDto.getItemNum().subtract(preemptItemNum));
            addrItemEo.setId(addrItemDto.getId());
            addrItemEo.setSpotGoodsNum(preemptItemNum);
            this.dgPerformOrderAddrItemService.updateSelective(addrItemEo);
            if (addrItemEo.getStockoutNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            TransferGoodsOrderDetailDto itemDetailDto = new TransferGoodsOrderDetailDto();
            itemDetailDto.setSkuCode(addrItemDto.getSkuCode());
            itemDetailDto.setQuantity(addrItemEo.getStockoutNum().divide(rate, 2, RoundingMode.HALF_UP));
            transferGoodsOrderItems.add(itemDetailDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)transferGoodsOrderItems)) {
            SupplyWarehouseSourcingConfigurePageReqDto reqDto = new SupplyWarehouseSourcingConfigurePageReqDto();
            reqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
            List configureDtos = (List)RestResponseHelper.extractData((RestResponse)this.supplyWarehouseSourcingConfigureApiProxy.list(reqDto));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)configureDtos), (String)"\u4f9b\u8d27\u4ed3\u5bfb\u6e90\u914d\u7f6e\u4e0d\u5b58\u5728");
            SupplyWarehouseSourcingConfigureDto dgVirtualWarehouseDto = (SupplyWarehouseSourcingConfigureDto)configureDtos.get(0);
            transferGoodsOrderExtDto.setCommitType("COMMIT");
            transferGoodsOrderExtDto.setPreOrderNo(dto.getSaleOrderNo());
            transferGoodsOrderExtDto.setOrderSource(Integer.valueOf(1));
            transferGoodsOrderExtDto.setBusinessType("channel_transfer_goods");
            transferGoodsOrderExtDto.setWarehouseCode(dgVirtualWarehouseDto.getChannelDefaultWarehouseCode());
            transferGoodsOrderExtDto.setWarehouseName(dgVirtualWarehouseDto.getChannelDefaultWarehouseName());
            transferGoodsOrderExtDto.setOrderDetail((List)transferGoodsOrderItems);
        }
        return transferGoodsOrderExtDto;
    }

    @Override
    public Boolean createTransferGoodsOrder(DgPerformOrderRespDto dto, TransferGoodsOrderExtDto transferGoodsOrderExtDto) {
        log.info("\u521b\u5efa\u501f\u8d27\u5355\u5165\u53c2\u6570\uff1a{}", JSON.toJSON((Object)transferGoodsOrderExtDto));
        Boolean flag = Boolean.TRUE;
        if (CollectionUtils.isNotEmpty((Collection)transferGoodsOrderExtDto.getOrderDetail())) {
            try {
                ArrayList list = Lists.newArrayList();
                Map<String, List<TransferGoodsOrderDetailDto>> group = transferGoodsOrderExtDto.getOrderDetail().stream().collect(Collectors.groupingBy(TransferGoodsOrderDetailDto::getSkuCode));
                for (Map.Entry<String, List<TransferGoodsOrderDetailDto>> entry : group.entrySet()) {
                    TransferGoodsOrderDetailDto transferGoodsOrderDetailDto = entry.getValue().get(0);
                    transferGoodsOrderDetailDto.setQuantity(entry.getValue().stream().map(TransferGoodsOrderDetailDto::getQuantity).collect(Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)));
                    list.add(transferGoodsOrderDetailDto);
                }
                transferGoodsOrderExtDto.setOrderDetail((List)list);
                RestResponseHelper.extractData((RestResponse)this.transferGoodsOrderApiProxy.insert(transferGoodsOrderExtDto));
            }
            catch (Exception e) {
                flag = Boolean.FALSE;
                log.error("\u521b\u5efa\u501f\u8d27\u5355\u5931\u8d25\uff1a{}", JSON.toJSON((Object)e.getMessage()));
                e.printStackTrace();
            }
        }
        return flag;
    }

    @Override
    public RestResponse<Void> customOrderPreemptInventory(DgPerformOrderRespDto dto) {
        PreemptExtDto preemptExtDto = new PreemptExtDto();
        ArrayList preemptExtDtos = Lists.newArrayList();
        ArrayList shoutVirtualWarehouseCodeList = Lists.newArrayList();
        List itemList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(dto.getId());
        AssertUtils.notEmpty((Collection)itemList, (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        SupplyWarehouseSourcingConfigureDto dgVirtualWarehouseDto = null;
        if (CustomOrderTypeEnum.CUSTOM_ORDER_TYPE_LIST.contains(dto.getOrderType())) {
            SupplyWarehouseSourcingConfigurePageReqDto reqDto = new SupplyWarehouseSourcingConfigurePageReqDto();
            reqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
            List configureDtos = (List)RestResponseHelper.extractData((RestResponse)this.supplyWarehouseSourcingConfigureApiProxy.list(reqDto));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)configureDtos), (String)"\u4f9b\u8d27\u4ed3\u5bfb\u6e90\u914d\u7f6e\u4e0d\u5b58\u5728");
            dgVirtualWarehouseDto = (SupplyWarehouseSourcingConfigureDto)configureDtos.get(0);
            shoutVirtualWarehouseCodeList.add(dgVirtualWarehouseDto.getRecodingSupplyWarehouseCode());
            if (CustomOrderTypeEnum.CHANGE_DELIVERY_ORDER.getType().equals(dto.getOrderType())) {
                shoutVirtualWarehouseCodeList.add(dgVirtualWarehouseDto.getChannelDefaultWarehouseCode());
            } else if (CustomOrderTypeEnum.STOCK_REFORM_ORDER.getType().equals(dto.getOrderType())) {
                preemptExtDto.setValidChannelNegative(Boolean.FALSE);
            }
        }
        DgPerformOrderSnapshotDto performOrderSnapshotDto = dto.getPerformOrderSnapshotDto();
        preemptExtDto.setHasRecordForError(Boolean.TRUE);
        preemptExtDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
        preemptExtDto.setSourceNo(dto.getSaleOrderNo());
        preemptExtDto.setSourceType(CsInventorySourceTypeEnum.OUT_SALE_PREEMPT.getCode());
        preemptExtDto.setValidNegative(Boolean.FALSE);
        preemptExtDto.setPreemptSupply(Boolean.TRUE);
        preemptExtDto.setPreemptWarehouseCode(performOrderSnapshotDto.getChannelWarehouseCode());
        preemptExtDto.setIsShoutVirtualWarehouse(Boolean.TRUE);
        preemptExtDto.setShoutVirtualWarehouseCodeList((List)shoutVirtualWarehouseCodeList);
        List operationDetailDtoList = itemList.stream().map(itemReqDto -> {
            OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
            inventoryOperateCargoReqDto.setSkuCode(itemReqDto.getSkuCode());
            inventoryOperateCargoReqDto.setNum(itemReqDto.getBasicNum());
            inventoryOperateCargoReqDto.setPreOrderItemId(itemReqDto.getId());
            inventoryOperateCargoReqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
            inventoryOperateCargoReqDto.setValidNegative(Boolean.FALSE);
            inventoryOperateCargoReqDto.setWarehouseCode(performOrderSnapshotDto.getChannelWarehouseCode());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        preemptExtDto.setDetails(operationDetailDtoList);
        preemptExtDtos.add(preemptExtDto);
        try {
            log.info("[\u9884\u5360\u6e20\u9053\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptExtDtos));
            RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionShopApiProxy.preemptByBatch((List)preemptExtDtos));
        }
        catch (Exception e) {
            log.error("[\u9884\u5360\u6e20\u9053\u4ed3]\u5f02\u5e38\uff1a", (Throwable)e);
            e.printStackTrace();
            throw new BizException("\u9884\u5360\u5e93\u5b58\u5931\u8d25\uff0c" + e.getMessage());
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> modifyOrder(DgPerformOrderRespDto dto, DgOrderReqDto dgOrderReqDto) {
        dgOrderReqDto.setNeedFeeThrow(false);
        dgOrderReqDto.getShopOrderReqDtoList().forEach(dgShopOrderReqDto -> {
            dgShopOrderReqDto.setSaleOrderNo(dto.getSaleOrderNo());
            dgShopOrderReqDto.setDgPerformOrderPayReqDto(null);
            dgShopOrderReqDto.setActivityList((List)Lists.newArrayList());
            dgShopOrderReqDto.setMaterialList((List)Lists.newArrayList());
        });
        this.saveChannelOrderV2(dgOrderReqDto);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> createCancelOrderTask(DgPerformOrderRespDto dto) {
        Date expiredTime;
        DgOrderConfigurationRespDto config = this.dgOrderConfigurationService.queryDetailByShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
        if (config != null && (expiredTime = OrderExpiredUtil.calcOrderCancleTime(config)) != null) {
            DgBizPerformOrderReqDto dgBizPerformOrderReqDto = new DgBizPerformOrderReqDto();
            dgBizPerformOrderReqDto.setId(dto.getId());
            dgBizPerformOrderReqDto.setCloseTime(expiredTime);
            this.omsOrderInfoDomain.update((DgPerformOrderReqDto)dgBizPerformOrderReqDto);
            this.scheduleService.addOrderTask(dto.getSaleOrderNo(), TradeSchedulerEnum.F2B_AUTO_CANCEL_ORDER, expiredTime, -1L, -1L);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> createAutoConfirmTask(DgPerformOrderRespDto dto) {
        DgOrderConfigurationRespDto config = this.dgOrderConfigurationService.queryDetailByShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
        if (config != null) {
            Date confirmTIme = OrderExpiredUtil.calcOrderAutoConfirmTime(config);
            if (confirmTIme != null) {
                this.scheduleService.addOrderTask(dto.getSaleOrderNo(), TradeSchedulerEnum.F2B_AUTO_CONFIRM_ORDER, confirmTIme, -1L, -1L);
            } else {
                log.info("\u5e97\u94fa{}\u8ba2\u5355\u914d\u7f6e\u5b57\u6bb5\u7b7e\u6536\u65f6\u95f4\u672a\u5927\u4e8e\u5f53\u524d\u65f6\u95f4", (Object)dto.getPerformOrderSnapshotDto().getShopCode());
            }
        } else {
            log.info("\u5e97\u94fa\u672a\u914d\u7f6e\u8ba2\u5355\u914d\u7f6e\u4fe1\u606f={}", (Object)dto.getPerformOrderSnapshotDto().getShopCode());
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> reSetOrderSteps(DgPerformOrderRespDto dto) {
        ArrayList orderStatusLogRespDtos = com.aliyun.openservices.shade.com.google.common.collect.Lists.newArrayList();
        DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
        orderStatusLogRespDto.setOrderStatus(DgF2BOrderStatus.WAIT_PAY.getCode());
        orderStatusLogRespDto.setOptDate(new Date());
        orderStatusLogRespDto.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"system"));
        orderStatusLogRespDtos.add(orderStatusLogRespDto);
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = new DgBizPerformOrderReqDto();
        dgBizPerformOrderReqDto.setId(dto.getId());
        dgBizPerformOrderReqDto.setOrderSteps(JSON.toJSONString((Object)orderStatusLogRespDtos));
        this.omsOrderInfoDomain.update((DgPerformOrderReqDto)dgBizPerformOrderReqDto);
        return RestResponse.VOID;
    }

    private DgOrderReqDto converOrderReqDto(DgCustomPackageOrderReqDto req, DgPerformOrderRespDto dto) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)req.getOrderAddrReqDtos()), (String)"\u5730\u5740\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        CustomerDiscountConfigDto discountConfigDto = null;
        if (req.getHandmadeDiscount() != null) {
            AssertUtils.notNull((Object)req.getCustomerDiscountId(), (String)"\u5ba2\u6237\u6298\u6263\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a");
            discountConfigDto = (CustomerDiscountConfigDto)RestResponseHelper.extractData((RestResponse)this.customerDiscountConfigApiProxy.get(req.getCustomerDiscountId()));
            AssertUtils.isTrue((discountConfigDto != null && discountConfigDto.getCustomerId().equals(req.getCustomerId()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u6298\u6263\u914d\u7f6e\u4e0d\u5b58\u5728");
            req.setHandmadeDiscount(discountConfigDto.getDiscount());
        }
        AtomicLong addrLineAtom = new AtomicLong(0L);
        AtomicLong itemLineAtom = new AtomicLong(0L);
        ArrayList addrItemDtos = Lists.newArrayList();
        ArrayList itemReqDtoList = Lists.newArrayList();
        for (DgCustomPackageOrderAddrReqDto orderAddrReqDto : req.getOrderAddrReqDtos()) {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)orderAddrReqDto.getItemList()), (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            orderAddrReqDto.setAddrLineNo(Optional.ofNullable(orderAddrReqDto.getAddrLineNo()).orElse(addrLineAtom.incrementAndGet()));
            for (OrderPreviewItemReqDto orderPreviewItemReqDto : orderAddrReqDto.getItemList()) {
                AssertUtils.notNull((Object)orderPreviewItemReqDto.getOrderItemUnit(), (String)"\u4e0b\u5355\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
                orderPreviewItemReqDto.setHandmadeDiscount((BigDecimal)Optional.ofNullable(discountConfigDto).map(CustomerDiscountConfigDto::getDiscount).orElse(null));
                orderPreviewItemReqDto.setItemLineNo(Optional.ofNullable(orderPreviewItemReqDto.getItemLineNo()).orElse(itemLineAtom.incrementAndGet()));
                itemReqDtoList.add(orderPreviewItemReqDto);
                DgPerformOrderAddrItemDto dgPerformOrderAddrItemDto = new DgPerformOrderAddrItemDto();
                dgPerformOrderAddrItemDto.setOrderAddrId(orderAddrReqDto.getAddrLineNo());
                dgPerformOrderAddrItemDto.setOrderItemId(orderPreviewItemReqDto.getItemLineNo());
                dgPerformOrderAddrItemDto.setSkuId(orderPreviewItemReqDto.getSkuId());
                dgPerformOrderAddrItemDto.setPlaceItemNum(orderPreviewItemReqDto.getItemNum());
                dgPerformOrderAddrItemDto.setItemNum(orderPreviewItemReqDto.getItemNum());
                dgPerformOrderAddrItemDto.setPurchaseOrderNo(orderAddrReqDto.getPurchaseOrderNo());
                dgPerformOrderAddrItemDto.setStocksCode(orderPreviewItemReqDto.getStocksCode());
                addrItemDtos.add(dgPerformOrderAddrItemDto);
            }
        }
        DgOrderReqDto orderReqDto = (DgOrderReqDto)BeanUtil.copyProperties((Object)req, DgOrderReqDto.class, (String[])new String[0]);
        DgShopOrderReqDto dgShopOrderReqDto = (DgShopOrderReqDto)BeanUtil.copyProperties((Object)req, DgShopOrderReqDto.class, (String[])new String[0]);
        dgShopOrderReqDto.setItemList((List)itemReqDtoList);
        dgShopOrderReqDto.setAddrItemDtos((List)addrItemDtos);
        dgShopOrderReqDto.setSaleOrderNo(dto.getSaleOrderNo());
        dgShopOrderReqDto.setCustomerDiscountId(req.getCustomerDiscountId());
        dgShopOrderReqDto.setHandmadeDiscount(req.getHandmadeDiscount());
        dgShopOrderReqDto.setPackageRemark(req.getPackageRemark());
        dgShopOrderReqDto.setDirectOrder(req.getDirectOrder());
        dgShopOrderReqDto.setCustomerBatch(req.getCustomerBatch());
        dgShopOrderReqDto.setProductionLotNumber(req.getProductionLotNumber());
        dgShopOrderReqDto.setAttachmentFileList(req.getAttachmentFileList());
        orderReqDto.setShopOrderReqDtoList((List)Lists.newArrayList((Object[])new DgShopOrderReqDto[]{dgShopOrderReqDto}));
        orderReqDto.setValidNegative(Boolean.FALSE);
        orderReqDto.setIsShoutVirtualWarehouse(Boolean.TRUE);
        orderReqDto.setIsVerifyChannelInventory(req.getIsVerifyChannelInventory());
        orderReqDto.setIsShoutVirtualWarehouse(req.getIsVerifyChannelInventory());
        return orderReqDto;
    }
}

