/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.trade.api.constants.EnableEnum;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicalWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.share.OperationDetailDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.proxy.order.ITransferOrderApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.warehouse.ILogicWarehouseApiProxy;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.proxy.inventory.IDgPhysicsWarehouseApiProxy;
import com.yunxi.dg.base.center.share.constants.ShopWarehouseEnum;
import com.yunxi.dg.base.center.share.dto.calc.PreemptExtDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventoryPreemptionSupplyDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyDto;
import com.yunxi.dg.base.center.share.dto.entity.DgInventorySupplyStrategyQueryReqDto;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualWarehouseDto;
import com.yunxi.dg.base.center.share.dto.entity.SupplyWarehouseSourcingConfigureDto;
import com.yunxi.dg.base.center.share.dto.entity.SupplyWarehouseSourcingConfigurePageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderDetailDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderDetailPageReqDto;
import com.yunxi.dg.base.center.share.dto.entity.TransferGoodsOrderExtDto;
import com.yunxi.dg.base.center.share.proxy.entity.ISupplyWarehouseSourcingConfigureApiProxy;
import com.yunxi.dg.base.center.share.proxy.entity.ITransferGoodsOrderApiProxy;
import com.yunxi.dg.base.center.share.proxy.entity.ITransferGoodsOrderDetailApiProxy;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgInventoryPreemptionShopApiProxy;
import com.yunxi.dg.base.center.share.proxy.strategy.IDgInventorySupplyStrategyQueryApiProxy;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderCreateAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderFulfillmentAction;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2BSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgOrderSourceModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAttachmentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrItemExtDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAttachmentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOrderLabelRecordReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderAddrReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderAllotInventoryReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderAllotItemInventoryReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderFulfillmentReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.OrderItemFulfillmentReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelBaseRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderLabelRecordRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.OrderAddrFulfillmentRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.OrderFulfillmentRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.OrderItemFulfillmentRespDto;
import com.yunxi.dg.base.center.trade.dto.response.DgPerformOrderLineDetailDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrItemEo;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderAddrItemService;
import com.yunxi.dg.base.center.trade.service.entity.IPayRecordService;
import com.yunxi.dg.base.center.trade.service.oms.channel.IChannelOrderService;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ChannelOrderFulfillmentActionImpl
implements IChannelOrderFulfillmentAction {
    private static final Logger log = LoggerFactory.getLogger(ChannelOrderFulfillmentActionImpl.class);
    @Value(value="${stock_out_logic_warehouse_code}")
    private String outLogicWarehouseCode;
    @Value(value="${stock_in_logic_warehouse_code}")
    private String inLogicWarehouseCode;
    @Value(value="${stock_order_delivery_logic_warehouse}")
    private String stockOrderLogicWarehouse;
    @Value(value="${query_pick_up_order_wait_seconds:2}")
    private Long queryPickUpOrderWatiTime;
    private static final String STOCK_UP = "STOCK_UP";
    private static final String PICK_UP = "PICK_UP";
    @Resource
    private IChannelOrderService channelOrderService;
    @Resource
    private IDgPerformOrderAddrItemService dgPerformOrderAddrItemService;
    @Resource
    private IPayRecordService payRecordService;
    @Resource
    private IDgPerformOrderAttachmentDomain dgPerformOrderAttachmentDomain;
    @Resource
    private IDgPerformOrderAddrItemDomain dgPerformOrderAddrItemDomain;
    @Resource
    private IDgB2BSaleStatemachineApi dgB2BSaleStatemachineApi;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    @Resource
    private ITransferOrderApiProxy transferOrderApiProxy;
    @Resource
    private ISupplyWarehouseSourcingConfigureApiProxy supplyWarehouseSourcingConfigureApiProxy;
    @Resource
    private IDgInventoryPreemptionShopApiProxy dgInventoryPreemptionShopApiProxy;
    @Resource
    private IChannelOrderCreateAction channelOrderCreateAction;
    @Resource
    private ITransferGoodsOrderApiProxy transferGoodsOrderApiProxy;
    @Resource
    private ILogicWarehouseApiProxy logicWarehouseApiProxy;
    @Resource
    private IDgPhysicsWarehouseApiProxy dgPhysicsWarehouseApiProxy;
    @Resource
    private ITransferGoodsOrderDetailApiProxy transferGoodsOrderDetailApiProxy;
    @Resource
    private IDgInventorySupplyStrategyQueryApiProxy dgInventorySupplyStrategyQueryApiProxy;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;

    @Override
    public RestResponse<Void> fulfillment(DgPerformOrderRespDto dto, OrderFulfillmentReqDto req) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)req.getOrderItemFulfillmentReqDtos()), (String)"\u5c65\u7ea6\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        OrderFulfillmentRespDto orderFulfillmentRespDto = this.channelOrderService.queryOrderFulfillmentList(dto.getId());
        List orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(dto.getId());
        dto.setOrderLineList(orderLineDtoList);
        List orderItemLineDtoList = this.performOrderItemLineDomain.queryInfoByOrderId(dto.getId());
        dto.setOrderItemLineList(orderItemLineDtoList);
        Map orderLineMap = orderLineDtoList.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        Map orderItemLineMap = orderItemLineDtoList.stream().collect(Collectors.toMap(DgPerformOrderItemLineDto::getOrderLineId, Function.identity(), (e1, e2) -> e1));
        List dgPerformOrderAddrItemExtDtos = this.dgPerformOrderAddrItemDomain.queryItemAddrInfo(req.getOrderId());
        Map addrMap = dgPerformOrderAddrItemExtDtos.stream().collect(Collectors.toMap(DgPerformOrderAddrItemDto::getOrderAddrId, Function.identity(), (e1, e2) -> e1));
        Map fulfillmentRespDtoMap = orderFulfillmentRespDto.getOrderAddrFulfillmentRespDtos().stream().map(OrderAddrFulfillmentRespDto::getOrderItemFulfillmentRespDtos).flatMap(Collection::stream).collect(Collectors.toMap(OrderItemFulfillmentRespDto::getOrderLineId, Function.identity(), (e1, e2) -> e1));
        HashMap addrOrderLineMap = Maps.newHashMap();
        HashMap addrOrderItemLineMap = Maps.newHashMap();
        for (OrderItemFulfillmentReqDto itemFulfillmentDto : req.getOrderItemFulfillmentReqDtos()) {
            AssertUtils.notNull((Object)itemFulfillmentDto.getOrderLineId(), (String)"\u5c65\u7ea6\u8ba2\u5355\u884cid\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)itemFulfillmentDto.getItemNum(), (String)"\u5c65\u7ea6\u8ba2\u5355\u884c\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            OrderItemFulfillmentRespDto itemFulfillmentRespDto = (OrderItemFulfillmentRespDto)fulfillmentRespDtoMap.get(itemFulfillmentDto.getOrderLineId());
            AssertUtils.notNull((Object)itemFulfillmentRespDto, (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
            AssertUtils.isTrue((itemFulfillmentDto.getItemNum().compareTo(itemFulfillmentRespDto.getWaitFulfillmentNum()) <= 0 ? 1 : 0) != 0, (String)"\u4e0d\u80fd\u8d85\u51fa\u5f85\u5c65\u7ea6\u6570\u91cf");
            BigDecimal fulfillmentedNum = Optional.ofNullable(itemFulfillmentRespDto.getFulfillmentedNum()).orElse(BigDecimal.ZERO);
            BigDecimal newFulfillmentNum = fulfillmentedNum.add(itemFulfillmentDto.getItemNum());
            this.dgPerformOrderAddrItemService.updateFulfillmetNum(itemFulfillmentRespDto.getAddrItemId(), fulfillmentedNum, newFulfillmentNum);
            List addrOrderLineDtos = addrOrderLineMap.getOrDefault(itemFulfillmentRespDto.getOrderAddrId(), Lists.newArrayList());
            DgPerformOrderLineDto oldOrderlineDto = (DgPerformOrderLineDto)orderLineMap.get(itemFulfillmentDto.getOrderLineId());
            if (oldOrderlineDto == null) continue;
            DgPerformOrderLineDto fulfillmentDto = (DgPerformOrderLineDto)BeanUtil.copyProperties((Object)oldOrderlineDto, DgPerformOrderLineDetailDto.class, (String[])new String[0]);
            fulfillmentDto.setItemNum(itemFulfillmentDto.getItemNum());
            List newAmountDtoList = Optional.ofNullable(oldOrderlineDto.getAmountDtoList()).orElse(Lists.newArrayList()).stream().map(lineAmountDto -> {
                DgPerformOrderLineAmountDto newLineAmountDto = (DgPerformOrderLineAmountDto)BeanUtil.copyProperties((Object)lineAmountDto, DgPerformOrderLineAmountDto.class, (String[])new String[0]);
                newLineAmountDto.setAmount(this.calcFulfillmentAmou(lineAmountDto.getAmount(), oldOrderlineDto.getItemNum(), fulfillmentedNum, itemFulfillmentDto.getItemNum()));
                return newLineAmountDto;
            }).collect(Collectors.toList());
            fulfillmentDto.setAmountDtoList(newAmountDtoList);
            addrOrderLineDtos.add(fulfillmentDto);
            addrOrderLineMap.put(itemFulfillmentRespDto.getOrderAddrId(), addrOrderLineDtos);
            List addrOrderItemLineDtos = addrOrderItemLineMap.getOrDefault(itemFulfillmentRespDto.getOrderAddrId(), Lists.newArrayList());
            DgPerformOrderItemLineDto oldOrderItemLineDto = (DgPerformOrderItemLineDto)orderItemLineMap.get(itemFulfillmentDto.getOrderLineId());
            DgPerformOrderItemLineDto fulfillmentOrderItemLineDto = (DgPerformOrderItemLineDto)BeanUtil.copyProperties((Object)oldOrderItemLineDto, DgPerformOrderItemLineDto.class, (String[])new String[0]);
            addrOrderItemLineDtos.add(fulfillmentOrderItemLineDto);
            addrOrderItemLineMap.put(itemFulfillmentRespDto.getOrderAddrId(), addrOrderItemLineDtos);
        }
        LogicalWarehouseRespDto logicWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(this.stockOrderLogicWarehouse));
        AssertUtils.notNull((Object)logicWarehouseRespDto, (String)String.format("\u5907\u8d27\u6539\u6307\u5b9a%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", this.stockOrderLogicWarehouse));
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = this.f2BOrderConverB2bOrder(dto);
        dgBizPerformOrderReqDto.setLogicalWarehouseId(logicWarehouseRespDto.getId());
        dgBizPerformOrderReqDto.setLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
        dgBizPerformOrderReqDto.setLogicalWarehouseName(logicWarehouseRespDto.getWarehouseName());
        dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
        dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().setLogicalWarehouseName(logicWarehouseRespDto.getWarehouseName());
        dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().setDefaultLogicalWarehouseId(logicWarehouseRespDto.getId());
        dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().setDefaultLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
        dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().setDefaultLogicalWarehouseName(logicWarehouseRespDto.getWarehouseName());
        dgBizPerformOrderReqDto.getPerformOrderWarehouseInfoDto().setDeliveryLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
        for (Map.Entry entry : addrOrderLineMap.entrySet()) {
            DgPerformOrderAddrItemExtDto addrItemExtDto = (DgPerformOrderAddrItemExtDto)addrMap.get(entry.getKey());
            DgBizPerformOrderReqDto nOrder = (DgBizPerformOrderReqDto)BeanUtil.copyProperties((Object)dgBizPerformOrderReqDto, DgBizPerformOrderReqDto.class, (String[])new String[0]);
            this.converItemData((List)entry.getValue(), nOrder, logicWarehouseRespDto);
            nOrder.setMainOrderNo(nOrder.getSaleOrderNo());
            nOrder.getPerformOrderExtensionDto().setAddrSaleOrderNo(addrItemExtDto.getAddrSaleOrderNo());
            nOrder.getPerformOrderExtensionDto().setPurchaseOrderNo(addrItemExtDto.getPurchaseOrderNo());
            DgPerformOrderAddrReqDto addrReqDto = (DgPerformOrderAddrReqDto)BeanUtil.copyProperties((Object)addrItemExtDto, DgPerformOrderAddrReqDto.class, (String[])new String[0]);
            addrReqDto.setId(addrItemExtDto.getOrderAddrId());
            nOrder.setOrderAddrReqDto(addrReqDto);
            nOrder.setOrderLineDetails((List)entry.getValue());
            nOrder.setOrderItemLineDtoList((List)addrOrderItemLineMap.get(entry.getKey()));
            RestResponseHelper.extractData((RestResponse)this.dgB2BSaleStatemachineApi.fulfillment(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), nOrder));
        }
        return RestResponse.VOID;
    }

    @Override
    public Boolean checkAllFulfillment(DgPerformOrderRespDto dto) {
        List dgPerformOrderAddrItemExtDtos = this.dgPerformOrderAddrItemDomain.queryItemAddrInfo(dto.getId());
        return dgPerformOrderAddrItemExtDtos.stream().allMatch(addrItemExtDto -> addrItemExtDto.getItemNum().compareTo(addrItemExtDto.getFulfillmentedNum()) == 0);
    }

    @Override
    public RestResponse<Void> delFulfillmentLabel(DgPerformOrderRespDto dto) {
        this.dgOrderLabelRecordDomain.removeOrderLabelRecordById(dto.getId(), DgOrderLabelEnum.PART_FUlFILLMENT);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> addPartFulfillmentLabel(DgPerformOrderRespDto dto) {
        this.dgOrderLabelRecordDomain.addOrderLabelRecord(dto.getId(), DgOrderLabelEnum.PART_FUlFILLMENT);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> allotInventory(DgPerformOrderRespDto dto, OrderAllotInventoryReqDto req) {
        List<DgPerformOrderAddrItemDto> performOrderAddrItemDtos = this.dgPerformOrderAddrItemService.queryByOrderId(dto.getId());
        Map addrItemDtoMap = performOrderAddrItemDtos.stream().collect(Collectors.toMap(DgPerformOrderAddrItemDto::getOrderItemId, Function.identity(), (e1, e2) -> e1));
        for (OrderAllotItemInventoryReqDto allotDto : req.getOrderAllotItemInventoryReqDtos()) {
            BigDecimal allotDeliveryNum;
            BigDecimal allotProductionNum = Optional.ofNullable(allotDto.getProductionReformNum()).orElse(BigDecimal.ZERO);
            AssertUtils.isTrue((allotProductionNum.add(allotDeliveryNum = Optional.ofNullable(allotDto.getDeliveryReformNum()).orElse(BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5206\u914d\u7684\u63d0\u8d27\u6539\u3001\u751f\u4ea7\u6539\u6570\u91cf\u5fc5\u987b\u6709\u4e00\u4e2a\u5927\u4e8e0");
            DgPerformOrderAddrItemDto addrItemDto = (DgPerformOrderAddrItemDto)addrItemDtoMap.get(allotDto.getOrderLineId());
            AssertUtils.notNull((Object)addrItemDto, (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
            UpdateWrapper updateWrapper = new UpdateWrapper();
            ((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)addrItemDto.getId())).eq((Object)"delivery_reform_num", (Object)addrItemDto.getDeliveryReformNum())).eq((Object)"production_reform_num", (Object)addrItemDto.getProductionReformNum())).eq((Object)"spot_goods_num", (Object)addrItemDto.getSpotGoodsNum());
            BigDecimal deliveryReformNum = addrItemDto.getDeliveryReformNum() == null || addrItemDto.getDeliveryReformNum().compareTo(BigDecimal.ZERO) == 0 ? Optional.ofNullable(allotDto.getDeliveryReformNum()).orElse(BigDecimal.ZERO) : addrItemDto.getDeliveryReformNum();
            BigDecimal productionReformNum = addrItemDto.getProductionReformNum() == null || addrItemDto.getProductionReformNum().compareTo(BigDecimal.ZERO) == 0 ? Optional.ofNullable(allotDto.getProductionReformNum()).orElse(BigDecimal.ZERO) : addrItemDto.getProductionReformNum();
            BigDecimal totalAllotNum = deliveryReformNum.add(productionReformNum);
            AssertUtils.isTrue((totalAllotNum.compareTo(addrItemDto.getStockoutNum()) <= 0 ? 1 : 0) != 0, (String)"\u5206\u914d\u5e93\u5b58\u603b\u6570\u4e0d\u80fd\u5927\u4e8e\u7f3a\u8d27\u91cf");
            DgPerformOrderAddrItemEo updateEo = new DgPerformOrderAddrItemEo();
            updateEo.setDeliveryReformNum(deliveryReformNum);
            updateEo.setProductionReformNum(productionReformNum);
            this.dgPerformOrderAddrItemService.updateInventoryNum(updateEo, (UpdateWrapper<DgPerformOrderAddrItemEo>)updateWrapper);
            allotDto.setOriginalSkuCode(addrItemDto.getOriginalSkuCode());
        }
        return RestResponse.VOID;
    }

    @Override
    public List<DgOrderLabelEnum> createTransferOrder(DgPerformOrderRespDto dto, OrderAllotInventoryReqDto req) {
        TransferOrderRespDto deliveryTrOrder;
        List orderLines = this.omsOrderLineBizQueryDomain.queryOrderLineInfoByOrderId(dto.getId());
        Map<Long, DgPerformOrderLineDto> orderLineMap = orderLines.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity(), (e1, e2) -> e1));
        ArrayList orderLabelEnums = Lists.newArrayList();
        DgOrderLabelRecordReqDto orderLabelRecordReqDto = new DgOrderLabelRecordReqDto();
        orderLabelRecordReqDto.setOrderId(dto.getId());
        orderLabelRecordReqDto.setLabelCodes(Arrays.asList(DgOrderLabelEnum.DELIVERY_TRANSFER_ORDER.getCode(), DgOrderLabelEnum.CREATE_DELIVERY_TRANSFER_FALI.getCode(), DgOrderLabelEnum.PRODUCTION_TRANSFER_ORDER.getCode(), DgOrderLabelEnum.CREATE_PRODUCTION_TRANSFER_FALI.getCode()));
        List labelRecordRespDtos = this.dgOrderLabelRecordDomain.queryByParam(orderLabelRecordReqDto);
        DgOrderLabelEnum deliveryLabelEnum = null;
        if (!labelRecordRespDtos.stream().anyMatch(label -> Objects.equals(label.getLabelCode(), DgOrderLabelEnum.DELIVERY_TRANSFER_ORDER)) && (deliveryTrOrder = this.createDeliveryTrOrder(dto, req, orderLineMap, labelRecordRespDtos)) != null) {
            try {
                Thread.sleep(1000L * this.queryPickUpOrderWatiTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            TransferGoodsOrderDetailPageReqDto reqDto = new TransferGoodsOrderDetailPageReqDto();
            reqDto.setPreOrderNo(deliveryTrOrder.getTransferOrderNo());
            log.info("\u63d0\u8d27\u6539\u8c03\u8d27\u5355\u660e\u7ec6\u5165\u53c2\u6570\uff1a{}", JSON.toJSON((Object)reqDto));
            PageInfo detailPage = (PageInfo)RestResponseHelper.extractData((RestResponse)this.transferGoodsOrderDetailApiProxy.pageByPreOrderNo(reqDto));
            log.info("\u63d0\u8d27\u6539\u8c03\u8d27\u5355\u660e\u7ec6\uff1a{}", JSON.toJSON((Object)detailPage));
            if (detailPage != null && CollectionUtils.isNotEmpty((Collection)detailPage.getList())) {
                this.updateOrderLessNum(dto, detailPage.getList());
                deliveryLabelEnum = DgOrderLabelEnum.DELIVERY_TRANSFER_ORDER;
            }
        }
        List<DgInventoryPreemptionSupplyDto> dgInventoryPreemptionSupplyDtos = this.preemptInventory(dto, orderLineMap, req);
        DgOrderLabelEnum productLabelEnum = null;
        if (CollectionUtils.isNotEmpty(dgInventoryPreemptionSupplyDtos)) {
            log.info("\u5728\u5236\u5e93\u5b58\u4e0d\u8db3\uff0c\u53d1\u8d77\u751f\u4ea7\u6539\u501f\u8d27");
            productLabelEnum = this.createProductTrOrder(dto, orderLineMap, labelRecordRespDtos, dgInventoryPreemptionSupplyDtos);
        }
        Optional.ofNullable(deliveryLabelEnum).ifPresent(orderLabelEnums::add);
        Optional.ofNullable(productLabelEnum).ifPresent(orderLabelEnums::add);
        return orderLabelEnums;
    }

    public void updateOrderProductLessNum(DgPerformOrderRespDto dto, List<DgInventoryPreemptionSupplyDto> req) {
        List<DgPerformOrderAddrItemDto> performOrderAddrItemDtos = this.dgPerformOrderAddrItemService.queryByOrderId(dto.getId());
        Map addrItemDtoMap = performOrderAddrItemDtos.stream().collect(Collectors.toMap(DgPerformOrderAddrItemDto::getOriginalSkuCode, Function.identity(), (e1, e2) -> e1));
        for (DgInventoryPreemptionSupplyDto goodsOrderDetailDto : req) {
            DgPerformOrderAddrItemDto addrItemDto = (DgPerformOrderAddrItemDto)addrItemDtoMap.get(goodsOrderDetailDto.getSkuCode());
            AssertUtils.notNull((Object)addrItemDto, (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
            BigDecimal lessNum = Optional.ofNullable(goodsOrderDetailDto.getLessNum()).orElse(BigDecimal.ZERO);
            if (lessNum.compareTo(BigDecimal.ZERO) <= 0) continue;
            BigDecimal curStockoutNum = Optional.ofNullable(addrItemDto.getStockoutNum()).orElse(BigDecimal.ZERO);
            BigDecimal productionReformNum = Optional.ofNullable(addrItemDto.getProductionReformNum()).orElse(BigDecimal.ZERO);
            BigDecimal preemptNum = productionReformNum.subtract(lessNum);
            BigDecimal newStockoutNum = curStockoutNum.subtract(preemptNum);
            DgPerformOrderAddrItemEo addrItemEo = new DgPerformOrderAddrItemEo();
            addrItemEo.setStockoutNum(newStockoutNum);
            addrItemEo.setId(addrItemDto.getId());
            this.dgPerformOrderAddrItemService.updateSelective(addrItemEo);
        }
    }

    public void updateOrderLessNum(DgPerformOrderRespDto dto, List<TransferGoodsOrderDetailDto> req) {
        List<DgPerformOrderAddrItemDto> performOrderAddrItemDtos = this.dgPerformOrderAddrItemService.queryByOrderId(dto.getId());
        Map addrItemDtoMap = performOrderAddrItemDtos.stream().collect(Collectors.toMap(DgPerformOrderAddrItemDto::getOriginalSkuCode, Function.identity(), (e1, e2) -> e1));
        for (TransferGoodsOrderDetailDto goodsOrderDetailDto : req) {
            DgPerformOrderAddrItemDto addrItemDto = (DgPerformOrderAddrItemDto)addrItemDtoMap.get(goodsOrderDetailDto.getSkuCode());
            AssertUtils.notNull((Object)addrItemDto, (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
            BigDecimal lessNum = Optional.ofNullable(goodsOrderDetailDto.getQuantity()).orElse(BigDecimal.ZERO);
            BigDecimal curStockoutNum = Optional.ofNullable(addrItemDto.getStockoutNum()).orElse(BigDecimal.ZERO);
            BigDecimal deliveryReformNum = Optional.ofNullable(addrItemDto.getDeliveryReformNum()).orElse(BigDecimal.ZERO);
            BigDecimal preemptNum = deliveryReformNum.subtract(lessNum);
            BigDecimal newStockoutNum = curStockoutNum.subtract(preemptNum);
            DgPerformOrderAddrItemEo addrItemEo = new DgPerformOrderAddrItemEo();
            addrItemEo.setStockoutNum(newStockoutNum);
            addrItemEo.setId(addrItemDto.getId());
            this.dgPerformOrderAddrItemService.updateSelective(addrItemEo);
        }
    }

    private TransferOrderRespDto createDeliveryTrOrder(DgPerformOrderRespDto dto, OrderAllotInventoryReqDto req, Map<Long, DgPerformOrderLineDto> orderLineMap, List<DgOrderLabelRecordRespDto> labelRecordRespDtos) {
        TransferOrderKeyDto transferOrderKeyDto = new TransferOrderKeyDto();
        transferOrderKeyDto.setPreOrderNo(dto.getSaleOrderNo());
        log.info("\u67e5\u8be2\u63d0\u8d27\u6539\u8c03\u62e8\u5355\u5165\u53c2\uff1a{}", JSON.toJSON((Object)transferOrderKeyDto));
        TransferOrderRespDto trfOrderDto = (TransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.detail(transferOrderKeyDto));
        if (trfOrderDto == null || Objects.equals("CANCELLED", trfOrderDto.getOrderStatus()) || !labelRecordRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).anyMatch(labelCode -> Objects.equals(labelCode, DgOrderLabelEnum.CREATE_DELIVERY_TRANSFER_FALI.getCode()))) {
            BigDecimal totalQuantity = BigDecimal.ZERO;
            HashMap detailReqDtoMap = Maps.newHashMap();
            for (OrderAllotItemInventoryReqDto allotItem : req.getOrderAllotItemInventoryReqDtos()) {
                if (allotItem.getDeliveryReformNum() == null || allotItem.getDeliveryReformNum().compareTo(BigDecimal.ZERO) <= 0) continue;
                DgPerformOrderLineDto orderLine = orderLineMap.get(allotItem.getOrderLineId());
                AssertUtils.notNull((Object)orderLine, (String)"\u8ba2\u5355\u884c\u4e0d\u5b58\u5728");
                TransferOrderDetailReqDto detailReqDto = detailReqDtoMap.getOrDefault(allotItem.getOriginalSkuCode(), new TransferOrderDetailReqDto());
                detailReqDto.setQuantity(Optional.ofNullable(detailReqDto.getQuantity()).orElse(BigDecimal.ZERO).add(allotItem.getDeliveryReformNum()));
                detailReqDto.setSpecification(orderLine.getSkuDesc());
                detailReqDto.setBasicUnit(orderLine.getBasicUnit());
                detailReqDto.setBasicUnitName(orderLine.getBasicUnitName());
                detailReqDto.setSkuName(orderLine.getSkuName());
                detailReqDto.setCargoId(orderLine.getItemId());
                detailReqDto.setUnit(orderLine.getOrderItemUnit());
                detailReqDto.setSkuCode(allotItem.getOriginalSkuCode());
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("skuCode", orderLine.getSkuCode());
                map.put("skuName", orderLine.getSkuName());
                detailReqDto.setExtension(JSON.toJSONString(map));
                detailReqDtoMap.put(allotItem.getOriginalSkuCode(), detailReqDto);
                totalQuantity = totalQuantity.add(allotItem.getDeliveryReformNum());
            }
            if (CollectionUtils.isNotEmpty(detailReqDtoMap.values())) {
                LogicalWarehouseRespDto outLogicWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(this.outLogicWarehouseCode));
                AssertUtils.notNull((Object)outLogicWarehouseRespDto, (String)String.format("\u63d0\u8d27\u6539\u8c03\u62e8\u5355\u6307\u5b9a\u8c03\u51fa\u903b%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", this.outLogicWarehouseCode));
                LogicalWarehouseRespDto inLogicWarehouseRespDto = (LogicalWarehouseRespDto)RestResponseHelper.extractData((RestResponse)this.logicWarehouseApiProxy.queryLogicWarehouseByCode(this.inLogicWarehouseCode));
                AssertUtils.notNull((Object)inLogicWarehouseRespDto, (String)String.format("\u63d0\u8d27\u6539\u8c03\u62e8\u5355\u6307\u5b9a\u8c03\u5165\u903b%s\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728", this.inLogicWarehouseCode));
                List dgPhysicsWarehouseDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgPhysicsWarehouseApiProxy.queryByLogicWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{inLogicWarehouseRespDto.getWarehouseCode()})));
                AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dgPhysicsWarehouseDtos), (String)"\u7269\u7406\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
                DgPhysicsWarehouseDto dgPhysicsWarehouseDto = dgPhysicsWarehouseDtos.stream().findFirst().orElse(new DgPhysicsWarehouseDto());
                DgVirtualWarehouseDto dgVirtualWarehouseDto = (DgVirtualWarehouseDto)RestResponseHelper.extractData((RestResponse)this.supplyWarehouseSourcingConfigureApiProxy.queryVirtualWarehouse(dto.getPerformOrderSnapshotDto().getShopCode()));
                AssertUtils.notNull((Object)dgVirtualWarehouseDto, (String)"\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
                TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
                transferOrderReqDto.setOrderType("modification_transfer_order");
                transferOrderReqDto.setPreOrderNo(dto.getSaleOrderNo());
                transferOrderReqDto.setType(PICK_UP);
                transferOrderReqDto.setTotalQuantity(totalQuantity);
                transferOrderReqDto.setOutLogicWarehouseCode(this.outLogicWarehouseCode);
                transferOrderReqDto.setOutLogicWarehouseName(outLogicWarehouseRespDto.getWarehouseName());
                transferOrderReqDto.setOutOrganizationId(outLogicWarehouseRespDto.getOrganizationId());
                transferOrderReqDto.setOutOrganizationCode(outLogicWarehouseRespDto.getOrganizationCode());
                transferOrderReqDto.setOutOrganization(outLogicWarehouseRespDto.getOrganizationName());
                transferOrderReqDto.setOutSubWarehouseCode(dgVirtualWarehouseDto.getWarehouseCode());
                transferOrderReqDto.setInLogicWarehouseCode(this.inLogicWarehouseCode);
                transferOrderReqDto.setInLogicWarehouseName(inLogicWarehouseRespDto.getWarehouseName());
                transferOrderReqDto.setInOrganizationId(inLogicWarehouseRespDto.getOrganizationId());
                transferOrderReqDto.setInOrganizationCode(inLogicWarehouseRespDto.getOrganizationCode());
                transferOrderReqDto.setInOrganization(inLogicWarehouseRespDto.getOrganizationName());
                transferOrderReqDto.setCustomerName(dto.getPerformOrderSnapshotDto().getCustomerName());
                transferOrderReqDto.setBizDate(new Date());
                transferOrderReqDto.setCustomerCode(dto.getPerformOrderSnapshotDto().getCustomerCode());
                transferOrderReqDto.setShopName(dto.getPerformOrderSnapshotDto().getShopName());
                transferOrderReqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
                transferOrderReqDto.setSaleOrderNo(dto.getSaleOrderNo());
                transferOrderReqDto.setExternalOrderNo(dto.getSaleOrderNo());
                transferOrderReqDto.setContact(dgPhysicsWarehouseDto.getContact());
                transferOrderReqDto.setContactPhone(dgPhysicsWarehouseDto.getPhone());
                transferOrderReqDto.setProvince(dgPhysicsWarehouseDto.getProvince());
                transferOrderReqDto.setProvinceCode(dgPhysicsWarehouseDto.getProvinceCode());
                transferOrderReqDto.setCity(dgPhysicsWarehouseDto.getCity());
                transferOrderReqDto.setCityCode(dgPhysicsWarehouseDto.getCityCode());
                transferOrderReqDto.setArea(dgPhysicsWarehouseDto.getDistrict());
                transferOrderReqDto.setAreaCode(dgPhysicsWarehouseDto.getDistrictCode());
                transferOrderReqDto.setAddress(dgPhysicsWarehouseDto.getDetailAddress());
                TransferOrderComboReqDto trOrderReqDto = new TransferOrderComboReqDto();
                trOrderReqDto.setCommitType("COMMIT");
                trOrderReqDto.setTransferOrderReqDto(transferOrderReqDto);
                trOrderReqDto.setDetailList((List)Lists.newArrayList(detailReqDtoMap.values()));
                log.info("\u521b\u5efa\u63d0\u8d27\u6539\u8c03\u62e8\u5355\u5165\u53c2\uff1a{}", JSON.toJSON((Object)trOrderReqDto));
                RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.add(trOrderReqDto));
                if (trfOrderDto == null) {
                    trfOrderDto = (TransferOrderRespDto)RestResponseHelper.extractData((RestResponse)this.transferOrderApiProxy.detail(transferOrderKeyDto));
                    AssertUtils.notNull((Object)trfOrderDto, (String)"\u63d0\u8d27\u6539\u8c03\u62e8\u5355\u4e0d\u5b58\u5728");
                }
            }
        }
        return trfOrderDto;
    }

    private List<DgInventoryPreemptionSupplyDto> preemptInventory(DgPerformOrderRespDto dto, Map<Long, DgPerformOrderLineDto> orderLineMap, OrderAllotInventoryReqDto req) {
        ArrayList shopCodes = Lists.newArrayList((Object[])new String[]{dto.getPerformOrderSnapshotDto().getShopCode()});
        DgInventorySupplyStrategyQueryReqDto strategyQueryReqDto = new DgInventorySupplyStrategyQueryReqDto();
        strategyQueryReqDto.setShopCodeList((List)shopCodes);
        strategyQueryReqDto.setStatus(EnableEnum.ENABLE.getCodeEn());
        strategyQueryReqDto.setFunctionModule(ShopWarehouseEnum.SHOP.getCode().toUpperCase());
        List supplyStrategyDtos = (List)RestResponseHelper.extractData((RestResponse)this.dgInventorySupplyStrategyQueryApiProxy.queryByList(strategyQueryReqDto));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)supplyStrategyDtos), (String)"\u5e97\u94fa\u9ed8\u8ba4\u6e20\u9053\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
        DgInventorySupplyStrategyDto dgInventorySupplyStrategyDto = (DgInventorySupplyStrategyDto)supplyStrategyDtos.stream().findFirst().get();
        SupplyWarehouseSourcingConfigurePageReqDto reqDto = new SupplyWarehouseSourcingConfigurePageReqDto();
        reqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
        List configureDtos = (List)RestResponseHelper.extractData((RestResponse)this.supplyWarehouseSourcingConfigureApiProxy.list(reqDto));
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)configureDtos), (String)"\u4f9b\u8d27\u4ed3\u5bfb\u6e90\u914d\u7f6e\u4e0d\u5b58\u5728");
        SupplyWarehouseSourcingConfigureDto configureDto = (SupplyWarehouseSourcingConfigureDto)configureDtos.get(0);
        ArrayList preemptDtos = Lists.newArrayList();
        List operationDetailDtoList = req.getOrderAllotItemInventoryReqDtos().stream().filter(allotItem -> allotItem.getProductionReformNum() != null && BigDecimal.ZERO.compareTo(allotItem.getProductionReformNum()) < 0).map(itemReqDto -> {
            DgPerformOrderLineDto orderLineDto = (DgPerformOrderLineDto)orderLineMap.get(itemReqDto.getOrderLineId());
            AssertUtils.notNull((Object)orderLineDto, (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
            OperationDetailDto inventoryOperateCargoReqDto = new OperationDetailDto();
            inventoryOperateCargoReqDto.setSkuCode(itemReqDto.getOriginalSkuCode());
            BigDecimal basicNum = itemReqDto.getProductionReformNum().multiply(orderLineDto.getBasicNum()).divide(orderLineDto.getItemNum());
            inventoryOperateCargoReqDto.setNum(basicNum);
            inventoryOperateCargoReqDto.setPreOrderItemId(itemReqDto.getOrderLineId());
            inventoryOperateCargoReqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
            inventoryOperateCargoReqDto.setValidNegative(Boolean.FALSE);
            inventoryOperateCargoReqDto.setInventoryType(Integer.valueOf(1));
            inventoryOperateCargoReqDto.setWarehouseCode(dgInventorySupplyStrategyDto.getRefEntityCode());
            return inventoryOperateCargoReqDto;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(operationDetailDtoList)) {
            PreemptExtDto preemptDto = new PreemptExtDto();
            preemptDto.setHasRecordForError(Boolean.TRUE);
            preemptDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
            preemptDto.setSourceNo(dto.getSaleOrderNo());
            preemptDto.setSourceType(dto.getOrderType());
            preemptDto.setValidNegative(Boolean.FALSE);
            preemptDto.setValidChannelNegative(Boolean.FALSE);
            preemptDto.setPreemptSupply(Boolean.TRUE);
            preemptDto.setIsShoutVirtualWarehouse(Boolean.TRUE);
            preemptDto.setPreemptWarehouseCode(dgInventorySupplyStrategyDto.getRefEntityCode());
            preemptDto.setShoutVirtualWarehouseCodeList((List)Lists.newArrayList((Object[])new String[]{configureDto.getChannelDefaultWarehouseCode()}));
            preemptDto.setDetails(operationDetailDtoList);
            preemptDtos.add(preemptDto);
            log.info("[\u751f\u4ea7\u6539\u9884\u5360\u6e20\u9053\u4ed3]\u9884\u5360\u5e93\u5b58\u53d1\u8d77\u7684\u53c2\u6570\u4fe1\u606f\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)preemptDtos));
            RestResponseHelper.extractData((RestResponse)this.dgInventoryPreemptionShopApiProxy.preemptByBatch((List)preemptDtos));
            List<DgInventoryPreemptionSupplyDto> preemptionSupplyDtos = this.channelOrderCreateAction.queryPreemptInventoryResult(dto);
            List<DgInventoryPreemptionSupplyDto> targetSupplyDtos = preemptionSupplyDtos.stream().filter(preemptionSupplyDto -> Objects.equals(preemptionSupplyDto.getWarehouseCode(), configureDto.getChannelDefaultWarehouseCode())).filter(preemptResult -> preemptResult.getLessNum() != null && BigDecimal.ZERO.compareTo(preemptResult.getLessNum()) < 0).collect(Collectors.toList());
            this.updateOrderProductLessNum(dto, targetSupplyDtos);
            return targetSupplyDtos;
        }
        return Lists.newArrayList();
    }

    private DgOrderLabelEnum createProductTrOrder(DgPerformOrderRespDto dto, Map<Long, DgPerformOrderLineDto> orderLineMap, List<DgOrderLabelRecordRespDto> labelRecordRespDtos, List<DgInventoryPreemptionSupplyDto> dgInventoryPreemptionSupplyDtos) {
        DgOrderLabelEnum productLabelEnum = null;
        BigDecimal totalQuantity = BigDecimal.ZERO;
        if (!labelRecordRespDtos.stream().map(DgOrderLabelBaseRespDto::getLabelCode).anyMatch(labelCode -> Objects.equals(labelCode, DgOrderLabelEnum.DELIVERY_TRANSFER_ORDER.getCode()))) {
            try {
                DgVirtualWarehouseDto dgVirtualWarehouseDto = (DgVirtualWarehouseDto)RestResponseHelper.extractData((RestResponse)this.supplyWarehouseSourcingConfigureApiProxy.queryVirtualWarehouse(dto.getPerformOrderSnapshotDto().getShopCode()));
                AssertUtils.notNull((Object)dgVirtualWarehouseDto, (String)"\u4f9b\u8d27\u4ed3\u4fe1\u606f\u4e0d\u5b58\u5728");
                HashMap map = Maps.newHashMap();
                for (DgInventoryPreemptionSupplyDto supplyDto : dgInventoryPreemptionSupplyDtos) {
                    DgPerformOrderLineDto orderLine = orderLineMap.get(supplyDto.getPreOrderItemId());
                    AssertUtils.notNull((Object)orderLine, (String)"\u8ba2\u5355\u884c\u4e0d\u5b58\u5728");
                    if (supplyDto.getLessNum() != null && BigDecimal.ZERO.compareTo(supplyDto.getLessNum()) < 0) {
                        TransferGoodsOrderDetailDto itemDetailDto = map.getOrDefault(supplyDto.getSkuCode(), new TransferGoodsOrderDetailDto());
                        itemDetailDto.setSkuCode(supplyDto.getSkuCode());
                        itemDetailDto.setQuantity(Optional.ofNullable(itemDetailDto.getQuantity()).orElse(BigDecimal.ZERO).add(supplyDto.getLessNum()));
                        map.put(supplyDto.getSkuCode(), itemDetailDto);
                    }
                    totalQuantity = totalQuantity.add(supplyDto.getLessNum());
                }
                if (CollectionUtils.isNotEmpty(map.values())) {
                    TransferGoodsOrderExtDto transferGoodsOrderExtDto = new TransferGoodsOrderExtDto();
                    transferGoodsOrderExtDto.setCommitType("COMMIT");
                    transferGoodsOrderExtDto.setOrderSource(Integer.valueOf(1));
                    transferGoodsOrderExtDto.setOrderType("2");
                    transferGoodsOrderExtDto.setWarehouseCode(dgVirtualWarehouseDto.getWarehouseCode());
                    transferGoodsOrderExtDto.setWarehouseName(dgVirtualWarehouseDto.getWarehouseName());
                    transferGoodsOrderExtDto.setOrderDetail((List)Lists.newArrayList(map.values()));
                    transferGoodsOrderExtDto.setPreOrderNo(dto.getSaleOrderNo());
                    transferGoodsOrderExtDto.setBusinessType(STOCK_UP);
                    HashMap<String, String> extFields = new HashMap<String, String>();
                    extFields.put("businessType", STOCK_UP);
                    transferGoodsOrderExtDto.setExtension(JSON.toJSONString(extFields));
                    log.info("\u521b\u5efa\u751f\u4ea7\u6539\u8c03\u8d27\u5355\u5165\u53c2\uff1a{}", JSON.toJSON((Object)transferGoodsOrderExtDto));
                    RestResponseHelper.extractData((RestResponse)this.transferGoodsOrderApiProxy.insert(transferGoodsOrderExtDto));
                    productLabelEnum = DgOrderLabelEnum.PRODUCTION_TRANSFER_ORDER;
                }
            }
            catch (Exception e) {
                productLabelEnum = DgOrderLabelEnum.CREATE_PRODUCTION_TRANSFER_FALI;
                e.printStackTrace();
                log.error("\u521b\u5efa\u751f\u4ea7\u6539\u8c03\u8d27\u5355\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            }
        }
        return productLabelEnum;
    }

    @Override
    public RestResponse<Void> addOrderLabels(Long id, List<DgOrderLabelEnum> req) {
        for (DgOrderLabelEnum orderLabelEnum : req) {
            this.dgOrderLabelRecordDomain.addOrderLabelRecord(id, orderLabelEnum);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> removeOrderLabels(Long id, List<DgOrderLabelEnum> req) {
        for (DgOrderLabelEnum orderLabelEnum : req) {
            this.dgOrderLabelRecordDomain.removeOrderLabelRecordById(id, orderLabelEnum);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> reloanByOrderId(DgPerformOrderRespDto dto) {
        List<DgPerformOrderAddrItemDto> performOrderAddrItemDtos = this.dgPerformOrderAddrItemService.queryByOrderId(dto.getId());
        HashMap map = Maps.newHashMap();
        for (DgPerformOrderAddrItemDto addrItemDto : performOrderAddrItemDtos) {
            if (addrItemDto.getStockoutNum() == null || BigDecimal.ZERO.compareTo(addrItemDto.getStockoutNum()) >= 0) continue;
            TransferGoodsOrderDetailDto itemDetailDto = map.getOrDefault(addrItemDto.getSkuCode(), new TransferGoodsOrderDetailDto());
            itemDetailDto.setSkuCode(addrItemDto.getSkuCode());
            itemDetailDto.setQuantity(Optional.ofNullable(itemDetailDto.getQuantity()).orElse(BigDecimal.ZERO).add(addrItemDto.getStockoutNum()));
            map.put(addrItemDto.getSkuCode(), itemDetailDto);
        }
        if (CollectionUtils.isNotEmpty(map.values())) {
            SupplyWarehouseSourcingConfigurePageReqDto reqDto = new SupplyWarehouseSourcingConfigurePageReqDto();
            reqDto.setShopCode(dto.getPerformOrderSnapshotDto().getShopCode());
            List configureDtos = (List)RestResponseHelper.extractData((RestResponse)this.supplyWarehouseSourcingConfigureApiProxy.list(reqDto));
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)configureDtos), (String)"\u4f9b\u8d27\u4ed3\u5bfb\u6e90\u914d\u7f6e\u4e0d\u5b58\u5728");
            SupplyWarehouseSourcingConfigureDto dgVirtualWarehouseDto = (SupplyWarehouseSourcingConfigureDto)configureDtos.get(0);
            TransferGoodsOrderExtDto transferGoodsOrderExtDto = new TransferGoodsOrderExtDto();
            transferGoodsOrderExtDto.setCommitType("COMMIT");
            transferGoodsOrderExtDto.setPreOrderNo(dto.getSaleOrderNo());
            transferGoodsOrderExtDto.setOrderSource(Integer.valueOf(1));
            transferGoodsOrderExtDto.setBusinessType("channel_transfer_goods");
            transferGoodsOrderExtDto.setPreBusinessType(STOCK_UP);
            transferGoodsOrderExtDto.setWarehouseCode(dgVirtualWarehouseDto.getChannelDefaultWarehouseCode());
            transferGoodsOrderExtDto.setWarehouseName(dgVirtualWarehouseDto.getChannelDefaultWarehouseName());
            transferGoodsOrderExtDto.setOrderDetail((List)Lists.newArrayList(map.values()));
            log.info("\u521b\u5efa\u751f\u4ea7\u6539\u8c03\u8d27\u5355\u5165\u53c2\uff1a{}", JSON.toJSON((Object)transferGoodsOrderExtDto));
            Boolean flag = this.channelOrderCreateAction.createTransferGoodsOrder(dto, transferGoodsOrderExtDto);
            AssertUtils.isTrue((boolean)flag, (String)"\u521b\u5efa\u501f\u8d27\u5355\u5931\u8d25");
        }
        return RestResponse.VOID;
    }

    private DgBizPerformOrderReqDto f2BOrderConverB2bOrder(DgPerformOrderRespDto dgBizPerformOrderRespDto) {
        List<PayRecordDto> payRecordEos = this.payRecordService.selectListByOrderNo(dgBizPerformOrderRespDto.getSaleOrderNo());
        String payMethodNames = payRecordEos.stream().map(PayRecordDto::getPayMethodName).distinct().collect(Collectors.joining("\u3001"));
        List dgPerformOrderAttachmentEos = this.dgPerformOrderAttachmentDomain.queryAttachmentByOrderId(dgBizPerformOrderRespDto.getId());
        DgBizPerformOrderReqDto dgBizPerformOrderReqDto = new DgBizPerformOrderReqDto();
        BeanUtil.copyProperties((Object)dgBizPerformOrderRespDto, (Object)dgBizPerformOrderReqDto, (String[])new String[]{"id", "saleOrderNo", "createTime", "createPerson", "updateTime", "updatePerson"});
        dgBizPerformOrderReqDto.setOrderSourceModel(DgOrderSourceModelEnum.F2B.getCode());
        dgBizPerformOrderReqDto.setPlatformOrderId(dgBizPerformOrderRespDto.getId());
        dgBizPerformOrderReqDto.setPlatformOrderNo(dgBizPerformOrderRespDto.getSaleOrderNo());
        dgBizPerformOrderReqDto.setPlatformCreateTime(dgBizPerformOrderRespDto.getCreateTime());
        dgBizPerformOrderReqDto.setOrderStatus(DgOmsSaleOrderStatus.WAIT_PICK.getCode());
        dgBizPerformOrderReqDto.setOmsSaleOrderStatus(DgOmsSaleOrderStatus.WAIT_PICK.getCode());
        dgBizPerformOrderReqDto.setBizModel(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode());
        dgBizPerformOrderReqDto.setOrderSource(DgSaleOrderSourceEnum.CHANNEL_MALL.getType());
        dgBizPerformOrderReqDto.setAllowSplitFlag(Integer.valueOf(1));
        dgBizPerformOrderReqDto.setShipmentEnterpriseId(dgBizPerformOrderRespDto.getPlanShipmentEnterpriseId());
        dgBizPerformOrderReqDto.setShipmentEnterpriseCode(dgBizPerformOrderRespDto.getPlanShipmentEnterpriseCode());
        dgBizPerformOrderReqDto.setShipmentEnterpriseName(dgBizPerformOrderRespDto.getPlanShipmentEnterpriseName());
        dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().setChannelCode(DgOrderSourceModelEnum.F2B.getCode());
        dgBizPerformOrderReqDto.getPerformOrderSnapshotDto().setChannelName(DgOrderSourceModelEnum.F2B.getDesc());
        dgBizPerformOrderReqDto.setOrderSource(DgSaleOrderSourceEnum.CHANNEL_MALL.getType());
        dgBizPerformOrderReqDto.getPerformOrderPaymentDto().setPayWay(payMethodNames);
        dgBizPerformOrderReqDto.setAllowSplitFlag(Integer.valueOf(1));
        if (CollectionUtil.isNotEmpty((Collection)dgPerformOrderAttachmentEos)) {
            dgBizPerformOrderReqDto.setAttachmentFileList(BeanUtil.copyToList((Collection)dgPerformOrderAttachmentEos, DgPerformOrderAttachmentDto.class));
        }
        return dgBizPerformOrderReqDto;
    }

    private void converItemData(List<DgPerformOrderLineDto> orderLineDetails, DgBizPerformOrderReqDto dgBizPerformOrderReqDto, LogicalWarehouseRespDto logicWarehouseRespDto) {
        BigDecimal goodsTotalAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal realPayAmount = BigDecimal.ZERO;
        BigDecimal goodsTotalNum = BigDecimal.ZERO;
        for (DgPerformOrderLineDto orderLineDto : orderLineDetails) {
            if (orderLineDto.getItemNum().compareTo(BigDecimal.ZERO) <= 0) continue;
            orderLineDto.setDeliveryItemBatchNo(orderLineDto.getBatchNo());
            orderLineDto.setLogicalWarehouseId(logicWarehouseRespDto.getId());
            orderLineDto.setLogicalWarehouseCode(logicWarehouseRespDto.getWarehouseCode());
            orderLineDto.setLogicalWarehouseName(logicWarehouseRespDto.getWarehouseName());
            orderLineDto.setPlatformOrderId(dgBizPerformOrderReqDto.getId());
            orderLineDto.setPlatformOrderNo(dgBizPerformOrderReqDto.getSaleOrderNo());
            orderLineDto.setPlatformOrderItemNo(orderLineDto.getId().toString());
            goodsTotalNum = goodsTotalNum.add(orderLineDto.getItemNum());
            Map<String, BigDecimal> lineAmountDtoMap = orderLineDto.getAmountDtoList().stream().filter(amountDto -> Objects.equals(DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode(), amountDto.getAmountSource())).collect(Collectors.toMap(DgPerformOrderLineAmountDto::getAccountType, DgPerformOrderLineAmountDto::getAmount, (e1, e2) -> e1));
            goodsTotalAmount = goodsTotalAmount.add(lineAmountDtoMap.getOrDefault(DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode(), BigDecimal.ZERO));
            discountAmount = discountAmount.add(lineAmountDtoMap.getOrDefault(DgOmsOrderAmountTypeEnum.LINE_DISCOUNT_AMOUNT.getCode(), BigDecimal.ZERO));
            payAmount = payAmount.add(lineAmountDtoMap.getOrDefault(DgOmsOrderAmountTypeEnum.LINE_ORIG_PRICE.getCode(), BigDecimal.ZERO));
            realPayAmount = realPayAmount.add(lineAmountDtoMap.getOrDefault(DgOmsOrderAmountTypeEnum.LINE_SETTLEMENT_AMOUNT.getCode(), BigDecimal.ZERO));
        }
        DgPerformOrderAmountDto amountDto2 = dgBizPerformOrderReqDto.getPerformOrderAmountDto();
        amountDto2.setGoodsTotalNum(goodsTotalNum);
        amountDto2.setSaleTotalAmount(goodsTotalAmount);
        amountDto2.setGoodsTotalAmount(goodsTotalAmount);
        amountDto2.setDiscountAmount(discountAmount);
        amountDto2.setPayAmount(payAmount);
        amountDto2.setOrderTotalAmount(payAmount);
        amountDto2.setRealPayAmount(realPayAmount);
        amountDto2.setMerchantReceivableAmount(realPayAmount);
    }

    private BigDecimal calcFulfillmentAmou(BigDecimal totalAmount, BigDecimal itemNum, BigDecimal fulfillmentedNum, BigDecimal fulfillmentNum) {
        BigDecimal price = totalAmount.divide(itemNum, 2, RoundingMode.DOWN);
        return itemNum.compareTo(fulfillmentedNum.add(fulfillmentNum)) == 0 ? totalAmount.subtract(price.multiply(fulfillmentedNum)) : price.multiply(fulfillmentNum);
    }
}

