/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.DgF2BAfterStatus;
import com.yunxi.dg.base.center.trade.action.oms.channel.IDgF2BMqMessageAction;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgRefundDetailDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderActivityDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleOmsOrderDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.AfterSaleOmsOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgRefundDetailDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.activity.ActivityDiscountInfo;
import com.yunxi.dg.base.center.trade.dto.orderreq.f2b.activity.OrderPayActivityMessageDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.trade.eo.OrderActivityEo;
import com.yunxi.dg.base.center.trade.service.after.IDgF2BAfterService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgF2BMqMessageActionImpl
implements IDgF2BMqMessageAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgF2BMqMessageActionImpl.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgF2BAfterService dgF2BAfterService;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IDgRefundDetailDomain dgRefundDetailDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IOrderActivityDomain orderActivityDomain;

    @Override
    public void sendMsgOrderStatusChange(DgPerformOrderRespDto respDto, String beforeStatus, String changeByEvent) {
        LOGGER.info("\u3010\u8ba2\u5355\u72b6\u6001\u53d8\u66f4mq\u3011afterSaleOrderStatusChangeEvent\uff0cid={}\uff0cstatus={}\uff0cbeforeStatus={}\uff0cchangeByEvent={}", new Object[]{respDto.getId(), respDto.getOrderStatus(), beforeStatus, changeByEvent});
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgBizPerformOrderRespDto saleOrderRespDto = this.omsOrderInfoQueryDomain.orderRelatedInformation(respDto.getSaleOrderNo());
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        MessageVo messageVo = new MessageVo();
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)saleOrderRespDto));
        object.put("beforeStatus", (Object)beforeStatus);
        object.put("afterStatus", (Object)respDto.getOrderStatus());
        object.put("changeByEvent", (Object)changeByEvent);
        saleOrderRespDto.setBeforeStatus(beforeStatus);
        saleOrderRespDto.setAfterStatus(respDto.getOrderStatus());
        saleOrderRespDto.setChangeByEvent(changeByEvent);
        messageVo.setData((Object)saleOrderRespDto);
        LOGGER.info("[\u8ba2\u5355\u72b6\u6001\u53d8\u66f4mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("F2B_PUSH_SALE_ORDER_STATUS_CHANGE_TAG", (Object)messageVo);
    }

    @Override
    public void sendMsgAfterStatusChange(DgAfterSaleOrderRespDto respDto, String beforeStatus, String changeByEvent) {
        LOGGER.info("\u3010\u8ba2\u5355\u72b6\u6001\u53d8\u66f4mq\u3011afterSaleOrderStatusChangeEvent\uff0cid={}\uff0cstatus={}\uff0cbeforeStatus={}\uff0cchangeByEvent={}", new Object[]{respDto.getId(), respDto.getStatus(), beforeStatus, changeByEvent});
        AssertUtils.notNull((Object)respDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = this.dgF2BAfterService.queryDetails(respDto.getId(), respDto.getAfterSaleOrderNo());
        AssertUtils.notNull((Object)afterSaleOrderRespDto, (String)"\u8ba2\u5355\uff08%s\uff09\u4e0d\u5b58\u5728", (Object[])new Object[]{respDto.getId()});
        MessageVo messageVo = new MessageVo();
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)afterSaleOrderRespDto));
        object.put("beforeStatus", (Object)beforeStatus);
        object.put("afterStatus", (Object)respDto.getStatus());
        object.put("changeByEvent", (Object)changeByEvent);
        DgPerformOrderSnapshotDto performOrderSnapshotDto = this.dgPerformOrderSnapshotDomain.selectDtoByOrderId(afterSaleOrderRespDto.getSaleOrderId());
        afterSaleOrderRespDto.setPerformOrderSnapshotDto(performOrderSnapshotDto);
        if (CollectionUtils.isNotEmpty((Collection)afterSaleOrderRespDto.getRefundDetailDtoList())) {
            ArrayList refundDetailDtoList = Lists.newArrayList();
            Map<String, List<DgRefundDetailDto>> refundWayMap = afterSaleOrderRespDto.getRefundDetailDtoList().stream().collect(Collectors.groupingBy(DgRefundDetailDto::getAssignRefundWay));
            for (Map.Entry<String, List<DgRefundDetailDto>> map : refundWayMap.entrySet()) {
                DgRefundDetailDto refundDetailDto = new DgRefundDetailDto();
                BigDecimal refundAmount = map.getValue().stream().map(DgRefundDetailDto::getRefundAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                CubeBeanUtils.copyProperties((Object)refundDetailDto, (Object)map.getValue().get(0), (String[])new String[0]);
                refundDetailDto.setRefundWay(map.getKey());
                refundDetailDto.setRefundAccount(map.getKey());
                refundDetailDto.setRefundAmount(refundAmount);
                refundDetailDto.setCreditFileNo(map.getValue().get(0).getCardNo());
                refundDetailDtoList.add(refundDetailDto);
            }
            afterSaleOrderRespDto.setRefundDetailDtoList((List)refundDetailDtoList);
        }
        messageVo.setData((Object)afterSaleOrderRespDto);
        LOGGER.info("[\u552e\u540e\u8ba2\u5355\u72b6\u6001\u53d8\u66f4mq,\u4ece\u72b6\u6001:{}->{}]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", new Object[]{beforeStatus, respDto.getStatus(), JSON.toJSONString((Object)messageVo)});
        this.commonsMqService.publishMessage("F2B_PUSH_AFTER_STATUS_CHANGE_TAG", (Object)messageVo);
    }

    @Override
    public void sendSyncB2BSaleReturn(DgAfterSaleOrderDto requestData) {
        LOGGER.info("\u63a8\u9001\u9000\u8d27\u5355\u81f3\u4f9b\u5e94\u94fe\uff1a{}", (Object)JSON.toJSONString((Object)requestData));
        AssertUtils.notNull((Object)requestData.getId(), (String)"\u6e20\u9053\u552e\u540e\u5355id \u4e0d\u80fd\u4e3a\u7a7a");
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)requestData);
        LOGGER.info("\u63a8\u9001\u9000\u8d27\u5355\u81f3\u4f9b\u5e94\u94fe\uff0c\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{} ", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.sendDelaySingleMessage("TRADE_DELAY_TOPIC", "F2B_CHANNEL_TRANSFER_SALE_RETURN", (Object)messageVo, Long.valueOf(5L));
    }

    @Override
    public void syncExternalSysOrderFulfillment(DgPerformOrderRespDto dto) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)dto.getSaleOrderNo());
        LOGGER.info("\u540c\u6b65\u5916\u90e8\u7cfb\u7edf\u5c65\u7ea6\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("SYNC_EXTERNAL_SYS_ORDER_FULFILLMENT_TAG", (Object)messageVo);
    }

    @Override
    public void dealWithActivityExpense(String orderNo, Integer type) {
        OrderActivityEo orderActivityEo = new OrderActivityEo();
        orderActivityEo.setOrderNo(orderNo);
        List resultList = this.orderActivityDomain.selectList((BaseEo)orderActivityEo);
        if (CollectionUtils.isNotEmpty((Collection)resultList)) {
            OrderPayActivityMessageDto messageDto = new OrderPayActivityMessageDto();
            messageDto.setOrderNo(orderNo);
            messageDto.setType(type);
            ArrayList activityDiscountInfos = com.google.common.collect.Lists.newArrayList();
            for (OrderActivityEo eo : resultList) {
                ActivityDiscountInfo di = new ActivityDiscountInfo();
                di.setActivityId(Long.valueOf(Long.parseLong(eo.getActivityId())));
                di.setDiscountAmount(eo.getDiscountAmount());
                di.setIsLastDelivery(Boolean.valueOf(true));
                activityDiscountInfos.add(di);
            }
            messageDto.setActivityDiscountInfos((List)activityDiscountInfos);
            String msg = JSON.toJSONString((Object)messageDto);
            LOGGER.info("\u5904\u7406\u6d3b\u52a8\u8d39\u7528\uff1a{}", (Object)msg);
            this.commonsMqService.sendSingleMessageAsync("ORDER_PAY_ACTIVITY_BUDGET_TOPIC", "ORDER_PAY_ACTIVITY_BUDGET_TAG", (Object)msg);
        }
    }

    @Override
    public void sendF2BAfterToOms(DgAfterSaleOrderDto afterSaleOrderDto, Boolean reTransformOrder) {
        LOGGER.info("\u6e20\u9053\u9000\u8d27\u5355\u63a8\u9001OMS\uff0csendF2BAfterToOms\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)afterSaleOrderDto), (Object)reTransformOrder);
        DgAfterSaleOrderRespDto afterOrder = this.dgF2BAfterService.queryDetails(afterSaleOrderDto.getId(), afterSaleOrderDto.getSaleOrderNo());
        LOGGER.info("\u83b7\u53d6\u9000\u8d27\u5355\u8be6\u60c5\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)afterOrder));
        AfterSaleOmsOrderDto omsOrderDto = new AfterSaleOmsOrderDto();
        omsOrderDto.setAfterStatus(afterOrder.getStatus());
        omsOrderDto.setAfterType(this.getAfterType(afterOrder.getAfterSaleOrderType()));
        omsOrderDto.setBizType(null);
        omsOrderDto.setBuyerNick(afterOrder.getCustomerName());
        omsOrderDto.setChannelCode("B2B");
        omsOrderDto.setCusServiceCode(afterOrder.getCustomerCode());
        omsOrderDto.setLastChanged(afterOrder.getUpdateTime());
        omsOrderDto.setPlatformCreated(afterOrder.getCreateTime());
        omsOrderDto.setPlatformOrderNo(afterOrder.getSaleOrderNo());
        omsOrderDto.setPlatformRefundOrderSn(afterOrder.getAfterSaleOrderNo());
        omsOrderDto.setPlatformShippingCode(null);
        omsOrderDto.setReason(afterOrder.getReason());
        omsOrderDto.setRefundFee(afterOrder.getRefundFee());
        omsOrderDto.setRefundStatus("1");
        if (afterOrder.getStatus().equals(DgF2BAfterStatus.WAIT_REFUND.getCode()) || afterOrder.getStatus().equals(DgF2BAfterStatus.COMPLETE.getCode()) || afterOrder.getStatus().equals(DgF2BAfterStatus.CLOSE.getCode())) {
            omsOrderDto.setRefundStatus("3");
        }
        omsOrderDto.setRelateToPlatformOrder("1");
        if (StringUtils.isNotBlank((CharSequence)omsOrderDto.getPlatformOrderNo())) {
            omsOrderDto.setRelateToPlatformOrder("0");
        }
        omsOrderDto.setRemark(null);
        omsOrderDto.setReturnShippingSn(null);
        omsOrderDto.setShippingCode(null);
        omsOrderDto.setShippingName(null);
        omsOrderDto.setShopCode(afterOrder.getShopCode());
        omsOrderDto.setType(this.getServiceType(afterOrder));
        List omsOrderItemList = afterOrder.getItemDtoList().stream().map(item -> {
            AfterSaleOmsOrderItemDto itemDto = new AfterSaleOmsOrderItemDto();
            itemDto.setAfterItemType("0");
            itemDto.setAfterOrderId(afterOrder.getId());
            itemDto.setAfterType(omsOrderDto.getAfterType());
            itemDto.setGift(item.getGift());
            itemDto.setItemAttr(item.getItemAttr());
            itemDto.setItemCode(item.getItemCode());
            itemDto.setItemName(item.getItemName());
            itemDto.setNum(item.getReturnNum());
            itemDto.setRefundFee(item.getRefundAmount());
            itemDto.setSettlementAmount(item.getSettlementAmount());
            if (item.getActualReturnNum() != null) {
                itemDto.setNum(item.getActualReturnNum());
            }
            itemDto.setRefundFee(item.getSettlementAmount());
            itemDto.setOid(item.getId().toString());
            itemDto.setPlatformOrderNo(afterOrder.getAfterSaleOrderNo());
            itemDto.setPlatformOrderItemNo(ObjectUtil.isNotEmpty((Object)item.getSaleOrderItemId()) ? item.getSaleOrderItemId().toString() : null);
            itemDto.setRefundStatus(omsOrderDto.getRefundStatus());
            itemDto.setReturnShippingName(null);
            itemDto.setReturnShippingSn(null);
            itemDto.setSkuCode(item.getSkuCode());
            itemDto.setSkuId(item.getSkuId().toString());
            itemDto.setSkuName(item.getSkuName());
            return itemDto;
        }).collect(Collectors.toList());
        BigDecimal settlementAmount = omsOrderItemList.stream().map(AfterSaleOmsOrderItemDto::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        omsOrderDto.setRefundFee(settlementAmount);
        omsOrderDto.setItemList(omsOrderItemList);
        LOGGER.info("b2b\uff08\u6e20\u9053\uff09\u9000\u8d27\u5355\u63a8\u9001OMS\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)omsOrderDto));
        this.commonsMqService.sendSingleMessage("B2B_AFTER_OMS_SYNC_TAG", (Object)JSON.toJSONString((Object)omsOrderDto));
    }

    private String getServiceType(DgAfterSaleOrderRespDto afterOrder) {
        String afterSaleOrderType = afterOrder.getAfterSaleOrderType();
        String type = "";
        type = AfterSaleOrderTypeEnum.JTK.getCode().equals(afterSaleOrderType) || AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderType) ? "TK" : (AfterSaleOrderTypeEnum.THTK.getCode().equals(afterSaleOrderType) ? "TH" : (AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrderType) ? "HH" : "TH"));
        return type;
    }

    private String getAfterType(String afterSaleOrderType) {
        String afterType = "";
        afterType = AfterSaleOrderTypeEnum.JTK.getCode().equals(afterSaleOrderType) || AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderType) ? "REFUND_ONLY" : (AfterSaleOrderTypeEnum.THTK.getCode().equals(afterSaleOrderType) ? "REFUND_RETURN" : (AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrderType) ? "EXCHANGE" : "REFUND_RETURN"));
        return afterType;
    }
}

