/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.action.oms.channel.Impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.action.oms.channel.IOrderItemToOrderLineAction;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderItemAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IItemPayRecordDomain;
import com.yunxi.dg.base.center.trade.dto.entity.ItemPayRecordDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineReturnApplyStatusEnum;
import com.yunxi.dg.base.center.trade.enums.ItemLineReturnStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgOrderItemAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformNoticeSyncRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.ItemPayRecordEo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderItemToOrderLineActionImpl
implements IOrderItemToOrderLineAction {
    private static final Logger log = LoggerFactory.getLogger(OrderItemToOrderLineActionImpl.class);
    @Resource
    private IDgPerformOrderItemDomain dgPerformOrderItemDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgOrderItemAmountDomain dgOrderItemAmountDomain;
    @Resource
    private IItemPayRecordDomain itemPayRecordDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformNoticeSyncRecordDomain dgPerformNoticeSyncRecordDomain;
    @Resource
    private IDgPerformNoticeSyncRecordItemDomain dgPerformNoticeSyncRecordItemDomain;
    BiConsumer<DgPerformOrderLineEo, DgPerformOrderItemEo> ORDER_ITEM_EO_TO_ORDER_LINE = (dgPerformOrderLineSummaryDto, performOrderItemDto) -> {
        dgPerformOrderLineSummaryDto.setItemType(performOrderItemDto.getType());
        dgPerformOrderLineSummaryDto.setGiftFlag(performOrderItemDto.getGift());
        dgPerformOrderLineSummaryDto.setMainOrderId(performOrderItemDto.getId());
        dgPerformOrderLineSummaryDto.setMainOrderItemId(performOrderItemDto.getId());
        dgPerformOrderLineSummaryDto.setItemAttribute(performOrderItemDto.getItemAttr());
        dgPerformOrderLineSummaryDto.setMainItemId(performOrderItemDto.getItemId());
        dgPerformOrderLineSummaryDto.setMainItemCode(performOrderItemDto.getItemCode());
        dgPerformOrderLineSummaryDto.setMainItemName(performOrderItemDto.getItemName());
        dgPerformOrderLineSummaryDto.setMainSkuId(performOrderItemDto.getSkuId());
        dgPerformOrderLineSummaryDto.setMainSkuCode(performOrderItemDto.getSkuCode());
        dgPerformOrderLineSummaryDto.setSkuName(performOrderItemDto.getSkuName());
        dgPerformOrderLineSummaryDto.setOrderItemUnit(performOrderItemDto.getOrderItemUnit());
        dgPerformOrderLineSummaryDto.setOrderItemUnitName(performOrderItemDto.getOrderItemUnitName());
        dgPerformOrderLineSummaryDto.setSalePrice(performOrderItemDto.getItemMarketPrice());
        dgPerformOrderLineSummaryDto.setSaleAmount(performOrderItemDto.getItemMarketPrice().multiply(performOrderItemDto.getItemNum()));
        dgPerformOrderLineSummaryDto.setTransactionAmount(performOrderItemDto.getItemOrigAmount());
        dgPerformOrderLineSummaryDto.setPromotionDiscountAmount(performOrderItemDto.getDiscountAmount());
        dgPerformOrderLineSummaryDto.setGiftType(performOrderItemDto.getGift());
        dgPerformOrderLineSummaryDto.setItemType(performOrderItemDto.getType());
        dgPerformOrderLineSummaryDto.setCalcUnitSymbol(performOrderItemDto.getOrderItemUnit());
        dgPerformOrderLineSummaryDto.setCalcUnitDesc(performOrderItemDto.getOrderItemUnitName());
        dgPerformOrderLineSummaryDto.setCalcItemNum(performOrderItemDto.getItemNum());
        dgPerformOrderLineSummaryDto.setCostAmount(performOrderItemDto.getTotalUseCostAmount());
    };

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> orderItemToOrderLine(List<Long> orderIds) {
        if (CollectionUtils.isEmpty(orderIds)) {
            return RestResponse.VOID;
        }
        List orderInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"id", orderIds)).eq((Object)"dr", (Object)0)).list();
        if (CollectionUtils.isEmpty((Collection)orderInfoEos)) {
            return RestResponse.VOID;
        }
        Map<Object, Object> noticeSyncRecordMap = new HashMap();
        List noticeSyncRecordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformNoticeSyncRecordDomain.filter().in((Object)"business_id", orderIds)).eq((Object)"dr", (Object)0)).eq((Object)"notice_result_sync_status", (Object)"FINISH")).list();
        if (CollectionUtils.isNotEmpty((Collection)noticeSyncRecordEos)) {
            noticeSyncRecordMap = noticeSyncRecordEos.stream().collect(Collectors.groupingBy(DgPerformNoticeSyncRecordEo::getBusinessId));
        }
        Map orderInfoEoMap = orderInfoEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        List orderItemEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderItemDomain.filter().in((Object)"order_id", orderIds)).eq((Object)"dr", (Object)0)).list();
        if (CollectionUtils.isEmpty((Collection)orderItemEoList)) {
            return RestResponse.VOID;
        }
        List orderItemIds = orderItemEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        Map<Object, Object> orderItemAmoumtMap = new HashMap();
        List<String> amounTypes = Arrays.asList(DgOrderAmountTypeEnum.PROMOTION_KNEAD_TOTAL.getCode(), DgOrderAmountTypeEnum.COST_KNEAD_TOTAL.getCode(), DgOrderAmountTypeEnum.TAX_RATE.getCode(), DgOrderAmountTypeEnum.TAX_AMOUNT.getCode());
        List itemAmountEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgOrderItemAmountDomain.filter().in((Object)"order_item_id", orderItemIds)).in((Object)"amount_type", amounTypes)).list();
        if (CollectionUtils.isNotEmpty((Collection)itemAmountEos)) {
            orderItemAmoumtMap = itemAmountEos.stream().collect(Collectors.groupingBy(DgOrderItemAmountEo::getOrderItemId));
        }
        List itemPayRecordEos = ((ExtQueryChainWrapper)this.itemPayRecordDomain.filter().in((Object)"order_item_id", orderItemIds)).list();
        Map<Object, Object> orderItemPayRecordMap = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)itemPayRecordEos)) {
            orderItemPayRecordMap = itemPayRecordEos.stream().collect(Collectors.groupingBy(ItemPayRecordEo::getOrderItemId));
        }
        ArrayList orderLineEos = Lists.newArrayList();
        ArrayList orderItemLineEos = Lists.newArrayList();
        for (DgPerformOrderItemEo dgPerformOrderItemEo : orderItemEoList) {
            List orderItemAmountEos;
            DgPerformOrderInfoEo orderInfoEo = (DgPerformOrderInfoEo)orderInfoEoMap.get(dgPerformOrderItemEo.getOrderId());
            dgPerformOrderItemEo.setDeliveredNum(dgPerformOrderItemEo.getDeliveredNum() == null ? BigDecimal.ZERO : dgPerformOrderItemEo.getDeliveredNum());
            DgPerformOrderLineEo orderLineEo = new DgPerformOrderLineEo();
            CubeBeanUtils.copyProperties((Object)orderLineEo, (Object)dgPerformOrderItemEo, (String[])new String[0]);
            this.ORDER_ITEM_EO_TO_ORDER_LINE.accept(orderLineEo, dgPerformOrderItemEo);
            orderLineEo.setOrderNo(orderInfoEo.getSaleOrderNo());
            List itemPayRecordEoList = (List)orderItemPayRecordMap.get(dgPerformOrderItemEo.getId());
            if (CollectionUtils.isNotEmpty((Collection)itemPayRecordEoList)) {
                ArrayList itemPayRecordDtos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)itemPayRecordDtos, (Collection)itemPayRecordEoList, ItemPayRecordDto.class);
                orderLineEo.setCostDetails(JSON.toJSONString((Object)itemPayRecordDtos));
            }
            if (CollectionUtils.isNotEmpty((Collection)(orderItemAmountEos = (List)orderItemAmoumtMap.get(dgPerformOrderItemEo.getId())))) {
                for (DgOrderItemAmountEo itemAmountEo : orderItemAmountEos) {
                    if (!itemAmountEo.getOrderItemId().equals(dgPerformOrderItemEo.getId())) continue;
                    if (DgOrderAmountTypeEnum.TAX_AMOUNT.getCode().equals(itemAmountEo.getAmountType())) {
                        orderLineEo.setTaxAmount(itemAmountEo.getAmount());
                    }
                    if (DgOrderAmountTypeEnum.TAX_RATE.getCode().equals(itemAmountEo.getAmountType())) {
                        orderLineEo.setRate(itemAmountEo.getAmount());
                    }
                    if (DgOrderAmountTypeEnum.PROMOTION_KNEAD_TOTAL.getCode().equals(itemAmountEo.getAmountType())) {
                        orderLineEo.setPromotionKneadeAmount(itemAmountEo.getAmount());
                    }
                    if (DgOrderAmountTypeEnum.COST_KNEAD_TOTAL.getCode().equals(itemAmountEo.getAmountType())) {
                        orderLineEo.setCostKneadeAmount(itemAmountEo.getAmount());
                    }
                    if (DgOrderAmountTypeEnum.KNEAD_TOTAL.getCode().equals(itemAmountEo.getAmountType())) {
                        orderLineEo.setKneadeAmount(itemAmountEo.getAmount());
                    }
                    if (DgOrderAmountTypeEnum.KNEAD_LATER_TOTAL.getCode().equals(itemAmountEo.getAmountType())) {
                        orderLineEo.setKneadLaterTotal(itemAmountEo.getAmount());
                    }
                    if (!DgOrderAmountTypeEnum.TOTAL_DISCOUNT_AMOUNT.getCode().equals(itemAmountEo.getAmountType())) continue;
                    orderLineEo.setPromotionDiscountAmount(itemAmountEo.getAmount());
                }
            }
            DgPerformOrderItemLineEo orderItemLineEo = new DgPerformOrderItemLineEo();
            CubeBeanUtils.copyProperties((Object)orderItemLineEo, (Object)orderLineEo, (String[])new String[0]);
            orderItemLineEo.setId(null);
            orderItemLineEo.setOrderLineId(orderLineEo.getId());
            orderItemLineEo.setDeliveryStatus(ItemLineDeliveryStatusEnum.NO.getType());
            orderItemLineEo.setCancelStatus(ItemLineDeliveryStatusEnum.NO.getType());
            orderItemLineEo.setReturnStatus(ItemLineReturnStatusEnum.NO.getType());
            orderItemLineEo.setReturnApplyStatus(ItemLineReturnApplyStatusEnum.NO.getType());
            if (dgPerformOrderItemEo.getDeliveredNum().equals(dgPerformOrderItemEo.getItemNum())) {
                List syncRecordEos = (List)noticeSyncRecordMap.get(dgPerformOrderItemEo.getOrderId());
                if (CollectionUtils.isNotEmpty((Collection)syncRecordEos) && syncRecordEos.size() == 1) {
                    orderItemLineEo.setDeliveryNoticeNo(((DgPerformNoticeSyncRecordEo)syncRecordEos.get(0)).getResultNoticeOrderNo());
                }
                orderItemLineEo.setDeliveryStatus(ItemLineDeliveryStatusEnum.YES.getType());
            }
            if (dgPerformOrderItemEo.getDeliveredNum().compareTo(BigDecimal.ZERO) <= 0 && orderInfoEo.getOrderStatus().equals("CANCEL")) {
                orderItemLineEo.setCancelStatus(ItemLineCancelStatusEnum.YES.getType());
            }
            orderItemLineEo.setSplitStatus(Integer.valueOf(0));
            orderItemLineEos.add(orderItemLineEo);
            orderLineEos.add(orderLineEo);
        }
        this.dgPerformOrderLineDomain.insertBatch((List)orderLineEos);
        this.dgPerformOrderItemLineDomain.insertBatch((List)orderItemLineEos);
        return RestResponse.VOID;
    }
}

